/*
 * Decompiled with CFR 0.152.
 */
package com.univ.tree.processus;

import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Structure;
import com.univ.tree.bean.JsTreeDataModel;
import com.univ.tree.bean.JsTreeModel;
import com.univ.tree.bean.JsTreeNodeModel;
import com.univ.tree.bean.JsTreePath;
import com.univ.tree.processus.GestionJsTree;
import com.univ.tree.processus.TypeStructureFilter;
import com.univ.tree.utils.JsTreeUtils;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuresJsTree
extends GestionJsTree<List<InfosStructure>> {
    public static final String ID_BEAN = "structuresJsTree";
    private static final Logger LOG = LoggerFactory.getLogger(StructuresJsTree.class);

    @Override
    public JsTreeModel traiterDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            boolean front = parameters.get("FRONT") != null && parameters.get("FRONT").equals("true");
            String permissions = parameters.get("PERMISSION");
            TypeStructureFilter filter = null;
            if (!StringUtils.isEmpty((CharSequence)parameters.get("FILTRE"))) {
                filter = new TypeStructureFilter(parameters.get("FILTRE"));
            }
            InfosStructure structure = Structure.renvoyerItemStructure(parameters.get("RACINE"));
            int niveau = Integer.parseInt(parameters.get("NIVEAU"));
            String[] selection = StringUtils.defaultString((String)parameters.get("SELECTED")).split(";");
            jsTree.getNodes().add(StructuresJsTree.buildStructureNode(permissions, autorisations, filter, structure, front, niveau, null));
            if (selection.length > 0) {
                this.loadToPath(autorisations, permissions, filter, front, jsTree, selection);
            }
        }
        catch (Exception e) {
            LOG.error("impossible de generer l'arborescence des structures", (Throwable)e);
            jsTree = new JsTreeModel();
        }
        return jsTree;
    }

    private void loadToPath(AutorisationBean autorisations, String permissions, TypeStructureFilter filter, boolean front, JsTreeModel jsTree, String[] selection) {
        ArrayList<String> loadedNodes = new ArrayList<String>();
        for (String code : selection) {
            try {
                JsTreePath path = this.getPathToCode(code);
                Iterator<String> codeIt = path.getChildPath().iterator();
                HashSet<String> nodes = new HashSet<String>();
                String topCode = codeIt.next();
                nodes.addAll(path.getChildPath());
                if (!loadedNodes.isEmpty()) {
                    while (loadedNodes.contains(topCode) && codeIt.hasNext()) {
                        topCode = codeIt.next();
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)topCode)) continue;
                JsTreeNodeModel parentNode = JsTreeUtils.getNodeWithCode(jsTree.getNodes().get(0), topCode);
                InfosStructure parent = Structure.renvoyerItemStructure(topCode);
                parentNode.getChildren().addAll(StructuresJsTree.buildStructureNode(permissions, autorisations, filter, parent, front, -2, nodes).getChildren());
                loadedNodes.addAll(nodes);
            }
            catch (Exception e) {
                LOG.error("An error occured trying to get OpenPath for structure tree", (Throwable)e);
            }
        }
    }

    private JsTreePath getPathToCode(String code) {
        JsTreePath path = new JsTreePath();
        InfosStructure child = Structure.renvoyerItemStructure(code);
        path.addChild(code);
        for (InfosStructure parent = child.getStructureRattachement(); parent != null && !parent.getCode().equals("00"); parent = parent.getStructureRattachement()) {
            path.addChild(parent.getCode());
        }
        return path;
    }

    private static JsTreeNodeModel buildStructureNode(String permissions, AutorisationBean autorisations, TypeStructureFilter filter, InfosStructure structure, boolean front, int niveau, Set<String> ids) {
        JsTreeNodeModel node;
        block9: {
            Iterator<InfosStructure> listSousStructuresIt;
            block10: {
                node = null;
                listSousStructuresIt = structure.getListeSousStructuresSortedByLibelleLong().iterator();
                boolean selectable = StructuresJsTree.isStructureSelectable(permissions, autorisations, filter, structure, ids);
                if (!StructuresJsTree.isStructureVisible(permissions, autorisations, filter, structure, front, selectable, ids)) break block9;
                node = new JsTreeNodeModel();
                if (!selectable) {
                    node.getAttr().put("rel", "not_selectable");
                }
                JsTreeDataModel datas = new JsTreeDataModel();
                if (structure.getCode().equals("00")) {
                    datas.setTitle(" ");
                    node.getAttr().put("rel", "root");
                    node.getAttr().put("class", "structure_root");
                    if (structure.getListeSousStructures().size() > 0) {
                        node.setState("open");
                    }
                } else {
                    datas.setTitle(structure.getLibelleLong());
                    node.getAttr().put("class", EscapeString.escapeAttributHtml("structure_" + structure.getCodeObjet() + "_" + structure.getTypeStructure()));
                    node.getAttr().put("title", structure.getLibelleLong());
                    node.getMetadata().put("libelle", structure.getLibelleLong());
                    node.getMetadata().put("sCode", structure.getCode());
                    if (structure.getListeSousStructures().size() > 0 && StructuresJsTree.hasVisibleChildren(permissions, autorisations, structure, filter, front, ids)) {
                        node.setState("closed");
                    }
                }
                node.getMetadata().put("numchildren", Integer.toString(structure.getListeSousStructures().size()));
                node.getAttr().put("id", structure.getCodeObjet() + "_" + Long.toString(structure.getIdStructure()));
                node.setData(datas);
                if (niveau <= 0 && niveau != -1) break block10;
                while (listSousStructuresIt.hasNext()) {
                    JsTreeNodeModel child;
                    InfosStructure sousStructure = listSousStructuresIt.next();
                    if (niveau != -1) {
                        --niveau;
                    }
                    if ((child = StructuresJsTree.buildStructureNode(permissions, autorisations, filter, sousStructure, front, niveau, ids)) != null) {
                        node.getChildren().add(child);
                    }
                    if (niveau == -1) continue;
                    ++niveau;
                }
                break block9;
            }
            if (niveau != -2) break block9;
            while (listSousStructuresIt.hasNext()) {
                JsTreeNodeModel child = null;
                InfosStructure sousStructure = listSousStructuresIt.next();
                child = !ids.contains(sousStructure.getCode()) ? StructuresJsTree.buildStructureNode(permissions, autorisations, filter, sousStructure, front, 0, null) : StructuresJsTree.buildStructureNode(permissions, autorisations, filter, sousStructure, front, niveau, ids);
                if (child == null) continue;
                node.getChildren().add(child);
            }
        }
        return node;
    }

    @Override
    public void assertParametersConsistency(Map<String, String> parameters) throws Exception {
        if (parameters.get("CODE") == null || parameters.get("CODE").length() == 0) {
            parameters.put("CODE", "00");
        }
        if (parameters.get("RACINE") == null || parameters.get("RACINE").length() == 0) {
            parameters.put("RACINE", "00");
        }
    }

    private static boolean isStructureSelectable(String permissions, AutorisationBean autorisations, TypeStructureFilter filter, InfosStructure structure, Set<String> ids) {
        boolean inIds;
        boolean selectableItem = true;
        boolean bl = inIds = ids == null || ids.isEmpty() || ids.contains(structure.getCode());
        if (permissions.length() > 0) {
            selectableItem = Structure.controlerPermission(autorisations, permissions, structure.getCode());
        }
        if (filter != null && selectableItem) {
            selectableItem = filter.accept(structure.getTypeStructure());
        }
        PermissionBean permissionCourante = new PermissionBean(permissions);
        if (!selectableItem && autorisations != null && autorisations.isRedacteurFicheCourante() && ("0006".equals(permissionCourante.getObjet()) || "0007".equals(permissionCourante.getObjet()) || "0013".equals(permissionCourante.getObjet())) && !autorisations.possedePermission(permissionCourante)) {
            selectableItem = true;
        }
        return selectableItem && inIds;
    }

    private static boolean hasVisibleChildren(String permissions, AutorisationBean autorisations, InfosStructure structure, TypeStructureFilter filter, boolean front, Set<String> ids) {
        for (InfosStructure currentChild : structure.getListeSousStructures()) {
            boolean selectable = false;
            boolean visible = false;
            try {
                selectable = StructuresJsTree.isStructureSelectable(permissions, autorisations, filter, currentChild, ids);
                visible = StructuresJsTree.isStructureVisible(permissions, autorisations, filter, structure, front, selectable, ids);
                if (!visible) continue;
                return true;
            }
            catch (Exception e) {
                LOG.error(String.format("An error occured determining children's visibility for structure %s", structure.getLibelleAffichable()), (Throwable)e);
            }
        }
        return false;
    }

    private static boolean isStructureVisible(String permissions, AutorisationBean autorisations, TypeStructureFilter filter, InfosStructure structure, boolean front, boolean selectable, Set<String> ids) {
        boolean inIds;
        boolean visible = selectable;
        boolean bl = inIds = ids == null || ids.isEmpty() || ids.contains(structure.getCode());
        if (!selectable) {
            Iterator<InfosStructure> listSousStructuresIt = structure.getListeSousStructures().iterator();
            InfosStructure sousStructure = null;
            while (listSousStructuresIt.hasNext() && !visible) {
                sousStructure = listSousStructuresIt.next();
                if (front && !sousStructure.isVisibleInFront()) continue;
                visible = StructuresJsTree.isStructureVisible(permissions, autorisations, filter, sousStructure, front, StructuresJsTree.isStructureSelectable(permissions, autorisations, filter, sousStructure, ids), ids);
            }
        }
        return visible && inIds;
    }

    @Override
    public JsTreeModel traiterRechercheDepuisRequete(HttpServletRequest req) {
        return new JsTreeModel();
    }

    @Override
    public JsTreeModel traiterFiltreDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        String query = StringUtils.defaultString((String)req.getParameter("QUERY"), (String)"");
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            parameters.put("NIVEAU", "-1");
            Hashtable<String, String> structures = Structure.getListeStructureParIntituleComplet(ContexteUtil.getContexteUniv());
            ArrayList<InfosStructure> listStructures = new ArrayList<InfosStructure>();
            for (Map.Entry structure : structures.entrySet()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)((CharSequence)structure.getValue()), (CharSequence)query)) continue;
                listStructures.add(Structure.renvoyerItemStructure((String)structure.getKey()));
            }
            jsTree = this.filterTree(autorisations, (List<InfosStructure>)listStructures, parameters);
            this.openAllNodes(jsTree.getNodes());
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to filter Rubrique tree for query \"%s\"", query), (Throwable)e);
        }
        return jsTree;
    }

    public static String getPath(String root, String code, String separator) {
        ArrayList<String> path = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)root)) {
            root = "00";
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return root;
        }
        InfosStructure structure = Structure.renvoyerItemStructure(code);
        while (StringUtils.isNotBlank((CharSequence)structure.getCode()) && !root.equals(structure.getCode())) {
            path.add(structure.getLibelleAffichable());
            structure = structure.getStructureRattachement();
        }
        Collections.reverse(path);
        return StringUtils.join(path, (String)separator);
    }

    @Override
    protected JsTreeModel filterTree(AutorisationBean autorisations, List<InfosStructure> structures, HashMap<String, String> parameters) {
        JsTreeModel jsTree = new JsTreeModel();
        String permissions = parameters.get("PERMISSION");
        InfosStructure structure = Structure.renvoyerItemStructure(parameters.get("RACINE"));
        int niveau = Integer.parseInt(parameters.get("NIVEAU"));
        HashSet<String> ids = new HashSet<String>();
        boolean front = parameters.get("FRONT") != null && parameters.get("FRONT").equals("true");
        TypeStructureFilter filter = null;
        if (!StringUtils.isEmpty((CharSequence)parameters.get("FILTRE"))) {
            filter = new TypeStructureFilter(parameters.get("FILTRE"));
        }
        for (InfosStructure currentStructure : structures) {
            ids.add(currentStructure.getCode());
            InfosStructure structureMere = Structure.renvoyerItemStructure(currentStructure.getCodeRattachement());
            while (StringUtils.isNotBlank((CharSequence)structureMere.getCode())) {
                ids.add(structureMere.getCode());
                structureMere = Structure.renvoyerItemStructure(structureMere.getCodeRattachement());
            }
        }
        if (ids.isEmpty()) {
            return jsTree;
        }
        ids.add("00");
        jsTree.getNodes().add(StructuresJsTree.buildStructureNode(permissions, autorisations, filter, structure, front, niveau, ids));
        return jsTree;
    }

    @Override
    public String getSelectedIds(String string) {
        String[] selections;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (String currentSelection : selections = string.split(";")) {
            try {
                InfosStructure structure = Structure.renvoyerItemStructure(currentSelection);
                if (structure == null || !StringUtils.isNotBlank((CharSequence)structure.getCode())) continue;
                selectedIds.add(structure.getCodeObjet() + "_" + Long.toString(structure.getIdStructure()));
            }
            catch (Exception e) {
                LOG.error("An error occured trying to retrieve Rubrique", (Throwable)e);
            }
        }
        return StringUtils.join(selectedIds, (String)";");
    }
}

