/*
 * Decompiled with CFR 0.152.
 */
package com.univ.tree.servlet;

import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.tree.processus.GestionJsTree;
import com.univ.tree.utils.JsTreeManager;
import com.univ.utils.SessionUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsTreeServlet
extends HttpServlet {
    private static final long serialVersionUID = -7982996758134619952L;
    private static final Logger LOG = LoggerFactory.getLogger(JsTreeServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (SessionUtil.getInfosSession(req).get("CODE") == null || autorisations == null) {
            req.getRequestDispatcher("/adminsite/").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(req.getParameter("JSTREEBEAN"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
            String action = req.getParameter("ACTION");
            try {
                if (!StringUtils.isBlank((CharSequence)action)) {
                    if (action.equals("RECHERCHER")) {
                        String resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterRechercheDepuisRequete(req).getNodes());
                        resp.setContentType("application/json");
                        resp.getWriter().write(resultatFormatter);
                    } else if (action.equals("FILTRER")) {
                        String resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterFiltreDepuisRequete(req).getNodes());
                        resp.setContentType("application/json");
                        resp.getWriter().write(resultatFormatter);
                    } else {
                        String resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterDepuisRequete(req).getNodes());
                        resp.setContentType("application/json");
                        resp.getWriter().write(resultatFormatter);
                    }
                } else {
                    String resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterDepuisRequete(req).getNodes());
                    resp.setContentType("application/json");
                    resp.getWriter().write(resultatFormatter);
                }
            }
            catch (ErreurAsyncException eA) {
                resp.getWriter().write(eA.getMessage());
                resp.setStatus(500);
            }
            catch (Exception e) {
                LOG.error("Une erreur est survenue lors de la construction de l'arborescence", (Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (SessionUtil.getInfosSession(req).get("CODE") == null || autorisations == null) {
            req.getRequestDispatcher("/adminsite/").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(req.getParameter("JSTREEBEAN"));
            resp.setCharacterEncoding("UTF-8");
            try {
                String result = gestionJsTree.traiterAction(autorisations, req.getParameterMap());
                resp.getWriter().write(result);
            }
            catch (ErreurAsyncException e) {
                resp.getWriter().write(e.getMessage());
                resp.setStatus(500);
            }
        }
    }
}

