/*
 * Decompiled with CFR 0.152.
 */
package com.univ.tree.utils;

import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.tree.bean.JsTreeNodeModel;
import com.univ.tree.processus.GestionJsTree;
import com.univ.tree.utils.JsTreeManager;
import com.univ.utils.EscapeString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsTreeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsTreeUtils.class);
    public static final String MODE_PARAM = "MODE";
    public static final String CODE_ROOT = "00";
    public static final String PARAM_BEAN_JSTREE = "JSTREEBEAN";
    public static final String BASE_URL_JSTREE = "/servlet/com.kportal.servlet.JsTreeServlet?JSTREEBEAN=%s";
    public static final String BASE_REQUEST_JSTREE = "/servlet/com.kportal.servlet.JsTreeServlet%s?JSTREEBEAN=%s";

    public static HashMap<String, String> getParameters(HttpServletRequest req) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String currentKey : req.getParameterMap().keySet()) {
            String currentValue = req.getParameter(currentKey);
            if (!StringUtils.isNotBlank((CharSequence)currentValue)) continue;
            parameters.put(currentKey, currentValue);
        }
        String permission = req.getParameter("PERMISSION") == null ? StringUtils.defaultString((String)req.getPathInfo()) : StringUtils.defaultString((String)req.getParameter("PERMISSION"));
        parameters.put("PERMISSION", permission);
        parameters.put("NIVEAU", StringUtils.isBlank((CharSequence)req.getParameter("NIVEAU")) ? "1" : req.getParameter("NIVEAU"));
        return parameters;
    }

    public static String getAjaxUrl(HttpServletRequest req) {
        HashMap<String, String> params = JsTreeUtils.getParameters(req);
        StringBuilder url = new StringBuilder(String.format(BASE_REQUEST_JSTREE, params.get("PERMISSION"), params.get(PARAM_BEAN_JSTREE)));
        GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(params.get(PARAM_BEAN_JSTREE));
        try {
            if (gestionJsTree != null) {
                if (StringUtils.isBlank((CharSequence)params.get("ACTION"))) {
                    gestionJsTree.assertParametersConsistency(params);
                }
                params.put("RACINE", "{0}");
                params.put("CODE", "{0}");
                params.remove("PERMISSION");
                params.remove(PARAM_BEAN_JSTREE);
                for (String currentKey : params.keySet()) {
                    if (StringUtils.isEmpty((CharSequence)params.get(currentKey))) continue;
                    url.append("&").append(EscapeString.escapeURL(currentKey)).append("=").append(params.get(currentKey));
                }
            }
        }
        catch (Exception e) {
            LOG.error("les parametres pass\u00e9s dans la requ\u00eate ne respectent pas les conditions pour generer un arbre", (Throwable)e);
            url = new StringBuilder("");
        }
        return url.toString();
    }

    public static String getFilterUrl(HttpServletRequest req) {
        HashMap<String, String> params = JsTreeUtils.getParameters(req);
        return String.format("/servlet/com.kportal.servlet.JsTreeServlet/TECH/rub/M?JSTREEBEAN=%s&ACTION=FILTRER&QUERY={0}", params.get(PARAM_BEAN_JSTREE));
    }

    public static String getSelected(HttpServletRequest req) {
        HashMap<String, String> params = JsTreeUtils.getParameters(req);
        GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(params.get(PARAM_BEAN_JSTREE));
        return gestionJsTree.getSelectedIds(params.get("SELECTED"));
    }

    public static String getSearchAjaxUrl(HttpServletRequest req) {
        HashMap<String, String> params = JsTreeUtils.getParameters(req);
        return JsTreeUtils.getSearchAjaxUrl(params);
    }

    public static String getSearchAjaxUrl(Map<String, String> params) {
        StringBuilder url = new StringBuilder(String.format(BASE_URL_JSTREE, params.get(PARAM_BEAN_JSTREE)));
        GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(params.get(PARAM_BEAN_JSTREE));
        try {
            if (gestionJsTree != null) {
                params.put("ACTION", "RECHERCHER");
                gestionJsTree.assertParametersConsistency(params);
                params.remove(PARAM_BEAN_JSTREE);
                for (String currentKey : params.keySet()) {
                    if (StringUtils.isEmpty((CharSequence)params.get(currentKey))) continue;
                    url.append("&").append(currentKey).append("=").append(params.get(currentKey));
                }
            }
        }
        catch (Exception e) {
            LOG.error("les parametres pass\u00e9s dans la requ\u00eate ne respectent pas les conditions pour generer un arbre", (Throwable)e);
            url = new StringBuilder("");
        }
        return url.toString();
    }

    public static String getSearchAjaxUrl(String params) {
        String[] splitParams;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String currentParam : splitParams = params.split("&")) {
            String[] keyValue = currentParam.split("=");
            if (StringUtils.isBlank((CharSequence)keyValue[0]) || StringUtils.isBlank((CharSequence)keyValue[1])) continue;
            parameters.put(keyValue[0], keyValue[1]);
        }
        return JsTreeUtils.getSearchAjaxUrl(parameters);
    }

    public static boolean isRubriqueSelectable(String permissions, AutorisationBean autorisations, InfosRubriques rubrique, Set<String> ids) throws Exception {
        boolean inIds;
        boolean selectableItem = true;
        boolean bl = inIds = ids == null || ids.isEmpty() || ids.contains(rubrique.getCode());
        if (permissions.length() > 0 && inIds) {
            selectableItem = Rubrique.controlerPermission(autorisations, permissions, rubrique.getCode());
        }
        return selectableItem;
    }

    public static boolean isRubriqueVisible(String permissions, AutorisationBean autorisations, InfosRubriques rubrique, boolean selectable, Set<String> ids) throws Exception {
        boolean inIds;
        boolean visible = selectable;
        boolean bl = inIds = ids == null || ids.isEmpty() || ids.contains(rubrique.getCode());
        if (!selectable) {
            Iterator<InfosRubriques> listSousRubriquesIt = rubrique.getListeSousRubriques().iterator();
            while (listSousRubriquesIt.hasNext() && !visible) {
                InfosRubriques sousRubrique = listSousRubriquesIt.next();
                visible = JsTreeUtils.isRubriqueVisible(permissions, autorisations, sousRubrique, JsTreeUtils.isRubriqueSelectable(permissions, autorisations, sousRubrique, ids), ids);
            }
        }
        return visible && inIds;
    }

    public static boolean isGroupeSelectable(String permissions, AutorisationBean autorisations, InfosGroupeDsi groupeDsi, Set<String> ids) throws Exception {
        boolean inIds;
        boolean selectableItem = groupeDsi.isSelectionnable();
        boolean bl = inIds = ids == null || ids.isEmpty() || ids.contains(groupeDsi.getCode());
        if (selectableItem && permissions.length() > 0) {
            selectableItem = permissions.startsWith("DYN") ? groupeDsi.getRequete().length() <= 0 : Groupedsi.controlerPermission(autorisations, permissions, groupeDsi.getCode());
        }
        return selectableItem && inIds;
    }

    public static boolean isGroupeVisible(String permissions, AutorisationBean autorisations, InfosGroupeDsi groupe, boolean selectable, Set<String> ids) throws Exception {
        boolean inIds;
        boolean visible = selectable;
        boolean bl = inIds = ids == null || ids.isEmpty() || ids.contains(groupe.getCode());
        if (!selectable) {
            Iterator<InfosGroupeDsi> listSousGroupesIt = groupe.getListeSousGroupes().iterator();
            while (listSousGroupesIt.hasNext() && !visible) {
                InfosGroupeDsi sousGroupe = listSousGroupesIt.next();
                visible = JsTreeUtils.isGroupeVisible(permissions, autorisations, sousGroupe, JsTreeUtils.isGroupeSelectable(permissions, autorisations, sousGroupe, ids), ids);
            }
        }
        return visible && inIds;
    }

    public static JsTreeNodeModel getNodeWithCode(JsTreeNodeModel tree, String code) {
        JsTreeNodeModel node = null;
        for (JsTreeNodeModel currentNode : tree.getChildren()) {
            if (currentNode.getMetadata().get("sCode").equals(code)) {
                node = currentNode;
            } else if (currentNode.getChildren().size() > 0) {
                node = JsTreeUtils.getNodeWithCode(currentNode, code);
            }
            if (node == null) continue;
            break;
        }
        return node;
    }

    public static enum Mode {
        STRUCTURE,
        RUBRIQUE,
        GROUPE;

    }
}

