/*
 * Decompiled with CFR 0.152.
 */
package com.univ.url;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import com.kportal.cache.AbstractCacheManager;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.FichePageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.url.CacheUrlRubrique;
import com.univ.url.UrlCacheRequest;
import com.univ.url.UrlManager;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheUrlManager
extends AbstractCacheManager {
    public static final String ID_BEAN = "cacheUrlManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheUrlRubrique.class);
    public static final String KEY_CACHE = "CacheUrlManager.cacheUrlRubrique";

    public static CacheUrlManager getInstance() {
        return (CacheUrlManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    private CacheUrlRubrique cacheUrlRubrique() {
        CacheUrlRubrique cacheUrlRubrique = new CacheUrlRubrique();
        Hashtable<String, String> lstUrlNavigation = cacheUrlRubrique.getLstUrlNavigation();
        Hashtable<String, String> lstNavigationUrl = cacheUrlRubrique.getLstNavigationUrl();
        for (InfosSite infoSite : Site.getListeInfosSites().values()) {
            int niveauMini = infoSite.getNiveauMinReecritureRubrique();
            int niveauMaxi = infoSite.getNiveauMaxReecritureRubrique();
            String codeRubriqueSite = infoSite.getCodeRubrique();
            InfosRubriques rubriqueSite = StringUtils.isEmpty((CharSequence)codeRubriqueSite) ? Rubrique.getTopLevelRubrique() : Rubrique.renvoyerItemRubrique(codeRubriqueSite);
            String urlSite = URLResolver.getAbsoluteUrl("/", infoSite, 0);
            if (StringUtils.isNotEmpty((CharSequence)codeRubriqueSite)) {
                String idNavigation = infoSite.getAlias() + ";" + codeRubriqueSite;
                lstUrlNavigation.put(idNavigation, urlSite);
                lstNavigationUrl.put(urlSite, idNavigation);
            }
            for (InfosRubriques infosRubCourante : rubriqueSite.getListeSousRubriquesTousNiveaux()) {
                StringBuilder urlRubrique = new StringBuilder();
                String codeRubrique = infosRubCourante.getCode();
                InfosRubriques infosRubNiveau = infosRubCourante;
                if (infoSite.getModeReecritureRubrique() != 0) {
                    int niveauRubrique = infosRubNiveau.getNiveau();
                    if (niveauRubrique <= niveauMaxi) {
                        while (niveauRubrique != 0 && niveauRubrique >= niveauMini) {
                            if (niveauRubrique <= niveauMaxi) {
                                if (urlRubrique.length() > 0) {
                                    urlRubrique.insert(0, "/");
                                }
                                urlRubrique.insert(0, Chaine.formatString(infosRubNiveau.getLibelleAffichable()));
                            }
                            infosRubNiveau = infosRubNiveau.getRubriqueMere();
                            niveauRubrique = infosRubNiveau.getNiveau();
                        }
                    }
                } else {
                    urlRubrique.append(Chaine.formatString(infosRubCourante.getLibelleAffichable()));
                }
                String idNavigation = infoSite.getAlias() + ";" + codeRubrique;
                BeanPageAccueil beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(infosRubCourante);
                if (beanAccueil == null) {
                    lstUrlNavigation.put(idNavigation, "");
                    continue;
                }
                if (infoSite.getModeReecritureRubrique() == 0 && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil) continue;
                if (urlRubrique.length() == 0) {
                    urlRubrique.append(Chaine.formatString(infosRubCourante.getLibelleAffichable()));
                }
                while (lstNavigationUrl.get(urlSite + urlRubrique.toString() + "/") != null) {
                    if (urlRubrique.toString().endsWith("-")) {
                        urlRubrique.append("+");
                        continue;
                    }
                    urlRubrique.append("-");
                }
                urlRubrique.insert(0, urlSite).append("/");
                lstUrlNavigation.put(idNavigation, urlRubrique.toString());
                lstNavigationUrl.put(urlRubrique.toString(), idNavigation);
            }
        }
        LOGGER.info("Chargement de " + lstNavigationUrl.size() + " urls de rubrique OK");
        return cacheUrlRubrique;
    }

    @TempCacheGet(key="CacheUrlManager.getAbsoluteUrlFriendly", contextual=false)
    public String getAbsoluteUrlFriendly(String key, OMContext ctx, Metatag metatag, UrlCacheRequest ucr) throws Exception {
        if (metatag == null) {
            return this.getAbsoluteUrlFriendly(ctx, ucr);
        }
        InfosSite infosSite = Site.renvoyerItemSite(ucr.getAlias());
        return URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(infosSite, Rubrique.renvoyerItemRubrique(ucr.getCodeRubrique()), metatag), ctx, infosSite);
    }

    @TempCacheFlush(key="CacheUrlManager.getAbsoluteUrlFriendly", contextual=false)
    public void refreshUrl(String key) {
    }

    private String getAbsoluteUrlFriendly(OMContext ctx, UrlCacheRequest ucr) throws Exception {
        String codeRubriqueAffichageTemp;
        String codeRubriqueCourante = ucr.getCodeRubrique();
        String codeRubriqueAffichage = ucr.getCodeRubriqueAffichage();
        String codeObjet = ucr.getCodeObjet();
        String codeFiche = ucr.getCodeFiche();
        String langueFiche = ucr.getLangueFiche();
        String etatFiche = ucr.getEtatFiche();
        if (etatFiche == null || etatFiche.length() == 0) {
            etatFiche = "0003";
        }
        if (langueFiche == null || langueFiche.length() == 0) {
            langueFiche = ctx instanceof ContexteUniv ? ((ContexteUniv)ctx).getLangue() : "0";
        }
        boolean chargementFiche = false;
        Metatag meta = new Metatag();
        meta.init();
        try (ContexteDao ctxDao = new ContexteDao();){
            meta.setCtx(ctxDao);
            ClauseWhere whereMeta = CacheUrlManager.whereMetaCodeObjetCodeLangueEtat(codeObjet, codeFiche, langueFiche, etatFiche);
            if (meta.select(whereMeta.formaterSQL()) > 0) {
                chargementFiche = true;
            } else if (!ctx.getLocale().equals(LangueUtil.getDefaultLocale()) && meta.select((whereMeta = CacheUrlManager.whereMetaCodeObjetCodeLangueEtat(codeObjet, codeFiche, LangueUtil.getLangueLocale(LangueUtil.getDefaultLocale()), etatFiche)).formaterSQL()) > 0) {
                chargementFiche = true;
            }
            if (!chargementFiche && meta.select((whereMeta = CacheUrlManager.whereMetaCodeObjetCodeLangueEtat(codeObjet, codeFiche, langueFiche, "0007")).formaterSQL()) > 0) {
                chargementFiche = true;
            }
            if (!chargementFiche) {
                String string = "";
                return string;
            }
            meta.nextItem();
        }
        ArrayList<String> lstCodeRubriquePubliable = new ArrayList<String>();
        if (meta.getMetaCodeRubrique().length() > 0) {
            lstCodeRubriquePubliable.add(meta.getMetaCodeRubrique());
        }
        Rubriquepublication rp = new Rubriquepublication();
        rp.init();
        ContexteDao ctxDao = new ContexteDao();
        Object object = null;
        try {
            rp.setCtx(ctxDao);
            if (rp.select(codeObjet, codeFiche, langueFiche) > 0) {
                while (rp.nextItem()) {
                    lstCodeRubriquePubliable.add(rp.getRubriqueDest());
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctxDao != null) {
                if (object != null) {
                    try {
                        ctxDao.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctxDao.close();
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)codeRubriqueAffichage)) {
            codeRubriqueAffichageTemp = codeRubriqueAffichage;
        } else {
            codeRubriqueAffichageTemp = Rubrique.getRubriquePublication(ctx, Rubrique.renvoyerItemRubrique(codeRubriqueCourante), lstCodeRubriquePubliable, true);
            if (codeRubriqueAffichageTemp == null) {
                for (String codeRubriqueTemp : lstCodeRubriquePubliable) {
                    if (Site.determinerSiteRubrique(codeRubriqueTemp, false) == null) continue;
                    codeRubriqueAffichageTemp = codeRubriqueTemp;
                    break;
                }
            }
            if (codeRubriqueAffichageTemp == null) {
                codeRubriqueAffichageTemp = Site.getSitePrincipal() != null ? Site.getSitePrincipal().getCodeRubrique() : codeRubriqueCourante;
            }
        }
        InfosSite site = Site.determinerSiteRubrique(codeRubriqueAffichageTemp);
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubriqueAffichageTemp);
        return URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(site, rubrique, meta), ctx, site);
    }

    private static ClauseWhere whereMetaCodeObjetCodeLangueEtat(String codeObjet, String code, String langue, String etat) {
        ClauseWhere whereCodeObjetCodeLangueEtat = new ClauseWhere(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
        whereCodeObjetCodeLangueEtat.and(ConditionHelper.egalVarchar("META_CODE", code));
        whereCodeObjetCodeLangueEtat.and(ConditionHelper.egalVarchar("META_LANGUE", langue));
        whereCodeObjetCodeLangueEtat.and(ConditionHelper.egalVarchar("META_ETAT_OBJET", etat));
        return whereCodeObjetCodeLangueEtat;
    }

    @Override
    public Object getObjectToCache() throws Exception {
        return this.cacheUrlRubrique();
    }

    @Override
    public String getCacheName() {
        return KEY_CACHE;
    }

    @Override
    public Object getObjectKey() {
        return KEY_CACHE;
    }
}

