/*
 * Decompiled with CFR 0.152.
 */
package com.univ.url;

import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.kportal.cms.objetspartages.om.ContentRedirect;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.SSOBean;
import com.univ.url.FrontOfficeMgr;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ExceptionFicheArchivee;
import com.univ.utils.ExceptionFicheNonAccessible;
import com.univ.utils.ExceptionFicheNonTrouvee;
import com.univ.utils.ExceptionLogin;
import com.univ.utils.ExceptionSite;
import com.univ.utils.ServicesUtil;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ContentServlet.class);
    private static final long serialVersionUID = 1L;

    public String getServletInfo() {
        return "K-Portal - Content Servlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            if (request.getRequestURI().startsWith("/adminsite")) {
                this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String forward = "";
            boolean kticketValide = false;
            try {
                String parametreFWD = request.getParameter("FWD");
                String parametreJSP = request.getParameter("JSP");
                if (request.getParameter("kticket") != null) {
                    kticketValide = this.gestionConnexionMultisite(request, response, ctx);
                    if ("".equals(parametreFWD)) {
                        LOG.debug("FWD = vide -> on sort de ContentServlet -->");
                        return;
                    }
                }
                String dossierJspFo = ctx.getInfosSite().getJspFo();
                if (StringUtils.isNotEmpty((CharSequence)parametreFWD) && (kticketValide || this.isParametreValidePourForward(parametreFWD, dossierJspFo))) {
                    forward = parametreFWD;
                    LOG.debug("FWD = " + forward);
                } else {
                    LOG.debug("FWD = vide -> lecture fiche ou parametre JSP");
                    FicheUniv fiche = FrontOfficeMgr.lireFiche(request);
                    if (fiche instanceof ContentRedirect && StringUtils.isNotBlank((CharSequence)((ContentRedirect)((Object)fiche)).getUrlRedirect())) {
                        response.sendRedirect(((ContentRedirect)((Object)fiche)).getUrlRedirect());
                        forward = "";
                        return;
                    }
                    if (this.isParametreValidePourForward(parametreJSP, dossierJspFo)) {
                        forward = parametreJSP;
                        LOG.debug("JSP = " + forward);
                    } else {
                        FicheUniv ficheCourante = ctx.getFicheCourante();
                        forward = dossierJspFo + "/fiche_" + ReferentielObjets.getNomObjet(ficheCourante) + ".jsp";
                        String webAppPath = WebAppUtil.getAbsolutePath();
                        if (!new File(webAppPath + forward).exists()) {
                            forward = dossierJspFo + "/fiche_objet.jsp";
                        }
                    }
                }
            }
            catch (ExceptionFicheArchivee | ExceptionFicheNonAccessible | ExceptionLogin | ExceptionSite e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                forward = ctx.getInfosSite().getJspFo() + "/jsb_exception.jsp";
                request.setAttribute("Exception", (Object)e);
            }
            catch (ExceptionFicheNonTrouvee e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                response.setStatus(404);
                forward = ctx.getInfosSite().getJspFo() + "/error/404.jsp?URL_DEMANDEE=" + URLEncoder.encode(request.getRequestURI(), "UTF-8");
                if (StringUtils.isNotEmpty((CharSequence)request.getHeader("referer"))) {
                    forward = forward + "&REFERER=" + URLEncoder.encode(request.getHeader("referer"), "UTF-8");
                }
                request.setAttribute("Exception", (Object)e);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                forward = ctx.getInfosSite().getJspFo() + "/jsb_exception.jsp";
                request.setAttribute("Exception", (Object)e);
            }
            finally {
                if (StringUtils.isNotBlank((CharSequence)forward)) {
                    ServletContext context = this.getServletConfig().getServletContext();
                    RequestDispatcher rd = context.getRequestDispatcher(forward);
                    rd.forward((ServletRequest)request, (ServletResponse)response);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean gestionConnexionMultisite(HttpServletRequest request, HttpServletResponse response, ContexteUniv ctx) {
        boolean kticketValide;
        block11: {
            kticketValide = Boolean.FALSE;
            if (ctx.getKsession().length() == 0) {
                SSOBean ssoBean = null;
                try {
                    ssoBean = ServicesUtil.getSSOBean(request);
                    LOG.debug("enregistrement ksession dans la session http : " + ssoBean.getId());
                    request.getSession(Boolean.FALSE.booleanValue()).setAttribute("KSESSION", (Object)ssoBean.getId());
                    String codeUtilisateur = ssoBean.getCodeKportal();
                    if (GestionnaireIdentification.getInstance().getMappingLogin() && ssoBean.getCodeGestion().length() > 0) {
                        codeUtilisateur = ssoBean.getCodeGestion();
                    }
                    GestionnaireIdentification.getInstance().chargeInfoUser(codeUtilisateur, ctx, request.getSession(Boolean.FALSE.booleanValue()), request.getHeader("user-agent"));
                    ctx.initialiserInfosUtilisateur();
                    LOG.debug("ksession dans le contexte :" + ctx.getKsession());
                    LOG.debug("code utilisateur dans le contexte :" + ctx.getCode());
                    kticketValide = Boolean.TRUE;
                }
                catch (Exception e) {
                    if (ssoBean != null) {
                        if (ssoBean.getCodeRetour().equals("100")) {
                            LOG.error("kticket non valide");
                            break block11;
                        }
                        if (ssoBean.getCodeRetour().equals("200")) {
                            LOG.error("session expir\u00e9e pour le kticket");
                            break block11;
                        }
                        if (ssoBean.getCodeRetour().equals("400")) {
                            LOG.error("Erreur de validation du kticket");
                            break block11;
                        }
                        if (ssoBean.getCodeRetour().equals("500")) {
                            LOG.error("kreferer non valide");
                            break block11;
                        }
                        if (!ssoBean.getCodeRetour().equals("600")) break block11;
                        LOG.error("ksite non valide");
                        break block11;
                    }
                    LOG.error("kticket invalide ignor\u00e9");
                }
            } else {
                Cookie[] tCookies;
                LOG.debug("ksession existe -> suppression de kticket et maj du cookie 'sso' \u00e0 false");
                ServicesUtil.supprimerTicket(request.getParameter("kticket"));
                for (Cookie cookie : tCookies = request.getCookies()) {
                    if (!cookie.getName().equals("sso")) continue;
                    cookie.setValue("false");
                    cookie.setMaxAge(0);
                    response.addCookie(cookie);
                    break;
                }
            }
        }
        return kticketValide;
    }

    private boolean isParametreValidePourForward(String urlAForwarder, String dossierJspValide) {
        return StringUtils.isNotEmpty((CharSequence)urlAForwarder) && urlAForwarder.startsWith(dossierJspValide + "/");
    }
}

