/*
 * Decompiled with CFR 0.152.
 */
package com.univ.url;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.composant.Menu;
import com.kportal.ihm.utils.EncadresFrontUtils;
import com.kportal.ihm.utils.FrontUtil;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.SousParagrapheBean;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.url.BeanFrontManager;
import com.univ.url.FrontOfficeBean;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontOfficeBeanUtil
implements BeanFrontManager<FrontOfficeBean> {
    private static final Logger LOG = LoggerFactory.getLogger(FrontOfficeBeanUtil.class);

    @Override
    public FrontOfficeBean initialiseBeanFront() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        FrontOfficeBean foBean = new FrontOfficeBean();
        foBean.setSaisieFront(this.isSaisieFront(ctx));
        foBean.setFicheUniv(ctx.getFicheCourante());
        foBean.setAccueilSite(FrontUtil.isAccueilSite(foBean.getFicheUniv()));
        foBean.setAccueilRubrique(FrontUtil.isFicheAccueilRubrique(foBean.getFicheUniv()));
        foBean.setApercu(ctx.isApercu());
        foBean.setMetatag(ctx.getMetaCourant());
        foBean.setCollaboratif(Espacecollaboratif.isExtensionActivated() && StringUtils.isNotBlank((CharSequence)ctx.getEspaceCourant()));
        FrontOfficeBeanUtil.initialiseEncadres(ctx, foBean);
        foBean.setActivationDSI("1".equals(PropertyHelper.getCoreProperty("dsi.activation")));
        foBean.setDsi(foBean.isActivationDSI() && StringUtils.isNotBlank((CharSequence)ctx.getCode()));
        List<Menu> menuSecondaire = FrontUtil.getMenuSecondairePageCourante();
        foBean.setNavigationSecondairePresente(foBean.isCollaboratif() || menuSecondaire != null && !menuSecondaire.isEmpty());
        foBean.setJspFo(ctx.getInfosSite().getJspFo());
        FrontOfficeBeanUtil.initialiseRubrique(ctx, foBean);
        FrontOfficeBeanUtil.initialiseRedacteur(foBean);
        this.initialiseMenus(foBean);
        return foBean;
    }

    private void initialiseMenus(FrontOfficeBean foBean) {
        foBean.setMenuAccesDirect(FrontUtil.getMenuAccesDirectParCategorie());
        foBean.setMenuLangue(FrontUtil.getMenuLangueParCategorie());
        foBean.setMenuPrincipal(FrontUtil.getMenuPrincipalParCategorie());
        foBean.setMenuSecondaire(FrontUtil.getMenuSecondairePageCourante());
        foBean.setMenuPiedDePage(FrontUtil.getMenuPiedDePageParCategorie());
        foBean.setMenuReseauxSociaux(FrontUtil.getMenuReseauxSociauxParCategorie());
    }

    private boolean isSaisieFront(ContexteUniv ctx) {
        InfoBean infoBean = (InfoBean)ctx.getRequeteHTTP().getAttribute("infoBean");
        if (infoBean != null && StringUtils.isNotBlank((CharSequence)infoBean.get("SAISIE_FRONT", String.class)) && StringUtils.isNotBlank((CharSequence)infoBean.getNomProcessus())) {
            return FrontUtil.isSaisieFront(infoBean.get("SAISIE_FRONT", String.class), infoBean.getNomProcessus());
        }
        return FrontUtil.isSaisieFront(ctx.getRequeteHTTP().getParameter("SAISIE_FRONT"), ctx.getRequeteHTTP().getParameter("PROC"));
    }

    private static void initialiseEncadres(ContexteUniv ctx, FrontOfficeBean foBean) {
        if (!foBean.isCollaboratif() && !foBean.isSaisieFront()) {
            foBean.setEncadresFiche(EncadresFrontUtils.getEncadresParType());
            foBean.setEncadresAutoFiche(EncadresFrontUtils.getEncadresAutoFiche(ctx, foBean.getFicheUniv()));
            foBean.setEncadresRecherche(EncadresFrontUtils.getEncadresRechercheFiche(foBean.getFicheUniv()));
            foBean.setEncadrePresent(FrontOfficeBeanUtil.existeEncadrePourPage(foBean));
        } else if (StringUtils.isNotBlank((CharSequence)ctx.getTemplateExterne())) {
            HashMap<String, List<SousParagrapheBean>> encadresExterne = new HashMap<String, List<SousParagrapheBean>>();
            encadresExterne.put("encadre_externe", EncadresFrontUtils.getEncadresExterne(ctx));
            foBean.setEncadresFiche(encadresExterne);
        }
    }

    private static boolean existeEncadrePourPage(FrontOfficeBean foBean) {
        List<SousParagrapheBean> sousParagrapheEncadre;
        boolean existeEncadreFiche = Boolean.FALSE;
        Iterator<List<SousParagrapheBean>> iterator = foBean.getEncadresFiche().values().iterator();
        while (iterator.hasNext() && !(existeEncadreFiche = !(sousParagrapheEncadre = iterator.next()).isEmpty())) {
        }
        return existeEncadreFiche || StringUtils.isNotBlank((CharSequence)foBean.getEncadresAutoFiche()) || !foBean.getEncadresRecherche().isEmpty();
    }

    private static void initialiseRubrique(ContexteUniv ctx, FrontOfficeBean foBean) {
        ArrayList<InfosRubriques> listeRubriques = FrontUtil.calculerRubriquesPageCourante(ctx, 5);
        InfosRubriques rubriqueNiveau1 = (InfosRubriques)listeRubriques.get(2);
        if (rubriqueNiveau1 != null) {
            foBean.setVisuelRubrique(FrontUtil.getUrlBandeauCourant(ctx));
            try {
                foBean.setAccrocheRubrique(UnivWebFmt.formaterEnHTML(ctx, rubriqueNiveau1.getAccroche()));
            }
            catch (Exception e) {
                LOG.error("impossible de calculer l'accroche de la rubrique courante", (Throwable)e);
            }
            foBean.setContactRubrique(rubriqueNiveau1.getContact());
            if (StringUtils.isNotBlank((CharSequence)rubriqueNiveau1.getCouleurTitre())) {
                String couleurTitreRubrique = rubriqueNiveau1.getCouleurTitre();
                if (!couleurTitreRubrique.contains("#")) {
                    couleurTitreRubrique = "#" + couleurTitreRubrique;
                }
                foBean.setCouleurTitreRubrique(couleurTitreRubrique);
            }
            if (rubriqueNiveau1.getCouleurFond().length() > 0) {
                String couleurFondRubrique = rubriqueNiveau1.getCouleurFond();
                if (!couleurFondRubrique.contains("#")) {
                    couleurFondRubrique = "#" + couleurFondRubrique;
                }
                foBean.setCouleurFondRubrique(couleurFondRubrique);
            }
        }
    }

    private static void initialiseRedacteur(FrontOfficeBean foBean) {
        FicheUniv ficheCourante = foBean.getFicheUniv();
        if (ficheCourante != null && FrontOfficeBeanUtil.isUtilisateurValide(ficheCourante.getCodeRedacteur())) {
            try {
                Utilisateur utilisateur = Utilisateur.getUtilisateur(foBean.getFicheUniv().getCodeRedacteur());
                if (utilisateur != null) {
                    foBean.setRedacteur(utilisateur.getPrenom() + " " + utilisateur.getNom());
                }
            }
            catch (Exception e) {
                LOG.error("impossible de calculer le redacteur de la fiche courante", (Throwable)e);
            }
        }
    }

    private static boolean isUtilisateurValide(String codeRedacteur) {
        return StringUtils.isNotBlank((CharSequence)codeRedacteur) && !"ANONYME".equals(codeRedacteur);
    }
}

