/*
 * Decompiled with CFR 0.152.
 */
package com.univ.url;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.kportal.extension.module.plugin.rubrique.FichePageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.url.CacheUrlManager;
import com.univ.url.UrlCacheRequest;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.ExceptionFicheArchivee;
import com.univ.utils.ExceptionFicheNonAccessible;
import com.univ.utils.ExceptionFicheNonTrouvee;
import com.univ.utils.ExceptionLogin;
import com.univ.utils.ExceptionSite;
import com.univ.utils.ExceptionUrlObsolete;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontOfficeMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontOfficeMgr.class);
    private static final String ID_BEAN = "frontOfficeMgr";
    public CacheUrlManager cacheUrlManager;

    public static FicheUniv lireFiche(HttpServletRequest request) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String uri = request.getRequestURI();
        String queryString = request.getQueryString();
        String url = uri;
        if (queryString != null && queryString.length() > 0) {
            url = url + "?" + queryString;
        }
        return FrontOfficeMgr.lireFiche(ctx, url, request.getParameterMap());
    }

    public static void lireFiche(ContexteUniv ctx, HttpServletRequest request) throws Exception {
        String uri = request.getRequestURI();
        if (FrontOfficeMgr.isURIFicheUniv(ctx, uri)) {
            String queryString = request.getQueryString();
            String url = uri;
            if (queryString != null && queryString.length() > 0) {
                url = url + "?" + queryString;
            }
            FrontOfficeMgr.lireFiche(ctx, url, request.getParameterMap());
        }
    }

    private static boolean isURIFicheUniv(ContexteUniv ctx, String uri) {
        return uri.startsWith(ctx.getInfosSite().getJspFo() + "/fiche_");
    }

    public static FicheUniv lireFiche(ContexteUniv ctx, String url, Map<String, String[]> params) throws Exception {
        Object code;
        boolean oldUrl = false;
        String uri = url;
        String param = "";
        if (url.contains("?")) {
            uri = url.substring(0, url.indexOf("?"));
            param = url.substring(url.indexOf("?") + 1);
        }
        Long idMeta = null;
        Metatag meta = new Metatag();
        meta.init();
        try {
            idMeta = new Long(uri.substring(uri.lastIndexOf("-") + 1, uri.lastIndexOf(".")));
        }
        catch (Exception e) {
            idMeta = null;
        }
        ClauseWhere whereMetatag = null;
        if (idMeta != null) {
            whereMetatag = new ClauseWhere(ConditionHelper.egal("ID_METATAG", idMeta, TypeOperande.LONG));
            whereMetatag.and(ConditionHelper.in("META_ETAT_OBJET", Arrays.asList("0003", "0005")));
        } else if (param.length() > 0) {
            String objet = RequeteUtil.renvoyerParametre(param, "OBJET");
            if (objet.length() == 0) {
                String s = "^\\" + ctx.getInfosSite().getJspFo() + "\\/fiche_([a-z]+).jsp.*$";
                Pattern p = Pattern.compile(s);
                Matcher m = p.matcher(url);
                objet = m.find() ? m.group(1) : "pagelibre";
            }
            code = RequeteUtil.renvoyerParametre(param, "CODE");
            String langue = RequeteUtil.renvoyerParametre(param, "LANGUE");
            whereMetatag = new ClauseWhere(ConditionHelper.egalVarchar("META_CODE_OBJET", ReferentielObjets.getCodeObjet(objet)));
            whereMetatag.and(ConditionHelper.egalVarchar("META_CODE", (String)code));
            whereMetatag.and(ConditionHelper.egalVarchar("META_LANGUE", langue));
            whereMetatag.and(ConditionHelper.egalVarchar("META_ETAT_OBJET", "0003"));
            oldUrl = RequeteUtil.renvoyerParametre(param, "JSP").length() == 0;
            String[] tParam = param.split("&");
            param = "";
            for (String p : tParam) {
                if (p.startsWith("OBJET=") || p.startsWith("CODE=") || p.startsWith("LANGUE=")) continue;
                param = param + (param.length() > 0 ? "&" : "") + p;
            }
        }
        if (whereMetatag == null) {
            throw new ExceptionFicheNonTrouvee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"));
        }
        try {
            ContexteDao ctxDao = new ContexteDao();
            code = null;
            try {
                meta.setCtx(ctxDao);
                meta.select(whereMetatag.formaterSQL());
                if (!meta.nextItem()) {
                    throw new ExceptionFicheNonTrouvee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"));
                }
            }
            catch (Throwable langue) {
                code = langue;
                throw langue;
            }
            finally {
                if (ctxDao != null) {
                    if (code != null) {
                        try {
                            ctxDao.close();
                        }
                        catch (Throwable langue) {
                            ((Throwable)code).addSuppressed(langue);
                        }
                    } else {
                        ctxDao.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionFicheNonTrouvee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"));
        }
        ctx.setMetaCourant(meta);
        String langueObjet = meta.getMetaLangue();
        String etatObjet = meta.getMetaEtatObjet();
        if ("0005".equals(etatObjet)) {
            ctx.setApercu(true);
        }
        if ("0004".equals(etatObjet) || "0006".equals(etatObjet)) {
            throw new ExceptionFicheArchivee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"));
        }
        if ("0007".equals(etatObjet)) {
            throw new ExceptionFicheArchivee(MessageHelper.getCoreMessage("ST_FICHE_ARCHIVEE"));
        }
        ctx.setLocale(LangueUtil.getLocale(langueObjet));
        ctx.setLangue(langueObjet);
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
        ficheUniv.init();
        ficheUniv.setIdFiche(meta.getMetaIdFiche());
        try {
            ContexteDao ctxDao = new ContexteDao();
            Object object = null;
            try {
                ficheUniv.setCtx(ctxDao);
                ficheUniv.retrieve();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ctxDao != null) {
                    if (object != null) {
                        try {
                            ctxDao.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ctxDao.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionFicheNonTrouvee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"));
        }
        if (oldUrl) {
            String newUrl = URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, ficheUniv), ctx);
            if (param.length() > 0) {
                newUrl = newUrl + (newUrl.contains("?") ? "&" : "?" + param);
            }
            throw new ExceptionUrlObsolete(newUrl);
        }
        String codeRubriqueForcee = null;
        if (FicheUnivMgr.isFicheCollaborative(ficheUniv)) {
            DiffusionSelective dif = (DiffusionSelective)((Object)ficheUniv);
            ctx.setEspaceCourant(dif.getDiffusionPublicViseRestriction());
            InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(dif.getDiffusionPublicViseRestriction());
            ctx.setInfosEspace(infosEspace);
            codeRubriqueForcee = infosEspace.getCodeRubrique();
        }
        PluginFicheHelper.setDataContexteUniv(ficheUniv, meta, "");
        if (!ctx.isApercu()) {
            InfosSite site = null;
            String codeRubriqueAffichage = null;
            if (params.get("RF") != null) {
                codeRubriqueForcee = params.get("RF")[0];
            }
            boolean controleRubrique = false;
            if (codeRubriqueForcee != null) {
                controleRubrique = true;
                if (ctx.getInfosSite().isRubriqueVisibleInSite(Rubrique.renvoyerItemRubrique(codeRubriqueForcee))) {
                    codeRubriqueAffichage = codeRubriqueForcee;
                } else {
                    site = Site.determinerSiteRubrique(codeRubriqueForcee);
                }
            } else {
                ArrayList<String> lstCodeRubriquePubliable = new ArrayList<String>();
                if (meta.getMetaCodeRubrique().length() > 0) {
                    lstCodeRubriquePubliable.add(meta.getMetaCodeRubrique());
                }
                Rubriquepublication rp = new Rubriquepublication();
                rp.init();
                try (ContexteDao ctxDao = new ContexteDao();){
                    rp.setCtx(ctxDao);
                    if (rp.select(meta.getMetaCodeObjet(), meta.getMetaCode(), langueObjet) > 0) {
                        while (rp.nextItem()) {
                            lstCodeRubriquePubliable.add(rp.getRubriqueDest());
                        }
                    }
                }
                codeRubriqueAffichage = Rubrique.getRubriquePublication(ctx, Rubrique.renvoyerItemRubrique(ctx.getCodeRubriqueHistorique()), lstCodeRubriquePubliable, true);
                if (codeRubriqueAffichage == null) {
                    site = Rubriquepublication.getSiteAffichage(ctx, ficheUniv);
                }
                if (site != null && site.equals(ctx.getInfosSite())) {
                    site = null;
                }
            }
            if (site != null && !site.getAlias().equals(ctx.getInfosSite().getAlias())) {
                String urlFiche = UnivWebFmt.determinerUrlFiche(ctx, ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName())), ficheUniv.getCode(), ficheUniv.getLangue(), true, codeRubriqueForcee);
                if (codeRubriqueForcee != null) {
                    urlFiche = urlFiche.contains("?") ? urlFiche + "&amp;RF=" + codeRubriqueForcee : urlFiche + "?RF=" + codeRubriqueForcee;
                }
                throw new ExceptionSite(URLResolver.getAbsoluteUrl(urlFiche, (OMContext)ctx, site));
            }
            if (codeRubriqueAffichage == null) {
                if (ctx.getInfosSite().getRestriction() == 1) {
                    if (ctx.getCode().length() == 0) {
                        throw new ExceptionLogin(url);
                    }
                    String errorMessage = MessageHelper.getCoreMessage(ctx.getLocale(), "FICHE.ERREUR.NON_VISIBLE_DANS_SITE");
                    errorMessage = errorMessage + String.format(" [ code : %s , nom : %s, type : %s]", ficheUniv.getCode(), ficheUniv.getLibelleAffichable(), ficheUniv.getClass().getName());
                    throw new ErreurApplicative(errorMessage);
                }
                codeRubriqueAffichage = ctx.getCodeRubriquePageCourante();
            }
            ctx.setCodeRubriqueFicheCourante(codeRubriqueAffichage);
            ctx.calculerCodeRubriquePageCourante();
            if (!FicheUnivMgr.controlerRestriction(ficheUniv, ctx, controleRubrique)) {
                String msg = MessageHelper.getCoreMessage(ctx.getLocale(), "ST_FICHE_INACCESSIBLE");
                if (ctx.getCode().length() > 0) {
                    msg = msg + "<br />" + MessageHelper.getCoreMessage(ctx.getLocale(), "ST_PAS_DROITS_ACCES");
                    throw new ExceptionFicheNonAccessible(msg);
                }
                throw new ExceptionLogin(url);
            }
        }
        if (ctx.isApercu()) {
            ctx.setCodeRubriqueFicheCourante(ficheUniv.getCodeRubrique());
            ctx.calculerCodeRubriquePageCourante();
            FicheUnivMgr.supprimerFiche(ficheUniv, true);
        }
        ficheUniv.setCtx(ctx);
        ctx.setFicheCourante(ficheUniv);
        return ficheUniv;
    }

    public static FicheUniv lireFicheAccueilRubrique(String url) throws Exception {
        String basePath;
        if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)(basePath = URLResolver.getBasePath(ContexteUtil.getContexteUniv().getRequeteHTTP())))) {
            FichePageAccueilRubrique.BeanFichePageAccueil beanAccueil;
            InfosRubriques rubriqueCourante;
            String[] temp;
            String navigation = FrontOfficeMgr.getInstance().getLstNavigationUrl().get(basePath + url);
            String codeRubrique = "";
            if (navigation != null && (temp = navigation.split(";", -2)).length > 1 && (rubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubrique = temp[1])) != null && (beanAccueil = (FichePageAccueilRubrique.BeanFichePageAccueil)PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(rubriqueCourante)) != null && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil) {
                FichePageAccueilRubrique.BeanFichePageAccueil fichePageAccueilRubrique = beanAccueil;
                return fichePageAccueilRubrique.getFichePageTete(false);
            }
        }
        return null;
    }

    public String getAbsoluteUrlFriendly(OMContext ctx, String codeObjet, String codeFiche, String langueFiche, String etatFiche, String codeRubriqueAffichage, String params) throws Exception {
        UrlCacheRequest ucr;
        String urlFiche;
        if (ctx.getInfosSite() == null) {
            ctx.setInfosSite(Site.getSitePrincipal());
        }
        String codeRubriqueCourante = ctx.getInfosSite().getCodeRubrique();
        if (ctx instanceof ContexteUniv) {
            codeRubriqueCourante = EscapeString.escapeURL(((ContexteUniv)ctx).getCodeRubriquePageCourante());
        }
        if (StringUtils.isEmpty((CharSequence)(urlFiche = this.cacheUrlManager.getAbsoluteUrlFriendly((ucr = new UrlCacheRequest(ctx.getInfosSite().getAlias(), codeRubriqueCourante, codeRubriqueAffichage, codeObjet, codeFiche, langueFiche, etatFiche)).getKey(), ctx, null, ucr)))) {
            this.cacheUrlManager.refreshUrl(ucr.getKey());
        }
        if (StringUtils.isNotBlank((CharSequence)urlFiche) && StringUtils.isNotBlank((CharSequence)params)) {
            urlFiche = urlFiche + (urlFiche.contains("?") ? "&" : "?");
            urlFiche = urlFiche + params;
        }
        return urlFiche;
    }

    public Hashtable<String, String> getLstNavigationUrl() {
        return Rubrique.getCacheUrlRubrique().getLstNavigationUrl();
    }

    public Hashtable<String, String> getLstUrlNavigation() {
        return Rubrique.getCacheUrlRubrique().getLstUrlNavigation();
    }

    public String getUrlAccueilRubrique(InfosSite infoSite, String codeRubrique) {
        return Rubrique.getCacheUrlRubrique().getLstUrlNavigation().get(infoSite.getAlias() + ";" + codeRubrique);
    }

    public InfosRubriques getInfosRubriqueByUrl(String url) {
        InfosRubriques infosRubriques = null;
        String alias = Rubrique.getCacheUrlRubrique().getLstNavigationUrl().get(url);
        if (alias != null) {
            infosRubriques = Rubrique.renvoyerItemRubrique(alias.substring(alias.indexOf(";") + 1));
        }
        return infosRubriques;
    }

    public CacheUrlManager getCacheUrlManager() {
        return this.cacheUrlManager;
    }

    public void setCacheUrlManager(CacheUrlManager cacheUrlManager) {
        this.cacheUrlManager = cacheUrlManager;
    }

    public static FrontOfficeMgr getInstance() {
        return (FrontOfficeMgr)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }
}

