/*
 * Decompiled with CFR 0.152.
 */
package com.univ.url;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.FrontOfficeMgr;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ExceptionFicheNonTrouvee;
import com.univ.utils.RequeteUtil;
import com.univ.utils.ServicesUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriqueServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(RubriqueServlet.class);
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String forward = "";
        String sendRedirect = "";
        ContexteUniv ctx = null;
        boolean isInterne = true;
        try {
            ctx = ContexteUtil.getContexteUniv();
            String urlFrontOffice = PropertyHelper.getCoreProperty("application.front_site");
            String extension = PropertyHelper.getCoreProperty("application.content_extension");
            if (urlFrontOffice == null || urlFrontOffice.length() == 0) {
                urlFrontOffice = "/contribution";
            }
            if (request.getRequestURI().startsWith(urlFrontOffice)) {
                forward = UnivWebFmt.getUrlLogin(ctx, false);
            } else if (request.getRequestURI().endsWith("/")) {
                String url = URLResolver.getBasePath(request);
                if (request.getRequestURI().equals("/")) {
                    InfosSite infosSite = Site.renvoyerItemSiteParHost(request.getServerName());
                    String codeRubrique = infosSite.getCodeRubrique();
                    if (StringUtils.isNotBlank((CharSequence)codeRubrique) && !Rubrique.controlerRestrictionRubrique(ctx, codeRubrique)) {
                        if (ctx.getCode().length() == 0) {
                            UnivWebFmt.redirigerVersLogin(ctx, response, url + request.getRequestURI());
                            LOG.debug("Redirection login");
                            return;
                        }
                        throw new ErreurApplicative(MessageHelper.getCoreMessage(ctx.getLocale(), "RUBRIQUE.ERREUR.NON_VISIBLE_DANS_SITE"));
                    }
                    forward = this.gestionUrlForward(request, ctx, infosSite, extension);
                } else {
                    String navigation = FrontOfficeMgr.getInstance().getLstNavigationUrl().get(url + request.getRequestURI());
                    String codeRubrique = "";
                    if (navigation != null) {
                        String[] temp = navigation.split(";", -2);
                        codeRubrique = temp[1];
                        InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubrique);
                        forward = UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, codeRubrique, false, "", true, false);
                        if (forward.length() > 0) {
                            if (!forward.contains("." + extension) && !Rubrique.controlerRestrictionRubrique(ctx, codeRubrique)) {
                                if (ctx.getCode().length() == 0) {
                                    UnivWebFmt.redirigerVersLogin(ctx, response, url + request.getRequestURI());
                                    LOG.debug("Redirection login");
                                    return;
                                }
                                throw new ErreurApplicative(MessageHelper.getCoreMessage(ctx.getLocale(), "RUBRIQUE.ERREUR.NON_VISIBLE_DANS_SITE"));
                            }
                            isInterne = PageAccueilRubriqueManager.getInstance().isInterne(Rubrique.renvoyerItemRubrique(codeRubrique));
                        } else {
                            ctx.setCodeRubriquePageCourante(codeRubrique);
                            ctx.setCodeRubriqueFicheCourante(codeRubrique);
                            ctx.setLocale(LangueUtil.getLocale(rubriqueCourante.getLangue()));
                            throw new ExceptionFicheNonTrouvee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"));
                        }
                    }
                }
                if (isInterne && forward.indexOf(url) == 0) {
                    forward = forward.substring(url.length());
                }
                if (forward.startsWith("http://") || forward.startsWith("https://")) {
                    sendRedirect = forward;
                    forward = "";
                }
            }
            if (forward.length() > 0) {
                this.getServletContext().getRequestDispatcher(forward).forward((ServletRequest)request, (ServletResponse)response);
            } else if (sendRedirect.length() > 0) {
                if (ctx.getKsession().length() > 0 && ServicesUtil.validerUrl(sendRedirect)) {
                    sendRedirect = sendRedirect + (sendRedirect.contains("?") ? "&" : "?");
                    sendRedirect = sendRedirect + "kticket=" + ServicesUtil.genererTicketService(ctx) + "&ksite=" + URLResolver.getAbsoluteUrl("/", ctx);
                }
                response.sendRedirect(sendRedirect);
            } else {
                this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            forward = (ctx != null ? ctx.getInfosSite().getJspFo() : Site.getSitePrincipal().getJspFo()) + "/jsb_exception.jsp";
            request.setAttribute("Exception", (Object)e);
            this.getServletContext().getRequestDispatcher(forward).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String gestionUrlForward(HttpServletRequest request, ContexteUniv ctx, InfosSite infosSite, String extension) throws Exception {
        String codeRubrique = infosSite.getCodeRubrique();
        String forward = this.getUrlAccueilSite(request, infosSite, extension);
        if (StringUtils.isBlank((CharSequence)forward)) {
            forward = this.getUrlAccueilRubrique(ctx, infosSite, codeRubrique);
        }
        return forward;
    }

    @Deprecated
    private String getUrlAccueilSite(HttpServletRequest request, InfosSite infosSite, String extension) {
        String forward = "";
        if (infosSite.getUrlAccueil().length() > 0) {
            String accueil = infosSite.getUrlAccueil();
            if (accueil.contains("LANGUE=")) {
                int indiceLocaleCourant = 0;
                String lg = RequeteUtil.renvoyerParametre(accueil, "LANGUE");
                if (lg.equals("")) {
                    String langueNavigateur = request.getHeader("accept-language");
                    if (langueNavigateur != null && langueNavigateur.length() > 0) {
                        if (langueNavigateur.length() > 2) {
                            langueNavigateur = langueNavigateur.substring(0, 2);
                        }
                        indiceLocaleCourant = LangueUtil.getIndiceFromCodeISO(langueNavigateur);
                    }
                } else if (LangueUtil.getListeLangues().get(lg) == null) {
                    indiceLocaleCourant = -1;
                }
                if (indiceLocaleCourant == -1) {
                    indiceLocaleCourant = 0;
                }
                accueil = accueil.replaceAll("LANGUE=" + lg, "LOCALE=" + indiceLocaleCourant);
            }
            if (!accueil.contains("OBJET=") && !accueil.contains("FWD=")) {
                accueil = "FWD=" + accueil;
            }
            if (extension == null || extension.length() == 0) {
                extension = "htm";
            }
            forward = "/accueil." + extension + "?" + accueil;
        }
        return forward;
    }

    private String getUrlAccueilRubrique(ContexteUniv ctx, InfosSite infosSite, String codeRubrique) throws Exception {
        String forward = "";
        if (StringUtils.isNotBlank((CharSequence)codeRubrique)) {
            InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubrique);
            ctx.setLocale(LangueUtil.getLocale(rubriqueCourante.getLangue()));
            forward = UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, codeRubrique, false, "", false, false);
            if (StringUtils.isBlank((CharSequence)forward) && !this.isSitePrincipal(infosSite.getAlias())) {
                forward = this.renvoyerUrlAccueilSitePrincipal(ctx);
            }
        }
        return forward;
    }

    private boolean isSitePrincipal(String alias) throws Exception {
        InfosSite infosSitePrincipal = Site.getSitePrincipal();
        if (infosSitePrincipal == null) {
            LOG.debug("aucun site principal");
            return Boolean.TRUE;
        }
        String aliasSitePrincipal = infosSitePrincipal.getAlias();
        return StringUtils.equals((CharSequence)alias, (CharSequence)aliasSitePrincipal);
    }

    private String renvoyerUrlAccueilSitePrincipal(ContexteUniv ctx) throws Exception {
        InfosSite infosSitePrincipal = Site.getSitePrincipal();
        if (infosSitePrincipal == null) {
            LOG.debug("Pas de site principal");
            return "";
        }
        String codeRubriqueSite = infosSitePrincipal.getCodeRubrique();
        return UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, codeRubriqueSite, Boolean.FALSE);
    }
}

