/*
 * Decompiled with CFR 0.152.
 */
package com.univ.url;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.FrontOfficeMgr;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ServicesUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class UrlManager {
    public static String calculerUrlApercu(String idMeta) {
        return UrlManager.calculerUrl(idMeta, "apercu");
    }

    public static String calculerUrlPage(String idMeta) {
        return UrlManager.calculerUrl(idMeta, "page");
    }

    public static String calculerUrl(String idMeta, String libelle) {
        String extension = PropertyHelper.getCoreProperty("application.content_extension");
        if (extension == null || extension.length() == 0) {
            extension = "htm";
        }
        String url = "/";
        url = url + libelle;
        url = url + "-";
        url = url + idMeta;
        url = url + ".";
        url = url + extension;
        return url;
    }

    public static String calculerUrlFiche(OMContext ctx, String codeObjet, Long idFiche) {
        if (StringUtils.isEmpty((CharSequence)codeObjet) || codeObjet.equals("0010")) {
            return "";
        }
        Metatag metatag = new Metatag();
        metatag.init();
        metatag.setCtx(ctx);
        try {
            ClauseWhere whereMetaCodeObjetEtIdFiche = new ClauseWhere(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
            whereMetaCodeObjetEtIdFiche.and(ConditionHelper.egal("META_ID_FICHE", idFiche, TypeOperande.LONG));
            metatag.select(whereMetaCodeObjetEtIdFiche.formaterSQL());
            if (!metatag.nextItem()) {
                return "";
            }
        }
        catch (Exception e) {
            return "";
        }
        return UrlManager.calculerUrlFiche(Site.determinerSiteRubrique(metatag.getMetaCodeRubrique()), Rubrique.renvoyerItemRubrique(metatag.getMetaCodeRubrique()), metatag);
    }

    public static String calculerUrlFiche(InfosSite site, InfosRubriques rubrique, Metatag meta) {
        String urlRubrique;
        String urlFiche = Chaine.formatString(meta.getMetaLibelleFiche());
        if (site != null && site.getModeReecritureRubrique() != 0 && StringUtils.isNotEmpty((CharSequence)(urlRubrique = FrontOfficeMgr.getInstance().getUrlAccueilRubrique(site, rubrique.getCode())))) {
            urlFiche = String.format("%s%s", urlRubrique, urlFiche);
            urlFiche = StringUtils.substringAfter((String)urlFiche, (String)URLResolver.getAbsoluteUrl("/", site, 0));
        }
        return UrlManager.calculerUrl(meta.getIdMetatag().toString(), urlFiche);
    }

    public static String calculerUrlFiche(OMContext ctx, Long idMeta) {
        Metatag metatag = new Metatag();
        metatag.init();
        metatag.setCtx(ctx);
        metatag.setIdMetatag(idMeta);
        try {
            metatag.retrieve();
            if (metatag.getMetaCodeObjet().equals("0010")) {
                return "";
            }
        }
        catch (Exception e) {
            return "";
        }
        return UrlManager.calculerUrlFiche(Site.determinerSiteRubrique(metatag.getMetaCodeRubrique()), Rubrique.renvoyerItemRubrique(metatag.getMetaCodeRubrique()), metatag);
    }

    public static String calculerUrlFiche(Metatag metatag) {
        if (metatag.getMetaCodeObjet().equals("0010")) {
            return "";
        }
        return UrlManager.calculerUrlFiche(Site.determinerSiteRubrique(metatag.getMetaCodeRubrique()), Rubrique.renvoyerItemRubrique(metatag.getMetaCodeRubrique()), metatag);
    }

    public static String calculerUrlForward(ContexteUniv ctx, String urlForward) throws Exception {
        String redirect = URLEncoder.encode(urlForward, "UTF-8");
        String extension = PropertyHelper.getCoreProperty("application.content_extension");
        if (extension == null || extension.length() == 0) {
            extension = "htm";
        }
        return "/forward." + extension + "?kticket=" + ServicesUtil.genererTicketService(ctx) + "&FWD=" + redirect;
    }
}

