/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public class ANSICodec {
    private final HashMap<Integer, Integer> unicodeToANSI = new HashMap();
    private final HashMap<String, String> unicodeToHex = new HashMap();
    private static ANSICodec codec = null;

    public ANSICodec() {
        this.initialize();
    }

    public static final ANSICodec getInstance() {
        if (codec == null) {
            codec = new ANSICodec();
        }
        return codec;
    }

    private final void initialize() {
        this.unicodeToANSI.put(376, 159);
        this.unicodeToHex.put("\u009f", "&#376;");
        this.unicodeToHex.put("\u0178", "&#376;");
        this.unicodeToANSI.put(382, 158);
        this.unicodeToHex.put("\u009e", "&#382;");
        this.unicodeToHex.put("\u017e", "&#382;");
        this.unicodeToANSI.put(339, 156);
        this.unicodeToHex.put("\u009c", "&#339;");
        this.unicodeToHex.put("\u0153", "&#339;");
        this.unicodeToANSI.put(8250, 155);
        this.unicodeToHex.put("\u009b", "&#8250;");
        this.unicodeToHex.put("\u203a", "&#8250;");
        this.unicodeToANSI.put(353, 154);
        this.unicodeToHex.put("\u009a", "&#353;");
        this.unicodeToHex.put("\u0161", "&#353;");
        this.unicodeToANSI.put(8482, 153);
        this.unicodeToHex.put("\u0099", "&#8482;");
        this.unicodeToHex.put("\u2122", "&#8482;");
        this.unicodeToANSI.put(732, 152);
        this.unicodeToHex.put("\u0098", "&#732;");
        this.unicodeToHex.put("\u02dc", "&#732;");
        this.unicodeToANSI.put(8212, 151);
        this.unicodeToHex.put("\u0097", "&#8212;");
        this.unicodeToHex.put("\u2014", "&#8212;");
        this.unicodeToANSI.put(8211, 150);
        this.unicodeToHex.put("\u0096", "&#8211;");
        this.unicodeToHex.put("\u2013", "&#8211;");
        this.unicodeToANSI.put(8226, 149);
        this.unicodeToHex.put("\u0095", "&#8226;");
        this.unicodeToHex.put("\u0095", "&#8226;");
        this.unicodeToANSI.put(8221, 148);
        this.unicodeToHex.put("\u0094", "&#8221;");
        this.unicodeToHex.put("\u201d", "&#8221;");
        this.unicodeToANSI.put(8220, 147);
        this.unicodeToHex.put("\u0093", "&#8220;");
        this.unicodeToHex.put("\u201c", "&#8220;");
        this.unicodeToANSI.put(8217, 146);
        this.unicodeToHex.put("\u0092", "&#8217;");
        this.unicodeToHex.put("\u2019", "&#8217;");
        this.unicodeToANSI.put(8216, 145);
        this.unicodeToHex.put("\u0091", "&#8216;");
        this.unicodeToHex.put("\u2018", "&#8216;");
        this.unicodeToANSI.put(381, 142);
        this.unicodeToHex.put("\u008e", "&#381;");
        this.unicodeToHex.put("\u017d", "&#381;");
        this.unicodeToANSI.put(338, 140);
        this.unicodeToHex.put("\u008c", "&#338;");
        this.unicodeToHex.put("\u0152", "&#338;");
        this.unicodeToANSI.put(8249, 139);
        this.unicodeToHex.put("\u008b", "&#8249;");
        this.unicodeToHex.put("\u2039", "&#8249;");
        this.unicodeToANSI.put(352, 138);
        this.unicodeToHex.put("\u008a", "&#352;");
        this.unicodeToHex.put("\u0160", "&#352;");
        this.unicodeToANSI.put(8240, 137);
        this.unicodeToHex.put("\u0089", "&#8240;");
        this.unicodeToHex.put("\u2030", "&#8240;");
        this.unicodeToANSI.put(710, 136);
        this.unicodeToHex.put("\u0088", "&#710;");
        this.unicodeToHex.put("\u02c6", "&#710;");
        this.unicodeToANSI.put(8225, 135);
        this.unicodeToHex.put("\u0087", "&#8225;");
        this.unicodeToHex.put("\u2021", "&#8225;");
        this.unicodeToANSI.put(8224, 134);
        this.unicodeToHex.put("\u0086", "&#8224;");
        this.unicodeToHex.put("\u2020", "&#8224;");
        this.unicodeToANSI.put(8230, 133);
        this.unicodeToHex.put("\u0085", "&#8230;");
        this.unicodeToHex.put("\u2026", "&#8230;");
        this.unicodeToANSI.put(8222, 132);
        this.unicodeToHex.put("\u0084", "&#8222;");
        this.unicodeToHex.put("\u201e", "&#8222;");
        this.unicodeToANSI.put(402, 131);
        this.unicodeToHex.put("\u0083", "&#402;");
        this.unicodeToHex.put("\u0192", "&#402;");
        this.unicodeToANSI.put(8218, 130);
        this.unicodeToHex.put("\u0082", "&#8218;");
        this.unicodeToHex.put("\u201a", "&#8218;");
        this.unicodeToANSI.put(8364, 128);
        this.unicodeToHex.put("\u0080", "&#8364;");
        this.unicodeToHex.put("\u20ac", "&#8364;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String decode(String chars) {
        BufferedReader br = new BufferedReader(new StringReader(chars));
        StringWriter sw = new StringWriter();
        try {
            int c;
            while ((c = br.read()) != -1) {
                if (this.unicodeToANSI.get(c) != null) {
                    c = this.unicodeToANSI.get(c);
                }
                ((Writer)sw).write(c);
            }
        }
        catch (IOException e) {
            String string = chars;
            return string;
        }
        finally {
            try {
                ((Writer)sw).close();
                br.close();
            }
            catch (IOException iOException) {}
        }
        return ((Object)sw).toString();
    }

    public final String encodeSpecialEntities(String chars) {
        for (String s : this.unicodeToHex.keySet()) {
            chars = chars.replace(s, this.unicodeToHex.get(s));
        }
        return chars;
    }
}

