/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.AttributRequeteur;
import com.univ.utils.ContexteUtil;
import com.univ.utils.DateUtil;
import com.univ.utils.IRequeteurConstantes;
import com.univ.utils.TableauBordAttribute;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRequeteur
implements IRequeteurConstantes {
    private String mode = "CONSUL";
    private TreeSet<String> listeActions = null;
    private boolean pagination = true;
    private boolean lien_ajout = true;
    private Hashtable<String, AttributRequeteur> listeAttributs = null;

    public AbstractRequeteur() {
    }

    public AbstractRequeteur(InfoBean infoBean) {
        String mode = "";
        String selection = "";
        String pagination = "";
        String lien = "";
        String dossier = "";
        String requete = "";
        if (infoBean.get("MODE") != null) {
            mode = infoBean.getString("MODE");
        }
        if (infoBean.get("ACTIONS") != null) {
            selection = infoBean.getString("ACTIONS");
        }
        if (infoBean.get("PAGE") != null) {
            pagination = infoBean.getString("PAGE");
        }
        if (infoBean.get("AJOUT") != null) {
            lien = infoBean.getString("AJOUT");
        }
        if (infoBean.get("DOSSIER") != null) {
            dossier = infoBean.getString("DOSSIER");
        }
        if (infoBean.get("REQUETE") != null) {
            requete = infoBean.getString("REQUETE");
        }
        this.initialiserRequeteur(mode, selection, pagination, lien, dossier, requete, infoBean);
    }

    public AbstractRequeteur(String mode, String selection, String pagination, String lien, String requete) {
        this.initialiserRequeteur(mode, selection, pagination, lien, "0", requete, null);
    }

    public AbstractRequeteur(String mode, String selection, String pagination, String lien, String dossier, String requete) {
        this.initialiserRequeteur(mode, selection, pagination, lien, dossier, requete, null);
    }

    private final void initialiserRequeteur(String _mode, String _selection, String _pagination, String _lien, String dossier, String _requete, InfoBean infoBean) {
        this.mode = _mode;
        this.listeActions = this.initialiserActions(_selection);
        this.pagination = AbstractRequeteur.getBooleanValue(_pagination);
        this.lien_ajout = AbstractRequeteur.getBooleanValue(_lien);
        this.listeAttributs = this.initialiserAttributs(infoBean);
        this.finaliser();
    }

    private TreeSet<String> initialiserActions(String actions) {
        TreeSet<String> treeTemp = new TreeSet<String>();
        if (StringUtils.isEmpty((CharSequence)actions) && !this.mode.equals("CONSUL")) {
            treeTemp.add("V");
            treeTemp.add("M");
        } else if (StringUtils.isNotEmpty((CharSequence)actions)) {
            for (String action : actions.split(",")) {
                if (!"M".equals(action) && !"S".equals(action) && !"V".equals(action)) continue;
                treeTemp.add(action);
            }
        }
        return treeTemp;
    }

    private Hashtable<String, AttributRequeteur> initialiserAttributs(InfoBean infoBean) {
        Hashtable<String, AttributRequeteur> hTemp = new Hashtable<String, AttributRequeteur>();
        if (infoBean == null) {
            return hTemp;
        }
        for (TableauBordAttribute attribute : TableauBordAttribute.values()) {
            String valeur = "";
            if (infoBean.get(attribute.getValue()) != null) {
                valeur = infoBean.get(attribute.getValue()).getClass().isAssignableFrom(Date.class) ? DateUtil.getSimpleDateFormat().format(infoBean.get(attribute.getValue())) : infoBean.getString(attribute.getValue());
            }
            boolean donneeNonSaisie = StringUtils.isEmpty((CharSequence)valeur) || valeur.equals("0000");
            boolean requetable = true;
            if (donneeNonSaisie && infoBean.get(attribute.getRequeteParam()) != null) {
                requetable = AbstractRequeteur.getBooleanValue(infoBean.getString(attribute.getRequeteParam()));
            }
            boolean triable = true;
            if (donneeNonSaisie && infoBean.get(attribute.getTriParam()) != null) {
                triable = AbstractRequeteur.getBooleanValue(infoBean.getString(attribute.getTriParam()));
            }
            hTemp.put(attribute.getValue(), new AttributRequeteur(attribute.getValue(), valeur, requetable, triable));
        }
        return hTemp;
    }

    private final void finaliser() {
        String code;
        if (this.mode.equals("CONSUL")) {
            this.setAttribut("ETAT_OBJET", "0003", false, false);
        }
        if (this.mode.equals("VALID")) {
            this.setAttribut("ETAT_OBJET", "0002", false, false);
            String message = MessageHelper.getCoreMessage(ContexteUtil.getContexteUniv().getLocale(), "ST_REQUETEUR_TITRE_MES_FICHES_A_VALIDER");
            if (message.length() == 0) {
                message = "Mes fiches \u00e0 valider";
            }
            this.setAttribut("TITRE", message, false, false);
        }
        if (this.listeAttributs.containsKey("CODE_REDACTEUR") && (code = this.getAttribut("CODE_REDACTEUR").getValeur()).equals("DYNAMIK")) {
            String message = MessageHelper.getCoreMessage(ContexteUtil.getContexteUniv().getLocale(), "ST_REQUETEUR_TITRE_MES_FICHES");
            if (message.length() == 0) {
                message = "Mes fiches";
            }
            this.setAttribut("TITRE", message, false, false);
        }
    }

    public final void setAttribut(String _nom, String _valeur, boolean _requetable, boolean _triable) {
        if (this.listeAttributs.containsKey(_nom)) {
            this.listeAttributs.remove(_nom);
        }
        this.listeAttributs.put(_nom, new AttributRequeteur(_nom, _valeur, _requetable, _triable));
    }

    public final void setAttribut(String _nom, String _chaine) {
        String valeur = _chaine;
        boolean requetable = true;
        boolean triable = true;
        StringTokenizer st2 = new StringTokenizer(_chaine, "|");
        if (st2.countTokens() == 3 || st2.countTokens() == 2) {
            valeur = st2.countTokens() == 3 && st2.hasMoreTokens() ? st2.nextToken() : "";
            if (st2.hasMoreTokens()) {
                requetable = AbstractRequeteur.getBooleanValue(st2.nextToken());
            }
            if (st2.hasMoreTokens()) {
                triable = AbstractRequeteur.getBooleanValue(st2.nextToken());
            }
        } else if (valeur.equals("1") && !_nom.equals("LANGUE_FICHE")) {
            valeur = "";
            requetable = true;
            triable = true;
        } else if (valeur.equals("0") && !_nom.equals("LANGUE_FICHE")) {
            valeur = "";
            requetable = false;
            triable = false;
        } else if (valeur.length() > 0) {
            requetable = true;
            triable = true;
        }
        if (this.listeAttributs.containsKey(_nom)) {
            this.listeAttributs.remove(_nom);
        }
        this.listeAttributs.put(_nom, new AttributRequeteur(_nom, valeur, requetable, triable));
    }

    public final AttributRequeteur getAttribut(String _nom) {
        AttributRequeteur attribut = null;
        attribut = this.listeAttributs.containsKey(_nom) ? this.listeAttributs.get(_nom) : new AttributRequeteur();
        return attribut;
    }

    public TreeSet<String> getListeActions() {
        return this.listeActions;
    }

    public Hashtable<String, AttributRequeteur> getListeAttributs() {
        return this.listeAttributs;
    }

    public boolean isLien_ajout() {
        return this.lien_ajout;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isPagination() {
        return this.pagination;
    }

    public final String genererUrlRequete() {
        String res = "/servlet/com.jsbsoft.jtf.core.SG?EXT=core&amp;PROC=GESTION_FICHES&amp;ACTION=LISTE&amp;";
        String temp = "";
        res = res + "MODE=" + this.mode;
        temp = this.getSelection();
        if (temp.length() > 0) {
            res = res + "&amp;ACTIONS=" + temp;
        }
        if (!this.pagination) {
            res = res + "&amp;PAGE=0";
        }
        if (!this.lien_ajout) {
            res = res + "&amp;AJOUT=0";
        }
        if ((temp = this.getAttributRequete()).length() > 0) {
            res = res + "&amp;REQUETE=" + temp;
        }
        return res;
    }

    public String getPagination() {
        return this.pagination ? "1" : "0";
    }

    public String getAjoutLien() {
        return this.lien_ajout ? "1" : "0";
    }

    public String getSelection() {
        StringBuilder res = new StringBuilder();
        for (String listeAction : this.listeActions) {
            if (res.length() > 0) {
                res.append(",");
            }
            res.append(listeAction);
        }
        return res.toString();
    }

    public final String getAttributRequete() {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, AttributRequeteur> entry : this.listeAttributs.entrySet()) {
            AttributRequeteur att = entry.getValue();
            if (StringUtils.isNotEmpty((CharSequence)att.getValeur())) {
                res.append("&");
                res.append(att.getNom().toUpperCase());
                res.append("=");
                res.append(att.getValeur());
            }
            if (!AbstractRequeteur.getBooleanValue(att.getRequetable())) {
                res.append("&");
                res.append(att.getNom().toUpperCase());
                res.append("_REQ=");
                res.append(att.getRequetable());
            }
            if (AbstractRequeteur.getBooleanValue(att.getTriable())) continue;
            res.append("&");
            res.append(att.getNom().toUpperCase());
            res.append("_TRI=");
            res.append(att.getTriable());
        }
        return res.toString();
    }

    public static final boolean getBooleanValue(String valeur, boolean defaut) {
        boolean res = defaut;
        if ("1".equals(valeur)) {
            res = true;
        } else if ("0".equals(valeur)) {
            res = false;
        }
        return res;
    }

    public static final boolean getBooleanValue(String valeur) {
        boolean res = true;
        if ("1".equals(valeur)) {
            res = true;
        } else if ("0".equals(valeur)) {
            res = false;
        }
        return res;
    }

    public static boolean getTriableBooleanValue(String valeur) {
        boolean res = false;
        if ("0000".equals(valeur) || "".equals(valeur) || "TOUS".equals(valeur)) {
            res = true;
        }
        return res;
    }

    public static final Date renvoyerDateSelection(String _code) {
        Date dateSelection = new Date(0L);
        if (_code.length() > 0) {
            Date dateAujourdhui = new Date(System.currentTimeMillis());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateAujourdhui);
            if (_code.equals("0001")) {
                dateSelection = dateAujourdhui;
            } else if (_code.equals("0002")) {
                int offset = (cal.get(7) - 2 + 7) % 7;
                cal.set(6, cal.get(6) - offset);
                dateSelection = new Date(cal.getTimeInMillis());
            } else if (_code.equals("0003")) {
                int offset = cal.get(5) - 1;
                cal.set(6, cal.get(6) - offset);
                dateSelection = new Date(cal.getTimeInMillis());
            }
        }
        return dateSelection;
    }

    protected static Condition traiterListeDesObjets(Collection<String> listeDesObjets, AutorisationBean autorisations, String mode, String codeStructure, String codeRubrique, String diffusionPublicVise, String diffusionPublicViseRestriction, String diffusionModeRestriction) throws Exception {
        ConditionList conditionSurObjet = new ConditionList();
        ArrayList<String> codesDesObjets = new ArrayList<String>();
        for (String nomObjet : listeDesObjets) {
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(nomObjet);
            if (AbstractRequeteur.isModeModificationOuValidation(ficheUniv, mode)) {
                ficheUniv = AbstractRequeteur.initialiserFicheUniv(ficheUniv, codeStructure, codeRubrique, diffusionPublicVise, diffusionModeRestriction, diffusionPublicViseRestriction);
                conditionSurObjet.or(RequeteSQLHelper.traiterConditionDsiMeta(autorisations, ficheUniv, mode, codeRubrique, null));
            }
            if (!AbstractRequeteur.isModeConsultationOuModification(ficheUniv, mode)) continue;
            codesDesObjets.add(ReferentielObjets.getCodeObjet(ficheUniv));
        }
        if (conditionSurObjet.isEmpty()) {
            if (codesDesObjets.isEmpty()) {
                return ConditionHelper.egalVarchar("T1.META_CODE_OBJET", "0000");
            }
            conditionSurObjet.setPremiereCondtion(ConditionHelper.in("T1.META_CODE_OBJET", codesDesObjets));
            if ("MODIF".equals(mode)) {
                conditionSurObjet.and(ConditionHelper.egalVarchar("T1.META_CODE_REDACTEUR", autorisations.getCode()));
            }
        } else if (!codesDesObjets.isEmpty()) {
            ConditionList conditionCodeObjetEtRedacteur = new ConditionList(ConditionHelper.in("T1.META_CODE_OBJET", codesDesObjets));
            conditionCodeObjetEtRedacteur.and(ConditionHelper.egalVarchar("T1.META_CODE_REDACTEUR", autorisations.getCode()));
            conditionSurObjet.or(conditionCodeObjetEtRedacteur);
        }
        return conditionSurObjet;
    }

    private static boolean isModeModificationOuValidation(FicheUniv ficheUniv, String mode) {
        return ficheUniv != null && ("MODIF".equals(mode) || "VALID".equals(mode));
    }

    private static boolean isModeConsultationOuModification(FicheUniv ficheUniv, String mode) {
        return ficheUniv != null && (StringUtils.isEmpty((CharSequence)mode) || "CONSUL".equals(mode) || "MODIF".equals(mode));
    }

    private static FicheUniv initialiserFicheUniv(FicheUniv ficheUniv, String codeStructure, String codeRubrique, String diffusionPublicVise, String diffusionModeRestriction, String diffusionPublicViseRestriction) {
        ficheUniv.init();
        ficheUniv.setCodeRattachement(codeStructure);
        ficheUniv.setCodeRubrique(codeRubrique);
        if (ficheUniv instanceof FicheRattachementsSecondaires) {
            ((FicheRattachementsSecondaires)((Object)ficheUniv)).setCodeRattachementAutres(codeStructure);
        }
        if (ficheUniv instanceof DiffusionSelective) {
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicVise(diffusionPublicVise);
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionModeRestriction(diffusionModeRestriction);
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicViseRestriction(diffusionPublicViseRestriction);
        }
        return ficheUniv;
    }

    public TreeMap<String, Object> getListeFiches(String _codeTri, String _ordreTri, int _from, int _increment, String _count) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dateDebut = new Date(0L);
        Date dateFin = new Date(0L);
        try {
            dateDebut = new Date(sdf.parse(this.getAttribut("DATE_DEBUT").getValeur()).getTime());
            dateFin = new Date(sdf.parse(this.getAttribut("DATE_FIN").getValeur()).getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getListeFiches(this.getAttribut("CODE_OBJET").getValeur(), this.getAttribut("ETAT_OBJET").getValeur(), this.getAttribut("LIBELLE_FICHE").getValeur(), this.getAttribut("CODE_REDACTEUR").getValeur(), this.getAttribut("CODE_RUBRIQUE").getValeur(), this.getAttribut("CODE_RATTACHEMENT").getValeur(), this.getAttribut("TYPE_DATE").getValeur(), dateDebut, dateFin, this.getAttribut("DIFFUSION_PUBLIC_VISE").getValeur(), this.getAttribut("DIFFUSION_MODE_RESTRICTION").getValeur(), this.getAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION").getValeur(), this.getAttribut("LANGUE_FICHE").getValeur(), _codeTri, _ordreTri, _from, _increment, this.getMode(), _count);
    }

    public TreeMap<String, Object> getListeFiches(String _codeObjet, String _etatObjet, String _libelle, String _codeRedacteur, String _codeRubrique, String _codeStructure, String _typeDate, Date _dateDebut, Date _dateFin, String _diffusionPublicVise, String _diffusionModeRestriction, String _diffusionPublicViseRestriction, String _langue, String _codeTri, String _ordreTri, int _from, int _increment, String _mode, String _count) throws Exception {
        String orderBy = "";
        String desc = "";
        if (_ordreTri.equals("desc")) {
            desc = "DESC";
        }
        orderBy = _codeTri.equals("") ? "META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : (_codeTri.equals("2") ? "META_DATE_MODIFICATION " + desc + ", META_LIBELLE_FICHE" : (_codeTri.equals("1") ? "META_LIBELLE_FICHE " + desc + ", META_DATE_MODIFICATION DESC" : (_codeTri.equals("3") ? "META_CODE_REDACTEUR " + desc + " , META_DATE_MODIFICATION DESC , META_LIBELLE_FICHE" : (_codeTri.equals("4") ? "META_ETAT_OBJET " + desc + ", META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : (_codeTri.equals("5") ? "META_LIBELLE_OBJET " + desc + ", META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : (_codeTri.equals("6") ? "RUB.INTITULE  " + desc + ", META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : (_codeTri.equals("7") ? "S.LIBELLE_COURT  " + desc + ", META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : (_codeTri.equals("8") ? "META_DIFFUSION_PUBLIC_VISE " + desc + ", META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : (_codeTri.equals("9") ? "META_LANGUE " + desc + ", META_DATE_MODIFICATION DESC, META_LIBELLE_FICHE" : _codeTri)))))))));
        TreeMap<String, Object> liste = null;
        liste = _mode.equals("CONSUL") || _mode.equals("MODIF") || _mode.equals("VALID") ? this.select(_codeObjet, _etatObjet, _libelle, _codeRedacteur, "", _codeStructure, _codeRubrique, _typeDate, _dateDebut, _dateFin, _diffusionPublicVise, _diffusionModeRestriction, _diffusionPublicViseRestriction, _langue, orderBy, _from, _increment, _mode, _count) : new TreeMap<String, Object>();
        return liste;
    }

    public int getCount() throws Exception {
        int count = 0;
        try {
            count = (Integer)this.getListeFiches("", "", 0, 0, "3").get("100000");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static String formaterRechercheRecursiveParRubrique(String _nomDonnee, String _codeRubrique, String _rubriqueRecherche) throws Exception {
        InfosRubriques rubriqueRecherche = Rubrique.renvoyerItemRubrique(_rubriqueRecherche);
        InfosRubriques infosRub = Rubrique.renvoyerItemRubrique(_codeRubrique);
        Collection<InfosRubriques> sousRubriques = infosRub.getListeSousRubriquesTousNiveaux();
        String sousReq = "";
        if (!sousRubriques.isEmpty()) {
            for (InfosRubriques rubriqueCourante : sousRubriques) {
                if (!_rubriqueRecherche.equals("") && !rubriqueRecherche.contains(rubriqueCourante)) continue;
                if (sousReq.length() > 0) {
                    sousReq = sousReq + ",";
                }
                sousReq = sousReq + "'" + rubriqueCourante.getCode() + "'";
            }
        }
        if (_rubriqueRecherche.equals("") || rubriqueRecherche.contains(Rubrique.renvoyerItemRubrique(_codeRubrique))) {
            if (sousReq.length() > 0) {
                sousReq = sousReq + ",";
            }
            sousReq = sousReq + "'" + _codeRubrique + "'";
        }
        if (sousReq.length() > 0) {
            return _nomDonnee.toUpperCase() + " IN (" + sousReq + ")";
        }
        return "";
    }

    public static String formaterRechercheParStructureMultiple(String _nomDonnee, String _codeStructures) {
        String resultatRequete = "";
        String newStructures = StringUtils.replace((String)_codeStructures, (String)"+", (String)";");
        StringTokenizer stStructures = new StringTokenizer(newStructures, ";");
        String codeStructure = "";
        Iterator<InfosStructure> listSousStructuresIt = null;
        while (stStructures.hasMoreTokens()) {
            codeStructure = stStructures.nextToken();
            if (codeStructure.equals("")) continue;
            listSousStructuresIt = Structure.renvoyerItemStructure(codeStructure).getListeSousStructuresTousNiveaux().iterator();
            if (resultatRequete.length() > 0) {
                resultatRequete = resultatRequete + " OR ";
            }
            resultatRequete = resultatRequete + _nomDonnee.toUpperCase() + " LIKE '%[" + codeStructure + "]%'";
            while (listSousStructuresIt.hasNext()) {
                codeStructure = listSousStructuresIt.next().getCode();
                resultatRequete = resultatRequete + " OR ";
                resultatRequete = resultatRequete + _nomDonnee.toUpperCase() + " LIKE '%[" + codeStructure + "]%'";
            }
        }
        return resultatRequete;
    }

    public HashSet<String> determinerListeSousRubriques(String _codeRubrique) throws Exception {
        HashSet<String> result = new HashSet<String>();
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(_codeRubrique);
        Collection<InfosRubriques> cRubriques = rubrique.getListeSousRubriquesTousNiveaux();
        for (InfosRubriques element : cRubriques) {
            result.add(element.getCode());
        }
        result.add(_codeRubrique);
        return result;
    }

    public HashSet<String> determinerListeSousRubriquesAutorisees(String _codeRubrique) throws Exception {
        HashSet<String> result = new HashSet<String>();
        Collection<InfosRubriques> cRubriques = Rubrique.determinerListeSousRubriquesAutorisees(ContexteUtil.getContexteUniv(), Rubrique.renvoyerItemRubrique(_codeRubrique));
        for (InfosRubriques element : cRubriques) {
            result.add(element.getCode());
        }
        result.add(_codeRubrique);
        return result;
    }

    public String getSqlBaseQuery() {
        return "SELECT DISTINCT T1.META_ID_FICHE, T1.META_CODE_OBJET FROM METATAG T1 ";
    }

    protected abstract TreeMap<String, Object> select(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, Date var9, Date var10, String var11, String var12, String var13, String var14, String var15, int var16, int var17, String var18, String var19) throws Exception;
}

