/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.univ.utils.ANSICodec;
import com.univ.utils.EscapeString;
import com.univ.utils.HTMLCodec;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.parser.txt.CharsetDetector;

public class Chaine {
    static final Pattern linkPattern = Pattern.compile("(?i)((?:(http[s]?)?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))");
    static final Pattern emailPattern = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*)@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");

    public static Vector<String> getVecteurSeparateur(String separateur, String chaine) {
        Vector<String> v = new Vector<String>();
        if (chaine != null) {
            StringTokenizer st = new StringTokenizer(chaine, separateur);
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
        }
        return v;
    }

    public static Vector<String> getVecteurPointsVirgules(String chaine) {
        Vector<String> v = new Vector<String>();
        if (chaine != null) {
            StringTokenizer st = new StringTokenizer(chaine, ";");
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
        }
        return v;
    }

    public static String convertirVirgulesEnAccolades(String chaine) {
        StringBuilder res = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)chaine)) {
            String[] temp;
            for (String element : temp = chaine.split(",")) {
                res.append("[").append(element).append("]");
            }
        }
        return res.toString();
    }

    public static String convertirPointsVirgulesEnAccolades(String chaine) {
        StringBuilder res = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)chaine)) {
            String[] temp;
            for (String element : temp = chaine.split(";")) {
                res.append("[").append(element).append("]");
            }
        }
        return res.toString();
    }

    public static Set<String> getHashSetPointsVirgules(String chaine) {
        HashSet<String> v = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(chaine, ";");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            v.add(val);
        }
        return v;
    }

    public static Set<String> getHashSetAccolades(String chaine) {
        HashSet<String> v = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)chaine)) {
            StringTokenizer st = new StringTokenizer(chaine, "[]");
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                v.add(val);
            }
        }
        return v;
    }

    public static String convertirPointsVirgules(Vector<String> v) {
        String res = "";
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            String item = e.nextElement();
            if (res.length() > 0) {
                res = res + ";";
            }
            res = res + item;
        }
        return res;
    }

    public static String convertirPointsVirgules(Set<String> v) {
        String res = "";
        for (String item : v) {
            if (res.length() > 0) {
                res = res + ";";
            }
            res = res + item;
        }
        return res;
    }

    public static Vector<String> getVecteurAccolades(String chaine) {
        Vector<String> v = new Vector<String>();
        if (StringUtils.isNotEmpty((CharSequence)chaine)) {
            StringTokenizer st = new StringTokenizer(chaine, "[]");
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                v.add(val);
            }
        }
        return v;
    }

    public static String convertirAccolades(Vector<String> v) {
        String res = "";
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            res = res + "[" + e.nextElement() + "]";
        }
        return res;
    }

    public static String transformeEnHtml(String _chaine) {
        Matcher matcherEmail = emailPattern.matcher(_chaine);
        _chaine = matcherEmail.replaceAll("<a href=\"mailto:$0\">$0</a>");
        Matcher matcherLink = linkPattern.matcher(_chaine);
        _chaine = matcherLink.replaceAll("<a href=\"$1\" onclick=\"javascript:window.open(this.href);return false;\">$1</a>");
        return _chaine;
    }

    @Deprecated
    public static String remplacerChaine1parChaine2(String _tag, String _chaine1, String _chaine2) {
        String tmp = "";
        int indexDebutTag = -1;
        int indexFinTag = 0;
        while ((indexDebutTag = _tag.indexOf(_chaine1, indexFinTag)) != -1) {
            tmp = tmp + _tag.substring(indexFinTag, indexDebutTag) + _chaine2;
            indexFinTag = indexDebutTag + _chaine1.length();
        }
        tmp = tmp + _tag.substring(indexFinTag);
        return tmp;
    }

    public static String traiterEmail(String _adresse) {
        if (_adresse == null) {
            return "";
        }
        String adresse = _adresse.trim().toLowerCase();
        adresse = StringUtils.replace((String)adresse, (String)"\u00e0", (String)"a");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e2", (String)"a");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e9", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e8", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ea", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00eb", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ee", (String)"i");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ef", (String)"i");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f4", (String)"o");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f6", (String)"o");
        adresse = StringUtils.replace((String)adresse, (String)"\u00fb", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00fc", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f9", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e7", (String)"c");
        adresse = StringUtils.replace((String)adresse, (String)"'", (String)"");
        adresse = StringUtils.replace((String)adresse, (String)" ", (String)"");
        return adresse;
    }

    public static String formatString(String chaine) {
        if (chaine == null) {
            return "";
        }
        int lg = chaine.length();
        StringBuilder sb = new StringBuilder(lg);
        int lastChar = 45;
        for (int i = 0; i < lg; ++i) {
            char c = chaine.charAt(i);
            int c2 = 63;
            int c3 = 63;
            if (c >= 'a' && c <= 'z') {
                c2 = c;
            } else if (c >= 'A' && c <= 'Z') {
                c2 = Character.toLowerCase(c);
            } else if (c >= '0' && c <= '9') {
                c2 = c;
            } else if (c == '\u00c0' || c == '\u00c1' || c == '\u00c2' || c == '\u00e0' || c == '\u00e1' || c == '\u00e2') {
                c2 = 97;
            } else if (c == '\u00c8' || c == '\u00c9' || c == '\u00ca' || c == '\u00cb' || c == '\u00e8' || c == '\u00e9' || c == '\u00ea' || c == '\u00eb') {
                c2 = 101;
            } else if (c == '\u00cc' || c == '\u00cd' || c == '\u00ce' || c == '\u00cf' || c == '\u00ec' || c == '\u00ed' || c == '\u00ee' || c == '\u00ef') {
                c2 = 105;
            } else if (c == '\u00d2' || c == '\u00d3' || c == '\u00d4' || c == '\u00f2' || c == '\u00f3' || c == '\u00f4') {
                c2 = 111;
            } else if (c == '\u00d9' || c == '\u00da' || c == '\u00db' || c == '\u00dc' || c == '\u00f9' || c == '\u00fa' || c == '\u00fb' || c == '\u00fc') {
                c2 = 117;
            } else if (c == '\u00c7' || c == '\u00e7') {
                c2 = 99;
            } else if (c == '\u00d1' || c == '\u00f1') {
                c2 = 110;
            } else if (c == '\u00c6' || c == '\u00e6') {
                c2 = 97;
                c3 = 101;
            } else if (c == '\u008c' || c == '\u009c') {
                c2 = 111;
                c3 = 101;
            } else {
                c2 = 45;
            }
            if (c2 == 45 && lastChar == 45) continue;
            sb.append((char)c2);
            lastChar = c2;
            if (c3 == 63) continue;
            sb.append((char)c3);
        }
        return sb.toString();
    }

    public static String formaterVilleInsee(String _ville) {
        return _ville.trim().replace(' ', '-');
    }

    public static boolean controlerHoraire(String _chaineHoraire) {
        boolean ok = false;
        if (StringUtils.isNotEmpty((CharSequence)_chaineHoraire) && _chaineHoraire.length() == 5 && _chaineHoraire.indexOf(":") == 2) {
            int heure = Integer.parseInt(_chaineHoraire.substring(0, 2));
            int minute = Integer.parseInt(_chaineHoraire.substring(3));
            if (heure >= 0 && heure <= 23 && minute >= 0 && minute <= 59) {
                ok = true;
            }
        }
        return ok;
    }

    public static String encodeMail(String _email) {
        HTMLCodec myHTMLCodec = HTMLCodec.getInstance();
        return myHTMLCodec.encode(_email, true);
    }

    public static String traiterEmailPrenom(String _adresse) {
        if (_adresse == null) {
            return "";
        }
        String adresse = _adresse.trim().toLowerCase();
        adresse = StringUtils.replace((String)adresse, (String)"\u00e0", (String)"a");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e2", (String)"a");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e9", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e8", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ea", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00eb", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ee", (String)"i");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ef", (String)"i");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f4", (String)"o");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f6", (String)"o");
        adresse = StringUtils.replace((String)adresse, (String)"\u00fb", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00fc", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f9", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e7", (String)"c");
        adresse = StringUtils.replace((String)adresse, (String)"'", (String)"");
        adresse = StringUtils.replace((String)adresse, (String)" ", (String)"-");
        return adresse;
    }

    public static String traiterEmailNom(String _adresse) {
        if (_adresse == null) {
            return "";
        }
        String adresse = _adresse.trim().toLowerCase();
        adresse = StringUtils.replace((String)adresse, (String)"\u00e0", (String)"a");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e2", (String)"a");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e9", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e8", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ea", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00eb", (String)"e");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ee", (String)"i");
        adresse = StringUtils.replace((String)adresse, (String)"\u00ef", (String)"i");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f4", (String)"o");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f6", (String)"o");
        adresse = StringUtils.replace((String)adresse, (String)"\u00fb", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00fc", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00f9", (String)"u");
        adresse = StringUtils.replace((String)adresse, (String)"\u00e7", (String)"c");
        adresse = StringUtils.replace((String)adresse, (String)"'", (String)"");
        adresse = StringUtils.replace((String)adresse, (String)" ", (String)"");
        return adresse;
    }

    public static void controlerCodeMetier(String code) throws ErreurApplicative {
        if (StringUtils.isNotEmpty((CharSequence)code) && code.length() == 1) {
            throw new ErreurApplicative("Le code doit contenir plus d'un caract\u00e8re.");
        }
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '@' || c == '.') continue;
            throw new ErreurApplicative("Seuls les caract\u00e8res alphanum\u00e9riques et les caract\u00e8res '.','-','_', et '@' sont autoris\u00e9s pour le code.");
        }
    }

    public static String supprimerISOLatin1Accent(String contenu) {
        int lg = contenu.length();
        StringBuffer sb = new StringBuffer(lg);
        for (int i = 0; i < lg; ++i) {
            char c = contenu.charAt(i);
            int c2 = 63;
            int c3 = 63;
            if (c == '\u00c0' || c == '\u00c1' || c == '\u00c2' || c == '\u00e0' || c == '\u00e1' || c == '\u00e2') {
                c2 = 97;
            } else if (c == '\u00c8' || c == '\u00c9' || c == '\u00ca' || c == '\u00cb' || c == '\u00e8' || c == '\u00e9' || c == '\u00ea' || c == '\u00eb') {
                c2 = 101;
            } else if (c == '\u00cc' || c == '\u00cd' || c == '\u00ce' || c == '\u00cf' || c == '\u00ec' || c == '\u00ed' || c == '\u00ee' || c == '\u00ef') {
                c2 = 105;
            } else if (c == '\u00d2' || c == '\u00d3' || c == '\u00d4' || c == '\u00f2' || c == '\u00f3' || c == '\u00f4') {
                c2 = 111;
            } else if (c == '\u00d9' || c == '\u00da' || c == '\u00db' || c == '\u00dc' || c == '\u00f9' || c == '\u00fa' || c == '\u00fb' || c == '\u00fc') {
                c2 = 117;
            } else if (c == '\u00c7' || c == '\u00e7') {
                c2 = 99;
            } else if (c == '\u00d1' || c == '\u00f1') {
                c2 = 110;
            } else if (c == '\u00c6' || c == '\u00e6') {
                c2 = 97;
                c3 = 101;
            } else if (c == '\u008c' || c == '\u009c') {
                c2 = 111;
                c3 = 101;
            } else {
                c2 = c;
            }
            sb.append((char)c2);
            if (c3 == 63) continue;
            sb.append((char)c3);
        }
        return sb.toString();
    }

    public static String remplacerPointsVirgules(String tag) {
        return Chaine.remplacerPointsVirgules(tag, false);
    }

    public static String remplacerPointsVirgules(String tag, boolean isParagraphe) {
        String res = "";
        if (isParagraphe) {
            res = StringUtils.replace((String)tag, (String)"&#59;", (String)"*");
            res = StringUtils.replace((String)res, (String)"&#61;", (String)"=");
            res = StringUtils.replace((String)res, (String)"&#38;", (String)"&");
            res = StringUtils.replace((String)res, (String)"&#63;", (String)"?");
            res = StringUtils.replace((String)res, (String)"&#35;", (String)"#");
        } else {
            res = EscapeString.unescapeHtml(tag);
        }
        int n = res.length();
        boolean insideTag = false;
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < n; ++i) {
            char c = res.charAt(i);
            if (c == '&') {
                insideTag = true;
            }
            if (c == ';') {
                if (!insideTag) {
                    sb.append('*');
                    continue;
                }
                sb.append(';');
                insideTag = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String formatToHtml(String chaine) {
        String replacement = "<br />";
        chaine = chaine.replaceAll("\r\n", "<br />");
        chaine = chaine.replaceAll("\r", "<br />");
        chaine = chaine.replaceAll("\n", "<br />");
        return chaine;
    }

    public static String encodeSpecialEntities(String chaine) {
        ANSICodec codec = ANSICodec.getInstance();
        return codec.encodeSpecialEntities(chaine);
    }

    public static String escapeJavaScript(String chaine) {
        return chaine.replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static List<String> getListCrochets(String chaine) {
        ArrayList<String> l = new ArrayList<String>();
        if (chaine != null) {
            StringTokenizer st = new StringTokenizer(chaine, "[]");
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
        }
        return l;
    }

    public static String encodeUTF8(String valeur) {
        return Chaine.encode(valeur, "UTF-8");
    }

    public static String encodeISO88591(String valeur) {
        return Chaine.encode(valeur, "ISO-8859-1");
    }

    public static String encode(String valeur, String charset) {
        String res = valeur;
        if (StringUtils.isNotEmpty((CharSequence)valeur)) {
            try {
                CharsetDetector detector = new CharsetDetector();
                detector.setText(valeur.getBytes());
                if (!detector.detect().getName().equals(charset)) {
                    res = new String(valeur.getBytes(charset), charset);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return res;
    }
}

