/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.RequeteMgr;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.SSOBean;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.objetspartages.om.SousParagrapheBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteConnecteur;
import com.univ.utils.RequeteUtil;
import com.univ.utils.ServicesUtil;
import com.univ.utils.URLResolver;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContexteUniv
extends ContextePage {
    public static final String CLEF_INFOS_SESSION_APPLICATIFS_METIER = "INFO_SESSION_APPLICATIFS_METIER";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContexteUniv.class);
    private Object jsp = null;
    private JspWriter jspWriter = null;
    private boolean apercu = false;
    private String requete = "";
    private String rubriqueExterneConnecteur = "";
    private List<SousParagrapheBean> encadresExternes = new ArrayList<SousParagrapheBean>();
    private Map<String, String> donneesSpecifiques = new HashMap<String, String>();
    private List<String> encadresRechercheExternes = new ArrayList<String>();
    private String ksession = "";
    private Date dateDerniereSession = new Date(0L);
    private String templateExterne = "";
    private String adresseMail = "";
    private boolean genererLiensInternes = false;
    private Vector<String> codesLiensInternes = new Vector();
    private String codeRubriquePageCourante = "";
    private String codeRubriqueFicheCourante = "";
    private String codeRubriqueHistorique = "";
    private FicheUniv ficheCourante = null;
    private Metatag metaCourant = null;
    private AutorisationBean autorisation = null;
    private boolean calculListeResultatsFront = false;
    private Vector<String> centresInteret = new Vector();
    private String code = "";
    private String codeGestion = "";
    private String codeStructure = "";
    private String groupePersonnalisationCourant = "";
    private TreeSet<String> groupesDsi = new TreeSet();
    private TreeSet<String> groupesDsiAvecAscendants = new TreeSet();
    private TreeSet<String> listeServicesAutorises = new TreeSet();
    private String serviceCourant = "";
    private String nom = "";
    private String prenom = "";
    private String profilDsi = "";
    private InfosProfilDsi infosProfilDsi = new InfosProfilDsi();
    private TreeSet<String> listeProfilsDsi = new TreeSet();
    private String profilPersonnalisationCourant = "";
    private HttpServletRequest requeteHTTP = null;
    private HttpServletResponse reponseHTTP = null;
    private ServletContext servletContext = null;
    @Deprecated
    private String espaceCourant = "";
    @Deprecated
    private String espaceHistorique = "";
    @Deprecated
    private String espacePersonnalisationCourant = "";
    @Deprecated
    private InfosEspaceCollaboratif infosEspace = new InfosEspaceCollaboratif();
    @Deprecated
    private TreeSet<String> listeEspaces = new TreeSet();
    @Deprecated
    private Vector<String> listeEspacesDontVisiteur = new Vector();
    private String urlPageCourante = "";

    public ContexteUniv(String _uri) {
        super(_uri);
    }

    public ContexteUniv(String _uri, String _langue) {
        super(_uri, _langue);
    }

    public ContexteUniv(PageContext _contextePage) throws Exception {
        this((HttpServletRequest)_contextePage.getRequest());
        this.setReponseHTTP((HttpServletResponse)_contextePage.getResponse());
        this.setServletContext(_contextePage.getServletContext());
        this.initialiserInfosUtilisateur();
        this.initialiserInfosConnecteurs();
        this.setEspaceCourant(this.getEspaceHistorique());
    }

    public ContexteUniv(HttpServletRequest request) {
        super(request.getRequestURI());
        this.setRequeteHTTP(request);
        String codeRH = request.getParameter("RH");
        if (codeRH != null) {
            this.codeRubriqueHistorique = codeRH;
        }
        this.setInfosSite(Site.renvoyerItemSiteParHost(request.getServerName()));
        this.setSecure(URLResolver.getRequestScheme(request).equals("https"));
        String dump = "";
        if (request.getParameterNames() != null) {
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                dump = dump + "param[" + name + "]=" + request.getParameter(name);
                dump = dump + "\n";
            }
        }
        if (request.getCookies() != null) {
            for (int i = 0; i < request.getCookies().length; ++i) {
                dump = dump + "Cookie[" + request.getCookies()[i].getName() + "] = " + request.getCookies()[i].getValue();
                dump = dump + "\n";
            }
        }
        if (request.getRemoteAddr() != null) {
            dump = dump + "IP :" + request.getRemoteAddr();
            dump = dump + "\n";
        }
        this.initialiserUrlPageCourante(request);
        RequeteMgr.ajouterEvenement(this.getIdRequete(), dump);
    }

    public void initialiserUrlPageCourante(HttpServletRequest request) {
        String urlPageCourante = "";
        if (StringUtils.isNotBlank((CharSequence)request.getRequestURI())) {
            urlPageCourante = request.getRequestURI();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
            urlPageCourante = urlPageCourante + "?" + request.getQueryString();
        }
        this.setUrlPageCourante(urlPageCourante);
    }

    public Object getJsp() {
        return this.jsp;
    }

    public String getRequete() {
        return this.requete;
    }

    public void setJsp(Object newJsp) {
        this.jsp = newJsp;
    }

    public void setRequete(String newRequete) {
        this.requete = newRequete;
    }

    public String getRubriqueExterneConnecteur() {
        return this.rubriqueExterneConnecteur;
    }

    public void setRubriqueExterneConnecteur(String newRubriqueNavigation) {
        this.rubriqueExterneConnecteur = newRubriqueNavigation;
    }

    public AutorisationBean getAutorisation() {
        return this.autorisation;
    }

    public Vector<String> getCentresInteret() {
        return this.centresInteret;
    }

    public String getCode() {
        return this.code;
    }

    public String getGroupePersonnalisationCourant() {
        return this.groupePersonnalisationCourant;
    }

    public TreeSet<String> getGroupesDsi() {
        return this.groupesDsi;
    }

    public TreeSet<String> getGroupesDsiAvecAscendants() {
        return this.groupesDsiAvecAscendants;
    }

    public TreeSet<String> getListeServicesAutorises() {
        return this.listeServicesAutorises;
    }

    public TreeSet<String> getListeProfilsDsi() {
        return this.listeProfilsDsi;
    }

    public String getNom() {
        return this.nom;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public String getProfilDsi() {
        return this.profilDsi;
    }

    public InfosProfilDsi getInfosProfilDsi() {
        return this.infosProfilDsi;
    }

    @Deprecated
    public String getProfilPersonnalisationCourant2() {
        return this.profilPersonnalisationCourant;
    }

    public HttpServletRequest getRequeteHTTP() {
        return this.requeteHTTP;
    }

    public HttpServletResponse getReponseHTTP() {
        return this.reponseHTTP;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void initialiserInfosUtilisateur() throws Exception {
        Hashtable<String, Object> infosSession;
        HttpServletRequest newRequeteHTTP = this.getRequeteHTTP();
        if (newRequeteHTTP == null) {
            return;
        }
        HttpSession _session = newRequeteHTTP.getSession(Boolean.TRUE.booleanValue());
        if (_session == null) {
            return;
        }
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)_session.getAttribute("session");
        if (sessionUtilisateur != null && (infosSession = sessionUtilisateur.getInfos()).get("CODE") != null) {
            this.setCode((String)infosSession.get("CODE"));
            this.setCodeStructure((String)infosSession.get("CODE_STRUCTURE"));
            this.setCodeGestion((String)infosSession.get("CODE_GESTION"));
            this.setNom((String)infosSession.get("NOM"));
            this.setPrenom((String)infosSession.get("PRENOM"));
            this.setProfilDsi((String)infosSession.get("PROFIL_DSI"));
            this.setInfosProfilDsi(Profildsi.renvoyerItemProfilDsi((String)infosSession.get("PROFIL_DSI")));
            this.setListeProfilsDsi(new TreeSet<String>((Vector)infosSession.get("PROFILS_DSI")));
            Map infosSessionApplicatifsMetier = (Map)infosSession.get(CLEF_INFOS_SESSION_APPLICATIFS_METIER);
            if (infosSessionApplicatifsMetier != null) {
                this.getDatas().put(CLEF_INFOS_SESSION_APPLICATIFS_METIER, infosSessionApplicatifsMetier);
            }
            this.setCentresInteret((Vector)infosSession.get("CENTRES_INTERET"));
            this.setAdresseMail((String)infosSession.get("ADRESSE_MAIL"));
            TreeSet<String> set = new TreeSet<String>();
            Enumeration e = ((Vector)infosSession.get("GROUPES_DSI")).elements();
            while (e.hasMoreElements()) {
                set.add((String)e.nextElement());
            }
            this.setGroupesDsi(set);
            this.calculerGroupesDsiAvecAscendants();
            this.setAutorisation((AutorisationBean)infosSession.get("AUTORISATIONS"));
            this.setKsession((String)infosSession.get("KSESSION"));
            this.initialiserEspace();
        }
        this.initialiserListeServices();
    }

    public void initialiserEspace() throws Exception {
        if (this.requeteHTTP != null) {
            String codeEspace = this.requeteHTTP.getParameter("ESPACE");
            if ((String)this.requeteHTTP.getAttribute("EXCLUSION_ESPACE") != null) {
                codeEspace = "";
            }
            InfoBean infoBean = (InfoBean)this.requeteHTTP.getAttribute("infoBean");
            if (codeEspace == null && infoBean != null) {
                codeEspace = infoBean.getString("ESPACE");
            }
            if (StringUtils.isNotBlank((CharSequence)codeEspace) && (infoBean != null && infoBean.get("EXCLUSION_ESPACE") == null || infoBean == null)) {
                this.setEspaceHistorique(codeEspace);
                this.setInfosEspace(Espacecollaboratif.renvoyerItemEspace(codeEspace));
                this.setEspaceCourant(this.getEspaceHistorique());
                this.setLocale(LangueUtil.getLocale(this.getInfosEspace().getLangue()));
            }
        }
    }

    public void supprimerInfosUtilisateurs() {
        this.setCode("");
        this.setCodeStructure("");
        this.setCodeGestion("");
        this.setNom("");
        this.setPrenom("");
        this.setProfilDsi("");
        this.setInfosProfilDsi(new InfosProfilDsi());
        this.setListeProfilsDsi(new TreeSet<String>());
        this.setListeServicesAutorises(new TreeSet<String>());
        this.setCentresInteret(new Vector<String>());
        this.setAdresseMail("");
        this.setGroupesDsi(new TreeSet<String>());
        this.setGroupesDsiAvecAscendants(new TreeSet<String>());
        this.setKsession("");
        this.setEspaceHistorique("");
        this.setInfosEspace(new InfosEspaceCollaboratif());
        this.setAutorisation(null);
    }

    public void calculerGroupesDsiAvecAscendants() throws Exception {
        TreeSet<String> listeGroupesAvecAscendants = new TreeSet<String>();
        for (String groupeCourant : this.getGroupesDsi()) {
            listeGroupesAvecAscendants.add(groupeCourant);
            InfosGroupeDsi infoGroupe = Groupedsi.renvoyerItemGroupeDsi(groupeCourant);
            int niveauItemCourant = infoGroupe.getNiveau();
            for (int niveau = niveauItemCourant - 1; niveau > 0; --niveau) {
                String codeGroupe = infoGroupe.getCodeGroupePere();
                listeGroupesAvecAscendants.add(codeGroupe);
                infoGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
            }
        }
        this.setGroupesDsiAvecAscendants(listeGroupesAvecAscendants);
    }

    public void initialiserListeServices() throws Exception {
        this.setListeServicesAutorises(ServicesUtil.calculerCodesServicesAutorises(this));
    }

    public Vector<ServiceBean> calculerListeServicesPush() throws Exception {
        return ServicesUtil.calculerListeServicesPush(this);
    }

    public boolean isCalculListeResultatsFront() {
        return this.calculListeResultatsFront;
    }

    public void setAutorisation(AutorisationBean newAutorisation) {
        this.autorisation = newAutorisation;
    }

    public void setCalculListeResultatsFront(boolean newAffichageListeResultats) {
        this.calculListeResultatsFront = newAffichageListeResultats;
    }

    public void setCentresInteret(Vector<String> newCentresInteret) {
        this.centresInteret = newCentresInteret;
    }

    public void setCode(String newCode) {
        this.code = newCode;
    }

    public void setGroupePersonnalisationCourant(String newGroupePersonnalisationCourant) {
        this.groupePersonnalisationCourant = newGroupePersonnalisationCourant;
    }

    public void setGroupesDsi(TreeSet<String> newGroupesDsi) {
        this.groupesDsi = newGroupesDsi;
    }

    public void setGroupesDsiAvecAscendants(TreeSet<String> newGroupesDsi) {
        this.groupesDsiAvecAscendants = newGroupesDsi;
    }

    public void setListeServicesAutorises(TreeSet<String> newServices) {
        this.listeServicesAutorises = newServices;
    }

    public void setListeProfilsDsi(TreeSet<String> newProfilsDsi) {
        this.listeProfilsDsi = newProfilsDsi;
    }

    public void setNom(String newNom) {
        this.nom = newNom;
    }

    public void setPrenom(String newPrenom) {
        this.prenom = newPrenom;
    }

    public void setProfilDsi(String newProfilDsi) {
        this.profilDsi = newProfilDsi;
    }

    public void setInfosProfilDsi(InfosProfilDsi newInfosProfilDsi) {
        this.infosProfilDsi = newInfosProfilDsi;
    }

    public void setRequeteHTTP(HttpServletRequest newRequeteHTTP) {
        this.requeteHTTP = newRequeteHTTP;
    }

    public List<SousParagrapheBean> getEncadresExternes() {
        return this.encadresExternes;
    }

    public List<String> getEncadresRechercheExternes() {
        return this.encadresRechercheExternes;
    }

    public String getKsession() {
        return this.ksession;
    }

    public String getTemplateExterne() {
        return this.templateExterne;
    }

    public void initialiserInfosConnecteurs() throws Exception {
        String ktemplate;
        HttpServletRequest request = this.getRequeteHTTP();
        if (request != null && StringUtils.isNotEmpty((CharSequence)(ktemplate = request.getParameter("ktemplate")))) {
            this.setTemplateExterne(ktemplate);
            String kSession = request.getParameter("ksession");
            if (StringUtils.isNotEmpty((CharSequence)kSession)) {
                this.setKsession(kSession);
            }
            RequeteConnecteur.parseFlux(this);
            if (kSession.length() > 0) {
                try {
                    SSOBean ssoBean = RequeteConnecteur.lireBeanSSO(this.ksession);
                    if (ssoBean.getCodeKportal().length() > 0) {
                        GestionnaireIdentification.getInstance().chargerContexteProxyClient(this, ssoBean.getCodeKportal());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Erreur \u00e0 la lecture des informations du bean SSO", (Throwable)e);
                }
            }
        }
    }

    public void setEncadresExternes(List<SousParagrapheBean> newEncadresExternes) {
        this.encadresExternes = newEncadresExternes;
    }

    public void setEncadresRechercheExternes(List<String> newEncadresRechercheExternes) {
        this.encadresRechercheExternes = newEncadresRechercheExternes;
    }

    public void setKsession(String newKsession) {
        this.ksession = newKsession;
    }

    public void setTemplateExterne(String newTemplateExterne) {
        this.templateExterne = newTemplateExterne;
    }

    public String getAdresseMail() {
        return this.adresseMail;
    }

    public void setAdresseMail(String newAdresseMail) {
        this.adresseMail = newAdresseMail;
    }

    public boolean isGenererLiensInternes() {
        return this.genererLiensInternes;
    }

    public void setGenererLiensInternes(boolean genererLiensInternes) {
        this.genererLiensInternes = genererLiensInternes;
    }

    public Vector<String> getCodesLiensInternes() {
        return this.codesLiensInternes;
    }

    public void setCodesLiensInternes(Vector<String> codesLiensInternes) {
        this.codesLiensInternes = codesLiensInternes;
    }

    public String getCodeGestion() {
        return this.codeGestion;
    }

    public void setCodeGestion(String codeGestion) {
        this.codeGestion = codeGestion;
    }

    public String getCodeStructure() {
        return this.codeStructure;
    }

    public void setCodeStructure(String codeStructure) {
        this.codeStructure = codeStructure;
    }

    public String getEspaceCourant() {
        return this.espaceCourant;
    }

    public void setEspaceCourant(String espaceCourant) {
        this.espaceCourant = espaceCourant;
    }

    @Deprecated
    public TreeSet<String> getListeEspaces() {
        return this.listeEspaces;
    }

    @Deprecated
    public void setListeEspaces(TreeSet<String> listeEspaces) {
        this.listeEspaces = listeEspaces;
    }

    public String getEspacePersonnalisationCourant() {
        return this.espacePersonnalisationCourant;
    }

    public void setEspacePersonnalisationCourant(String espacePersonnalisationCourant) {
        this.espacePersonnalisationCourant = espacePersonnalisationCourant;
    }

    public InfosEspaceCollaboratif getInfosEspace() {
        return this.infosEspace;
    }

    public void setInfosEspace(InfosEspaceCollaboratif infosEspace) {
        this.infosEspace = infosEspace;
    }

    public String getCodeRubriquePageCourante() {
        return this.codeRubriquePageCourante;
    }

    public void setCodeRubriquePageCourante(String codeRubriquePageCourante) {
        this.codeRubriquePageCourante = codeRubriquePageCourante;
    }

    public void calculerCodeRubriquePageCourante() {
        String objet;
        InfosRubriques infosRubriques;
        String code = this.getCodeRubriquePageCourante();
        if (!this.getCodeRubriqueFicheCourante().equals("")) {
            code = this.getCodeRubriqueFicheCourante();
        } else if (this.getRequeteHTTP() != null && this.getRequeteHTTP().getParameter("RF") != null) {
            code = this.getRequeteHTTP().getParameter("RF");
        } else if (this.getRequete() != null && this.getRequete().contains("OBJET=") && (infosRubriques = Rubrique.renvoyerItemRubrique(objet = RequeteUtil.renvoyerParametre(this.getRequete(), "OBJET"))).getCode().length() > 0) {
            code = infosRubriques.getCode();
        }
        if (this.getTemplateExterne() != null && this.getTemplateExterne().length() > 0) {
            code = this.getRubriqueExterneConnecteur();
        }
        if (StringUtils.isEmpty((CharSequence)code)) {
            code = this.getCodeRubriqueHistorique();
        }
        if ("".equals(code) || !this.getInfosSite().isRubriqueVisibleInSite(Rubrique.renvoyerItemRubrique(code))) {
            code = this.getInfosSite().getCodeRubrique();
        }
        this.setCodeRubriquePageCourante(code);
    }

    public String getCodeRubriqueHistorique() {
        return this.codeRubriqueHistorique;
    }

    public void setCodeRubriqueHistorique(String codeRubriqueHistorique) {
        this.codeRubriqueHistorique = codeRubriqueHistorique;
    }

    public String getEspaceHistorique() {
        return this.espaceHistorique;
    }

    public void setEspaceHistorique(String espaceHistorique) {
        this.espaceHistorique = espaceHistorique;
    }

    public String getServiceCourant() {
        return this.serviceCourant;
    }

    public FicheUniv getFicheCourante() {
        return this.ficheCourante;
    }

    public void setFicheCourante(FicheUniv ficheCourante) {
        this.ficheCourante = ficheCourante;
    }

    public void setServiceCourant(String serviceCourant) {
        this.serviceCourant = serviceCourant;
    }

    public Date getDateDerniereSession() {
        return this.dateDerniereSession;
    }

    public void setDateDerniereSession(Date dateDerniereSession) {
        this.dateDerniereSession = dateDerniereSession;
    }

    @Deprecated
    public Vector<String> getListeEspacesDontVisiteur() {
        return this.listeEspacesDontVisiteur;
    }

    @Deprecated
    public void setListeEspacesDontVisiteur(Vector<String> listeEspacesDontVisiteur) {
        this.listeEspacesDontVisiteur = listeEspacesDontVisiteur;
    }

    public String getCodeRubriqueFicheCourante() {
        return this.codeRubriqueFicheCourante;
    }

    public void setCodeRubriqueFicheCourante(String codeRubriqueFicheCourante) {
        this.codeRubriqueFicheCourante = codeRubriqueFicheCourante;
    }

    public Map<String, String> getDonneesSpecifiques() {
        return this.donneesSpecifiques;
    }

    public void setDonneesSpecifiques(Map<String, String> donneesSpecifiques) {
        this.donneesSpecifiques = donneesSpecifiques;
    }

    public boolean isApercu() {
        return this.apercu;
    }

    public void setApercu(boolean apercu) {
        this.apercu = apercu;
    }

    public static ContexteUniv getContexteUniv(PageContext contextePage) throws Exception {
        HttpServletRequest request = (HttpServletRequest)contextePage.getRequest();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx == null) {
            ctx = ContexteUniv.initContexteUniv(request, (HttpServletResponse)contextePage.getResponse(), contextePage.getServletContext(), contextePage.getServletConfig());
            ctx.setApercu(request.getParameter("MODE") != null && request.getParameter("MODE").equals("APERCU"));
        }
        ctx.setContextePage(contextePage);
        return ctx;
    }

    public static ContexteUniv initContexteUniv(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ServletConfig servletConfig) throws Exception {
        ContexteUniv ctx = new ContexteUniv(request);
        ctx.setReponseHTTP(response);
        ctx.setServletContext(servletContext);
        ctx.initialiserInfosUtilisateur();
        ctx.initialiserInfosConnecteurs();
        ctx.setEspaceCourant(ctx.getEspaceHistorique());
        return ctx;
    }

    public void setContextePage(PageContext contextePage) {
    }

    public Metatag getMetaCourant() {
        return this.metaCourant;
    }

    public void setMetaCourant(Metatag metaCourant) {
        this.metaCourant = metaCourant;
    }

    public void setReponseHTTP(HttpServletResponse reponseHTTP) {
        this.reponseHTTP = reponseHTTP;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public JspWriter getJspWriter() {
        return this.jspWriter;
    }

    public void setJspWriter(JspWriter jspWriter) {
        this.jspWriter = jspWriter;
    }

    public String getUrlPageCourante() {
        return this.urlPageCourante;
    }

    public void setUrlPageCourante(String urlPageCourante) {
        this.urlPageCourante = urlPageCourante;
    }
}

