/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContexteUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContexteUtil.class);
    private static final ThreadLocal<ContexteUniv> threadLocal = new ThreadLocal();

    public static ContexteUniv setContexteUniv(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        ContexteUniv ctx = new ContexteUniv(request);
        ctx.setReponseHTTP(response);
        try {
            ctx.initialiserInfosUtilisateur();
        }
        catch (Exception e) {
            LOGGER.error("impossible d'initialiser les infos utilisateurs", (Throwable)e);
        }
        try {
            ctx.initialiserInfosConnecteurs();
        }
        catch (Exception e) {
            LOGGER.error("impossible d'initialiser les infos des connecteurs", (Throwable)e);
        }
        ctx.setEspaceCourant(ctx.getEspaceHistorique());
        ctx.setServletContext(servletContext);
        ContexteUtil.initLangueUtilisateur(request, ctx);
        ContexteUtil.ajoutDansThreadLocal(ctx);
        return ctx;
    }

    private static void initLangueUtilisateur(HttpServletRequest request, ContexteUniv ctx) {
        String codeRubrique = "";
        if (ctx.getRequeteHTTP() != null) {
            codeRubrique = ctx.getRequeteHTTP().getParameter("RF");
        }
        InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique(StringUtils.defaultString((String)codeRubrique, (String)ctx.getCodeRubriqueHistorique()));
        Locale localeNavigateur = request.getLocale();
        if (StringUtils.isNotBlank((CharSequence)rubriqueCourante.getCode())) {
            ctx.setLangue(rubriqueCourante.getLangue());
            ctx.setLocale(LangueUtil.getLocale(rubriqueCourante.getLangue()));
        } else {
            Locale effectiveLocale = LangueUtil.getEffectiveLocale(localeNavigateur);
            ctx.setLocale(effectiveLocale);
            ctx.setLangue(LangueUtil.getLangueLocale(effectiveLocale));
        }
    }

    public static ContexteUniv setContexteSansRequete() {
        ContexteUniv ctx = new ContexteUniv("");
        ContexteUtil.ajoutDansThreadLocal(ctx);
        return ctx;
    }

    private static void ajoutDansThreadLocal(ContexteUniv ctx) {
        ContexteUniv oldCtx = ContexteUtil.getContexteUniv();
        if (oldCtx != null) {
            oldCtx.release();
            LOGGER.warn("Initialisation d'un contexte univ alors qu'il en existe d\u00e9j\u00e0 un");
        }
        threadLocal.set(ctx);
    }

    public static ContexteUniv getContexteUniv() {
        return threadLocal.get();
    }

    public static void releaseContexteUniv() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx != null) {
            ctx.release();
            threadLocal.remove();
        } else {
            LOGGER.warn("contexte d\u00e9j\u00e0 lib\u00e9r\u00e9");
        }
    }
}

