/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private static final Logger LOG = LoggerFactory.getLogger(DateUtil.class);

    public static SimpleDateFormat getSimpleDateFormat() {
        return (SimpleDateFormat)sdf.clone();
    }

    public static Date parseDate(String sDate) {
        Date date = null;
        if (StringUtils.isNotBlank((CharSequence)sDate)) {
            try {
                date = new Date(DateUtil.getSimpleDateFormat().parse(sDate).getTime());
            }
            catch (ParseException e) {
                LOG.info("date incorrecte : " + sDate);
            }
        }
        return date != null ? date : new Date(0L);
    }

    public static String formatDate(Date date) {
        return date == null ? "" : DateUtil.getSimpleDateFormat().format(date);
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(7, 2);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(7, 1);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getFirstDayOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return new Date(cal.getTimeInMillis());
    }

    public static Date getLastDayOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return new Date(cal.getTimeInMillis());
    }

    public static Date addDays(Date date, int nbDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(5, nbDays);
        return new Date(cal.getTimeInMillis());
    }
}

