/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.extension.module.composant.ComposantRole;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ExportCsvUtil;
import com.univ.utils.SimpleDownloadServlet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.servlet.annotation.WebServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="servletExportRoles", urlPatterns={"/servlet/downloadExportRoles"}, loadOnStartup=1)
public class DownloadExportRolesServlet
extends SimpleDownloadServlet {
    private static final long serialVersionUID = -2328660109979013684L;
    private static final Logger LOG = LoggerFactory.getLogger(DownloadExportRolesServlet.class);

    @Override
    protected String getFilePath() {
        return ExportCsvUtil.getExportFilePath("roles", DownloadExportRolesServlet.getLocale());
    }

    @Override
    protected String getFileType() {
        return "text/csv";
    }

    @Override
    protected String getDownloadedFileName(File file) {
        String dlFileName = super.getDownloadedFileName(file);
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime creationTime = attributes.creationTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(creationTime.toMillis());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            dlFileName = "roles-" + formatter.format(calendar.getTime()) + ".csv";
        }
        catch (IOException e) {
            LOG.error("Erreur lors de la lecture de la date de cr\u00e9ation du fichier", (Throwable)e);
        }
        return dlFileName;
    }

    @Override
    protected boolean isAuthorized() {
        return ComposantRole.isAutoriseParActionProcessus(ContexteUtil.getContexteUniv().getAutorisation(), null);
    }

    private static Locale getLocale() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx != null) {
            return ctx.getLocale();
        }
        return LangueUtil.getDefaultLocale();
    }
}

