/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.MySQLCodec;

public class EscapeString {
    private static final MySQLCodec CODEC_MYSQL = new MySQLCodec(MySQLCodec.Mode.STANDARD);
    private static final URLCodec CODEC_URL = new URLCodec("UTF-8");
    public static final String[] EVENTS_JS = new String[]{"onblur", "onchange", "onclick", "ondblclick", "onerror", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onresize", "onselect", "onunload"};
    public static final String BALISE_JS = "script";

    public static String escapeHtml(String chaineAEchaper) {
        return ESAPI.encoder().encodeForHTML(chaineAEchaper);
    }

    public static String escapeAttributHtml(String chaineAEchaper) {
        return ESAPI.encoder().encodeForHTMLAttribute(chaineAEchaper);
    }

    public static String escapeJavaScript(String chaineAEchaper) {
        return ESAPI.encoder().encodeForJavaScript(chaineAEchaper);
    }

    public static String escapeCSS(String chaineAEchaper) {
        return ESAPI.encoder().encodeForCSS(chaineAEchaper);
    }

    public static String escapeURL(String chaineAEchaper) {
        String valeurEchapper = null;
        try {
            valeurEchapper = CODEC_URL.encode(chaineAEchaper);
        }
        catch (EncoderException e) {
            valeurEchapper = chaineAEchaper;
        }
        return valeurEchapper;
    }

    public static String escapeSqlValue(String chaineAEchaper) {
        return ESAPI.encoder().encodeForSQL((Codec)CODEC_MYSQL, chaineAEchaper);
    }

    public static String escapeSql(String chaineAEchaper) {
        chaineAEchaper = StringUtils.replace((String)chaineAEchaper, (String)"\\", (String)"\\\\");
        return StringUtils.replace((String)chaineAEchaper, (String)"'", (String)"''");
    }

    public static String unescapeHtml(String chaineADecoder) {
        return ESAPI.encoder().decodeForHTML(chaineADecoder);
    }

    public static String unescapeURL(String chaineAEDecoder) {
        String valeurEchapper = null;
        try {
            valeurEchapper = new String(CODEC_URL.decode(chaineAEDecoder.getBytes()));
        }
        catch (DecoderException e) {
            valeurEchapper = chaineAEDecoder;
        }
        return valeurEchapper;
    }

    public static String escapeScriptAndEvent(String valeur) {
        String chaine = valeur.toLowerCase();
        Pattern p = Pattern.compile("<([a-z]+)(.*?)>", 32);
        Matcher m = p.matcher(chaine);
        boolean escape = false;
        block0: while (m.find()) {
            String tag1 = m.group(1);
            if (tag1.equals(BALISE_JS)) {
                escape = true;
                break;
            }
            String tag2 = m.group(2);
            if (!StringUtils.isNotEmpty((CharSequence)tag2)) continue;
            for (String event : EVENTS_JS) {
                if (tag2.indexOf(event) == -1) continue;
                escape = true;
                continue block0;
            }
        }
        if (escape) {
            valeur = valeur.replaceAll("<", "&lt;");
            valeur = valeur.replaceAll(">", "&gt;");
        }
        return valeur;
    }
}

