/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import java.io.File;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class ExportCsvUtil {
    private static final String EXPORT_PATH_PROPERTIES_KEY = "export.batch.dest";
    private static final String EXPORT_FOLDER = "export.folder";
    private static final String DEFAULT_EXPORT_FOLDER = "export.default.folder";
    private static final String EXTENSION_FILE = ".csv";
    public static final String DEFAULT_SEPARATOR = ";";
    public static final String ERROR = "error";

    public static String createNewExportFile(String exportType, Locale locale) {
        File renamedFile;
        File extract = new File(ExportCsvUtil.getExportFilePath(exportType, locale));
        String ctm = String.valueOf(System.currentTimeMillis());
        if (extract.exists() && !extract.renameTo(renamedFile = new File(ExportCsvUtil.getExportFilePath(exportType, locale) + "." + ctm))) {
            ctm = ERROR;
        }
        return ctm;
    }

    public static boolean rollbackExportFile(String exportType, Locale locale, String lastCtm) {
        File toRb;
        boolean succeed = false;
        File toRm = new File(ExportCsvUtil.getExportFilePath(exportType, locale));
        if (toRm.exists()) {
            succeed = toRm.delete();
        }
        if (succeed && (toRb = new File(ExportCsvUtil.getExportFilePath(exportType, locale) + "." + lastCtm)).exists()) {
            File renewFile = new File(ExportCsvUtil.getExportFilePath(exportType, locale));
            succeed = toRb.renameTo(renewFile);
        }
        return succeed;
    }

    public static String getExportFilePath(String exportType, Locale locale) {
        return ExportCsvUtil.getFolderSpecificPath(exportType) + "/" + exportType + "_" + locale + EXTENSION_FILE;
    }

    public static String getFolderSpecificPath(String exportType) {
        String folder = (String)StringUtils.defaultIfEmpty((CharSequence)exportType, (CharSequence)DEFAULT_EXPORT_FOLDER);
        String res = ExportCsvUtil.getFolderAbsolutePath() + "/" + folder;
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    private static String getFolderAbsolutePath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(EXPORT_PATH_PROPERTIES_KEY), (CharSequence)(WebAppUtil.getAbsolutePath() + ExportCsvUtil.getFolderDefaultRelativePath()));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    private static String getFolderDefaultRelativePath() {
        return PropertyHelper.getCoreProperty(EXPORT_FOLDER);
    }
}

