/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.univ.objetspartages.cache.CacheStructureManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ExceptionFicheNonAccessible;
import com.univ.utils.ExceptionFicheNonTrouvee;
import com.univ.utils.FicheUnivMgr;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FicheUnivHelper {
    public static FicheUniv instancierFiche(String codeOrNom) {
        return ReferentielObjets.instancierFiche(codeOrNom);
    }

    public static FicheUniv getFiche(String codeOrNom, String codeFiche, String langue) throws Exception {
        FicheUniv fiche = null;
        if (StringUtils.isNotEmpty((CharSequence)codeOrNom) && StringUtils.isNotEmpty((CharSequence)codeFiche) && (fiche = ReferentielObjets.instancierFiche(codeOrNom)) != null) {
            if (StringUtils.isEmpty((CharSequence)langue)) {
                langue = "0";
            }
            try (ContexteDao ctx = new ContexteDao();){
                fiche.init();
                fiche.setCtx(ctx);
                int count = fiche.selectCodeLangueEtat(codeFiche, langue, "0003");
                if (count == 0) {
                    count = fiche.selectCodeLangueEtat(codeFiche, langue, "");
                }
                if (count == 0) {
                    count = fiche.selectCodeLangueEtat(codeFiche, "", "0003");
                }
                if (count > 0) {
                    fiche.nextItem();
                }
            }
        }
        return fiche;
    }

    public static FicheUniv getFicheFrontOffice(ContexteUniv ctx, String codeOrNom, String codeFiche, String langue, boolean controleRubrique) throws ExceptionFicheNonTrouvee, ExceptionFicheNonAccessible {
        FicheUniv fiche = null;
        if (StringUtils.isNotEmpty((CharSequence)codeOrNom) && StringUtils.isNotEmpty((CharSequence)codeFiche) && (fiche = ReferentielObjets.instancierFiche(codeOrNom)) != null) {
            langue = StringUtils.defaultString((String)langue, (String)"0");
            try (ContexteDao ctxDao = new ContexteDao();){
                fiche.init();
                fiche.setCtx(ctxDao);
                boolean isVisible = Boolean.TRUE;
                try {
                    int count = fiche.selectCodeLangueEtat(codeFiche, langue, EtatFiche.EN_LIGNE.getEtat());
                    if (count > 0) {
                        fiche.nextItem();
                    }
                    isVisible = FicheUnivMgr.controlerRestriction(fiche, ctx, controleRubrique);
                }
                catch (Exception e) {
                    throw new ExceptionFicheNonTrouvee(MessageHelper.getCoreMessage("ST_FICHE_INEXISTANTE"), e);
                }
                if (!isVisible) {
                    throw new ExceptionFicheNonAccessible(MessageHelper.getCoreMessage("ST_FICHE_INACCESSIBLE"));
                }
            }
        }
        return fiche;
    }

    public static FicheUniv getFicheFrontOfficePourJSP(ContexteUniv ctx, String codeOrNom, String codeFiche, String langue, boolean controleRubrique) {
        FicheUniv fiche;
        try {
            fiche = FicheUnivHelper.getFicheFrontOffice(ctx, codeOrNom, codeFiche, langue, controleRubrique);
        }
        catch (ExceptionFicheNonAccessible | ExceptionFicheNonTrouvee e) {
            fiche = null;
        }
        return fiche;
    }

    public static FicheUniv getFicheParIdMeta(Long idMeta) throws Exception {
        FicheUniv ficheUniv = null;
        try (ContexteDao ctxConnection = new ContexteDao();){
            Metatag meta = new Metatag();
            meta.setCtx(ctxConnection);
            meta.setIdMetatag(idMeta);
            meta.retrieve();
            ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
            if (ficheUniv != null) {
                ficheUniv.setCtx(ctxConnection);
                ficheUniv.init();
                ficheUniv.setIdFiche(meta.getMetaIdFiche());
                ficheUniv.retrieve();
            }
        }
        return ficheUniv;
    }

    public static Map<String, String> getListeFiche(String codeOrNom, String etat, String langue) throws Exception {
        FicheUniv fiche;
        HashMap<String, String> res = new HashMap<String, String>();
        if (etat == null) {
            return res;
        }
        if (StringUtils.isNotEmpty((CharSequence)codeOrNom) && StringUtils.isNotEmpty((CharSequence)codeOrNom) && (fiche = ReferentielObjets.instancierFiche(codeOrNom)) != null) {
            int count;
            if (StringUtils.isEmpty((CharSequence)langue)) {
                langue = "0";
            }
            if ((count = fiche.selectCodeLangueEtat("", langue, etat)) > 0) {
                while (fiche.nextItem()) {
                    res.put(fiche.getCode(), fiche.getLibelleAffichable());
                }
            }
        }
        return res;
    }

    public static String getLibelle(FicheUniv fiche, String nomTable, String codeLibelle) {
        return CodeLibelle.lireLibelle(ReferentielObjets.getExtension(fiche), nomTable, LangueUtil.getLocale(Integer.parseInt(fiche.getLangue())), codeLibelle);
    }

    public static void supprimerListeFichesParIdsMeta(Collection<Long> idsMetas, AutorisationBean autorisations) throws Exception {
        if (idsMetas != null && !idsMetas.isEmpty() && autorisations != null) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            for (Long idMeta : idsMetas) {
                Metatag meta = new Metatag();
                meta.setCtx(ctx);
                meta.setIdMetatag(idMeta);
                meta.retrieve();
                FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
                fiche.setCtx(ctx);
                fiche.setIdFiche(meta.getMetaIdFiche());
                fiche.retrieve();
                if (!autorisations.estAutoriseASupprimerLaFiche(fiche)) continue;
                fiche.setEtatObjet(EtatFiche.A_SUPPRIMER.getEtat());
                fiche.update();
                meta.addHistorique(Metatag.HISTORIQUE_SUPPRESSION, ctx.getCode(), EtatFiche.A_SUPPRIMER.getEtat());
                meta.synchroniser(fiche, true);
                FicheUnivMgr.enregistrerMeta(meta);
                PluginFicheHelper.synchroniserObjets(fiche, meta, null);
            }
        }
    }

    public static void archiverListeFichesParIdsMeta(Collection<Long> idsMetas, AutorisationBean autorisations) throws Exception {
        CacheStructureManager cacheStructureManager;
        boolean shouldFlushCacheStructure = false;
        if (idsMetas != null && !idsMetas.isEmpty() && autorisations != null) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            for (Long idMeta : idsMetas) {
                Metatag meta = new Metatag();
                meta.setCtx(ctx);
                meta.setIdMetatag(idMeta);
                meta.retrieve();
                FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
                fiche.setCtx(ctx);
                fiche.setIdFiche(meta.getMetaIdFiche());
                fiche.retrieve();
                if (fiche instanceof StructureModele) {
                    shouldFlushCacheStructure = true;
                }
                if (!autorisations.estAutoriseAModifierLaFiche(fiche)) continue;
                fiche.setEtatObjet(EtatFiche.ARCHIVE.getEtat());
                fiche.update();
                meta.setMetaDateArchivage(new Date(0L));
                meta.addHistorique(Metatag.HISTORIQUE_ARCHIVAGE, ctx.getCode(), EtatFiche.ARCHIVE.getEtat());
                meta.synchroniser(fiche, true);
                FicheUnivMgr.enregistrerMeta(meta);
                PluginFicheHelper.synchroniserObjets(fiche, meta, null);
            }
        }
        if (shouldFlushCacheStructure && (cacheStructureManager = ApplicationContextManager.getCoreContextBean("cacheStructureManager", CacheStructureManager.class)) != null) {
            cacheStructureManager.flush();
        }
    }

    public static void mettreEnLigneListeFichesParIdsMeta(Collection<Long> idsMetas, AutorisationBean autorisations) throws Exception {
        if (idsMetas != null && !idsMetas.isEmpty() && autorisations != null) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            for (Long idMeta : idsMetas) {
                Metatag meta = new Metatag();
                meta.setCtx(ctx);
                meta.setIdMetatag(idMeta);
                meta.retrieve();
                FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
                fiche.setCtx(ctx);
                fiche.setIdFiche(meta.getMetaIdFiche());
                fiche.retrieve();
                if (!autorisations.estAutoriseAModifierLaFiche(fiche)) continue;
                fiche.setEtatObjet(EtatFiche.EN_LIGNE.getEtat());
                fiche.update();
                meta.setMetaDateMiseEnLigne(new Date(0L));
                meta.addHistorique(Metatag.HISTORIQUE_VALIDATION, ctx.getCode(), EtatFiche.EN_LIGNE.getEtat());
                meta.synchroniser(fiche, true);
                FicheUnivMgr.enregistrerMeta(meta);
                PluginFicheHelper.synchroniserObjets(fiche, meta, null);
            }
        }
    }

    public static Map<String, String> getClassEtatsObjet() {
        Map<String, String> libellesParEtat = ReferentielObjets.getEtatsObjet();
        HashMap<String, String> classParEtat = new HashMap<String, String>();
        for (String codeLibelle : libellesParEtat.keySet()) {
            classParEtat.put(codeLibelle, FicheUnivHelper.getClassEtat(codeLibelle));
        }
        return classParEtat;
    }

    public static String getClassEtat(String etat) {
        return PropertyHelper.getCoreProperty("ETATFICHE_" + etat);
    }
}

