/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.textsearch.CacheIndexerManager;
import com.jsbsoft.jtf.textsearch.Indexer;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheAnnuaire;
import com.univ.objetspartages.om.FicheArchivable;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import java.sql.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FicheUnivMgr {
    private static final Logger LOG = LoggerFactory.getLogger(FicheUnivMgr.class);

    public static boolean controlerRestriction(FicheUniv ficheUniv, OMContext _ctx) throws Exception {
        return FicheUnivMgr.controlerRestriction(ficheUniv, _ctx, true);
    }

    public static boolean controlerRestriction(FicheUniv ficheUniv, OMContext _ctx, boolean controleRubrique) throws Exception {
        String activationDsi = PropertyHelper.getCoreProperty("dsi.activation");
        if (activationDsi == null) {
            activationDsi = "0";
        }
        if (activationDsi.equals("0")) {
            return true;
        }
        boolean accesOK = true;
        HttpServletRequest requeteHTTP = null;
        ContexteUniv ctx = null;
        boolean ajouterRestriction = false;
        if (_ctx instanceof ContexteUniv && (requeteHTTP = (ctx = (ContexteUniv)_ctx).getRequeteHTTP()) != null) {
            ajouterRestriction = true;
        }
        if (ajouterRestriction) {
            if (ficheUniv instanceof DiffusionSelective) {
                accesOK = false;
                DiffusionSelective ficheDiffusion = (DiffusionSelective)((Object)ficheUniv);
                String modeRestriction = ficheDiffusion.getDiffusionModeRestriction();
                if (modeRestriction.equals("0")) {
                    accesOK = true;
                } else if (modeRestriction.equals("1")) {
                    String prefixeIP;
                    String adresseIP = requeteHTTP.getRemoteAddr();
                    String rechercheDomaine = PropertyHelper.getCoreProperty("dsi.recherche_domaine");
                    if (rechercheDomaine == null) {
                        rechercheDomaine = "0";
                    }
                    String hostClient = "zzzzz.zz";
                    if (rechercheDomaine.equals("1")) {
                        hostClient = requeteHTTP.getRemoteHost();
                    }
                    if ((prefixeIP = PropertyHelper.getCoreProperty("dsi.prefixe_ip")) == null) {
                        prefixeIP = "";
                    }
                    StringTokenizer st = new StringTokenizer(prefixeIP, ";");
                    while (st.hasMoreTokens()) {
                        String ipCourant = st.nextToken();
                        boolean estUneIP = true;
                        for (int i = 0; i < ipCourant.length(); ++i) {
                            char ch = ipCourant.charAt(i);
                            if (Character.isDigit(ch) || ch == '.') continue;
                            estUneIP = false;
                        }
                        if (estUneIP && adresseIP.indexOf(ipCourant) == 0) {
                            accesOK = true;
                        }
                        if (estUneIP || !hostClient.endsWith(ipCourant)) continue;
                        accesOK = true;
                    }
                } else if (modeRestriction.equals("2")) {
                    accesOK = FicheUnivMgr.controlerRestrictionGroupeDsi(ficheDiffusion.getDiffusionPublicVise(), ctx);
                } else if (modeRestriction.equals("3")) {
                    accesOK = FicheUnivMgr.controlerRestrictionGroupeDsi(ficheDiffusion.getDiffusionPublicViseRestriction(), ctx);
                } else if (modeRestriction.equals("4")) {
                    InfosEspaceCollaboratif espace = Espacecollaboratif.renvoyerItemEspace(ficheDiffusion.getDiffusionPublicViseRestriction());
                    if (Espacecollaboratif.estMembreEspace(ctx, espace)) {
                        accesOK = true;
                    } else if (Espacecollaboratif.estVisiteurEspace(ctx, espace)) {
                        accesOK = true;
                    }
                }
            }
            if (accesOK && controleRubrique) {
                accesOK = Rubrique.controlerRestrictionRubrique(ctx, ficheUniv.getCodeRubrique());
                if (!accesOK) {
                    Vector<String> listeRubriquesPublications = Rubriquepublication.getListeRubriquesPublication(_ctx, ficheUniv, ctx.getInfosSite().getCodeRubrique());
                    Enumeration<String> e = listeRubriquesPublications.elements();
                    while (!accesOK && e.hasMoreElements()) {
                        accesOK = Rubrique.controlerRestrictionRubrique(ctx, e.nextElement());
                    }
                }
                if (accesOK && ctx.getCodeRubriqueFicheCourante().length() > 0) {
                    accesOK = Rubrique.controlerRestrictionRubrique(ctx, ctx.getCodeRubriqueFicheCourante());
                }
            }
            if (ctx.getCodeRubriqueFicheCourante().equals("ZYZYZYZYZYZYZYZYZYZYZY")) {
                accesOK = false;
                ctx.setCodeRubriqueFicheCourante("");
            }
        }
        return accesOK;
    }

    private static boolean controlerRestrictionGroupeDsi(String groupesRestrictionFiche, ContexteUniv ctx) throws Exception {
        boolean accesOK = false;
        Vector<String> listeGroupes = new Vector<String>();
        for (String groupeCourant : ctx.getGroupesDsi()) {
            listeGroupes.add(groupeCourant);
            InfosGroupeDsi infoGroupe = Groupedsi.renvoyerItemGroupeDsi(groupeCourant);
            int niveauItemCourant = infoGroupe.getNiveau();
            for (int niveau = niveauItemCourant - 1; niveau > 0; --niveau) {
                String codeGroupe = infoGroupe.getCodeGroupePere();
                listeGroupes.add(codeGroupe);
                infoGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
            }
        }
        Enumeration e = listeGroupes.elements();
        while (e.hasMoreElements()) {
            String codeGroupeDsi = (String)e.nextElement();
            if (!groupesRestrictionFiche.contains("[/" + codeGroupeDsi + "]")) continue;
            accesOK = true;
        }
        return accesOK;
    }

    public static void init(FicheUniv ficheUniv) {
        ficheUniv.setMetaKeywords("");
        ficheUniv.setMetaDescription("");
        ficheUniv.setTitreEncadre("");
        ficheUniv.setContenuEncadre("");
        ficheUniv.setEncadreRecherche("");
        ficheUniv.setEncadreRechercheBis("");
        ficheUniv.setDateAlerte(new Date(0L));
        ficheUniv.setMessageAlerte("");
        ficheUniv.setDateCreation(new Date(System.currentTimeMillis()));
        ficheUniv.setDateModification(new Date(System.currentTimeMillis()));
        ficheUniv.setDateProposition(new Date(0L));
        ficheUniv.setDateValidation(new Date(0L));
        ficheUniv.setCodeRedacteur("");
        ficheUniv.setCodeValidation("");
        ficheUniv.setCodeRattachement("");
        ficheUniv.setCodeRubrique("");
        if (ficheUniv instanceof DiffusionSelective) {
            DiffusionSelective ficheDiffusion = (DiffusionSelective)((Object)ficheUniv);
            ficheDiffusion.setDiffusionModeRestriction("0");
            ficheDiffusion.setDiffusionPublicVise("");
            ficheDiffusion.setDiffusionPublicViseRestriction("");
        }
        ficheUniv.setEtatObjet("0001");
        ficheUniv.setNbHits(0L);
    }

    public static FicheUniv init(Metatag meta) throws Exception {
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
        if (ficheUniv != null) {
            ficheUniv.init();
            ficheUniv.setCodeRattachement(meta.getMetaCodeRattachement());
            ficheUniv.setCodeRubrique(meta.getMetaCodeRubrique());
            if (ficheUniv instanceof FicheRattachementsSecondaires) {
                ((FicheRattachementsSecondaires)((Object)ficheUniv)).setCodeRattachementAutres(Chaine.convertirPointsVirgulesEnAccolades(meta.getMetaCodeRattachementAutres()));
            }
            ficheUniv.setCodeRedacteur(meta.getMetaCodeRedacteur());
            ficheUniv.setCodeValidation(meta.getMetaCodeValidation());
            ficheUniv.setCode(meta.getMetaCode());
            ficheUniv.setLangue(meta.getMetaLangue());
            ficheUniv.setEtatObjet(meta.getMetaEtatObjet());
            if (ficheUniv instanceof DiffusionSelective) {
                ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicVise(meta.getMetaDiffusionPublicVise());
                ((DiffusionSelective)((Object)ficheUniv)).setDiffusionModeRestriction(meta.getMetaDiffusionModeRestriction());
                ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicViseRestriction(meta.getMetaDiffusionPublicViseRestriction());
            }
        }
        return ficheUniv;
    }

    @Deprecated
    public static void creerVersionTravail(OMContext ctx, FicheUniv fiche) throws Exception {
        FicheUnivMgr.creerVersionTravail(fiche);
    }

    public static void creerVersionTravail(FicheUniv fiche) throws Exception {
        try (ContexteDao ctx = new ContexteDao();){
            if (FicheUnivMgr.existeVersionTravail(fiche)) {
                FicheUniv fiche2 = (FicheUniv)fiche.getClass().newInstance();
                fiche2.init();
                fiche2.setCtx(ctx);
                if (fiche2.selectCodeLangueEtat(fiche.getCode(), fiche.getLangue(), "0001") > 0) {
                    while (fiche2.nextItem()) {
                        FicheUnivMgr.supprimerFiche(fiche2, true);
                    }
                }
            }
            fiche.setIdFiche(0L);
            fiche.setEtatObjet("0001");
            fiche.setCtx(ctx);
            fiche.add();
        }
    }

    @Deprecated
    public static void enregistrer(boolean fCreation, OMContext ctx, FicheUniv fiche) throws Exception {
        FicheUnivMgr.enregistrer(fCreation, fiche);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void enregistrer(boolean creation, FicheUniv fiche) throws Exception {
        try (ContexteDao ctx = new ContexteDao();){
            if (creation) {
                boolean doublon = Boolean.FALSE;
                FicheUniv fiche2 = (FicheUniv)fiche.getClass().newInstance();
                fiche2.init();
                fiche2.setCtx(ctx);
                if (fiche2.selectCodeLangueEtat(fiche.getCode(), fiche.getLangue(), "") > 0) {
                    doublon = Boolean.TRUE;
                }
                if (doublon) throw new ErreurApplicative("Cette fiche existe d\u00e9j\u00e0");
                fiche.setCtx(ctx);
                fiche.add();
                return;
            } else {
                fiche.setCtx(ctx);
                fiche.update();
            }
            return;
        }
    }

    @Deprecated
    public static void enregistrerMeta(OMContext ctx, Metatag meta) throws Exception {
        FicheUnivMgr.enregistrerMeta(meta);
    }

    public static void enregistrerMeta(Metatag meta) throws Exception {
        try (ContexteDao ctx = new ContexteDao();){
            meta.setCtx(ctx);
            if (!meta.getIdMetatag().equals(0L)) {
                meta.setMetaDateOperation(new Date(System.currentTimeMillis()));
                meta.update();
            } else {
                meta.add();
            }
        }
    }

    @Deprecated
    public static boolean existeVersionTravail(OMContext ctx, FicheUniv fiche) throws Exception {
        return FicheUnivMgr.existeVersionTravail(fiche);
    }

    public static boolean existeVersionTravail(FicheUniv fiche) throws Exception {
        boolean result;
        try (ContexteDao ctx = new ContexteDao();){
            FicheUniv fiche2 = (FicheUniv)fiche.getClass().newInstance();
            fiche2.init();
            fiche2.setCtx(ctx);
            result = fiche2.selectCodeLangueEtat(fiche.getCode(), fiche.getLangue(), "0001") > 0;
        }
        return result;
    }

    @Deprecated
    public static Metatag lireMeta(OMContext ctx, FicheUniv ficheUniv) throws Exception {
        return FicheUnivMgr.lireMeta(ficheUniv);
    }

    public static Metatag lireMeta(FicheUniv ficheUniv) throws Exception {
        Metatag meta = new Metatag();
        meta.init();
        try (ContexteDao ctx = new ContexteDao();){
            meta.setCtx(ctx);
            if (meta.select(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()), ficheUniv.getIdFiche()) > 0) {
                meta.nextItem();
            } else {
                meta.setMetaCodeObjet(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()));
                meta.setMetaLibelleObjet(ReferentielObjets.getLibelleObjet(meta.getMetaCodeObjet()));
                meta.setMetaIdFiche(ficheUniv.getIdFiche());
                meta.setMetaDiffusionModeRestriction("0");
            }
        }
        return meta;
    }

    @Deprecated
    public static Metatag creerMeta(OMContext ctx, FicheUniv ficheUniv) throws Exception {
        return FicheUnivMgr.creerMeta(ficheUniv);
    }

    public static Metatag creerMeta(FicheUniv ficheUniv) throws Exception {
        Metatag meta = new Metatag();
        try (ContexteDao ctx = new ContexteDao();){
            meta.init();
            meta.setCtx(ctx);
            meta.setMetaIdFiche(ficheUniv.getIdFiche());
            meta.setMetaCodeObjet(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()));
            if (ficheUniv instanceof FicheArchivable) {
                meta.setMetaDateArchivage(((FicheArchivable)((Object)ficheUniv)).getDateArchivage());
            }
            meta.calculerReferences(ficheUniv);
            meta.setMetaLibelleObjet(ReferentielObjets.getLibelleObjet(meta.getMetaCodeObjet()));
            meta.setMetaCodeRattachement(ficheUniv.getCodeRattachement());
            meta.setMetaCodeRubrique(ficheUniv.getCodeRubrique());
            if (ficheUniv instanceof FicheRattachementsSecondaires) {
                meta.setMetaCodeRattachementAutres(Chaine.convertirPointsVirgulesEnAccolades(((FicheRattachementsSecondaires)((Object)ficheUniv)).getCodeRattachementAutres()));
            }
            meta.setMetaLibelleObjet(ReferentielObjets.getLibelleObjet(meta.getMetaCodeObjet()));
            meta.setMetaLibelleFiche(ficheUniv.getLibelleAffichable());
            meta.setMetaMetaKeywords(ficheUniv.getMetaKeywords());
            meta.setMetaMetaDescription(ficheUniv.getMetaDescription());
            meta.setMetaDateCreation(ficheUniv.getDateCreation());
            meta.setMetaDateProposition(ficheUniv.getDateProposition());
            meta.setMetaDateValidation(ficheUniv.getDateValidation());
            meta.setMetaDateMiseEnLigne(ficheUniv.getDateCreation());
            meta.setMetaDateModification(ficheUniv.getDateModification());
            meta.setMetaCodeRedacteur(ficheUniv.getCodeRedacteur());
            meta.setMetaCodeValidation(ficheUniv.getCodeValidation());
            meta.setMetaCode(ficheUniv.getCode());
            meta.setMetaLangue(ficheUniv.getLangue());
            meta.setMetaEtatObjet(ficheUniv.getEtatObjet());
            meta.setMetaNbHits(ficheUniv.getNbHits());
            if (ficheUniv instanceof DiffusionSelective) {
                meta.setMetaDiffusionPublicVise(((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicVise());
                meta.setMetaDiffusionModeRestriction(((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction());
                meta.setMetaDiffusionPublicViseRestriction(((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction());
            }
            meta.add();
        }
        return meta;
    }

    @Deprecated
    public static Long mettreEnLigne(OMContext ctx, FicheUniv fiche, FicheUniv ancienneFiche) throws Exception {
        return FicheUnivMgr.mettreEnLigne(fiche, ancienneFiche);
    }

    public static Long mettreEnLigne(FicheUniv fiche, FicheUniv ancienneFiche) throws Exception {
        Long idMetaFicheEnLigne = 0L;
        try (ContexteDao ctx = new ContexteDao();){
            if (!fiche.getEtatObjet().equals("0003")) {
                fiche.setEtatObjet("0003");
                fiche.setCtx(ctx);
                fiche.update();
                if (ancienneFiche != null && !ancienneFiche.getIdFiche().equals(fiche.getIdFiche())) {
                    idMetaFicheEnLigne = FicheUnivMgr.supprimerFiche(ancienneFiche, false);
                }
            }
        }
        return idMetaFicheEnLigne;
    }

    @Deprecated
    public static Metatag supprimerMeta(OMContext ctx, FicheUniv ficheUniv) throws Exception {
        return FicheUnivMgr.supprimerMeta(ficheUniv);
    }

    public static Metatag supprimerMeta(FicheUniv ficheUniv) throws Exception {
        Metatag meta = new Metatag();
        meta.init();
        try (ContexteDao ctx = new ContexteDao();){
            meta.setCtx(ctx);
            if (meta.select(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()), ficheUniv.getIdFiche()) > 0) {
                while (meta.nextItem()) {
                    meta.delete();
                }
            }
        }
        return meta;
    }

    public static String getReferenceParJointure(String objet, String code) {
        StringBuilder res = new StringBuilder();
        String newObjet = objet;
        if (objet.equalsIgnoreCase("structure")) {
            newObjet = Structure.getNomObjetStructureParCodeLangue(code, "");
        } else if (objet.equalsIgnoreCase("annuaire")) {
            Object[] codeLangueAnnuaire;
            Object langue = "";
            Object newCode = code;
            if (code.contains(",") && ArrayUtils.isNotEmpty((Object[])(codeLangueAnnuaire = code.split(","))) && codeLangueAnnuaire.length >= 2) {
                newCode = codeLangueAnnuaire[0];
                langue = codeLangueAnnuaire[1];
            }
            newObjet = FicheAnnuaire.getNomObjetAnnuaireParCodeLangue((String)newCode, (String)langue);
        }
        StringTokenizer st = new StringTokenizer(code, ";");
        while (st.hasMoreTokens()) {
            res.append("[id-fiche]").append(newObjet).append(";").append(st.nextToken()).append("[/id-fiche]");
        }
        return res.toString();
    }

    public static String getReferenceParPhoto(Long idPhoto) {
        String res = "";
        if (!idPhoto.equals(new Long(0L))) {
            res = "[id-image]" + idPhoto + "[/id-image]";
        }
        return res;
    }

    public static String getReferenceParListePhoto(List<Ressource> listePhotos) {
        String res = "";
        for (Ressource photo : listePhotos) {
            if (!photo.isPhoto() || photo.getIdMedia() == null) continue;
            res = "[id-image]" + photo.getIdMedia() + "[/id-image]";
        }
        return res;
    }

    public static String getReferenceParTexte(String texte) {
        String res = "";
        if (texte != null) {
            res = texte;
        }
        return res;
    }

    @Deprecated
    public static Metatag lireMeta(OMContext ctx, String _codeObjet, Long idFiche) throws Exception {
        return FicheUnivMgr.lireMeta(_codeObjet, idFiche);
    }

    public static Metatag lireMeta(String codeObjet, Long idFiche) throws Exception {
        Metatag meta = new Metatag();
        try (ContexteDao ctx = new ContexteDao();){
            meta.init();
            meta.setCtx(ctx);
            if (meta.select(codeObjet, idFiche) > 0) {
                meta.nextItem();
            }
        }
        return meta;
    }

    public static void dupliquer(FicheUniv ficheUniv) {
        ficheUniv.setDateAlerte(new Date(0L));
        ficheUniv.setMessageAlerte("");
        ficheUniv.setDateCreation(new Date(System.currentTimeMillis()));
        ficheUniv.setDateModification(new Date(System.currentTimeMillis()));
        ficheUniv.setDateProposition(new Date(0L));
        ficheUniv.setDateValidation(new Date(0L));
        ficheUniv.setCodeValidation("");
        ficheUniv.setEtatObjet("0001");
        ficheUniv.setNbHits(0L);
    }

    public static boolean isFicheCollaborative(FicheUniv _ficheUniv) {
        return _ficheUniv instanceof DiffusionSelective && "4".equals(((DiffusionSelective)((Object)_ficheUniv)).getDiffusionModeRestriction()) && ((DiffusionSelective)((Object)_ficheUniv)).getDiffusionPublicViseRestriction().length() > 0;
    }

    @Deprecated
    public static boolean synchroniserMetaTag(OMContext ctx, FicheUniv ficheUniv, String majReferences) throws Exception {
        return FicheUnivMgr.synchroniserMetaTag(ficheUniv, majReferences);
    }

    @Deprecated
    public static boolean synchroniserMetaTag(OMContext ctx, FicheUniv ficheUniv, String majReferences, boolean effectuerTraitementFiche) throws Exception {
        return FicheUnivMgr.synchroniserMetaTag(ficheUniv, majReferences, effectuerTraitementFiche);
    }

    public static boolean synchroniserMetaTag(FicheUniv ficheUniv, String majReferences) throws Exception {
        return FicheUnivMgr.synchroniserMetaTag(ficheUniv, majReferences, false);
    }

    public static boolean synchroniserMetaTag(FicheUniv ficheUniv, String majReferences, boolean effectuerTraitementFiche) throws Exception {
        String codeObjet = "";
        String code = "";
        String langue = "0";
        boolean synchro = false;
        try (ContexteDao ctx = new ContexteDao();){
            codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
            code = ficheUniv.getCode();
            langue = ficheUniv.getLangue();
            long today = System.currentTimeMillis();
            Metatag meta = new Metatag();
            meta.init();
            meta.setCtx(ctx);
            Indexer indexer = Indexer.getInstance();
            if (meta.select(codeObjet, ficheUniv.getIdFiche()) > 0) {
                while (meta.nextItem()) {
                    List<String> differences;
                    if (effectuerTraitementFiche) {
                        if (meta.getMetaDateSuppression() != null) {
                            if (Formateur.estSaisie(meta.getMetaDateSuppression()) && today > meta.getMetaDateSuppression().getTime()) {
                                FicheUnivMgr.supprimerFiche(ficheUniv, true);
                                continue;
                            }
                        } else {
                            meta.setMetaDateSuppression(new Date(0L));
                        }
                        if ("0003".equals(ficheUniv.getEtatObjet())) {
                            if (meta.getMetaDateRubriquage() != null) {
                                if (Formateur.estSaisie(meta.getMetaDateRubriquage()) && today > meta.getMetaDateRubriquage().getTime() && meta.getMetaCodeRubriquage().length() > 0) {
                                    if (Rubrique.renvoyerItemRubrique(meta.getMetaCodeRubriquage()).getCode().length() > 0) {
                                        ficheUniv.setCodeRubrique(meta.getMetaCodeRubriquage());
                                        ficheUniv.setCtx(ctx);
                                        ficheUniv.update();
                                        meta.addHistorique(Metatag.HISTORIQUE_RUBRIQUAGE_AUTO, "nobody", ficheUniv.getEtatObjet());
                                    }
                                    meta.setMetaCodeRubriquage("");
                                    meta.setMetaDateRubriquage(new Date(0L));
                                }
                            } else {
                                meta.setMetaDateRubriquage(new Date(0L));
                            }
                            if (meta.getMetaDateArchivage() != null) {
                                if (Formateur.estSaisie(meta.getMetaDateArchivage()) && today > meta.getMetaDateArchivage().getTime()) {
                                    ficheUniv.setEtatObjet("0007");
                                    ficheUniv.setCtx(ctx);
                                    ficheUniv.update();
                                    meta.setMetaDateArchivage(new Date(0L));
                                    meta.addHistorique(Metatag.HISTORIQUE_ARCHIVAGE_AUTO, "nobody", "0007");
                                    MetatagBean metaClone = new MetatagBean();
                                    metaClone.setMetaIdFiche(ficheUniv.getIdFiche());
                                    metaClone.setMetaCodeObjet(meta.getMetaCodeObjet());
                                    CacheIndexerManager.getInstance().addOrUpdate(metaClone.hashCode(), metaClone);
                                }
                            } else {
                                meta.setMetaDateArchivage(new Date(0L));
                            }
                        }
                    }
                    boolean update = false;
                    if ("1".equals(majReferences)) {
                        String references = meta.getMetaListeReferences();
                        meta.calculerReferences(ficheUniv);
                        if (!references.equals(meta.getMetaListeReferences())) {
                            update = true;
                        }
                    }
                    if (!(differences = meta.controlerCoherenceAvecFiche(ficheUniv)).isEmpty()) {
                        meta.synchroniser(ficheUniv, false);
                        update = true;
                    }
                    if (!effectuerTraitementFiche) {
                        meta.setMetaDateOperation(new Date(System.currentTimeMillis()));
                        update = true;
                    }
                    if (!update) continue;
                    meta.update();
                }
            } else {
                FicheUnivMgr.creerMeta(ficheUniv);
            }
            synchro = true;
        }
        catch (Exception e) {
            LOG.error("Exception pendant synchronisation metatag fiche  objet : " + ReferentielObjets.getNomObjet(codeObjet) + " code : " + code + " langue : " + langue, (Throwable)e);
        }
        return synchro;
    }

    @Deprecated
    public static Long supprimerFiche(OMContext ctx, FicheUniv ficheUniv, boolean suppressionMeta) {
        return FicheUnivMgr.supprimerFiche(ficheUniv, suppressionMeta);
    }

    public static Long supprimerFiche(FicheUniv ficheUniv, boolean suppressionMeta) {
        String nomObjet = "";
        Long idMeta = 0L;
        try (ContexteDao ctx = new ContexteDao();){
            Metatag meta;
            nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(ficheUniv));
            ficheUniv.setCtx(ctx);
            ficheUniv.delete();
            MetatagBean metaClone = new MetatagBean();
            metaClone.setMetaIdFiche(ficheUniv.getIdFiche());
            metaClone.setMetaCodeObjet(ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName()));
            CacheIndexerManager.getInstance().addOrUpdate(metaClone.hashCode(), metaClone);
            if (suppressionMeta) {
                meta = FicheUnivMgr.supprimerMeta(ficheUniv);
                idMeta = meta.getIdMetatag();
            } else {
                meta = FicheUnivMgr.lireMeta(ficheUniv);
                idMeta = meta.getIdMetatag();
            }
            FicheUniv fiche2 = (FicheUniv)ficheUniv.getClass().newInstance();
            fiche2.init();
            fiche2.setCtx(ctx);
            if (fiche2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "") == 0) {
                Rubriquepublication.deleteGlobal(ficheUniv);
            }
            PluginFicheHelper.supprimerObjets(ficheUniv, meta, null);
            LOG.debug("Suppression fiche objet : " + nomObjet + " code : " + ficheUniv.getCode() + " langue : " + ficheUniv.getLangue() + "\n");
        }
        catch (Exception e) {
            LOG.error("Exception pendant suppression fiche objet : " + nomObjet + " code : " + ficheUniv.getCode() + " langue : " + ficheUniv.getLangue(), (Throwable)e);
        }
        return idMeta;
    }

    public static void supprimerFiche(FicheUniv ficheUniv, Metatag meta) {
        String nomObjet = "";
        try (ContexteDao ctx = new ContexteDao();){
            nomObjet = ReferentielObjets.getNomObjet(meta.getMetaCodeObjet());
            ficheUniv.setCtx(ctx);
            ficheUniv.delete();
            MetatagBean metaClone = new MetatagBean();
            metaClone.setMetaIdFiche(meta.getMetaIdFiche());
            metaClone.setMetaCodeObjet(meta.getMetaCodeObjet());
            CacheIndexerManager.getInstance().addOrUpdate(metaClone.hashCode(), metaClone);
            meta.setCtx(ctx);
            meta.delete();
            FicheUniv fiche2 = (FicheUniv)ficheUniv.getClass().newInstance();
            fiche2.init();
            fiche2.setCtx(ctx);
            if (fiche2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "") == 0) {
                Rubriquepublication.deleteGlobal(ficheUniv);
            }
            PluginFicheHelper.supprimerObjets(ficheUniv, meta, null);
            LOG.debug("Suppression fiche objet : " + nomObjet + " code : " + ficheUniv.getCode() + " langue : " + ficheUniv.getLangue());
        }
        catch (Exception e) {
            LOG.error("Exception pendant suppression fiche objet : " + nomObjet + " code : " + ficheUniv.getCode() + " langue : " + ficheUniv.getLangue(), (Throwable)e);
        }
    }

    @Deprecated
    public static String getFullTextString(OMContext ctx, FicheUniv fiche) throws Exception {
        String res = Structure.getLibelleAffichable(fiche.getCodeRattachement(), fiche.getLangue());
        if (res.length() > 0) {
            res = res + " ";
        }
        return res;
    }
}

