/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.kportal.core.webapp.WebAppUtil;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderServlet
extends HttpServlet {
    private static final long serialVersionUID = -2328660109979013684L;
    private static final Logger LOG = LoggerFactory.getLogger(FileReaderServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performTask(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performTask(request, response);
    }

    public void performTask(HttpServletRequest request, HttpServletResponse response) {
        int status;
        ContexteUniv ctx;
        block26: {
            ctx = null;
            status = 0;
            try {
                File f;
                ctx = ContexteUtil.getContexteUniv();
                String file = request.getParameter("FILE") != null ? request.getParameter("FILE") : "";
                String fileName = request.getParameter("NAME") != null ? request.getParameter("NAME") : "";
                String contentType = request.getParameter("TYPE") != null ? request.getParameter("TYPE") : "";
                String contentDisposition = "";
                String filePath = "";
                if (!file.contains("../")) {
                    String serverPath = WebAppUtil.getDownloadPrivatePath();
                    if (StringUtils.isEmpty((CharSequence)file) && StringUtils.isNotEmpty((CharSequence)fileName)) {
                        file = fileName;
                    }
                    if (StringUtils.isEmpty((CharSequence)fileName) && StringUtils.isNotEmpty((CharSequence)file)) {
                        fileName = file.contains("/") ? StringUtils.substringAfterLast((String)file, (String)"/") : file;
                    }
                    contentDisposition = "attachment;filename=\"" + fileName + "\"";
                    filePath = serverPath + File.separator + file;
                    if (StringUtils.isEmpty((CharSequence)contentType)) {
                        contentType = "text/plain";
                    }
                }
                if ((f = new File(filePath)).exists()) {
                    try (ServletOutputStream writer = response.getOutputStream();){
                        response.setContentType(contentType);
                        response.setCharacterEncoding("UTF-8".toLowerCase());
                        if (contentDisposition.length() > 0) {
                            response.setHeader("Content-Disposition", contentDisposition);
                        }
                        this.ecrireContenuDuFichier(writer, f);
                        break block26;
                    }
                    catch (IOException e) {
                        LOG.error("Erreur lors de la lecture/ecriture du fichier", (Throwable)e);
                    }
                    break block26;
                }
                if (filePath.length() > 0) {
                    status = 404;
                }
            }
            catch (Exception e) {
                LOG.error("Erreur lors de la lecture/ecriture du fichier", (Throwable)e);
            }
        }
        if (status != 0) {
            response.setStatus(status);
            String pageErreur = "";
            pageErreur = status == 404 ? ctx.getInfosSite().getJspFo() + "/error/404.jsp" : ctx.getInfosSite().getJspFo() + "/error/403.jsp";
            try {
                RequestDispatcher rd = this.getServletContext().getRequestDispatcher(pageErreur);
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException | ServletException e) {
                LOG.error("erreur lors du forward de la request", e);
            }
        }
    }

    private void ecrireContenuDuFichier(ServletOutputStream writer, File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            int nbBytes;
            byte[] buf = new byte[4096];
            while ((nbBytes = bis.read(buf)) > 0) {
                writer.write(buf, 0, nbBytes);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("Erreur lors de la lecture du fichier", (Throwable)e);
            writer.write("Erreur lors de la lecture du fichier".getBytes());
        }
    }
}

