/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static final Pattern fileRegex = Pattern.compile("[\\p{L}\\w -:]+(((\\.|-)([0-9a-zA-Z]+))$)");

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)in, (OutputStream)out);
    }

    public static void emptyDirectory(File directory) throws IOException {
        FileUtils.cleanDirectory((File)directory);
    }

    public static void emptyAndDeleteDirectory(File directory) throws IOException {
        FileUtils.deleteDirectory((File)directory);
    }

    public static int copierFichier(File source, File destination) {
        return FileUtil.copierFichier(source, destination, false);
    }

    public static int copierFichier(File source, File destination, boolean deleteSource) {
        boolean poids = false;
        try {
            FileUtil.primitiveCopierFichier(source, destination, deleteSource);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Erreur lors de l'ecriture du fichier %s", destination.getAbsolutePath()), (Throwable)e);
        }
        return 0;
    }

    public static int primitiveCopierFichier(File source, File destination, boolean deleteSource) throws IOException {
        int poids = 0;
        if (source.isDirectory()) {
            FileUtils.copyDirectory((File)source, (File)destination);
        } else {
            FileUtils.copyFile((File)source, (File)destination);
            poids = (int)destination.length();
        }
        if (deleteSource) {
            source.delete();
        }
        return poids;
    }

    public static int calculerPoids(File f) {
        try {
            return (int)Math.ceil((double)FileUtils.sizeOf((File)f) / 1024.0);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(String.format("Fichier %s introuvable.", f.getName()), (Throwable)e);
            return 0;
        }
    }

    public static String getExtension(String filename) {
        Matcher fileMatcher = fileRegex.matcher(filename);
        String res = "";
        if (fileMatcher.matches() && fileMatcher.groupCount() > 0) {
            res = fileMatcher.group(4);
        }
        return res.toLowerCase();
    }

    public static String mkdir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }
}

