/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class HTMLCodec {
    private final HashMap<String, String> entityLookup = new HashMap();
    private final HashMap<String, Object> charLookup = new HashMap();
    private static HTMLCodec codec = null;

    public HTMLCodec() {
        this.initialize();
    }

    public static final HTMLCodec getInstance() {
        if (codec == null) {
            codec = new HTMLCodec();
        }
        return codec;
    }

    public final String decode(String chars) {
        if (!this.charLookup.containsKey("&#32;")) {
            this.addBasicChars();
        }
        StringBuffer tempBuffer = new StringBuffer();
        StringBuffer results = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(chars, "");
        int lastAmpersandIndex = -1;
        while (tokenizer.hasMoreElements()) {
            String currentChar = tokenizer.nextToken();
            tempBuffer.append(currentChar);
            if (currentChar.equals("&")) {
                lastAmpersandIndex = tempBuffer.length();
            }
            if (!currentChar.equals(";") || lastAmpersandIndex <= -1 || lastAmpersandIndex <= tempBuffer.length() - 7) continue;
            try {
                results.append((String)this.charLookup.get(tempBuffer.toString()));
            }
            catch (NullPointerException e) {
                results.append(tempBuffer.toString());
            }
            lastAmpersandIndex = -1;
            tempBuffer.delete(1, tempBuffer.length());
        }
        return results.toString();
    }

    public char[] decode(char[] chars) {
        return this.decode(new String(chars)).toCharArray();
    }

    public char[] encode(char[] chars) {
        return this.encode(new String(chars)).toCharArray();
    }

    public final String encode(String chars) {
        return this.encode(chars, false);
    }

    public final String encode(String chars, boolean includeBasicChars) {
        if (includeBasicChars) {
            this.addBasicChars();
        }
        char[] charArray = chars.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (char element : charArray) {
            String currentChar = "" + element;
            try {
                buffer.append(this.entityLookup.get(currentChar));
            }
            catch (NullPointerException e) {
                buffer.append(currentChar);
            }
        }
        return buffer.toString();
    }

    private final void initialize() {
        String aChar;
        int index;
        this.entityLookup.put("\t", "&#09;");
        this.entityLookup.put("\n", "&#10;");
        this.entityLookup.put(System.getProperty("line.separator"), "&#10;");
        this.entityLookup.put("\r", "&#13;");
        this.entityLookup.put("<", "&#60;");
        this.entityLookup.put(">", "&#62;");
        for (index = 11; index < 32; ++index) {
            aChar = String.valueOf((char)index);
            this.entityLookup.put(aChar, "&#0" + index + ";");
        }
        for (index = 128; index < 256; ++index) {
            aChar = String.valueOf((char)index);
            this.entityLookup.put(aChar, "&#" + index + ";");
        }
        this.entityLookup.put("\u00a1", "&iexcl;");
        this.entityLookup.put("\u00a2", "&cent;");
        this.entityLookup.put("\u00a3", "&pound;");
        this.entityLookup.put("\u00a4", "&curren;");
        this.entityLookup.put("\u00a5", "&yen;");
        this.entityLookup.put("\u00a6", "&brvbar;");
        this.entityLookup.put("\u00a7", "&sect;");
        this.entityLookup.put("\u00a8", "&uml;");
        this.entityLookup.put("\u00a9", "&copy;");
        this.entityLookup.put("\u00aa", "&ordf;");
        this.entityLookup.put("\u00ab", "&laquo;");
        this.entityLookup.put("\u00ac", "&not;");
        this.entityLookup.put("\u00ad", "&shy;");
        this.entityLookup.put("\u00ae", "&reg;");
        this.entityLookup.put("\u00af", "&macr;");
        this.entityLookup.put("\u00b0", "&deg;");
        this.entityLookup.put("\u00b1", "&plusmn;");
        this.entityLookup.put("\u00b2", "&sup2;");
        this.entityLookup.put("\u00b3", "&sup3;");
        this.entityLookup.put("\u00b4", "&acute;");
        this.entityLookup.put("\u00b5", "&micro;");
        this.entityLookup.put("\u00b6", "&para;");
        this.entityLookup.put("\u00b7", "&middot;");
        this.entityLookup.put("\u00b8", "&cedil;");
        this.entityLookup.put("\u00b9", "&sup1;");
        this.entityLookup.put("\u00ba", "&ordm;");
        this.entityLookup.put("\u00bb", "&raquo;");
        this.entityLookup.put("\u00bc", "&frac14;");
        this.entityLookup.put("\u00bd", "&frac12;");
        this.entityLookup.put("\u00be", "&frac34;");
        this.entityLookup.put("\u00bf", "&iquest;");
        this.entityLookup.put("\u00c0", "&Agrave;");
        this.entityLookup.put("\u00c1", "&Aacute;");
        this.entityLookup.put("\u00c2", "&Acirc;");
        this.entityLookup.put("\u00c3", "&Atilde;");
        this.entityLookup.put("\u00c4", "&Auml;");
        this.entityLookup.put("\u00c5", "&Aring;");
        this.entityLookup.put("\u00c6", "&AElig;");
        this.entityLookup.put("\u00c7", "&Ccedil;");
        this.entityLookup.put("\u00c8", "&Egrave;");
        this.entityLookup.put("\u00c9", "&Eacute;");
        this.entityLookup.put("\u00ca", "&Ecirc;");
        this.entityLookup.put("\u00cb", "&Euml;");
        this.entityLookup.put("\u00cc", "&Igrave;");
        this.entityLookup.put("\u00cd", "&Iacute;");
        this.entityLookup.put("\u00ce", "&Icirc;");
        this.entityLookup.put("\u00cf", "&Iuml;");
        this.entityLookup.put("\u00d0", "&ETH;");
        this.entityLookup.put("\u00d1", "&Ntilde;");
        this.entityLookup.put("\u00d2", "&Ograve;");
        this.entityLookup.put("\u00d3", "&Oacute;");
        this.entityLookup.put("\u00d4", "&Ocirc;");
        this.entityLookup.put("\u00d5", "&Otilde;");
        this.entityLookup.put("\u00d6", "&Ouml;");
        this.entityLookup.put("\u00d7", "&times;");
        this.entityLookup.put("\u00d8", "&Oslash;");
        this.entityLookup.put("\u00d9", "&Ugrave;");
        this.entityLookup.put("\u00da", "&Uacute;");
        this.entityLookup.put("\u00db", "&Ucirc;");
        this.entityLookup.put("\u00dc", "&Uuml;");
        this.entityLookup.put("\u00dd", "&Yacute;");
        this.entityLookup.put("\u00de", "&THORN;");
        this.entityLookup.put("\u00df", "&szlig;");
        this.entityLookup.put("\u00e0", "&agrave;");
        this.entityLookup.put("\u00e1", "&aacute;");
        this.entityLookup.put("\u00e2", "&acirc;");
        this.entityLookup.put("\u00e3", "&atilde;");
        this.entityLookup.put("\u00e4", "&auml;");
        this.entityLookup.put("\u00e5", "&aring;");
        this.entityLookup.put("\u00e6", "&aelig;");
        this.entityLookup.put("\u00e7", "&ccedil;");
        this.entityLookup.put("\u00e8", "&egrave;");
        this.entityLookup.put("\u00e9", "&eacute;");
        this.entityLookup.put("\u00ea", "&ecirc;");
        this.entityLookup.put("\u00eb", "&euml;");
        this.entityLookup.put("\u00ec", "&igrave;");
        this.entityLookup.put("\u00ed", "&iacute;");
        this.entityLookup.put("\u00ee", "&icirc;");
        this.entityLookup.put("\u00ef", "&iuml;");
        this.entityLookup.put("\u00f0", "&eth;");
        this.entityLookup.put("\u00f1", "&ntilde;");
        this.entityLookup.put("\u00f2", "&ograve;");
        this.entityLookup.put("\u00f3", "&oacute;");
        this.entityLookup.put("\u00f4", "&ocirc;");
        this.entityLookup.put("\u00f5", "&otilde;");
        this.entityLookup.put("\u00f6", "&ouml;");
        this.entityLookup.put("\u00f7", "&divid;");
        this.entityLookup.put("\u00f8", "&oslash;");
        this.entityLookup.put("\u00f9", "&ugrave;");
        this.entityLookup.put("\u00fa", "&uacute;");
        this.entityLookup.put("\u00fb", "&ucirc;");
        this.entityLookup.put("\u00fc", "&uuml;");
        this.entityLookup.put("\u00fd", "&yacute;");
        this.entityLookup.put("\u00fe", "&thorn;");
        this.entityLookup.put("\u00ff", "&yuml;");
        this.entityLookup.put("\u0080", "&euro;");
    }

    public final void addBasicChars() {
        for (int index = 32; index < 128; ++index) {
            String aChar = String.valueOf((char)index);
            this.entityLookup.put(aChar, "&#" + index + ";");
        }
        this.createCharLookup();
    }

    private final void createCharLookup() {
        Set<String> keySet = this.entityLookup.keySet();
        Iterator<String> it = keySet.iterator();
        while (it.hasNext()) {
            String currentKey = this.entityLookup.get(it.next());
            this.charLookup.put(this.entityLookup.get(currentKey), currentKey);
        }
    }
}

