/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.univ.utils.EscapeString;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HTMLtoTexteTransformer {
    private static final String REGEXP_HTML_TAG = "<([a-zA-Z0-9]+)[^>]*>";
    private static final String REGEXP_HTML_END_TAG = "</([a-zA-Z0-9]+)>";
    private static final String REGEXP_HTML_LINK = "<[aA].*?[Hh][Rr][Ee][Ff]=\"?([a-zA-Z0-9\\:\\.\\/_\\-@,&;=\\?%$]*)\"?.*?>(.*?)</[aA]>";

    private HTMLtoTexteTransformer() {
    }

    public static String transformerHtml(String _texteHtml, boolean apercu) throws Exception {
        String tag;
        if (_texteHtml.trim().equals("")) {
            return _texteHtml;
        }
        String newTexte = _texteHtml;
        String cr = "<br />";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(REGEXP_HTML_LINK);
        Matcher m = p.matcher(newTexte);
        while (m.find()) {
            String text = m.group(2) + " : " + m.group(1);
            m.appendReplacement(sb, Matcher.quoteReplacement(text));
        }
        m.appendTail(sb);
        newTexte = sb.toString();
        p = Pattern.compile(REGEXP_HTML_TAG);
        m = p.matcher(newTexte);
        sb = new StringBuffer();
        while (m.find()) {
            tag = m.group(1);
            if (tag.equalsIgnoreCase("br")) {
                m.appendReplacement(sb, "\n");
                continue;
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        newTexte = sb.toString();
        p = Pattern.compile(REGEXP_HTML_END_TAG);
        m = p.matcher(newTexte);
        sb = new StringBuffer();
        while (m.find()) {
            tag = m.group(1);
            if (tag.equalsIgnoreCase("li") || tag.equalsIgnoreCase("div") || tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("h")) {
                m.appendReplacement(sb, "\n");
                continue;
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        newTexte = sb.toString();
        BufferedReader br = new BufferedReader(new StringReader(newTexte));
        String line = null;
        sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (StringUtils.isEmpty((CharSequence)line)) continue;
            sb.append(line + "<br />");
        }
        newTexte = sb.toString();
        newTexte = newTexte.replaceAll("&rsquo;", "&#39;");
        newTexte = newTexte.replaceAll("&oelig;", "oe");
        newTexte = newTexte.replaceAll("&euro;", "e");
        return EscapeString.unescapeHtml(newTexte);
    }
}

