/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import java.io.DataInput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInfo {
    private static Logger LOG = LoggerFactory.getLogger(ImageInfo.class);
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_GIF = 1;
    public static final int FORMAT_PNG = 2;
    public static final int FORMAT_BMP = 3;
    public static final int FORMAT_PCX = 4;
    private static final String[] FORMAT_NAMES = new String[]{"JPEG", "GIF", "PNG", "BMP", "PCX"};
    private static final String[] EXTENSION_NAMES = new String[]{"jpg", "gif", "png", "bmp", "pcx"};
    private int width;
    private int height;
    private int bitsPerPixel;
    private int format;
    private InputStream in;
    private DataInput din;

    public boolean check() {
        try {
            int b1 = this.read() & 0xFF;
            int b2 = this.read() & 0xFF;
            if (b1 == 71 && b2 == 73) {
                return this.checkGif();
            }
            if (b1 == 137 && b2 == 80) {
                return this.checkPng();
            }
            return b1 == 255 && b2 == 216 && this.checkJpeg();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean checkGif() throws IOException {
        byte[] GIF_MAGIC_87A = new byte[]{70, 56, 55, 97};
        byte[] GIF_MAGIC_89A = new byte[]{70, 56, 57, 97};
        byte[] a = new byte[9];
        if (this.read(a) != 9) {
            return false;
        }
        if (!this.equals(a, 0, GIF_MAGIC_89A, 0, 4) && !this.equals(a, 0, GIF_MAGIC_87A, 0, 4)) {
            return false;
        }
        this.format = 1;
        this.width = this.getShortLittleEndian(a, 4);
        this.height = this.getShortLittleEndian(a, 6);
        this.bitsPerPixel = ((a[8] & 0xFF) >> 4 & 7) + 1;
        return true;
    }

    private boolean checkJpeg() throws IOException {
        byte[] data = new byte[6];
        while (this.read(data, 0, 4) == 4) {
            int marker = this.getShortBigEndian(data, 0);
            int size = this.getShortBigEndian(data, 2);
            if ((marker & 0xFF00) != 65280) {
                return false;
            }
            if (marker >= 65472 && marker <= 65487 && marker != 65476 && marker != 65480) {
                if (this.read(data) != 6) {
                    return false;
                }
                this.format = 0;
                this.bitsPerPixel = (data[0] & 0xFF) * (data[5] & 0xFF);
                this.width = this.getShortBigEndian(data, 3);
                this.height = this.getShortBigEndian(data, 1);
                return true;
            }
            this.skip(size - 2);
        }
        return false;
    }

    private boolean checkPng() throws IOException {
        byte[] PNG_MAGIC = new byte[]{78, 71, 13, 10, 26, 10};
        byte[] a = new byte[24];
        if (this.read(a) != 24) {
            return false;
        }
        if (!this.equals(a, 0, PNG_MAGIC, 0, 6)) {
            return false;
        }
        this.format = 2;
        this.width = this.getIntBigEndian(a, 14);
        this.height = this.getIntBigEndian(a, 18);
        this.bitsPerPixel = a[22] & 0xFF;
        int colorType = a[23] & 0xFF;
        if (colorType == 2 || colorType == 6) {
            this.bitsPerPixel *= 3;
        }
        return true;
    }

    private boolean equals(byte[] a1, int offs1, byte[] a2, int offs2, int num) {
        while (num-- > 0) {
            if (a1[offs1++] == a2[offs2++]) continue;
            return false;
        }
        return true;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        if (this.format >= 0 && this.format < FORMAT_NAMES.length) {
            return FORMAT_NAMES[this.format];
        }
        return "?";
    }

    public String getExtensionName() {
        if (this.format >= 0 && this.format < EXTENSION_NAMES.length) {
            return EXTENSION_NAMES[this.format];
        }
        return "?";
    }

    public int getHeight() {
        return this.height;
    }

    private int getIntBigEndian(byte[] a, int offs) {
        return (a[offs] & 0xFF) << 24 | (a[offs + 1] & 0xFF) << 16 | (a[offs + 2] & 0xFF) << 8 | a[offs + 3] & 0xFF;
    }

    private int getShortBigEndian(byte[] a, int offs) {
        return (a[offs] & 0xFF) << 8 | a[offs + 1] & 0xFF;
    }

    private int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    public int getWidth() {
        return this.width;
    }

    public static void main(String[] args) {
        ImageInfo imageInfo = new ImageInfo();
        if (args.length == 0) {
            ImageInfo.run(System.in, imageInfo);
        } else {
            int index = 0;
            while (index < args.length) {
                FileInputStream in = null;
                try {
                    String filename = args[index++];
                    LOG.debug(filename + ";");
                    in = new FileInputStream(filename);
                    ImageInfo.run(in, imageInfo);
                    in.close();
                }
                catch (Exception e) {
                    LOG.error("impossible de lire les donn\u00e9es de l'image", (Throwable)e);
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        return this.din.readByte();
    }

    private int read(byte[] a) throws IOException {
        if (this.in != null) {
            return this.in.read(a);
        }
        this.din.readFully(a);
        return a.length;
    }

    private int read(byte[] a, int offset, int num) throws IOException {
        if (this.in != null) {
            return this.in.read(a, offset, num);
        }
        this.din.readFully(a, offset, num);
        return num;
    }

    private static void run(InputStream in, ImageInfo imageInfo) {
        imageInfo.setInput(in);
        if (imageInfo.check()) {
            LOG.debug(imageInfo.getFormatName() + ";" + imageInfo.getWidth() + ";" + imageInfo.getHeight() + ";" + imageInfo.getBitsPerPixel());
        }
    }

    public void setInput(DataInput dataInput) {
        this.din = dataInput;
        this.in = null;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
        this.din = null;
    }

    private void skip(int num) throws IOException {
        if (this.in != null) {
            this.in.skip(num);
        } else {
            this.din.skipBytes(num);
        }
    }

    public void close() throws IOException {
        this.in.close();
    }
}

