/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.cms.mail.MailFormaterManager;
import com.kportal.cms.mail.MailNotificationFormater;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.processus.SaisieFiche;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.ThreadMail;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailUtil.class);

    private static MailFormaterManager getFormaterManager() {
        return (MailFormaterManager)ApplicationContextManager.getCoreContextBean("mailFormaterManager");
    }

    private static List<MailNotificationFormater> getFormaters(String name) {
        if (MailUtil.getFormaterManager().getFormaters().get(name) != null) {
            return MailUtil.getFormaterManager().getFormaters().get(name);
        }
        return MailUtil.getFormaterManager().getDefaultFormaters();
    }

    public static void envoyerMailRetourValidation(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta, boolean miseEnLigne) throws Exception {
        for (MailNotificationFormater formater : MailUtil.getFormaters(ficheUniv.getClass().getName())) {
            LOGGER.debug("Parcours de l'historique pour retrouver le demandeur de validation : " + meta.getMetaHistorique());
            Vector<String> vHistorique = meta.getVecteurHistorique();
            Iterator<String> itHistorique = vHistorique.iterator();
            String evenement = "";
            String item = "";
            String auteurModification = "";
            while (itHistorique.hasNext()) {
                StringTokenizer st;
                item = itHistorique.next();
                if (item.length() <= 0 || !(st = new StringTokenizer(item = item.substring(1), "/")).hasMoreTokens() || !(evenement = st.nextToken()).equals(Metatag.HISTORIQUE_DEMANDE_VALIDATION) || !st.hasMoreTokens()) continue;
                st.nextToken();
                if (!st.hasMoreTokens()) continue;
                auteurModification = st.nextToken();
                break;
            }
            Utilisateur validateur = Utilisateur.getUtilisateur(ContexteUtil.getContexteUniv().getCode());
            String message = "";
            message = miseEnLigne ? formater.getMessageRetourMiseEnLigne(infoBean.getValues(), ficheUniv, meta, validateur) : formater.getMessageRetourNonValide(infoBean.getValues(), ficheUniv, meta, validateur);
            if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
            ArrayList<String> lstDest = new ArrayList<String>();
            if (auteurModification.length() > 0) {
                LOGGER.debug("Envoi mail retour validation au demandeur : " + auteurModification);
                Utilisateur ut = Utilisateur.getUtilisateur(auteurModification);
                if (ut.getCode().length() > 0) {
                    lstDest.add(ut.getAdresseMail());
                }
            }
            if (ficheUniv.getCodeRedacteur().equalsIgnoreCase("ANONYME") && StringUtils.isNotEmpty((CharSequence)meta.getMetaMailAnonyme())) {
                lstDest.add(meta.getMetaMailAnonyme());
            }
            if (lstDest.size() <= 0) continue;
            String objet = (String)StringUtils.defaultIfEmpty((CharSequence)MessageHelper.getCoreMessage("ST_MAIL_OBJET_RE_DEMANDE_VALIDATION"), (CharSequence)"Re: Demande de validation");
            ThreadMail tm = new ThreadMail(lstDest, objet, message);
            Thread th = new Thread(tm);
            th.start();
        }
    }

    public static void envoyerMailDemandeValidation(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
        for (MailNotificationFormater formater : MailUtil.getFormaters(ficheUniv.getClass().getName())) {
            String chaineValidateur = "";
            if (infoBean.get("LISTE_VALIDATEURS") != null) {
                chaineValidateur = infoBean.getString("LISTE_VALIDATEURS");
            }
            if (chaineValidateur.equalsIgnoreCase("[AUCUNS]")) continue;
            String codeRubriqueValidation = ficheUniv.getCodeRubrique();
            String publicsVisesValidation = "";
            String espaceValidation = "";
            if (ficheUniv instanceof DiffusionSelective && ((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction().equals("4")) {
                espaceValidation = ((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction();
            }
            String codeAction = "V";
            if (StringUtils.isNotEmpty((CharSequence)meta.getMetaNiveauApprobation())) {
                codeAction = meta.getMetaNiveauApprobation();
            }
            TreeSet<String> mails = Utilisateur.getListeUtilisateursPossedantPermission(new PermissionBean("FICHE", infoBean.getString("CODE_OBJET"), codeAction), AutorisationBean.getStructuresPerimetreFiche(ficheUniv), codeRubriqueValidation, "", espaceValidation, true);
            Utilisateur utilisateur_demandeur = Utilisateur.getUtilisateur(ContexteUtil.getContexteUniv().getCode());
            String message = formater.getMessageDemandeValidation(infoBean.getValues(), ficheUniv, meta, utilisateur_demandeur);
            if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
            ArrayList<String> lDestMail = new ArrayList<String>();
            Vector<String> vValidateur = Chaine.getVecteurPointsVirgules(chaineValidateur);
            for (String validateur : mails) {
                String[] tValidateur = validateur.split(";", -2);
                String adresseMail = tValidateur[0];
                String code = tValidateur[2];
                if (vValidateur.size() != 0 && !vValidateur.contains(tValidateur[2])) continue;
                lDestMail.add(tValidateur[0]);
            }
            String objet = (String)StringUtils.defaultIfEmpty((CharSequence)MessageHelper.getCoreMessage("ST_MAIL_OBJET_DEMANDE_VALIDATION"), (CharSequence)"Demande de validation");
            ThreadMail tm = new ThreadMail(lDestMail, objet, message);
            Thread th = new Thread(tm);
            th.start();
        }
    }

    public static void envoyerMailNotification(InfoBean infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        for (MailNotificationFormater formater : MailUtil.getFormaters(ficheUniv.getClass().getName())) {
            if (FicheUnivMgr.isFicheCollaborative(ficheUniv)) continue;
            String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
            String codeRubriqueValidation = ficheUniv.getCodeRubrique();
            String publicsVisesValidation = "";
            String espaceValidation = "";
            if (ficheUniv instanceof DiffusionSelective && ((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction().equals("4")) {
                espaceValidation = ((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction();
            }
            TreeSet<String> mails = Utilisateur.getListeUtilisateursPossedantPermission(new PermissionBean("FICHE", codeObjet, "N"), AutorisationBean.getStructuresPerimetreFiche(ficheUniv), codeRubriqueValidation, "", espaceValidation, true);
            Vector<String> rubPubs = Rubriquepublication.getListeRubriquesPublication(ContexteUtil.getContexteUniv(), ficheUniv);
            for (String rubPub : rubPubs) {
                mails.addAll(Utilisateur.getListeUtilisateursPossedantPermission(new PermissionBean("FICHE", codeObjet, "N"), AutorisationBean.getStructuresPerimetreFiche(ficheUniv), rubPub, "", espaceValidation, true));
            }
            Utilisateur utilisateur_demandeur = Utilisateur.getUtilisateur(ContexteUtil.getContexteUniv().getCode());
            String message = formater.getMessageNotification(infoBean.getValues(), ficheUniv, meta, utilisateur_demandeur);
            if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
            ArrayList<String> lDestMail = new ArrayList<String>();
            for (String validateur : mails) {
                String[] tValidateur = validateur.split(";", -2);
                if (tValidateur[2].equals(utilisateur_demandeur.getCode())) continue;
                lDestMail.add(tValidateur[0]);
            }
            String userLabel = "";
            if (ctx != null) {
                userLabel = Utilisateur.getLibelle(ctx.getCode());
            }
            userLabel = StringUtils.defaultString((String)userLabel, (String)MessageHelper.getCoreMessage("MAIL.NOTIFICATION.AN_ANON"));
            String objet = String.format(MessageHelper.getCoreMessage("MAIL.NOTIFICATION_OBJECT"), ReferentielObjets.getLibelleObjet(codeObjet), ficheUniv.getLibelleAffichable(), userLabel);
            ThreadMail tm = new ThreadMail(lDestMail, objet, message);
            Thread th = new Thread(tm);
            th.start();
        }
    }

    public static boolean controlerListeValidateur(SaisieFiche processus, FicheUniv _fiche, String _chaineUtilisateur, String _codeApprobation) throws Exception {
        boolean res = true;
        if (_chaineUtilisateur != null && _chaineUtilisateur.length() > 0 && !_chaineUtilisateur.equals("[AUCUNS]")) {
            String[] utilisateur;
            String codeObjet = ReferentielObjets.getCodeObjet(_fiche);
            String codeRubriqueValidation = _fiche.getCodeRubrique();
            String publicsVisesValidation = "";
            String espaceValidation = "";
            if (_fiche instanceof DiffusionSelective && ((DiffusionSelective)((Object)_fiche)).getDiffusionModeRestriction().equals("4")) {
                espaceValidation = ((DiffusionSelective)((Object)_fiche)).getDiffusionPublicViseRestriction();
            }
            TreeSet<String> mails = Utilisateur.getListeUtilisateursPossedantPermission(new PermissionBean("FICHE", codeObjet, _codeApprobation), AutorisationBean.getStructuresPerimetreFiche(_fiche), codeRubriqueValidation, "", espaceValidation, false);
            for (String anUtilisateur : utilisateur = _chaineUtilisateur.split(";", -2)) {
                if (mails.contains(anUtilisateur)) continue;
                res = false;
                break;
            }
        }
        return res;
    }

    public static boolean verifMail(String mail) {
        return Pattern.matches("[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[_A-Za-z0-9-]+)", mail);
    }
}

