/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.kportal.core.config.PropertyHelper;
import com.univ.utils.FileUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhotoUtil {
    public static final String[] contentType = new String[]{"JPEG", "PNG", "GIF"};
    private static final Logger LOG = LoggerFactory.getLogger(PhotoUtil.class);

    public static File resize(String path, String format, int newLargeur, int newHauteur, boolean replace) {
        File fOld = new File(path);
        File fNew = new File(fOld.getParent(), "tmp_" + System.currentTimeMillis());
        try {
            String scaleType = PropertyHelper.getCoreProperty("phototheque.proportions");
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            BufferedImage image = ImageIO.read(fOld);
            BufferedImage bImage = PhotoUtil.scale(image, newLargeur, newHauteur, scaleType);
            if (!image.equals(bImage)) {
                IIOImage ioImage = new IIOImage(bImage, null, null);
                ImageOutputStream ios = ImageIO.createImageOutputStream(fNew);
                writer.setOutput(ios);
                if ("jpg".equals(format.toLowerCase()) || "jpeg".equals(format.toLowerCase())) {
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(0.9f);
                    writer.write(null, ioImage, iwp);
                } else {
                    writer.write(ioImage);
                }
                ios.close();
                writer.dispose();
            } else {
                fNew = fOld;
            }
            if (replace) {
                FileUtil.copierFichier(fNew, fOld, true);
                return fOld;
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Impossible de redimensionner l'image \"%s\"", fOld.getAbsolutePath()), (Throwable)e);
            return fOld;
        }
        return fNew;
    }

    public static BufferedImage scale(BufferedImage image, int newWidth, int newHeight, String scaleType) throws IOException {
        Dimension optimalValues = PhotoUtil.computeOptimalValues(image, newWidth, newHeight, scaleType);
        BufferedImage buf = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)optimalValues.width, (int)optimalValues.height, (BufferedImageOp[])new BufferedImageOp[0]);
        if ((newHeight < optimalValues.height || newWidth < optimalValues.width) && "crop".equals(scaleType)) {
            Dimension cropPos = new Dimension(0, 0);
            cropPos.height = optimalValues.height / 2 - newHeight / 2;
            cropPos.width = optimalValues.width / 2 - newWidth / 2;
            if (buf.getHeight() != newHeight || buf.getWidth() != newWidth) {
                buf = Scalr.crop((BufferedImage)buf, (int)cropPos.width, (int)cropPos.height, (int)newWidth, (int)newHeight, (BufferedImageOp[])new BufferedImageOp[0]);
            }
        }
        return buf;
    }

    private static Dimension computeOptimalValues(BufferedImage image, int requestedWidth, int requestedHeight, String scaleType) {
        Dimension result = new Dimension();
        float height = image.getHeight();
        float width = image.getWidth();
        float yScale = (float)requestedHeight / height;
        float xScale = (float)requestedWidth / width;
        if (yScale > 1.0f || xScale > 1.0f) {
            result.setSize(width, height);
        } else {
            if ("ratio".equals(scaleType)) {
                if (xScale < yScale) {
                    requestedHeight = (int)(height * xScale);
                } else {
                    requestedWidth = (int)(width * yScale);
                }
            } else if (xScale < yScale) {
                requestedWidth = (int)(width * yScale);
            } else if (xScale > yScale) {
                requestedHeight = (int)(height * xScale);
            } else {
                requestedHeight = (int)(height * xScale);
                requestedWidth = (int)(width * xScale);
            }
            result.setSize(requestedWidth, requestedHeight);
        }
        return result;
    }
}

