/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.textsearch.CibleRecherche;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.jsbsoft.jtf.textsearch.sitesdistants.RechercheSitesDistants;
import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.RechercheExterne;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RechercheFicheHelper;
import com.univ.utils.RechercheUtil;
import com.univ.utils.RequeteUtil;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class RechercheFiche
extends ProcessusBean {
    public static final String REQUETE = "REQUETE";
    public static final String QUERY = "QUERY";
    public static final String SEARCH_RESULTS = "SEARCH_RESULTS";
    public static final String NB_TOTAL_PAGES = "NB_TOTAL_PAGES";
    public static final String INDICE_DERNIERE_PAGE = "INDICE_DERNIERE_PAGE";
    public static final String INDICE_PAGE_PRECEDENTE = "INDICE_PAGE_PRECEDENTE";
    public static final String FIN_FENETRE = "FIN_FENETRE";
    public static final String DEBUT_FENETRE = "DEBUT_FENETRE";
    public static final String NB_RESULTATS = "NB_RESULTATS";
    public static final String NB_RESULTATS_PAR_PAGE = "NB_RESULTATS_PAR_PAGE";
    protected static final String ECRAN_RECHERCHE = "RECHERCHE";
    protected static final String ECRAN_RECHERCHE_AVANCEE = "RECHERCHE_AVANCEE";
    protected static final String ECRAN_LISTE = "LISTE";
    private static final String FROM_PARAMETER = "FROM";

    public RechercheFiche(InfoBean ciu) {
        super(ciu);
    }

    protected void preparerLISTE() {
        this.ecranLogique = ECRAN_LISTE;
    }

    protected void preparerRECHERCHE() throws Exception {
        boolean rechercheEffectuee = false;
        Locale locale = this.getLocale();
        this.infoBean.set("SAISIE_FRONT", "TRUE");
        if (this.infoBean.getString("OBJET").equalsIgnoreCase("STRUCTURE")) {
            Hashtable<String, String> ht1 = Libelle.getListe("60", locale);
            Hashtable<String, String> ht2 = Libelle.getListe("63", locale);
            ht1.putAll(ht2);
            this.infoBean.set("LISTE_TYPE_STRUCTURES", ht1);
            this.infoBean.set("LISTE_STRUCTURES", Structure.getListeStructuresPremierNiveau(String.valueOf(LangueUtil.getIndiceLocale(locale)), true));
            rechercheEffectuee = true;
        }
        if (!rechercheEffectuee) {
            for (RechercheExterne bean : ClassBeanManager.getInstance().getBeanOfType(RechercheExterne.class)) {
                RechercheExterne rechercheExterne = bean;
                if (!rechercheExterne.preparerRECHERCHE(this.infoBean, this)) continue;
                rechercheEffectuee = true;
                break;
            }
        }
        this.ecranLogique = ECRAN_RECHERCHE;
    }

    protected void preparerRECHERCHE_AVANCEE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE_AVANCEE;
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.ecranLogique = this.infoBean.getEcranLogique();
        this.fixObjetParameter();
        this.action = this.infoBean.getActionUtilisateur();
        this.etat = 1;
        if (this.ecranLogique == null) {
            if (this.action.equals("RECHERCHER")) {
                this.preparerRECHERCHE();
            }
            if (this.action.equals(ECRAN_RECHERCHE_AVANCEE)) {
                this.preparerRECHERCHE_AVANCEE();
            }
        } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
            this.traiterRECHERCHE();
        }
        this.infoBean.setEcranLogique(this.ecranLogique);
        return this.etat == 2;
    }

    private void fixObjetParameter() {
        if (this.infoBean.get("OBJET") == null && this.infoBean.get("objet") != null) {
            this.infoBean.set("OBJET", this.infoBean.get("objet"));
        }
    }

    protected void traiterRECHERCHE() throws Exception {
        if (this.action.equals("VALIDER")) {
            String requestParams = "";
            if (RechercheFicheHelper.isFullTextSearch(this.infoBean)) {
                requestParams = this.buildRequest();
                this.infoBean.set(REQUETE, requestParams);
            } else {
                for (RechercheExterne rechercheExterne : ClassBeanManager.getInstance().getBeanOfType(RechercheExterne.class)) {
                    if (!rechercheExterne.traiterRECHERCHE(this.infoBean, this)) continue;
                    requestParams = this.infoBean.getString(REQUETE);
                    break;
                }
            }
            List<ResultatRecherche> results = this.search(requestParams);
            this.processPagination(results);
            this.preparerLISTE();
        }
    }

    private void processPagination(List<ResultatRecherche> results) {
        int nbResultats = 0;
        int nbResultatsParPage = 10;
        String nbResultPerPage = PropertyHelper.getCoreProperty("recherche.nbrespage");
        if (StringUtils.isNotBlank((CharSequence)nbResultPerPage) && StringUtils.isNumeric((CharSequence)nbResultPerPage)) {
            nbResultatsParPage = Integer.valueOf(nbResultPerPage);
        }
        int debutFenetre = 0;
        int finFenetre = 0;
        int indicePagePrecedente = 0;
        int indiceDernierePage = 0;
        String fromParameter = this.infoBean.getString(FROM_PARAMETER);
        if (StringUtils.isNotBlank((CharSequence)fromParameter) && StringUtils.isNumeric((CharSequence)fromParameter)) {
            debutFenetre = Integer.valueOf(fromParameter);
        }
        if (results.size() > 0) {
            nbResultats = results.get(0).getTotal();
        }
        int nbTotalPages = nbResultats / nbResultatsParPage;
        if (nbResultats % nbResultatsParPage > 0) {
            ++nbTotalPages;
        }
        if (nbResultats < (finFenetre = debutFenetre + nbResultatsParPage)) {
            finFenetre = nbResultats;
        }
        if (nbResultats > finFenetre) {
            indiceDernierePage = nbTotalPages * nbResultatsParPage - nbResultatsParPage;
        }
        if (debutFenetre > 0) {
            indicePagePrecedente = debutFenetre - nbResultatsParPage;
        }
        this.infoBean.set(DEBUT_FENETRE, debutFenetre);
        this.infoBean.set(FIN_FENETRE, finFenetre);
        this.infoBean.set(INDICE_PAGE_PRECEDENTE, indicePagePrecedente);
        this.infoBean.set(INDICE_DERNIERE_PAGE, indiceDernierePage);
        this.infoBean.set(NB_TOTAL_PAGES, nbTotalPages);
        this.infoBean.set(NB_RESULTATS, nbResultats);
        this.infoBean.set(NB_RESULTATS_PAR_PAGE, nbResultatsParPage);
    }

    private List<ResultatRecherche> search(String requete) throws Exception {
        List<ResultatRecherche> listeFiches = Collections.emptyList();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        ctx.putData("requete", requete);
        ctx.putData("criteresRechAvancee", "");
        ctx.putData("modifRecherche", "&MODIFRECHERCHE=TRUE");
        ctx.setCalculListeResultatsFront(Boolean.TRUE);
        listeFiches = RechercheFicheHelper.isFullTextSearch(this.infoBean) ? RechercheUtil.traiterRecherche(ctx, requete) : RequeteUtil.traiterRequete(ctx, requete);
        ctx.setCalculListeResultatsFront(Boolean.FALSE);
        ctx.setRequete(requete.toUpperCase());
        this.infoBean.set(SEARCH_RESULTS, listeFiches);
        return listeFiches;
    }

    private String buildRequest() throws ErreurApplicative {
        InfosSite infosSite;
        if (StringUtils.isNotEmpty((CharSequence)this.infoBean.getString("SITE_RECHERCHE"))) {
            if (this.infoBean.getString("SITE_RECHERCHE").equalsIgnoreCase("TOUS")) {
                this.infoBean.set("CODE_SITE_DISTANT", this.infoBean.getString("SITE_RECHERCHE"));
                this.infoBean.set("CODE_RUBRIQUE", "");
            } else {
                infosSite = Site.renvoyerItemSite(this.infoBean.getString("SITE_RECHERCHE"));
                CibleRecherche cible = RechercheSitesDistants.getCible(this.infoBean.getString("SITE_RECHERCHE"));
                if (cible != null) {
                    this.infoBean.set("CODE_SITE_DISTANT", cible.getCode());
                } else if (infosSite != null) {
                    this.infoBean.set("CODE_RUBRIQUE", infosSite.getCodeRubrique());
                }
            }
        }
        if ("0".equals(this.infoBean.getString("SITE_CLOISONNE"))) {
            this.infoBean.set("CODE_RUBRIQUE", "");
        } else if (StringUtils.isEmpty((CharSequence)this.infoBean.getString("CODE_RUBRIQUE")) && (infosSite = this.getInfosSite()) != null && (infosSite.getRestriction() == 1 || "1".equals(this.infoBean.getString("SITE_CLOISONNE")))) {
            this.infoBean.set("CODE_RUBRIQUE", infosSite.getCodeRubrique());
        }
        try {
            if (this.infoBean.get("DATE_DEBUT") != null && this.infoBean.get("DATE_DEBUT") instanceof String) {
                Formateur.parserDate(this.infoBean.getString("DATE_DEBUT"));
            }
            if (this.infoBean.get("DATE_FIN") != null && this.infoBean.get("DATE_FIN") instanceof String) {
                Formateur.parserDate(this.infoBean.getString("DATE_FIN"));
            }
        }
        catch (Exception e) {
            throw new ErreurApplicative("Format de date incorrect");
        }
        String requete = "OBJET=" + this.infoBean.getString("OBJET");
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, QUERY, false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "CODE_SITE_DISTANT", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "SITES_DISTANTS", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "SITES_DISTANTS_EXCLUS", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "CODE_RUBRIQUE", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "DATE_DEBUT", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "DATE_FIN", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "DOCUMENT_JOINT", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "SEARCH_SOUSRUBRIQUES", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "SEARCH_EXCLUSIONOBJET", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "LANGUE_SEARCH", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "ESPACE", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, FROM_PARAMETER, false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "LANGUE", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "UNOBJET", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "PAGE", false, true);
        requete = RechercheFicheHelper.ajouterCritereRequete(this.infoBean.getValues(), requete, "TRI", false, true);
        return requete;
    }
}

