/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.textsearch.CibleRecherche;
import com.jsbsoft.jtf.textsearch.FrenchAnalyzer;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.jsbsoft.jtf.textsearch.Searcher;
import com.jsbsoft.jtf.textsearch.sitesdistants.RechercheSitesDistants;
import com.jsbsoft.jtf.textsearch.util.BooleanQueryBySite;
import com.jsbsoft.jtf.textsearch.util.SearchPropertiesHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.EscapeString;
import com.univ.utils.RequeteUtil;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RechercheUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RechercheUtil.class);

    public static Vector<ResultatRecherche> traiterRecherche(OMContext ctx, String request) throws Exception {
        Searcher searcher = Searcher.getInstance();
        if (searcher.getSearcher() == null) {
            return new Vector<ResultatRecherche>();
        }
        return new Vector<ResultatRecherche>(RechercheUtil.search(ctx, searcher, request));
    }

    public static int getTotalResultats(OMContext ctx, String request) throws Exception {
        Searcher searcher = Searcher.getInstance();
        if (searcher.getSearcher() == null) {
            return 0;
        }
        return RechercheUtil.getTotalHits(ctx, searcher, request);
    }

    private static List<ResultatRecherche> search(OMContext ctx, Searcher searcher, String request) throws Exception {
        request = EscapeString.unescapeURL(request);
        BooleanQueryBySite query = RechercheUtil.getQuery(ctx, request);
        BooleanQuery searchQuery = RechercheUtil.getSearchQuery(searcher.getAnalyzer(), request, query.getAlias());
        if (!searchQuery.clauses().isEmpty()) {
            query.add((Query)searchQuery, BooleanClause.Occur.MUST);
        }
        String tri = RequeteUtil.renvoyerParametre(request, "TRI");
        String page = RequeteUtil.renvoyerParametre(request, "PAGE");
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        boolean reverse = true;
        if (tri.startsWith("DATE")) {
            reverse = !tri.endsWith("_REV");
            sortFields.add(new SortField("meta_date_mise_en_ligne", 3, reverse));
        } else if (tri.startsWith("OBJET")) {
            reverse = tri.endsWith("_REV");
            sortFields.add(new SortField("nom_objet", 3, reverse));
        } else if (tri.startsWith("SITE")) {
            reverse = tri.endsWith("_REV");
            sortFields.add(new SortField("code_site", 3, reverse));
        } else {
            sortFields.add(SortField.FIELD_SCORE);
        }
        Sort sort = new Sort(sortFields.toArray(new SortField[sortFields.size()]));
        int nbResultatsParPage = 10000;
        int debut = 0;
        int end = 0;
        if (page == null || !page.equalsIgnoreCase("false")) {
            nbResultatsParPage = 10;
            if (PropertyHelper.getCoreProperty("recherche.nbrespage") != null) {
                try {
                    nbResultatsParPage = Integer.parseInt(PropertyHelper.getCoreProperty("recherche.nbrespage"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (RequeteUtil.renvoyerParametre(request, "FROM").length() > 0) {
                try {
                    debut = Integer.parseInt(RequeteUtil.renvoyerParametre(request, "FROM"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        end = debut + nbResultatsParPage;
        ArrayList<ResultatRecherche> listeFiches = new ArrayList<ResultatRecherche>();
        int maxResult = searcher.getSearcher().maxDoc();
        if (maxResult > 0) {
            if (PropertyHelper.getCoreProperty("recherche.nbresmax") != null) {
                try {
                    maxResult = Integer.parseInt(PropertyHelper.getCoreProperty("recherche.nbresmax"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TopFieldCollector tfc = TopFieldCollector.create((Sort)sort, (int)maxResult, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
            searcher.getSearcher().search((Query)query, (Collector)tfc);
            int totalHits = tfc.getTotalHits();
            TopDocs results = tfc.topDocs();
            float maxScore = results.getMaxScore();
            int nbHits = results.scoreDocs.length;
            LOG.debug("" + System.currentTimeMillis() + ", nb resultats : " + nbHits);
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<mark class=\"highlight\">", "</mark>");
            QueryScorer queryScorer = new QueryScorer((Query)searchQuery);
            Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)queryScorer);
            highlighter.setTextFragmenter((Fragmenter)new SimpleSpanFragmenter(queryScorer, 200));
            highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
            if (nbHits > 0) {
                if (nbHits < end) {
                    end = nbHits;
                }
                for (int i = debut; i < end; ++i) {
                    Document doc = searcher.getSearcher().doc(results.scoreDocs[i].doc);
                    ResultatRecherche resultatRecherche = new ResultatRecherche();
                    resultatRecherche.setObjet(doc.get("nom_objet"));
                    resultatRecherche.setIdFiche(doc.get("id_fiche"));
                    resultatRecherche.setLangue(doc.get("langue"));
                    resultatRecherche.setCodeRubrique(doc.get("code_rubrique"));
                    resultatRecherche.setTitre(doc.get("title"));
                    resultatRecherche.setUrl(doc.get("url"));
                    resultatRecherche.setDateModification(doc.get("date_modification"));
                    resultatRecherche.setDescription(doc.get("description"));
                    resultatRecherche.setScore(results.scoreDocs[i].score / maxScore);
                    resultatRecherche.setRank(i);
                    resultatRecherche.setTotal(nbHits);
                    resultatRecherche.setTotalHits(totalHits);
                    resultatRecherche.setHighlightedTextContent((String)StringUtils.defaultIfEmpty((CharSequence)highlighter.getBestFragment((Analyzer)searcher.getAnalyzer(), "contenu", CompressionTools.decompressString((byte[])doc.getBinaryValue("contenu"))), (CharSequence)""));
                    resultatRecherche.setHighlightedTextContentFile((String)StringUtils.defaultIfEmpty((CharSequence)highlighter.getBestFragment((Analyzer)searcher.getAnalyzer(), "contenu_fichiers", CompressionTools.decompressString((byte[])doc.getBinaryValue("contenu_fichiers"))), (CharSequence)""));
                    listeFiches.add(resultatRecherche);
                }
            }
        } else {
            LOG.warn("Aucun document dans l'index de recherche");
        }
        return listeFiches;
    }

    private static int getTotalHits(OMContext ctx, Searcher searcher, String request) throws Exception {
        request = EscapeString.unescapeURL(request);
        BooleanQueryBySite query = RechercheUtil.getQuery(ctx, request);
        query.add((Query)RechercheUtil.getSearchQuery(searcher.getAnalyzer(), request, query.getAlias()), BooleanClause.Occur.MUST);
        TopDocs top = searcher.getSearcher().search((Query)query, 10000);
        return top.totalHits;
    }

    private static BooleanQueryBySite getQuery(OMContext ctx, String request) throws Exception {
        BooleanQuery bQMode;
        String codeEspace;
        Date date;
        String objet;
        Object listeSites;
        BooleanQueryBySite query = new BooleanQueryBySite();
        int maxClauses = 2048;
        String paramMaxClauses = PropertyHelper.getCoreProperty("lucene.maxclauses");
        if (paramMaxClauses != null && paramMaxClauses.length() > 0) {
            try {
                maxClauses = Integer.parseInt(paramMaxClauses);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ContexteUniv ctxUniv = null;
        if (ctx instanceof ContexteUniv) {
            ctxUniv = (ContexteUniv)ctx;
        }
        BooleanQuery.setMaxClauseCount((int)maxClauses);
        BooleanQuery qB = new BooleanQuery();
        boolean dsiActif = "1".equals(PropertyHelper.getCoreProperty("dsi.activation"));
        String codeRubrique = RequeteUtil.renvoyerParametre(request, "CODE_RUBRIQUE");
        if (codeRubrique == null) {
            codeRubrique = "";
        }
        Boolean rechercheArborescente = Boolean.valueOf(RequeteUtil.renvoyerParametre(request, "SEARCH_SOUSRUBRIQUES"));
        String codeSiteDistant = RequeteUtil.renvoyerParametre(request, "CODE_SITE_DISTANT");
        String sitesDistants = RequeteUtil.renvoyerParametre(request, "SITES_DISTANTS");
        String sitesDistantsExclus = RequeteUtil.renvoyerParametre(request, "SITES_DISTANTS_EXCLUS");
        if ((codeSiteDistant.equals("") || codeSiteDistant.equalsIgnoreCase("TOUS")) && sitesDistants.length() == 0) {
            InfosRubriques rubrique;
            InfosSite infosSite = null;
            String codeRubriqueSite = null;
            if (ctxUniv != null && ctxUniv.isCalculListeResultatsFront() && (infosSite = ctxUniv.getInfosSite()) != null && infosSite.getRestriction() == 1) {
                codeRubriqueSite = infosSite.getCodeRubrique();
            }
            if (codeRubriqueSite != null && codeRubriqueSite.length() > 0) {
                InfosRubriques infosRub = Rubrique.renvoyerItemRubrique(codeRubrique);
                if (infosRub.getCode().length() == 0) {
                    codeRubrique = codeRubriqueSite;
                } else if (!infosSite.isRubriqueVisibleInSite(infosRub)) {
                    codeRubrique = "ZYZYZYZYZYZYZYZYZYZYZY";
                }
            }
            HashSet<InfosRubriques> listeRubriques = new HashSet<InfosRubriques>();
            if (codeRubrique.length() == 0) {
                rubrique = Rubrique.getTopLevelRubrique();
                listeRubriques.add(Rubrique.renvoyerItemRubrique(""));
            } else {
                rubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
            }
            if (dsiActif && ctxUniv != null && ctxUniv.isCalculListeResultatsFront()) {
                if (Rubrique.controlerRestrictionRubrique(ctxUniv, codeRubrique)) {
                    if (rechercheArborescente.booleanValue()) {
                        listeRubriques.addAll(Rubrique.determinerListeSousRubriquesAutorisees(ctxUniv, rubrique));
                    }
                } else {
                    rubrique = new InfosRubriques("ZYZYZYZYZYZYZYZYZYZYZY");
                }
                listeRubriques.add(rubrique);
            } else {
                if (rechercheArborescente.booleanValue()) {
                    listeRubriques.addAll(rubrique.getListeSousRubriquesTousNiveaux());
                }
                listeRubriques.add(rubrique);
            }
            RechercheSitesDistants rsd = new RechercheSitesDistants();
            listeSites = rsd.getLstCible();
            if (listeSites.size() > 0 && !"TOUS".equals(sitesDistantsExclus)) {
                Object listeSitesDistants = null;
                List<String> listeSitesDistantsExclus = null;
                if (sitesDistants.length() > 0 && !"TOUS".equals(sitesDistants)) {
                    listeSitesDistants = Arrays.asList(sitesDistants.split(";"));
                } else if (sitesDistantsExclus.length() > 0) {
                    listeSitesDistantsExclus = Arrays.asList(sitesDistantsExclus.split(";"));
                }
                Iterator iterator = listeSites.iterator();
                while (iterator.hasNext()) {
                    CibleRecherche infosSiteDistant = (CibleRecherche)iterator.next();
                    if (listeSitesDistants == null && listeSitesDistantsExclus == null) {
                        RechercheUtil.addRubriqueClause(qB, infosSiteDistant.getCode());
                        continue;
                    }
                    if (listeSitesDistants != null && listeSitesDistants.contains(infosSiteDistant.getCode())) {
                        RechercheUtil.addRubriqueClause(qB, infosSiteDistant.getCode());
                        continue;
                    }
                    if (listeSitesDistantsExclus == null || listeSitesDistantsExclus.contains(infosSiteDistant.getCode())) continue;
                    RechercheUtil.addRubriqueClause(qB, infosSiteDistant.getCode());
                }
            }
            for (InfosRubriques sousRubrique : listeRubriques) {
                RechercheUtil.addRubriqueClause(qB, sousRubrique.getCode());
            }
        } else if (!codeSiteDistant.equals("") && !codeSiteDistant.equalsIgnoreCase("TOUS")) {
            RechercheUtil.addRubriqueClause(qB, codeSiteDistant);
        }
        if (qB.getClauses().length > 0) {
            query.add((Query)qB, BooleanClause.Occur.MUST);
        }
        String alias = "";
        if (SearchPropertiesHelper.executeRechercheBySite() && StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            InfosSite infosSite = Site.determinerSiteRubrique(codeRubrique);
            alias = infosSite.getAlias();
        }
        AbstractList listeObjetsExclus = new ArrayList();
        String chaineObjetsExclus = RequeteUtil.renvoyerParametre(request, "SEARCH_EXCLUSIONOBJET");
        if (chaineObjetsExclus.length() > 0) {
            listeObjetsExclus = Chaine.getVecteurPointsVirgules(chaineObjetsExclus.replaceAll(" ", ";"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(objet = RequeteUtil.renvoyerParametre(request, "OBJET"))) && !objet.equals("TOUS")) {
            if (!listeObjetsExclus.contains(objet)) {
                query.add((Query)new TermQuery(new Term("nom_objet", objet.toLowerCase())), BooleanClause.Occur.MUST);
            }
        } else if (listeObjetsExclus.size() > 0 || SearchPropertiesHelper.hasBoostParObjet(alias)) {
            if (SearchPropertiesHelper.executeRechercheBySite() || SearchPropertiesHelper.hasBoostParObjet(alias)) {
                ArrayList<String> listeObjets = new ArrayList<String>();
                listeObjets.addAll(ReferentielObjets.getReferentiel().getCodesObjetsTries());
                listeSites = listeObjets.iterator();
                while (listeSites.hasNext()) {
                    String codeObjet = (String)listeSites.next();
                    String nomObjet = ReferentielObjets.getNomObjet(codeObjet);
                    if (listeObjetsExclus.contains(nomObjet)) continue;
                    TermQuery tq = new TermQuery(new Term("nom_objet", nomObjet.toLowerCase()));
                    tq.setBoost((float)SearchPropertiesHelper.getBoostParObjet(alias, nomObjet) * 1.0f);
                    query.add((Query)tq, BooleanClause.Occur.SHOULD);
                }
            } else {
                for (String nomObjet : listeObjetsExclus) {
                    query.add((Query)new TermQuery(new Term("nom_objet", nomObjet.toLowerCase())), BooleanClause.Occur.MUST_NOT);
                }
            }
        }
        boolean controlerDate = false;
        String dateDebut = "19700101";
        String dateFin = "20990101";
        String dateRequete = RequeteUtil.renvoyerParametre(request, "DATE_DEBUT");
        if (dateRequete.length() > 0) {
            date = Formateur.parserDate(dateRequete);
            dateDebut = new SimpleDateFormat("yyyyMMdd").format(date);
            controlerDate = true;
        }
        if ((dateRequete = RequeteUtil.renvoyerParametre(request, "DATE_FIN")).length() > 0) {
            date = Formateur.parserDate(dateRequete);
            dateFin = new SimpleDateFormat("yyyyMMdd").format(date);
            controlerDate = true;
        }
        String langue = RequeteUtil.renvoyerParametre(request, "LANGUE_SEARCH");
        query.add((Query)new TermQuery(new Term("etat_objet", "0003")), BooleanClause.Occur.MUST);
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            query.add((Query)new TermQuery(new Term("langue", langue)), BooleanClause.Occur.MUST);
        }
        if (controlerDate) {
            TermRangeQuery qD = new TermRangeQuery("date_modification", dateDebut, dateFin, true, true);
            query.add((Query)qD, BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotEmpty((CharSequence)(codeEspace = RequeteUtil.renvoyerParametre(request, "ESPACE")))) {
            bQMode = new BooleanQuery();
            bQMode.add((Query)new TermQuery(new Term("mode_restriction", "4")), BooleanClause.Occur.MUST);
            bQMode.add((Query)new WildcardQuery(new Term("public_vise_restriction", "*;" + codeEspace + ";*")), BooleanClause.Occur.MUST);
            query.add((Query)bQMode, BooleanClause.Occur.MUST);
        } else if (dsiActif && ctxUniv != null && ctxUniv.isCalculListeResultatsFront()) {
            bQMode = new BooleanQuery();
            bQMode.add((Query)new TermQuery(new Term("mode_restriction", "0")), BooleanClause.Occur.SHOULD);
            if (ctxUniv.getKsession().length() > 0) {
                TreeSet<String> groupes = new TreeSet<String>();
                for (String groupeCourant : ctxUniv.getGroupesDsi()) {
                    groupes.add(groupeCourant);
                    InfosGroupeDsi infoGroupe = Groupedsi.renvoyerItemGroupeDsi(groupeCourant);
                    int niveauItemCourant = infoGroupe.getNiveau();
                    String codeGroupe = "";
                    for (int niveau = niveauItemCourant - 1; niveau > 0; --niveau) {
                        codeGroupe = infoGroupe.getCodeGroupePere();
                        groupes.add(codeGroupe);
                        infoGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
                    }
                }
                if (groupes.size() > 0) {
                    BooleanQuery bQMode2 = new BooleanQuery();
                    bQMode2.add((Query)new TermQuery(new Term("mode_restriction", "2")), BooleanClause.Occur.MUST);
                    BooleanQuery bQMode3 = new BooleanQuery();
                    bQMode3.add((Query)new TermQuery(new Term("mode_restriction", "3")), BooleanClause.Occur.MUST);
                    BooleanQuery bQPublicVise = new BooleanQuery();
                    BooleanQuery bQPublicViseR = new BooleanQuery();
                    Iterator i = groupes.iterator();
                    String groupe = "";
                    while (i.hasNext()) {
                        groupe = (String)i.next();
                        bQPublicVise.add((Query)new WildcardQuery(new Term("public_vise", "*;/" + groupe + ";*")), BooleanClause.Occur.SHOULD);
                        bQPublicViseR.add((Query)new WildcardQuery(new Term("public_vise_restriction", "*;/" + groupe + ";*")), BooleanClause.Occur.SHOULD);
                    }
                    bQMode2.add((Query)bQPublicVise, BooleanClause.Occur.MUST);
                    bQMode3.add((Query)bQPublicViseR, BooleanClause.Occur.MUST);
                    bQMode.add((Query)bQMode2, BooleanClause.Occur.SHOULD);
                    bQMode.add((Query)bQMode3, BooleanClause.Occur.SHOULD);
                }
                TreeSet<String> espacesUtilisateur = new TreeSet<String>();
                if (Espacecollaboratif.isExtensionActivated()) {
                    Collection<InfosEspaceCollaboratif> listeEspaces = Espacecollaboratif.getListeEspaces();
                    for (InfosEspaceCollaboratif espace : listeEspaces) {
                        if (!Espacecollaboratif.estMembreEspace(ctxUniv, espace)) continue;
                        espacesUtilisateur.add(espace.getCode());
                    }
                }
                if (espacesUtilisateur.size() > 0) {
                    BooleanQuery bQMode4 = new BooleanQuery();
                    bQMode4.add((Query)new TermQuery(new Term("mode_restriction", "4")), BooleanClause.Occur.MUST);
                    BooleanQuery bQEspaces = new BooleanQuery();
                    for (String espaceCourant : espacesUtilisateur) {
                        bQEspaces.add((Query)new WildcardQuery(new Term("public_vise_restriction", "*;" + espaceCourant + ";*")), BooleanClause.Occur.SHOULD);
                    }
                    bQMode4.add((Query)bQEspaces, BooleanClause.Occur.MUST);
                    bQMode.add((Query)bQMode4, BooleanClause.Occur.SHOULD);
                }
            }
            if (bQMode.getClauses().length > 0) {
                query.add((Query)bQMode, BooleanClause.Occur.MUST);
            }
        }
        if (ctxUniv != null && ctxUniv.isCalculListeResultatsFront()) {
            BooleanQuery dateQuery = new BooleanQuery();
            GregorianCalendar gc = new GregorianCalendar();
            String upper = new SimpleDateFormat("yyyyMMdd").format(new Date(gc.getTimeInMillis()));
            String lower = null;
            for (int boost = SearchPropertiesHelper.getBoostDate(); boost > 1; --boost) {
                gc.set(1, gc.get(1) - 1);
                lower = new SimpleDateFormat("yyyyMMdd").format(new Date(gc.getTimeInMillis()));
                TermRangeQuery rQ = new TermRangeQuery("meta_date_mise_en_ligne", lower, upper, false, true);
                rQ.setBoost((float)boost * 10000.0f);
                dateQuery.add((Query)rQ, BooleanClause.Occur.SHOULD);
                upper = lower;
            }
            TermRangeQuery rQ = new TermRangeQuery("meta_date_mise_en_ligne", null, upper, false, true);
            dateQuery.add((Query)rQ, BooleanClause.Occur.SHOULD);
            query.add((Query)dateQuery, BooleanClause.Occur.MUST);
        }
        BooleanClause[] bc = query.getClauses();
        LOG.debug("d\u00e9tail de la requete:");
        LOG.debug(query.toString());
        for (BooleanClause element : bc) {
            LOG.debug(element.getQuery().toString() + ", obligatoire : " + element.isRequired() + ", interdit :" + element.isProhibited());
        }
        if (StringUtils.isNotEmpty((CharSequence)alias)) {
            query.setAlias(alias);
        }
        return query;
    }

    private static BooleanQuery getSearchQuery(FrenchAnalyzer analyzer, String request, String alias) throws ParseException {
        Query q;
        String sQuery = RequeteUtil.renvoyerParametre(request, "QUERY");
        String documentJoints = RequeteUtil.renvoyerParametre(request, "DOCUMENT_JOINT");
        String[] parsers = null;
        parsers = documentJoints.equals("1") ? new String[]{"title", "description", "keywords", "contenu", "contenu_fichiers"} : new String[]{"title", "description", "keywords", "contenu"};
        HashMap boosts = new HashMap();
        MultiFieldQueryParser objParser = new MultiFieldQueryParser(Version.LUCENE_36, parsers, (Analyzer)analyzer, boosts);
        BooleanQuery searchQuery = new BooleanQuery();
        BooleanQuery searchSousQuery = new BooleanQuery();
        if (StringUtils.isEmpty((CharSequence)sQuery) && Boolean.valueOf(RequeteUtil.renvoyerParametre(request, "SEARCH_EMPTYQUERY")).booleanValue()) {
            return searchQuery;
        }
        String sQuery1 = "";
        String sQuery2 = "";
        String sQuery3 = "";
        String sQuery4 = "";
        String sQuery5 = "";
        String s = "\\s*((([^\"\\[\\]\\s]+))|(\\\"([^\"]+)\\\"))\\s*";
        Pattern p = Pattern.compile("\\s*((([^\"\\[\\]\\s]+))|(\\\"([^\"]+)\\\"))\\s*");
        Matcher m = p.matcher(sQuery);
        boolean googleLike = false;
        while (m.find()) {
            String word = m.group(1);
            if (word.length() <= 1 && !StringUtils.isNumeric((CharSequence)word)) continue;
            if (!word.startsWith("\"") || !word.endsWith("\"")) {
                if (sQuery1.length() > 0) {
                    sQuery1 = sQuery1 + " ";
                }
                if (word.startsWith("-") || word.startsWith("+")) {
                    sQuery1 = sQuery1 + word.substring(0, 1) + RechercheUtil.escape(word.substring(1));
                    googleLike = true;
                    continue;
                }
                if (word.equalsIgnoreCase("OR") || word.equalsIgnoreCase("AND")) {
                    if (!m.find()) continue;
                    sQuery1 = sQuery1 + word.toUpperCase() + " " + RechercheUtil.escape(m.group(1));
                    googleLike = true;
                    continue;
                }
                sQuery1 = sQuery1 + RechercheUtil.escape(word);
                if (analyzer.getStoptable().contains(word)) continue;
                if (sQuery2.length() > 0) {
                    sQuery2 = sQuery2 + " AND ";
                    sQuery3 = sQuery3 + " OR ";
                }
                sQuery2 = sQuery2 + RechercheUtil.escape(word);
                sQuery3 = sQuery3 + RechercheUtil.escape(word);
                if (word.length() <= 2) continue;
                if (sQuery4.length() > 0) {
                    sQuery4 = sQuery4 + " AND ";
                    sQuery5 = sQuery5 + " OR ";
                }
                sQuery4 = sQuery4 + Chaine.supprimerISOLatin1Accent(RechercheUtil.escape(word)) + "*";
                sQuery5 = sQuery5 + Chaine.supprimerISOLatin1Accent(RechercheUtil.escape(word)) + "*";
                continue;
            }
            Query q2 = objParser.parse(RechercheUtil.escape(word));
            q2.setBoost(2.0f);
            searchQuery.add(q2, BooleanClause.Occur.MUST);
        }
        if (!googleLike) {
            if (sQuery1.length() > 0) {
                q = objParser.parse("\"" + sQuery1 + "\"");
                q.setBoost((float)SearchPropertiesHelper.getBoostRecherchePhrase(alias) * 1.0f);
                searchSousQuery.add(q, BooleanClause.Occur.SHOULD);
            }
            if (sQuery2.length() > 0) {
                q = objParser.parse(sQuery2);
                q.setBoost((float)SearchPropertiesHelper.getBoostRechercheAND(alias) * 1.0f);
                searchSousQuery.add(q, BooleanClause.Occur.SHOULD);
                if (SearchPropertiesHelper.executeRechercheOR(alias)) {
                    q = objParser.parse(sQuery3);
                    q.setBoost((float)SearchPropertiesHelper.getBoostRechercheOR(alias) * 1.0f);
                    searchSousQuery.add(q, BooleanClause.Occur.SHOULD);
                }
                if (SearchPropertiesHelper.executeRechercheLIKE(alias) && sQuery4.length() > 0) {
                    q = objParser.parse(sQuery4);
                    q.setBoost((float)SearchPropertiesHelper.getBoostRechercheLIKE(alias) * 1.0f);
                    searchSousQuery.add(q, BooleanClause.Occur.SHOULD);
                    q = objParser.parse(sQuery5);
                    q.setBoost((float)SearchPropertiesHelper.getBoostRechercheLIKE(alias) * 1.0f);
                    searchSousQuery.add(q, BooleanClause.Occur.SHOULD);
                }
                if (searchSousQuery.getClauses().length > 0) {
                    searchQuery.add((Query)searchSousQuery, BooleanClause.Occur.MUST);
                }
            }
        } else if (sQuery1.length() > 0) {
            q = objParser.parse(sQuery1);
            searchQuery.add(q, BooleanClause.Occur.MUST);
        }
        return searchQuery;
    }

    private static void addRubriqueClause(BooleanQuery query, String codeRubrique) {
        query.add((Query)new TermQuery(new Term("code_rubrique", codeRubrique)), BooleanClause.Occur.SHOULD);
    }

    private static String escape(String word) {
        int lg = word.length();
        StringBuilder sb = new StringBuilder(lg);
        for (int i = 0; i < lg; ++i) {
            char c = word.charAt(i);
            if (c == '+' || c == '-' || c == '&' || c == '|' || c == '!' || c == '\\' || c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '^' || c == '~' || c == '*' || c == '?' || c == ':' || c == '%') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

