/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.SSOBean;
import com.univ.objetspartages.om.SousParagrapheBean;
import com.univ.utils.ContexteUniv;
import com.univ.xml.NodeUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequeteConnecteur {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequeteConnecteur.class);

    public static void parseFlux(ContexteUniv ctx) throws Exception {
        String rubriqueExterneConnecteur = "";
        ArrayList<SousParagrapheBean> encadresExternes = new ArrayList<SousParagrapheBean>();
        ArrayList<String> encadresRechercheExternes = new ArrayList<String>();
        HashMap<String, String> donneesSpecifiques = new HashMap<String, String>();
        String langue = "";
        String graphBean = ctx.getRequeteHTTP().getParameter("graphbean");
        LOGGER.debug("graphbean = " + graphBean);
        if (graphBean == null) {
            return;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(graphBean.getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document = null;
        Node rootElement = null;
        try {
            builder = factory.newDocumentBuilder();
            document = builder.parse(is);
            rootElement = document.getDocumentElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Node donnees = rootElement; donnees != null; donnees = donnees.getNextSibling()) {
            if (!donnees.hasChildNodes()) continue;
            for (Node requete = donnees.getFirstChild(); requete != null; requete = requete.getNextSibling()) {
                if (requete.getNodeName().compareTo("RUBRIQUE") == 0 && requete.getFirstChild() != null) {
                    rubriqueExterneConnecteur = requete.getFirstChild().getNodeValue().trim();
                }
                if (requete.getNodeName().compareTo("LANGUE") == 0 && requete.getFirstChild() != null) {
                    langue = requete.getFirstChild().getNodeValue().trim();
                }
                if (requete.getNodeName().equals("SECURE") && requete.getFirstChild() != null) {
                    ctx.setSecure(requete.getFirstChild().getNodeValue().trim().equals("1"));
                }
                if (requete.getNodeName().compareTo("LISTE_ENCADRES") == 0) {
                    for (Node listeEncadres = requete.getFirstChild(); listeEncadres != null; listeEncadres = listeEncadres.getNextSibling()) {
                        if (listeEncadres.getNodeName().compareTo("ENCADRE") != 0) continue;
                        SousParagrapheBean encadre = new SousParagrapheBean();
                        for (Node nodeEncadre = listeEncadres.getFirstChild(); nodeEncadre != null; nodeEncadre = nodeEncadre.getNextSibling()) {
                            if (nodeEncadre.getNodeName().compareTo("TITRE") == 0) {
                                encadre.setTitre(nodeEncadre.getFirstChild().getNodeValue().trim());
                            }
                            if (nodeEncadre.getNodeName().compareTo("CONTENU") != 0) continue;
                            encadre.setContenu(nodeEncadre.getFirstChild().getNodeValue().trim());
                        }
                        encadresExternes.add(encadre);
                    }
                }
                if (requete.getNodeName().compareTo("DONNEES_SPECIFIQUES") == 0) {
                    for (Node listeDonnees = requete.getFirstChild(); listeDonnees != null; listeDonnees = listeDonnees.getNextSibling()) {
                        if (listeDonnees.getNodeName().compareTo("DONNEE") != 0) continue;
                        String nom = "";
                        String valeur = "";
                        for (Node nodeDonnees = listeDonnees.getFirstChild(); nodeDonnees != null; nodeDonnees = nodeDonnees.getNextSibling()) {
                            if (nodeDonnees.getNodeName().compareTo("NOM") == 0) {
                                nom = nodeDonnees.getFirstChild().getNodeValue().trim();
                            }
                            if (nodeDonnees.getNodeName().compareTo("VALEUR") != 0) continue;
                            valeur = nodeDonnees.getFirstChild().getNodeValue().trim();
                        }
                        if (nom.length() <= 0) continue;
                        donneesSpecifiques.put(nom, valeur);
                    }
                }
                if (requete.getNodeName().compareTo("LISTE_ENCADRES_RECHERCHE") != 0) continue;
                for (Node listeEncadresRecherche = requete.getFirstChild(); listeEncadresRecherche != null; listeEncadresRecherche = listeEncadresRecherche.getNextSibling()) {
                    if (listeEncadresRecherche.getFirstChild() == null) continue;
                    encadresRechercheExternes.add(listeEncadresRecherche.getFirstChild().getNodeValue().trim());
                }
            }
        }
        ctx.setRubriqueExterneConnecteur(rubriqueExterneConnecteur);
        ctx.setEncadresExternes(encadresExternes);
        ctx.setEncadresRechercheExternes(encadresRechercheExternes);
        ctx.setDonneesSpecifiques(donneesSpecifiques);
        if (langue.length() > 0) {
            ctx.setLangue(langue);
        }
    }

    public static SSOBean lireBeanSSO(String _ksession) throws Exception {
        SSOBean ssoBean = new SSOBean();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = null;
        File f = new File(WebAppUtil.getSessionsPath() + File.separator + "session_" + _ksession + ".xml");
        if (!f.exists()) {
            return ssoBean;
        }
        document = builder.parse(f);
        Element rootElement = document.getDocumentElement();
        Element donnees = rootElement;
        if (donnees.hasChildNodes()) {
            for (Node nextFeuille = donnees.getFirstChild(); nextFeuille != null; nextFeuille = nextFeuille.getNextSibling()) {
                if (nextFeuille.getNodeName().equals("ID")) {
                    ssoBean.setId(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("CODE")) {
                    ssoBean.setCodeKportal(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("CIVILITE")) {
                    ssoBean.setCivilite(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("NOM")) {
                    ssoBean.setNom(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("PRENOM")) {
                    ssoBean.setPrenom(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("EMAIL")) {
                    ssoBean.setEmail(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("STRUCTURE")) {
                    ssoBean.setStructure(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("CODE_LDAP")) {
                    ssoBean.setCodeGestion(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (nextFeuille.getNodeName().equals("PROFIL")) {
                    ssoBean.setProfil(NodeUtil.extraireValeurNode(nextFeuille));
                }
                if (!nextFeuille.getNodeName().equals("GROUPES")) continue;
                ssoBean.setGroupes(NodeUtil.extraireValeurNode(nextFeuille));
            }
        }
        return ssoBean;
    }
}

