/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.kportal.extension.module.plugin.objetspartages.IPluginRecherche;
import com.kportal.extension.module.plugin.objetspartages.PluginRechercheHelper;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.EscapeString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequeteUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RequeteUtil.class);

    @Deprecated
    public static FicheUniv lireFiche(OMContext _ctx, ResultatRecherche resultat) throws Exception {
        return RequeteUtil.lireFiche(resultat);
    }

    public static FicheUniv lireFiche(ResultatRecherche resultat) {
        String objet = resultat.getObjet();
        String idFiche = resultat.getIdFiche();
        if (StringUtils.isEmpty((CharSequence)objet) || StringUtils.isEmpty((CharSequence)idFiche)) {
            return null;
        }
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(objet);
        if (ficheUniv == null) {
            return null;
        }
        ficheUniv.init();
        try (ContexteDao ctx = new ContexteDao();){
            ficheUniv.setCtx(ctx);
            ficheUniv.setIdFiche(Long.valueOf(idFiche));
            ficheUniv.retrieve();
        }
        catch (Exception e) {
            LOG.warn("Fiche inexistante id = " + idFiche, (Throwable)e);
            ficheUniv = null;
        }
        return ficheUniv;
    }

    @Deprecated
    public static FicheUniv lireFiche(OMContext ctx, String descriptionFiche) throws Exception {
        return RequeteUtil.lireFiche(descriptionFiche);
    }

    @Deprecated
    public static FicheUniv lireFiche(String descriptionFiche) {
        FicheUniv ficheUniv = null;
        String objet = "";
        String idFiche = "";
        int indiceToken = 0;
        StringTokenizer st = new StringTokenizer(descriptionFiche, ";");
        while (st.hasMoreTokens()) {
            if (indiceToken == 0) {
                objet = st.nextToken();
            } else if (indiceToken == 1) {
                idFiche = st.nextToken();
            } else {
                st.nextToken();
            }
            ++indiceToken;
        }
        if (objet.length() == 0 || idFiche.length() == 0) {
            return ficheUniv;
        }
        ficheUniv = ReferentielObjets.instancierFiche(objet);
        ficheUniv.init();
        try (ContexteDao ctx = new ContexteDao();){
            ficheUniv.setCtx(ctx);
            ficheUniv.setIdFiche(Long.valueOf(idFiche));
            ficheUniv.retrieve();
        }
        catch (Exception e) {
            LOG.warn("Fiche inexistante id = " + idFiche, (Throwable)e);
            ficheUniv = null;
        }
        return ficheUniv;
    }

    public static String renvoyerParametre(String requete, String nomParametre) {
        return RequeteUtil.renvoyerParametre(requete, nomParametre, false);
    }

    public static String renvoyerParametre(String requete, String nomParametre, boolean toUpperCase) {
        String res = "";
        if (requete != null) {
            String chaineARechercher = nomParametre.toUpperCase() + "=";
            StringTokenizer st = new StringTokenizer(requete, "&");
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                if (!val.toUpperCase().startsWith(chaineARechercher)) continue;
                if (chaineARechercher.length() < val.length()) {
                    res = val.substring(chaineARechercher.length());
                    if (!toUpperCase) continue;
                    res = res.toUpperCase();
                    continue;
                }
                res = "";
            }
        }
        return res;
    }

    @Deprecated
    public static Vector traiterRequete(OMContext ctx, String requete, boolean renvoyerResultat) throws Exception {
        Vector<Object> resultats = new Vector();
        List<ResultatRecherche> res = RequeteUtil.traiterRequete(ctx, requete);
        if (renvoyerResultat) {
            resultats = new Vector<ResultatRecherche>(res);
        } else {
            for (ResultatRecherche resultatRecherche : res) {
                resultats.add(resultatRecherche.getObjet() + ";" + resultatRecherche.getIdFiche());
            }
        }
        return resultats;
    }

    public static List<ResultatRecherche> traiterRequete(OMContext ctx, String requete) throws Exception {
        requete = StringUtils.replace((String)requete, (String)"+", (String)"%2B");
        requete = EscapeString.unescapeURL(requete);
        List<ResultatRecherche> res = new ArrayList<ResultatRecherche>();
        LOG.debug("requete (traiterRequete) :" + requete);
        String REQUETE = requete.toUpperCase();
        String objet = RequeteUtil.renvoyerParametre(REQUETE, "OBJET");
        if (objet.length() > 0) {
            ctx.getDatas().put("optimizedSelect", "1");
            IPluginRecherche pluginRequete = PluginRechercheHelper.getPluginActif(REQUETE);
            if (pluginRequete != null) {
                requete = pluginRequete.preparerRequete(ctx, requete);
            }
            if (StringUtils.isNotEmpty((CharSequence)requete)) {
                FicheUniv ficheUniv;
                boolean annuleCritereNombre = pluginRequete != null && pluginRequete.annuleCritereNombre(REQUETE);
                int limit = -1;
                int idxDebNb = requete.indexOf("NOMBRE=");
                if (annuleCritereNombre && idxDebNb != -1) {
                    try {
                        limit = Integer.parseInt(RequeteUtil.renvoyerParametre(requete, "NOMBRE"));
                        int idxFinNb = requete.indexOf("&", idxDebNb + 1);
                        if (idxFinNb == -1) {
                            idxFinNb = requete.length() - 1;
                        }
                        requete = requete.substring(0, idxDebNb) + requete.substring(idxFinNb + 1);
                    }
                    catch (Exception idxFinNb) {
                        // empty catch block
                    }
                }
                if (ctx instanceof ContexteUniv) {
                    String groupeDsi = RequeteUtil.renvoyerParametre(requete, "GROUPE_DSI").replaceAll("@", ",");
                    String profilDsi = RequeteUtil.renvoyerParametre(requete, "PROFIL_DSI");
                    if (profilDsi.equals("DYNAMIK")) {
                        groupeDsi = profilDsi;
                    } else {
                        InfosProfilDsi infosProfilDsi = Profildsi.renvoyerItemProfilDsi(profilDsi);
                        if (infosProfilDsi.getGroupes().size() > 0) {
                            Iterator<String> it = infosProfilDsi.getGroupes().iterator();
                            while (it.hasNext()) {
                                if (groupeDsi.length() > 0) {
                                    groupeDsi = groupeDsi + ";";
                                }
                                groupeDsi = groupeDsi + it.next();
                            }
                        }
                    }
                    ((ContexteUniv)ctx).setGroupePersonnalisationCourant(groupeDsi);
                    String espace = RequeteUtil.renvoyerParametre(requete, "ESPACE");
                    ((ContexteUniv)ctx).setEspacePersonnalisationCourant(espace);
                }
                long debutRequete = System.currentTimeMillis();
                if (!(pluginRequete != null && pluginRequete.isExclusif() || (ficheUniv = ReferentielObjets.instancierFiche(objet)) == null)) {
                    ficheUniv.setCtx(ctx);
                    ficheUniv.init();
                    ficheUniv.traiterRequete(requete);
                    if (ctx.getDatas().get("optimizedLimit") != null) {
                        limit = Integer.parseInt((String)ctx.getDatas().get("optimizedLimit"));
                    }
                    TreeSet<Long> tListeFiches = new TreeSet<Long>();
                    while (ficheUniv.nextItem() && (limit == -1 || tListeFiches.size() < limit)) {
                        if (tListeFiches.contains(ficheUniv.getIdFiche())) continue;
                        tListeFiches.add(ficheUniv.getIdFiche());
                        ResultatRecherche resultat = new ResultatRecherche();
                        resultat.setObjet(objet);
                        resultat.setIdFiche(String.valueOf(ficheUniv.getIdFiche()));
                        res.add(resultat);
                    }
                }
                if (pluginRequete != null) {
                    res = pluginRequete.traiterRequete(ctx, requete, res);
                }
                long finRequete = System.currentTimeMillis();
                LOG.debug("Dur\u00e9e requ\u00eate : " + (finRequete - debutRequete) + " ms.");
            }
            if (res.size() > 0) {
                ((ResultatRecherche)res.get(0)).setTotal(res.size());
            }
        }
        ctx.getDatas().remove("optimizedSelect");
        ctx.getDatas().remove("optimizedLimit");
        ctx.getDatas().remove("optimizedObject");
        if (ctx instanceof ContexteUniv) {
            ((ContexteUniv)ctx).setGroupePersonnalisationCourant("");
            ((ContexteUniv)ctx).setEspacePersonnalisationCourant("");
        }
        return res;
    }

    @Deprecated
    public static void initialiserRequete(OMContext ctx) {
        ctx.getDatas().put("optimizedSelect", "1");
    }

    @Deprecated
    public static List<ResultatRecherche> finaliserRequete(OMContext ctx, List<ResultatRecherche> res) {
        if (res.size() > 0) {
            res.get(0).setTotal(res.size());
        }
        ctx.getDatas().remove("optimizedSelect");
        ctx.getDatas().remove("optimizedLimit");
        ctx.getDatas().remove("optimizedObject");
        if (ctx instanceof ContexteUniv) {
            ((ContexteUniv)ctx).setGroupePersonnalisationCourant("");
            ((ContexteUniv)ctx).setEspacePersonnalisationCourant("");
        }
        return res;
    }

    @Deprecated
    public static String renvoyerListeParametresRenseignesRequete(String requete) {
        String res = "";
        StringTokenizer st = new StringTokenizer(requete.toUpperCase(), "&");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            String partieGauche = val.substring(0, val.indexOf("="));
            String partieDroite = val.substring(val.indexOf("=") + 1);
            partieDroite = StringUtils.replace((String)partieDroite, (String)"%20", (String)" ");
            partieDroite = StringUtils.replace((String)partieDroite, (String)"'", (String)"");
            if (partieGauche.equals("OBJET") || partieDroite.length() <= 0 || partieDroite.compareTo("A") <= 0) continue;
            if (res.length() > 0) {
                res = res + ", ";
            }
            res = res + partieDroite;
        }
        return res;
    }
}

