/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.AbstractRequeteur;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ClauseJoinHelper;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RequeteurFiches
extends AbstractRequeteur {
    public RequeteurFiches() {
    }

    public RequeteurFiches(InfoBean infoBean) {
        super(infoBean);
    }

    public RequeteurFiches(String mode, String selection, String pagination, String lien, String requete) {
        super(mode, selection, pagination, lien, "0", requete);
    }

    @Deprecated
    public RequeteurFiches(String mode, String selection, String pagination, String lien, String dossier, String requete) {
        super(mode, selection, pagination, lien, dossier, requete);
    }

    public static int getNombreFichesCollaboratives(OMContext _ctx, String _codeObjet, String _etatObjet, String _codeEspace) throws Exception {
        RequeteurFiches requeteur = new RequeteurFiches();
        TreeMap<String, Object> listeMeta = requeteur.select(_codeObjet, _etatObjet, "", "", "", "", "", "", new Date(0L), new Date(0L), "", "4", _codeEspace, "", "", 0, 0, "", "3");
        return (Integer)listeMeta.get("100000");
    }

    public static int getNombreFiches(OMContext _ctx, String _codeObjet, String _etatObjet) throws Exception {
        RequeteurFiches requeteur = new RequeteurFiches();
        TreeMap<String, Object> listeMeta = requeteur.select(_codeObjet, _etatObjet, "", "", "", "", "", "", new Date(0L), new Date(0L), "", "", "", "", "", 0, 0, "", "3");
        return (Integer)listeMeta.get("100000");
    }

    public static TreeMap<String, FicheUniv> getListeFichesUtilisateur(OMContext _ctx, String _codeObjet, String _codeRedacteur) throws Exception {
        RequeteurFiches requeteur = new RequeteurFiches();
        TreeMap<String, FicheUniv> result = new TreeMap<String, FicheUniv>();
        int compteur = 0;
        TreeMap<String, Object> listeMeta = requeteur.select(_codeObjet, "0003", "", _codeRedacteur, "", "", "", "", new Date(0L), new Date(0L), "", "", "", "", "META_DATE_MODIFICATION DESC, META_CODE_OBJET, META_LIBELLE_FICHE", 0, 0, "", "1");
        Iterator<String> it = listeMeta.keySet().iterator();
        while (it.hasNext()) {
            MetatagBean bean = (MetatagBean)listeMeta.get(it.next());
            Long idFiche = bean.getMetaIdFiche();
            String codeObjet = bean.getMetaCodeObjet();
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(codeObjet));
            if (ficheUniv == null) continue;
            ficheUniv.init();
            ficheUniv.setCtx(_ctx);
            ficheUniv.setIdFiche(idFiche);
            try {
                ficheUniv.retrieve();
                result.put("" + compteur++, ficheUniv);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public TreeMap<String, Object> select(String typeObjet, String etatObjet, String libelle, String codeRedacteur, String codeValidation, String codeRattachement, String codeRubrique, String typeDate, Date dateDebut, Date dateFin, String diffusionPublicVise, String diffusionModeRestriction, String diffusionPublicViseRestriction, String langue, String orderBy, int from, int increment, String mode, String count) throws Exception {
        ContexteUniv ctxUniv = ContexteUtil.getContexteUniv();
        TreeMap<String, Object> hashResultat = new TreeMap();
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = RequeteurFiches.construireClauseWhere(ctxUniv, typeObjet, etatObjet, libelle, codeRedacteur, codeValidation, codeRattachement, codeRubrique, typeDate, dateDebut, dateFin, diffusionPublicVise, diffusionModeRestriction, diffusionPublicViseRestriction, langue, mode);
        requeteSelect.where(where);
        ClauseOrderBy clauseOrderBy = OrderByHelper.reconstruireClauseOrderBy(orderBy);
        requeteSelect.orderBy(clauseOrderBy);
        requeteSelect.setJointures(RequeteurFiches.traiterJointureRequeteGenerique(where, clauseOrderBy));
        Metatag meta = new Metatag();
        meta.init();
        meta.setCtx(ctxUniv);
        if (!count.equals("3")) {
            hashResultat = RequeteurFiches.executerRequete(requeteSelect, from, increment, meta);
        }
        if (count.equals("3") || count.equals("2")) {
            int total = meta.selectCount(requeteSelect.formaterRequete());
            hashResultat.put(String.valueOf(100000), total);
        }
        return hashResultat;
    }

    public static ClauseWhere construireClauseWhere(ContexteUniv ctxUniv, String typeObjet, String etatObjet, String libelle, String codeRedacteur, String codeValidation, String codeRattachement, String codeRubrique, String typeDate, Date dateDebut, Date dateFin, String diffusionPublicVise, String diffusionModeRestriction, String diffusionPublicViseRestriction, String langue, String mode) throws Exception {
        Set<InfosGroupeDsi> listeGroupes;
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("T1.META_ETAT_OBJET", etatObjet));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.like("T1.META_LIBELLE_FICHE", libelle, "%", "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(RequeteurFiches.traiterCodeRedacteur(codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeValidation)) {
            where.and(ConditionHelper.egalVarchar("T1.META_CODE_VALIDATION", codeValidation));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar("T1.META_LANGUE", langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            ConditionList conditionStructure = new ConditionList(ConditionHelper.getConditionStructure("T1.META_CODE_RATTACHEMENT", codeRattachement));
            conditionStructure.or(ConditionHelper.getConditionStructureMultiple("T1.META_CODE_RATTACHEMENT", codeRattachement));
            where.and(conditionStructure);
        }
        if (StringUtils.isNotEmpty((CharSequence)diffusionPublicVise)) {
            listeGroupes = RequeteurFiches.determinerListeGroupeDiffusion(diffusionPublicVise);
            where.and(RequeteurFiches.traiterDiffusionPublicVise(listeGroupes));
        }
        if (RequeteurFiches.isDiffusionModeRestriction(diffusionModeRestriction)) {
            where.and(ConditionHelper.egalVarchar("T1.META_DIFFUSION_MODE_RESTRICTION", diffusionModeRestriction));
        } else if (StringUtils.isEmpty((CharSequence)diffusionModeRestriction)) {
            where.and(ConditionHelper.notEgal("T1.META_DIFFUSION_MODE_RESTRICTION", "4", TypeOperande.VARCHAR));
        }
        if (StringUtils.isNotEmpty((CharSequence)diffusionPublicViseRestriction)) {
            if ("4".equals(diffusionModeRestriction)) {
                where.and(ConditionHelper.egalVarchar("T1.META_DIFFUSION_PUBLIC_VISE_RESTRICTION", diffusionPublicViseRestriction));
            } else {
                listeGroupes = RequeteurFiches.determinerListeGroupeDiffusion(diffusionPublicViseRestriction);
                where.and(RequeteurFiches.traiterDiffusionPublicViseRestriction(listeGroupes));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)typeDate)) {
            where.and(RequeteurFiches.traiterTypeDate(typeDate, dateDebut, dateFin));
        }
        where.and(RequeteurFiches.traiterCritereGeneriques(ctxUniv, mode, typeObjet, codeRattachement, codeRubrique, diffusionPublicVise, diffusionModeRestriction, diffusionPublicViseRestriction));
        return where;
    }

    private static ConditionList traiterCodeRedacteur(String codesRedacteurs) {
        String[] codesSplites;
        ConditionList conditionSurredacteur = new ConditionList();
        codesRedacteurs = codesRedacteurs.toUpperCase();
        for (String codeRedacteur : codesSplites = codesRedacteurs.split(":")) {
            if (codeRedacteur.startsWith("SANSDYNAMIK")) {
                codeRedacteur = codeRedacteur.substring("SANSDYNAMIK".length());
                conditionSurredacteur.or(ConditionHelper.notEgal("T1.META_CODE_REDACTEUR", codeRedacteur, TypeOperande.VARCHAR));
                continue;
            }
            conditionSurredacteur.or(ConditionHelper.egalVarchar("T1.META_CODE_REDACTEUR", codeRedacteur));
        }
        return conditionSurredacteur;
    }

    private static Set<InfosGroupeDsi> determinerListeGroupeDiffusion(String diffusionPublicVise) throws Exception {
        String[] groupes;
        HashSet<InfosGroupeDsi> listeDesGroupes = new HashSet<InfosGroupeDsi>();
        for (String codeGroupe : groupes = diffusionPublicVise.split(";")) {
            InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
            listeDesGroupes.add(groupe);
            listeDesGroupes.addAll(groupe.getListeSousGroupesTousNiveaux());
        }
        return listeDesGroupes;
    }

    private static Condition traiterDiffusionPublicVise(Set<InfosGroupeDsi> listeGroupes) {
        return RequeteurFiches.construitConditionDiffusion(listeGroupes, "T1.META_DIFFUSION_PUBLIC_VISE");
    }

    private static Condition construitConditionDiffusion(Set<InfosGroupeDsi> listeGroupes, String nomColonne) {
        ConditionList conditionCodeDiffusion = new ConditionList();
        for (InfosGroupeDsi infosGroupe : listeGroupes) {
            conditionCodeDiffusion.or(ConditionHelper.like(nomColonne, infosGroupe.getCode(), "%[/", "]%"));
        }
        return conditionCodeDiffusion;
    }

    private static Condition traiterDiffusionPublicViseRestriction(Set<InfosGroupeDsi> listeGroupes) {
        return RequeteurFiches.construitConditionDiffusion(listeGroupes, "T1.META_DIFFUSION_PUBLIC_VISE_RESTRICTION");
    }

    private static boolean isDiffusionModeRestriction(String diffusionModeRestriction) {
        return "0".equals(diffusionModeRestriction) || "1".equals(diffusionModeRestriction) || "2".equals(diffusionModeRestriction) || "3".equals(diffusionModeRestriction) || "4".equals(diffusionModeRestriction);
    }

    public static TreeMap<String, Object> executerRequete(RequeteSQL requeteSelect, int from, int increment, Metatag meta) throws Exception {
        TreeMap<String, Object> resultatsMeta = new TreeMap<String, Object>();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        int inc = -1;
        RequeteSQL requeteAExecuter = requeteSelect.clone();
        if (increment != 0) {
            if (ctx.getDatas().get("optimizedLimit") != null) {
                ctx.getDatas().put("optimizedLimit", String.valueOf(increment));
            } else {
                requeteAExecuter.limit(new ClauseLimit(from, increment));
            }
            inc = increment;
        }
        ctx.getDatas().put("optimizedSelect", "1");
        int compteur = 100001;
        meta.selectNoCount(requeteAExecuter.formaterRequete());
        while (meta.nextItem() && (inc == -1 || resultatsMeta.size() < inc)) {
            MetatagBean bean = new MetatagBean();
            bean.init(meta);
            if (resultatsMeta.containsValue(bean)) continue;
            resultatsMeta.put(String.valueOf(compteur), bean);
            ++compteur;
        }
        ctx.getDatas().remove("optimizedSelect");
        return resultatsMeta;
    }

    public static Collection<ClauseJoin> traiterJointureRequeteGenerique(ClauseWhere where, ClauseOrderBy clauseOrderBy) throws Exception {
        Collection<String> codesTypeStructures;
        String orderByFormater;
        ArrayList<ClauseJoin> listeJointures = new ArrayList<ClauseJoin>();
        if (where.formaterSQL().contains("RUB_PUB.")) {
            ClauseJoin joinRubPub = new ClauseJoin(ClauseJoin.TypeJointure.LEFT_JOIN, "RUBRIQUEPUBLICATION RUB_PUB");
            joinRubPub.on(ConditionHelper.critereJointureSimple("T1.META_CODE", "RUB_PUB.CODE_FICHE_ORIG"));
            joinRubPub.and(ConditionHelper.critereJointureSimple("T1.META_LANGUE", "RUB_PUB.LANGUE_FICHE_ORIG"));
            joinRubPub.and(ConditionHelper.critereJointureSimple("T1.META_CODE_OBJET", "RUB_PUB.TYPE_FICHE_ORIG"));
            listeJointures.add(joinRubPub);
        }
        if ((orderByFormater = clauseOrderBy.formaterSQL()).contains("RUB.")) {
            ClauseJoin joinRub = ClauseJoinHelper.creerJointure(ClauseJoin.TypeJointure.LEFT_JOIN, "RUBRIQUE RUB", ConditionHelper.critereJointureSimple("RUB.CODE", "T1.META_CODE_RUBRIQUE"));
            listeJointures.add(joinRub);
        }
        if (orderByFormater.contains("S.") && CollectionUtils.isNotEmpty(codesTypeStructures = ReferentielObjets.getReferentiel().getCodesObjetsStructure())) {
            ClauseJoin joinStructure = new ClauseJoin();
            String premiereStructureDefini = codesTypeStructures.iterator().next();
            String nomClasse = ReferentielObjets.getClasseObjet(premiereStructureDefini);
            joinStructure.setTypeJointure(ClauseJoin.TypeJointure.LEFT_JOIN);
            nomClasse = nomClasse.substring(nomClasse.lastIndexOf(".") + 1);
            joinStructure.setNomTable(nomClasse.toUpperCase() + " S");
            joinStructure.on(ConditionHelper.critereJointureSimple("S.CODE", "T1.META_CODE_RATTACHEMENT"));
            listeJointures.add(joinStructure);
        }
        if (orderByFormater.contains("U.")) {
            ClauseJoin joinUtilisateur = new ClauseJoin(ClauseJoin.TypeJointure.LEFT_JOIN, "UTILISATEUR U");
            joinUtilisateur.on(ConditionHelper.critereJointureSimple("U.CODE", "T1.META_CODE_REDACTEUR"));
            joinUtilisateur.or(ConditionHelper.egalVarchar("T1.META_CODE_REDACTEUR", ""));
            listeJointures.add(joinUtilisateur);
        }
        return listeJointures;
    }

    private static Condition traiterTypeDate(String typeDate, Date dateDebut, Date dateFin) {
        ConditionList conditionSurDate = new ConditionList();
        if (Formateur.estSaisie(dateDebut) || Formateur.estSaisie(dateFin)) {
            if (!Formateur.estSaisie(dateDebut)) {
                dateDebut = new Date(0L);
            }
            if (!Formateur.estSaisie(dateFin)) {
                dateFin = new Date(System.currentTimeMillis());
            }
            conditionSurDate.setPremiereCondtion(ConditionHelper.greaterEquals("T1.META_" + typeDate, dateDebut, TypeOperande.DATE_ET_HEURE));
            conditionSurDate.and(ConditionHelper.lessEquals("T1.META_" + typeDate, dateFin, TypeOperande.DATE_ET_HEURE));
        }
        return conditionSurDate;
    }

    public static Condition traiterCritereGeneriques(ContexteUniv ctxUniv, String mode, String typeObjet, String codeStructure, String codeRubrique, String diffusionPublicVise, String diffusionModeRestriction, String diffusionPublicViseRestriction) throws Exception {
        ConditionList conditionGenerique = new ConditionList();
        AutorisationBean autorisations = RequeteurFiches.getAutorisationBean(ContexteUtil.getContexteUniv());
        if (autorisations == null && (mode.equals("MODIF") || mode.equals("VALID"))) {
            return ConditionHelper.egalVarchar("T1.META_CODE_OBJET", "0000");
        }
        Collection<String> listeDesObjets = RequeteurFiches.recupererTypesObjets(typeObjet, diffusionModeRestriction);
        diffusionModeRestriction = RequeteurFiches.despecialiserModeRestriction(diffusionModeRestriction);
        conditionGenerique.setPremiereCondtion(RequeteurFiches.traiterListeDesObjets(listeDesObjets, autorisations, mode, codeStructure, codeRubrique, diffusionPublicVise, diffusionPublicViseRestriction, diffusionModeRestriction));
        if (mode.equals("CONSUL")) {
            Condition conditiionDSI = RequeteSQLHelper.construireConditionDSI(ctxUniv, diffusionPublicVise, diffusionModeRestriction, diffusionPublicViseRestriction, null);
            conditionGenerique.and(conditiionDSI);
        }
        if (!diffusionModeRestriction.equals("4")) {
            Condition conditionRubriquePublication = ConditionHelper.getConditionRubPubSuivantAction(ctxUniv, mode, "T1.META_CODE_RUBRIQUE", codeRubrique);
            conditionGenerique.and(conditionRubriquePublication);
        }
        if (mode.equals("CONSUL")) {
            Date aujourdhui = new Date(System.currentTimeMillis());
            conditionGenerique.and(ConditionHelper.genericCondition("DATE_FORMAT(T1.META_DATE_MISE_EN_LIGNE, '%Y-%m-%d')", TypeOperande.NON_ECHAPABLE, aujourdhui, TypeOperande.DATE, Operateur.LESS_EQUALS));
        }
        if (mode.equals("MODIF")) {
            ConditionList conditionEtatObjet = new ConditionList(ConditionHelper.egalVarchar("T1.META_ETAT_OBJET", "0001"));
            conditionEtatObjet.or(ConditionHelper.egalVarchar("T1.META_ETAT_OBJET", "0002"));
            conditionEtatObjet.or(ConditionHelper.egalVarchar("T1.META_ETAT_OBJET", "0003"));
            conditionGenerique.and(conditionEtatObjet);
        }
        return conditionGenerique;
    }

    private static AutorisationBean getAutorisationBean(OMContext ctx) {
        AutorisationBean autorisations = null;
        if (ctx.getDatas() != null) {
            autorisations = (AutorisationBean)ctx.getDatas().get("AUTORISATIONS");
        }
        if (autorisations == null && ctx instanceof ContexteUniv) {
            autorisations = ((ContexteUniv)ctx).getAutorisation();
        }
        return autorisations;
    }

    private static Collection<String> recupererTypesObjets(String typeObjet, String diffusionModeRestriction) throws Exception {
        List<String> typesDesObjetsChercher = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)typeObjet) || "0000".equals(typeObjet)) {
            for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
                if (StringUtils.isEmpty((CharSequence)diffusionModeRestriction) && objet.isStrictlyCollaboratif() || diffusionModeRestriction.equals("4") && !objet.isCollaboratif()) continue;
                typesDesObjetsChercher.add(objet.getNomObjet());
            }
        } else {
            typesDesObjetsChercher = Arrays.asList(typeObjet.split(","));
        }
        return typesDesObjetsChercher;
    }

    private static String despecialiserModeRestriction(String diffusionModeRestriction) {
        if ("+4".equals(diffusionModeRestriction)) {
            return "";
        }
        return diffusionModeRestriction;
    }
}

