/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.identification.ValidateurCAS;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.cache.CacheServiceManager;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.objetspartages.om.Preferences;
import com.univ.objetspartages.om.SSOBean;
import com.univ.objetspartages.om.Service;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.portail.service.registry.PortletOccurenceRegistry;
import com.univ.portail.util.Valeur;
import com.univ.services.ReponseService;
import com.univ.services.RequeteService;
import com.univ.services.ServicesInvoker;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.DefautParametrageService;
import com.univ.utils.IParametrageService;
import com.univ.utils.RequeteConnecteur;
import com.univ.utils.ServiceWrappedResponse;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.xml.NodeUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServicesUtil {
    private static Logger LOG = LoggerFactory.getLogger(ServicesUtil.class);
    private static final String URL_ACTIVATION_SERVICE = "/adminsite/sso/activation_service.jsp?service=";

    public static CacheServiceManager getCacheServiceManager() {
        return (CacheServiceManager)ApplicationContextManager.getCoreContextBean("cacheServiceManager");
    }

    public static Map<String, ServiceBean> getServices() {
        HashMap res = ServicesUtil.getCacheServiceManager().call();
        if (res == null) {
            res = new HashMap();
        }
        return res;
    }

    public static TreeSet<String> calculerCodesServicesAutorises(ContexteUniv ctx) throws Exception {
        TreeSet<String> listeServices = new TreeSet<String>();
        for (ServiceBean service : ServicesUtil.getServices().values()) {
            boolean serviceAutorise = false;
            if (service.getDiffusionModeRestriction().equals("3")) {
                serviceAutorise = true;
            } else if (service.getDiffusionModeRestriction().equals("0") && ctx.getCode().length() > 0) {
                serviceAutorise = true;
            } else {
                Vector<Object> groupesRestriction = new Vector();
                if (service.getDiffusionModeRestriction().equals("1")) {
                    groupesRestriction = service.getDiffusionPublicVise();
                }
                if (service.getDiffusionModeRestriction().equals("2")) {
                    groupesRestriction = service.getDiffusionPublicViseRestriction();
                }
                Enumeration<Object> eRestriction = groupesRestriction.elements();
                while (eRestriction.hasMoreElements()) {
                    String codeGroupeRestriction = (String)eRestriction.nextElement();
                    if (!ctx.getGroupesDsiAvecAscendants().contains(codeGroupeRestriction)) continue;
                    serviceAutorise = true;
                }
            }
            if (!serviceAutorise) continue;
            listeServices.add(service.getCode());
        }
        return listeServices;
    }

    public static Vector<ServiceBean> calculerListeServicesPush(ContexteUniv ctx) throws Exception {
        TreeSet<String> listeCodesServices = new TreeSet<String>();
        Vector<ServiceBean> vListeServices = new Vector<ServiceBean>();
        for (ServiceBean service : ServicesUtil.getServices().values()) {
            if (!ctx.getListeServicesAutorises().contains(service.getCode())) continue;
            boolean pushOK = false;
            if (service.getDiffusionMode().equals("0")) {
                pushOK = true;
            }
            if (service.getDiffusionMode().equals("1")) {
                Vector<String> groupesDiffusion = service.getDiffusionPublicVise();
                Enumeration<String> eDiffusion = groupesDiffusion.elements();
                while (eDiffusion.hasMoreElements()) {
                    String codeGroupeDiffusion = eDiffusion.nextElement();
                    if (!ctx.getGroupesDsiAvecAscendants().contains(codeGroupeDiffusion)) continue;
                    pushOK = true;
                }
            }
            if (!pushOK || listeCodesServices.contains(service.getCode())) continue;
            listeCodesServices.add(service.getCode());
            vListeServices.add(service);
        }
        return vListeServices;
    }

    public static String transformerTagsServices(ContexteUniv _ctx, String _texte, String idPage) throws Exception {
        return ServicesUtil.transformerTagsServices(_ctx, _texte, idPage, true);
    }

    public static String transformerTagsServices(ContexteUniv _ctx, String _texte, String idPage, boolean bInterpreterPortlets) throws Exception {
        Hashtable<String, RequeteService> requetesServices = new Hashtable<String, RequeteService>();
        Hashtable<String, Valeur> occurencesService = new Hashtable<String, Valeur>();
        String res = ServicesUtil.transformerTagsServicesHorsContenu(_ctx, _texte, requetesServices, occurencesService, idPage, bInterpreterPortlets);
        if (requetesServices.size() > 0) {
            Map<String, ReponseService> reponsesServices = new ServicesInvoker().executer(_ctx, requetesServices);
            for (String cleRequete : reponsesServices.keySet()) {
                ReponseService reponse = reponsesServices.get(cleRequete);
                String contenu = "";
                if (reponse != null) {
                    contenu = reponse.isTerminated() ? reponse.getReponse() : MessageHelper.getCoreMessage("ST_SERVICES_DELAI_DEPASSE");
                }
                res = StringUtils.replace((String)res, (String)cleRequete, (String)contenu);
            }
        }
        return res;
    }

    public static String transformerTagsServicesHorsContenu(ContexteUniv _ctx, String _texte, Map<String, RequeteService> _requetesServices, Map<String, Valeur> occurencesService, String idPage, boolean bInterpreterPortlets) throws Exception {
        String nomVue;
        String texte = _texte;
        int indexTexte = 0;
        int indexDebutMotCle = -1;
        int indexFinMotCle = 0;
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        StringBuffer newTexte = new StringBuffer(texte.length() + 100);
        while ((indexDebutMotCle = texte.indexOf("[service_debut", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String contenuTag = Chaine.remplacerPointsVirgules(texte.substring(indexDebutMotCle + 1, indexFinMotCle));
            String codeService = "";
            StringTokenizer st = new StringTokenizer(contenuTag, "*");
            int indiceToken = 0;
            while (st.hasMoreTokens()) {
                String itemTag = st.nextToken();
                if (indiceToken == 1) {
                    codeService = itemTag;
                }
                ++indiceToken;
            }
            String tagFinGroupe = "[service_fin]";
            int indexFinGroupe = texte.indexOf("[service_fin]", indexDebutMotCle);
            if (indexFinGroupe == -1) {
                indexTexte = indexDebutMotCle;
                break;
            }
            int indexDebutMotCleSuivant = texte.indexOf("[service_debut", indexDebutMotCle + 1);
            if (indexDebutMotCleSuivant != -1 && indexDebutMotCleSuivant < indexFinGroupe) {
                indexTexte = indexDebutMotCle;
                break;
            }
            if (codeService.length() > 0 && _ctx.getListeServicesAutorises().contains(codeService) && (bInterpreterPortlets || !ServicesUtil.getService(codeService).getType().equals("P"))) {
                _ctx.setServiceCourant(codeService);
                newTexte.append(ServicesUtil.transformerTagsServicesHorsContenu(_ctx, texte.substring(indexFinMotCle + 1, indexFinGroupe), _requetesServices, occurencesService, idPage, bInterpreterPortlets));
                _ctx.setServiceCourant("");
            }
            indexFinMotCle = texte.indexOf("]", indexFinGroupe);
            indexTexte = indexFinMotCle + 1;
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        if (_ctx.getServiceCourant().length() > 0) {
            texte = new String(newTexte);
            indexTexte = 0;
            indexDebutMotCle = -1;
            indexFinMotCle = 0;
            newTexte = new StringBuffer(texte.length() + 100);
            ServiceBean service = ServicesUtil.getService(_ctx.getServiceCourant());
            while ((indexDebutMotCle = texte.indexOf("[", indexTexte)) != -1) {
                newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
                indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
                String valeurRemplacement = "";
                boolean estUnMotcle = false;
                String motCle = "";
                if (indexFinMotCle != -1) {
                    motCle = texte.substring(indexDebutMotCle + 1, indexFinMotCle);
                    if (motCle.startsWith("service_contenu")) {
                        nomVue = "";
                        int idxPtV = motCle.indexOf(";");
                        if (idxPtV != -1) {
                            nomVue = motCle.substring(idxPtV + 1);
                        }
                        int iRequete = _requetesServices.size();
                        String cleRequete = "#requete#" + iRequete + "#";
                        _requetesServices.put(cleRequete, new RequeteService(service, nomVue, ""));
                        valeurRemplacement = cleRequete;
                        estUnMotcle = true;
                    } else if (motCle.startsWith("service_link")) {
                        String nomLink = "";
                        int idx = motCle.indexOf(";");
                        nomLink = idx != -1 ? motCle.substring(idx + 1) : service.getIntitule();
                        String target = ServicesUtil.determinerTargetService(_ctx, service);
                        valeurRemplacement = "<a href=\"" + ServicesUtil.determinerUrlAccueilService(_ctx, service) + "\"";
                        if (target.length() > 0) {
                            valeurRemplacement = valeurRemplacement + " onclick=\"window.open(this.href, '" + target + "'); return false;\"";
                        }
                        valeurRemplacement = valeurRemplacement + ">" + nomLink + "</a>";
                        estUnMotcle = true;
                    } else if (motCle.equals("service_url")) {
                        valeurRemplacement = ServicesUtil.determinerUrlAccueilService(_ctx, service);
                        estUnMotcle = true;
                    } else if (motCle.equals("service_target")) {
                        valeurRemplacement = ServicesUtil.determinerTargetService(_ctx, service);
                        estUnMotcle = true;
                    }
                }
                if (estUnMotcle) {
                    newTexte.append(valeurRemplacement);
                    indexTexte = indexFinMotCle + 1;
                    continue;
                }
                newTexte.append("[");
                indexTexte = indexDebutMotCle + 1;
            }
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(texte.length() + 100);
        while ((indexDebutMotCle = texte.indexOf("[service", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String valeurRemplacement = "";
            boolean estUnMotcle = false;
            String motCle = "";
            if (indexFinMotCle != -1 && (motCle = texte.substring(indexDebutMotCle + 1, indexFinMotCle)).startsWith("service")) {
                String codeService = "";
                nomVue = "";
                String[] tokens = motCle.split(";", -2);
                try {
                    if (tokens.length > 1) {
                        codeService = tokens[1];
                    }
                    if (tokens.length > 2) {
                        nomVue = tokens[2];
                    }
                    ServiceBean service = ServicesUtil.getService(codeService);
                    if (_ctx.getListeServicesAutorises().contains(codeService) && (bInterpreterPortlets || !service.getType().equals("P"))) {
                        String codePortlet = "";
                        if (service.getType().equals("P")) {
                            if (occurencesService.containsKey(codeService)) {
                                occurencesService.get(codeService).augmenterIndice(1);
                            } else {
                                occurencesService.put(codeService, new Valeur());
                            }
                            codePortlet = service.getCode() + "_occ_" + idPage + "_" + occurencesService.get(codeService).toString();
                            PortletOccurenceRegistry.ajouterFragment(codePortlet);
                        }
                        int iRequete = _requetesServices.size();
                        String cleRequete = "#requete#" + iRequete + "#";
                        _requetesServices.put(cleRequete, new RequeteService(service, nomVue, codePortlet));
                        valeurRemplacement = cleRequete;
                        if (!service.getType().equals("P")) {
                            valeurRemplacement = ServicesUtil.getHeaderService(_ctx, service) + valeurRemplacement + ServicesUtil.getFooterService(_ctx);
                        }
                    } else {
                        valeurRemplacement = "";
                    }
                    estUnMotcle = true;
                }
                catch (PortletException ex) {
                    newTexte.append("Le service '" + codeService + "' n'existe pas.");
                }
            }
            if (estUnMotcle) {
                newTexte.append(valeurRemplacement);
                indexTexte = indexFinMotCle + 1;
                continue;
            }
            newTexte.append("[");
            indexTexte = indexDebutMotCle + 1;
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        return texte;
    }

    public static String ajouterParametresService(ContexteUniv _ctx, ServiceBean _service, String url, String ticket) throws Exception {
        String nomClasseParametrage = PropertyHelper.getCoreProperty("service_parametrage." + _service.getCode() + ".classe");
        if (nomClasseParametrage == null) {
            nomClasseParametrage = PropertyHelper.getCoreProperty("service_parametrage.classe");
        }
        if (nomClasseParametrage != null) {
            IParametrageService parametrageServiceSpecif = (IParametrageService)Class.forName(nomClasseParametrage).newInstance();
            return parametrageServiceSpecif.getUrlParametree(_ctx, _service, url, ticket);
        }
        return new DefautParametrageService().getUrlParametree(_ctx, _service, url, ticket);
    }

    public static String determinerUrlAccueilService(ContexteUniv _ctx, ServiceBean _service) {
        String url = "";
        if (_service.getType().equals("U")) {
            url = URL_ACTIVATION_SERVICE + _service.getCode();
        } else if ("P".equals(_service.getType())) {
            url = "/portal/_st_" + _service.getCode() + "/maximized?AFFICHAGE=unitaire&amp;CODE_SERVICE=" + _service.getCode();
        }
        return url;
    }

    public static String determinerUrlServiceTypeUrl(ContexteUniv _ctx, ServiceBean _service) throws Exception {
        String url = _service.getUrl();
        if (url.length() > 0) {
            ValidateurCAS validateurCAS;
            String kticket = "";
            if (_service.getJetonKportal().equals("1") || _ctx.getKsession().length() > 0) {
                kticket = ServicesUtil.genererTicketService(_ctx);
            }
            url = ServicesUtil.ajouterParametresService(_ctx, _service, url, kticket);
            if ("1".equals(_service.getProxyCas()) && (validateurCAS = GestionnaireIdentification.getInstance().getValidateurCAS()) != null) {
                url = validateurCAS.getUrlCasServiceLogin(url);
            }
        }
        LOG.debug("*** url service appelee : " + url);
        return url;
    }

    public static String validerTicket(String kticket) throws Exception {
        String ksession = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        File f = new File(WebAppUtil.getSessionsPath() + File.separator + "kticket_" + kticket + ".xml");
        if (f.exists()) {
            Document document = builder.parse(f);
            Element rootElement = document.getDocumentElement();
            Element donnees = rootElement;
            if (donnees.hasChildNodes()) {
                for (Node nextFeuille = donnees.getFirstChild(); nextFeuille != null; nextFeuille = nextFeuille.getNextSibling()) {
                    if (!nextFeuille.getNodeName().equals("KSESSION")) continue;
                    ksession = NodeUtil.extraireValeurNode(nextFeuille);
                }
            }
            f.delete();
        } else {
            LOG.error("Le fichier " + f.getName() + " est introuvable.");
        }
        return ksession;
    }

    public static void supprimerTicket(String kticket) {
        File f = new File(WebAppUtil.getSessionsPath() + File.separator + "kticket_" + kticket + ".xml");
        if (f.exists()) {
            f.delete();
        }
    }

    public static SSOBean getSSOBean(HttpServletRequest request) throws Exception {
        SSOBean ssoBean = null;
        if (request.getParameter("ksite") != null && request.getParameter("ksite").length() > 0 || request.getParameter("kportal_host") != null && request.getParameter("kportal_host").length() > 0) {
            ssoBean = ServicesUtil.getSSOBeanFromRequest(request);
        } else {
            String ksession = ServicesUtil.validerTicket(request.getParameter("kticket"));
            ssoBean = RequeteConnecteur.lireBeanSSO(ksession);
        }
        return ssoBean;
    }

    public static String determinerTargetService(ContexteUniv _ctx, ServiceBean _service) {
        String target = "";
        if (_service.getUrlPopup().equals("1")) {
            target = _service.getCode();
        }
        return target;
    }

    private static String getHeaderService(ContexteUniv _ctx, ServiceBean _service) throws Exception {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(_ctx.getRequeteHTTP());
        StringWriter storedWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(storedWriter);
        ServiceWrappedResponse wrappedResponse = new ServiceWrappedResponse(_ctx.getReponseHTTP(), writer);
        ServletContext ctxServlet = _ctx.getServletContext();
        wrappedRequest.setAttribute("titre", (Object)_service.getIntitule());
        RequestDispatcher rd = ctxServlet.getRequestDispatcher("/adminsite/portal/service_header.jsp");
        rd.include((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        return storedWriter.toString();
    }

    private static String getFooterService(ContexteUniv _ctx) throws Exception {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(_ctx.getRequeteHTTP());
        StringWriter storedWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(storedWriter);
        ServiceWrappedResponse wrappedResponse = new ServiceWrappedResponse(_ctx.getReponseHTTP(), writer);
        ServletContext ctxServlet = _ctx.getServletContext();
        RequestDispatcher rd = ctxServlet.getRequestDispatcher("/adminsite/portal/service_footer.jsp");
        rd.include((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        return storedWriter.toString();
    }

    public static String genererTicketService(ContexteUniv _ctx) throws Exception {
        long random = (long)(Math.random() * 10000.0);
        String ticket = Long.toString(System.currentTimeMillis()) + "_" + random;
        if (StringUtils.isEmpty((CharSequence)_ctx.getKsession())) {
            throw new ErreurApplicative("Veuillez vous connecter");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element nodeFiche = document.createElement("KTICKET");
        NodeUtil.addNode((Node)nodeFiche, "KSESSION", _ctx.getKsession());
        document.appendChild(nodeFiche);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        File fichierSortie = new File(WebAppUtil.getSessionsPath() + File.separator + "kticket_" + ticket + ".xml");
        fichierSortie.createNewFile();
        try (FileWriter fw = new FileWriter(fichierSortie);){
            StreamResult sr = new StreamResult(fw);
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.transform(source, sr);
        }
        return ticket;
    }

    private static SSOBean getSSOBeanFromRequest(HttpServletRequest request) throws Exception {
        String url;
        SSOBean bean = new SSOBean();
        String kticket = request.getParameter("kticket");
        String urlServeur = request.getParameter("ksite");
        if (urlServeur == null || urlServeur.length() == 0) {
            urlServeur = request.getParameter("kportal_host");
        }
        if (!ServicesUtil.validerUrl(urlServeur)) {
            bean.setCodeRetour("600");
            return bean;
        }
        InfosSite infosSite = Site.renvoyerItemSiteParHost(request.getServerName());
        String uri = "/adminsite/sso/validation_ticket.jsp?kticket=" + kticket + "&kreferer=" + URLResolver.getAbsoluteBoUrl("/", infosSite);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(url = urlServeur + uri);
        Element arbreXML = document.getDocumentElement();
        NodeList nodeList = arbreXML.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node donnees = nodeList.item(i);
                if (donnees == null || donnees.getFirstChild() == null) continue;
                if (donnees.getNodeName().compareTo("CIVILITE") == 0) {
                    bean.setCivilite(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("CODE_UTILISATEUR_KPORTAL") == 0) {
                    bean.setCodeKportal(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("CODE_GESTION_KPORTAL") == 0) {
                    bean.setCodeGestion(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("EMAIL") == 0) {
                    bean.setEmail(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("GROUPES") == 0) {
                    bean.setGroupes(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("NOM") == 0) {
                    bean.setNom(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("PRENOM") == 0) {
                    bean.setPrenom(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("PROFIL") == 0) {
                    bean.setProfil(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("STRUCTURE") == 0) {
                    bean.setStructure(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("KSESSION") == 0) {
                    bean.setKsession(donnees.getFirstChild().getNodeValue().trim());
                }
                if (donnees.getNodeName().compareTo("CODE_RETOUR") != 0) continue;
                bean.setCodeRetour(donnees.getFirstChild().getNodeValue().trim());
            }
        }
        return bean;
    }

    public static boolean validerUrl(String sUrl) {
        boolean res = false;
        URL url = null;
        try {
            url = new URL(sUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
        String host = url.getHost();
        String param = PropertyHelper.getCoreProperty("sso.sites_confiance");
        if (param != null) {
            String[] aliasHost;
            for (String element : aliasHost = param.split(";")) {
                if (!host.matches(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean validerSite(String sUrl) {
        URL url = null;
        try {
            url = new URL(sUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return Site.renvoyerItemSiteParHost(url.getHost()).getAlias().length() > 0;
    }

    public static ServiceBean getService(String codeService) {
        if (ServicesUtil.getServices().containsKey(codeService)) {
            return ServicesUtil.getServices().get(codeService);
        }
        return new ServiceBean();
    }

    public static synchronized void ordonnerInstancesServices(OMContext _ctx, List<String> vCodesServices) throws Exception {
        Service service = new Service();
        service.setCtx(_ctx);
        int ordre = 0;
        for (String codeService : vCodesServices) {
            ClauseWhere whereCodeService = new ClauseWhere(ConditionHelper.egalVarchar("CODE", codeService));
            if (service.select(whereCodeService.formaterSQL()) <= 0) continue;
            service.nextItem();
            service.setOrdre(new Integer(ordre));
            service.update();
            ++ordre;
        }
    }

    public static synchronized void removeInstanceService(OMContext _ctx, String codeService) throws Exception {
        if (codeService != null) {
            Service service = new Service();
            service.setCtx(_ctx);
            ClauseWhere whereCodeService = new ClauseWhere(ConditionHelper.egalVarchar("CODE", codeService));
            if (service.select(whereCodeService.formaterSQL()) > 0) {
                service.nextItem();
                service.delete();
            }
            Preferences pref = new Preferences();
            pref.setCtx(_ctx);
            pref.init();
            pref.deleteAllPreferences(codeService);
        }
    }

    public static synchronized void setInstanceService(OMContext _ctx, ServiceBean serviceBean) throws Exception {
        Service service = new Service();
        service.setCtx(_ctx);
        boolean creation = false;
        ClauseWhere whereCodeService = new ClauseWhere(ConditionHelper.egalVarchar("CODE", serviceBean.getCode()));
        if (service.select(whereCodeService.formaterSQL()) > 0) {
            service.nextItem();
        } else {
            service.init();
            creation = true;
        }
        service.setCode(serviceBean.getCode());
        service.setIntitule(serviceBean.getIntitule());
        service.setType(serviceBean.getType());
        service.setEncodage(serviceBean.getEncodage());
        service.setExpirationCache(serviceBean.getExpirationCache());
        service.setJetonKportal(serviceBean.getJetonKportal());
        service.setProxyCas(serviceBean.getProxyCas());
        service.setUrl(serviceBean.getUrl());
        service.setPortletDefinitionId(serviceBean.getPortletDefinitionId());
        service.setUrlPopup(serviceBean.getUrlPopup());
        service.setVueReduiteType(serviceBean.getVueReduiteType());
        service.setVueReduiteUrl(serviceBean.getVueReduiteUrl());
        service.setVueReduiteCtx(serviceBean.getVueReduiteCtx());
        service.setVueReduiteUrlCrossCtx(serviceBean.getVueReduiteUrlCrossCtx());
        service.setDiffusionMode(serviceBean.getDiffusionMode());
        service.setDiffusionPublicVise(Chaine.convertirAccolades(serviceBean.getDiffusionPublicVise()));
        service.setDiffusionModeRestriction(serviceBean.getDiffusionModeRestriction());
        service.setDiffusionPublicViseRestriction(Chaine.convertirAccolades(serviceBean.getDiffusionPublicViseRestriction()));
        if (creation) {
            service.add();
        } else {
            service.update();
        }
        Preferences prefGenerales = new Preferences();
        prefGenerales.setCtx(_ctx);
        prefGenerales.init();
        prefGenerales.selectPreferencesGenerales(service.getCode());
        while (prefGenerales.nextItem()) {
            prefGenerales.delete();
        }
        List<InfosPreferences> listePreferencesGenerales = serviceBean.getPreferencesGenerales();
        Iterator<InfosPreferences> iter = listePreferencesGenerales.iterator();
        InfosPreferences infosPref = null;
        while (iter.hasNext()) {
            infosPref = iter.next();
            prefGenerales.init();
            prefGenerales.setService(serviceBean.getCode());
            prefGenerales.setType("S");
            prefGenerales.setNom(infosPref.getNom());
            prefGenerales.setValeur(infosPref.getValeursAsString());
            prefGenerales.add();
        }
    }
}

