/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.kportal.servlet.ExtensionServlet;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleDownloadServlet
extends ExtensionServlet {
    private static final long serialVersionUID = -2328660109979013684L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDownloadServlet.class);

    protected abstract String getFilePath();

    protected abstract String getFileType();

    protected abstract boolean isAuthorized();

    protected String getDownloadedFileName(File file) {
        return file.getName();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performTask(request, response);
    }

    public void performTask(HttpServletRequest request, HttpServletResponse response) {
        int status = 0;
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (this.isAuthorized()) {
            File f = new File(this.getFilePath());
            if (f.exists()) {
                try (ServletOutputStream writer = response.getOutputStream();){
                    String contentType = "";
                    if (StringUtils.isEmpty((CharSequence)this.getFileType())) {
                        contentType = "text/plain";
                    }
                    response.setContentType(contentType);
                    response.setCharacterEncoding("UTF-8".toLowerCase());
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + this.getDownloadedFileName(f) + "\"");
                    FileUtils.copyFile((File)f, (OutputStream)writer);
                }
                catch (IOException e) {
                    LOG.error("Erreur lors de la lecture/ecriture du fichier", (Throwable)e);
                }
            } else if (this.getFilePath().length() > 0) {
                status = 404;
            }
        } else {
            status = 403;
        }
        if (status != 0) {
            response.setStatus(status);
            String pageErreur = "";
            pageErreur = status == 404 ? ctx.getInfosSite().getJspFo() + "/error/404.jsp" : ctx.getInfosSite().getJspFo() + "/error/403.jsp";
            try {
                RequestDispatcher rd = this.getServletContext().getRequestDispatcher(pageErreur);
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException | ServletException e) {
                LOG.error("erreur lors du forward de la request", e);
            }
        }
    }
}

