/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.utils.ContexteUniv;
import com.univ.utils.UnivWebFmt;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLResolver {
    private static final Logger LOG = LoggerFactory.getLogger(URLResolver.class);
    public static final String FORWARDED_PROTOCOL = "X-Forwarded-Proto";
    public static final String FORWARDED_PORT = "X-Forwarded-Port";
    public static final int STANDARD_ACTION = 0;
    public static final int LOGIN_FRONT = 1;
    public static final int PERSONNALISER_FRONT = 2;
    public static final int DEMANDER_MDP_FRONT = 3;
    public static final int PRESENTER_MDP_FRONT = 4;
    public static final int DECONNECTER_FRONT = 5;

    public static String getBasePath(String scheme, String hostName, int port) {
        StringBuilder basePath = new StringBuilder();
        if (scheme != null && hostName != null) {
            basePath.append(scheme.toLowerCase());
            basePath.append("://");
            basePath.append(hostName);
            int defaultPort = -1;
            if (scheme.equalsIgnoreCase("http")) {
                defaultPort = 80;
            } else if (scheme.equalsIgnoreCase("https")) {
                defaultPort = 443;
            }
            if (port < 0) {
                port = defaultPort;
            }
            if (port != defaultPort) {
                basePath.append(':');
                basePath.append(port);
            }
        }
        return basePath.toString();
    }

    public static String getBasePath(InfosSite site, boolean secure) {
        return secure ? URLResolver.getBasePath("https", site.getHttpsHostname(), site.getHttpsPort()) : URLResolver.getBasePath("http", site.getHttpHostname(), site.getHttpPort());
    }

    private static boolean isSecureFoUrl(OMContext ctx, InfosSite site) {
        boolean secure = false;
        if (site == null) {
            site = Site.getSitePrincipal();
        }
        int ssl_mode = site.getSslMode();
        switch (ssl_mode) {
            case 0: {
                break;
            }
            case 1: {
                secure = ctx.isSecure();
                break;
            }
            case 2: {
                secure = true;
            }
        }
        return secure;
    }

    private static boolean isSecureFoUrl(InfosSite site, int action) {
        boolean secure = false;
        if (site == null) {
            site = Site.getSitePrincipal();
        }
        if (site.getSslMode() == 2) {
            secure = true;
        } else if (action == 1 || action == 2 || action == 3 || action == 4) {
            secure = site.isHttpsAction(action);
        } else if (site.getSslMode() == 1 && action == 5) {
            secure = !site.isHttpAction(action);
        }
        return secure;
    }

    private static boolean isSecureBoUrl(InfosSite site) {
        if (site == null) {
            site = Site.getSitePrincipal();
        }
        return site.getBoSslMode() == 1;
    }

    public static String getBasePath(HttpServletRequest request) {
        String scheme = URLResolver.getRequestScheme(request);
        String hostName = request.getServerName();
        int port = URLResolver.getRequestPort(request);
        return URLResolver.getBasePath(scheme, hostName, port);
    }

    public static String getAbsoluteUrlFiche(FicheUniv fiche, ContexteUniv ctx) {
        String res;
        try {
            res = URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, fiche), (OMContext)ctx, ctx.getInfosSite());
        }
        catch (Exception e) {
            LOG.error("impossible de determiner l'url de la fiche", (Throwable)e);
            res = URLResolver.getAbsoluteUrl("/", ctx);
        }
        return res;
    }

    public static String getAbsoluteUrl(String relativeUrl, OMContext ctx) {
        return URLResolver.getAbsoluteUrl(relativeUrl, ctx, ctx.getInfosSite());
    }

    public static String getAbsoluteUrl(String relativeUrl, OMContext ctx, int specificAction) {
        return URLResolver.getAbsoluteUrl(relativeUrl, ctx.getInfosSite(), specificAction);
    }

    public static String getAbsoluteUrl(String relativeUrl, OMContext ctx, InfosSite site) {
        if (site == null) {
            site = ctx.getInfosSite();
        }
        return URLResolver.getAbsoluteUrl(relativeUrl, URLResolver.isSecureFoUrl(ctx, site), site);
    }

    public static String getAbsoluteUrl(String relativeUrl, InfosSite site, int specificAction) {
        return URLResolver.getAbsoluteUrl(relativeUrl, URLResolver.isSecureFoUrl(site, specificAction), site);
    }

    public static String getAbsoluteUrl(String relativeUrl, boolean secure, InfosSite site) {
        String url = relativeUrl.startsWith("http") || relativeUrl.startsWith("https") ? relativeUrl : URLResolver.getBasePath(site == null ? Site.getSitePrincipal() : site, secure) + relativeUrl;
        return url;
    }

    public static String getAbsoluteBoUrl(String relativeUrl, InfosSite site) {
        return URLResolver.getBasePath(site == null ? Site.getSitePrincipal() : site, URLResolver.isSecureBoUrl(site)) + relativeUrl;
    }

    public static String getRessourceUrl(String relativeUrl, OMContext ctx) {
        return URLResolver.getAbsoluteUrl(relativeUrl, URLResolver.isSecureFoUrl(ctx, ctx.getInfosSite()), ctx.getInfosSite());
    }

    public static String getRessourceUrl(String relativeUrl, OMContext ctx, boolean secure) {
        return URLResolver.getAbsoluteUrl(relativeUrl, secure, ctx.getInfosSite());
    }

    public static String getApercuUrl(HttpServletRequest request, String relativeUrl) {
        String hostName = request.getServerName();
        int port = URLResolver.getRequestPort(request);
        String scheme = URLResolver.getRequestScheme(request);
        if (scheme.equals("https") && Site.getSitePrincipal().getSslMode() < 1) {
            scheme = "http";
            port = Site.getSitePrincipal().getHttpPort();
        }
        return URLResolver.getBasePath(scheme, hostName, port) + relativeUrl;
    }

    public static String getAbsoluteUrlAcceuil(ContexteUniv ctx, InfosRubriques infosRubrique) throws Exception {
        return URLResolver.getAbsoluteUrl(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, infosRubrique.getCode()), ctx);
    }

    public static String getRequestScheme(HttpServletRequest request) {
        String scheme = request.getHeader(FORWARDED_PROTOCOL);
        if (StringUtils.isBlank((CharSequence)scheme)) {
            scheme = request.getScheme();
        }
        return scheme;
    }

    public static int getRequestPort(HttpServletRequest request) {
        String portInHeader = request.getHeader(FORWARDED_PORT);
        int port = request.getServerPort();
        if (StringUtils.isNotBlank((CharSequence)portInHeader) && StringUtils.isNumeric((CharSequence)portInHeader)) {
            try {
                port = Integer.valueOf(portInHeader);
            }
            catch (NumberFormatException nfe) {
                LOG.error("unable to parse the X-Forwarded-Port header value", (Throwable)nfe);
            }
        }
        return port;
    }

    public static String getRequestBase(HttpServletRequest request) {
        String realScheme = URLResolver.getRequestScheme(request);
        String fullUrl = request.getRequestURL().toString();
        fullUrl = StringUtils.removeEnd((String)fullUrl, (String)request.getRequestURI());
        fullUrl = StringUtils.removeStart((String)fullUrl, (String)request.getScheme());
        fullUrl = realScheme + fullUrl;
        return fullUrl;
    }
}

