/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.textsearch.CibleRecherche;
import com.jsbsoft.jtf.textsearch.sitesdistants.RechercheSitesDistants;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.module.composant.ComposantUtilisateur;
import com.kportal.extension.module.plugin.toolbox.PluginToolboxHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.tree.processus.GroupsJsTree;
import com.univ.tree.processus.RubriquesJsTree;
import com.univ.tree.processus.StructuresJsTree;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UnivFmt {
    public static final String TYPE_TOOLBAR_BACKOFFICE = "BackOffice";
    public static final int TYPE_LISTE_INPUT = 0;
    public static final int TYPE_LISTE_COMBO = 1;
    public static final int TYPE_LISTE_RECHERCHE = 2;
    private static final int GROUPEDSI_RESTRICTION = 0;
    private static final int GROUPEDSI_PUBLIC_VISE = 1;
    public static final int CONTEXT_DEFAULT = 0;
    public static final int CONTEXT_STRUCTURE = 1;
    public static final int CONTEXT_ZONE = 2;
    public static final int CONTEXT_GROUPEDSI_RESTRICTION = 3;
    public static final int CONTEXT_GROUPEDSI_PUBLIC_VISE = 4;
    public static final int CONTEXT_STRUCTURES_ENSEIGNEMENT = 6;
    public static final Pattern selectPattern = Pattern.compile("([/]*[a-zA-Z0-9\\-]*)/([\\S]*)");
    public static final HashMap<String, String> URLS = new HashMap();

    public void insererChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, int size, String nomZone) throws IOException {
        this.insererChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, size, nomZone, "", false, "");
    }

    public void insererChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone) throws IOException {
        this.insererChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nomZone, "");
    }

    public void insererCombo(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomTable, String nomZone) throws IOException {
        this.insererCombo(fmt, out, infoBean, nomDonnee, optionModification, nomTable, nomZone, "");
    }

    public void insererCombo(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomTable, String nomZone, String tricle) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        fmt.insererCombo((Writer)out, infoBean, nomDonnee, optionModification, nomTable, "8pt,LIB=" + nomZone + tricle);
        this.insererFinChamp(out);
    }

    public void insererComboHashtable(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, Map<String, String> map, String nomZone) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        fmt.insererCombo((Writer)out, infoBean, nomDonnee, optionModification, map, "8pt,LIB=" + nomZone);
        this.insererFinChamp(out);
    }

    public void insererContenuComboHashtable(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, Map<String, String> map, String nomZone) throws IOException {
        fmt.insererCombo((Writer)out, infoBean, nomDonnee, optionModification, map, "8pt,LIB=" + nomZone);
    }

    public void insererComboHashtable(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomHashtable, String nomZone) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        fmt.insererComboHashtable((Writer)out, infoBean, nomDonnee, optionModification, nomHashtable, "8pt,LIB=" + nomZone);
        this.insererFinChamp(out);
    }

    @Deprecated
    public void insererRadiosBoutons(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        this.insererContenuRadiosBoutons(fmt, out, infoBean, nomDonnee, optionModification);
        this.insererFinChamp(out);
    }

    @Deprecated
    public void insererRadiosBoutons(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, int ordreElement) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone);
        this.insererContenuRadiosBoutons(fmt, out, infoBean, nomDonnee, optionModification, ordreElement);
        this.insererFinChamp(out);
    }

    public void insererContenuRadiosBoutons(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification) throws IOException {
        this.insererContenuRadiosBoutons(fmt, out, infoBean, nomDonnee, optionModification, 1);
    }

    public void insererContenuRadiosBoutons(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int ordreElements) throws IOException {
        if (optionModification == -1) {
            return;
        }
        Hashtable<String, String> hRadio = new Hashtable<String, String>();
        int i = 0;
        while (infoBean.get("RADIO" + i) != null) {
            hRadio.put(i + "#" + infoBean.get("RADIO" + i), "");
            infoBean.set("RADIO" + i, null);
            ++i;
        }
        i = 0;
        TreeSet tree = new TreeSet(hRadio.keySet());
        Iterator it = tree.iterator();
        String checked = "";
        String value = "";
        out.println("<ul class=\"en_ligne\">");
        while (it.hasNext()) {
            checked = "";
            String libelle = (String)it.next();
            if ((libelle = libelle.substring(libelle.indexOf("#") + 1)).contains("#")) {
                try {
                    value = libelle.substring(libelle.indexOf("#") + 1);
                }
                catch (Exception e) {
                    value = Integer.toString(i);
                }
                libelle = libelle.substring(0, libelle.indexOf("#"));
            } else {
                value = Integer.toString(i);
            }
            if (value.equals(infoBean.getString(nomDonnee))) {
                checked = "checked=\"checked\"";
            }
            out.println("<li>");
            if (0 != optionModification) {
                out.println("<input id=\"" + nomDonnee + i + "\" type=\"radio\" name=\"" + nomDonnee + "\" value=\"" + value + "\" " + checked + " />");
            } else {
                out.println("<input id=\"" + nomDonnee + i + "\" type=\"radio\" disabled=\"disabled\" name=\"" + nomDonnee + "\" value=\"" + value + "\" " + checked + " />");
            }
            out.println("<label for=\"" + nomDonnee + i + "\">" + libelle + "</label>");
            out.println("</li>");
            ++i;
        }
        out.println("</ul>");
    }

    public void insererContenuSaisieStructure(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws Exception {
        String szTmp;
        String res = "";
        String libelle = "";
        if (infoBean.get("LIBELLE_" + nomDonnee) != null) {
            libelle = EscapeString.escapeHtml(infoBean.getString("LIBELLE_" + nomDonnee));
        }
        String value = "";
        if (infoBean.get(nomDonnee) != null) {
            value = EscapeString.escapeHtml(infoBean.getString(nomDonnee));
        }
        boolean frontOffice = false;
        String lg = String.valueOf(LangueUtil.getIndiceLocale(LangueUtil.getDefaultLocale()));
        String langueInfoBean = infoBean.getString("LANGUE");
        String langueFicheInfoBean = infoBean.getString("LANGUE_FICHE");
        if (StringUtils.isNotEmpty((CharSequence)langueFicheInfoBean) && StringUtils.isNumeric((CharSequence)langueFicheInfoBean)) {
            lg = langueFicheInfoBean;
        } else if (StringUtils.isNotEmpty((CharSequence)langueInfoBean) && StringUtils.isNumeric((CharSequence)langueInfoBean)) {
            lg = langueInfoBean;
        }
        if (infoBean.get("SAISIE_FRONT") != null) {
            frontOffice = true;
        }
        if ((szTmp = nomDonnee).startsWith("TMP_")) {
            szTmp = szTmp.substring(4);
        }
        if (optionModification != 0) {
            if (libelle.equals("-") || libelle.equals("")) {
                libelle = MessageHelper.getMessage(infoBean.getNomExtension(), "JTF_CLIQUER_PARCOURIR");
            }
            res = res + "<input type=\"text\" class=\"readonly\" readonly=\"readonly\" id=\"LIBELLE_" + nomDonnee + "\" name=\"LIBELLE_";
            res = res + nomDonnee;
            res = res + "\" size=\"30\" value=\"";
            res = res + libelle;
            if (value.length() > 0) {
                res = res + "\" title=\"" + Structure.getFilAriane(value, "");
            }
            res = res + "\"/>";
            int indiceChamps = fmt.getIndiceChamp();
            res = res + "<input type=\"hidden\" name=\"#FORMAT_" + szTmp + "\" value=\"" + optionModification + ";" + 0 + ";0;0;LIB=" + nomZone + ";" + indiceChamps++ + "\"/>";
            fmt.setIndiceChamp(indiceChamps);
            res = res + "<input type=\"hidden\" name=\"" + nomDonnee;
            res = res + "\" value=\"" + value;
            res = res + "\" />";
            if (optionModification == -1 || ReferentielObjets.getNombreObjetsTypeStructure() == 0) {
                out.println(res);
                return;
            }
            if (frontOffice) {
                String filtre = "";
                if (infoBean.get("FILTRE_" + nomDonnee) != null) {
                    filtre = infoBean.getString("FILTRE_" + nomDonnee);
                    filtre = EscapeString.escapeJavaScript(filtre);
                }
                res = res + "<input id=\"parcourir_" + nomDonnee + "\" type=\"button\" class=\"button submit\" value=\"" + MessageHelper.getCoreMessage("JTF_BOUTON_PARCOURIR") + "\" onclick=\"showMessageField('strfo/" + lg + "/" + filtre + "','" + nomDonnee + "','LIBELLE_" + nomDonnee + "');\"/> ";
            } else {
                String typeAide = "structure/";
                if (infoBean.getEtatObjet() != null && !infoBean.getEtatObjet().equals("CREATION")) {
                    typeAide = typeAide + lg;
                }
                String nomDonneeFiltreArbre = nomDonnee;
                if (nomDonnee.startsWith("TMP")) {
                    nomDonneeFiltreArbre = nomDonnee.substring(4);
                }
                if (infoBean.get("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT") != null && infoBean.getString("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT").equals(nomDonneeFiltreArbre) || infoBean.get("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT_AUTRES") != null && infoBean.getString("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT_AUTRES").equals(nomDonneeFiltreArbre)) {
                    String type = infoBean.getString("GRS_PERMISSION_TYPE");
                    String objet = infoBean.getString("GRS_PERMISSION_OBJET");
                    String action = infoBean.getString("GRS_PERMISSION_ACTION");
                    if (type != null && type.length() > 0 && objet != null && objet.length() > 0 && action != null && action.length() > 0) {
                        typeAide = "strbo/" + type + "/" + objet + "/" + action + "/";
                        if (!"CREATION".equals(infoBean.getEtatObjet())) {
                            typeAide = typeAide + lg;
                        }
                    }
                }
                typeAide = typeAide + "/";
                if (infoBean.get("FILTRE_" + nomDonnee) != null) {
                    typeAide = typeAide + EscapeString.escapeJavaScript(infoBean.getString("FILTRE_" + nomDonnee));
                }
                res = res + "<input id=\"parcourir_" + nomDonnee + "\" type=\"button\" class=\"button\" value=\"" + MessageHelper.getCoreMessage("JTF_BOUTON_PARCOURIR") + "\" onclick=\"showMessageField('" + typeAide + "','" + nomDonnee + "','LIBELLE_" + nomDonnee + "');\" /> ";
            }
            if (optionModification == 1) {
                res = res + "<input type=\"button\" class=\"button reset\" value=\"" + MessageHelper.getCoreMessage("JTF_BOUTON_EFFACER") + "\" onclick=\"effacerTextField('" + nomDonnee + "','LIBELLE_" + nomDonnee + "','','" + MessageHelper.getCoreMessage("JTF_CLIQUER_PARCOURIR") + "');\"/> ";
            }
        } else {
            fmt.insererChampSaisie((Writer)out, infoBean, "LIBELLE_" + szTmp, 0, 0, 0, 0);
        }
        out.println(res);
    }

    public void insererDrapeauLangue(JspWriter out, String codeLangue) throws IOException {
        String urlDrapeau = LangueUtil.getPathImageDrapeau(codeLangue);
        String res = "<img src = \"" + urlDrapeau + "\" alt=\"" + LangueUtil.getDisplayName(codeLangue) + "\" />";
        out.print(res);
    }

    private void insererFckToolbox(JspWriter out, InfoBean infoBean, String nomDonnee, int width, int height, String toolbar, AutorisationBean autorisations, boolean pageLibre, boolean encadreAvance, boolean pageStyle) throws IOException {
        String valeur = "";
        if (infoBean.getString(nomDonnee) != null) {
            valeur = this.escapeFckValue(infoBean.getString(nomDonnee), infoBean.isControled(nomDonnee));
            valeur = this.formaterFckValue(infoBean, valeur);
        }
        out.write("<script type=\"text/javascript\">\r\n");
        out.write(" var oFCKeditor" + nomDonnee + " = new FCKeditor( '" + nomDonnee + "', " + width + ", " + height + ", '', '' ) ;\r\n");
        out.write(" oFCKeditor" + nomDonnee + ".Config.CustomConfigurationsPath = '/adminsite/fcktoolbox/kosmos/kportalconfig.js' ;\r\n");
        out.write("oFCKeditor" + nomDonnee + ".Config.ExtensionsPath = '" + WebAppUtil.getRelativeExtensionsPath() + "';\r\n");
        String conf = PluginToolboxHelper.getConfiguration(infoBean);
        if (conf.length() > 0) {
            out.write("oFCKeditor" + nomDonnee + ".Config.CustomPlugins = '" + conf + "';\r\n");
        }
        out.write(" oFCKeditor" + nomDonnee + ".BasePath = '/adminsite/fcktoolbox/fckeditor/' ;\r\n");
        out.write(" oFCKeditor" + nomDonnee + ".Value = '" + EscapeString.escapeJavaScript(valeur) + "';\r\n");
        if (StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("fckeditor.kportalestyles"))) {
            out.write("oFCKeditor" + nomDonnee + ".Config['KStylesXmlPath'] = '" + PropertyHelper.getCoreProperty("fckeditor.kportalestyles") + "';\r\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("fckeditor.fckstyles"))) {
            out.write("oFCKeditor" + nomDonnee + ".Config['StylesXmlPath'] = '" + PropertyHelper.getCoreProperty("fckeditor.fckstyles") + "';\r\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("fckeditor.fcktemplates"))) {
            out.write("oFCKeditor" + nomDonnee + ".Config['TemplatesXmlPath'] = '" + PropertyHelper.getCoreProperty("fckeditor.fcktemplates") + "';\r\n");
        }
        String sToolbar = "";
        out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] = \"\";\r\n");
        if (StringUtils.equals((CharSequence)toolbar, (CharSequence)TYPE_TOOLBAR_BACKOFFICE)) {
            out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"" + PropertyHelper.getCoreProperty("fckeditor.toolbar.standard") + "\";\r\n");
            if (encadreAvance) {
                if (PropertyHelper.getCoreProperty("fckeditor.toolbar.encadre") != null && PropertyHelper.getCoreProperty("fckeditor.toolbar.encadre").length() > 0) {
                    out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"+" + PropertyHelper.getCoreProperty("fckeditor.toolbar.encadre") + "\";\r\n");
                }
            } else if (pageLibre) {
                if (PropertyHelper.getCoreProperty("fckeditor.toolbar.styles_pagelibre") != null && PropertyHelper.getCoreProperty("fckeditor.toolbar.styles_pagelibre").length() > 0) {
                    out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"+" + PropertyHelper.getCoreProperty("fckeditor.toolbar.styles_pagelibre") + "\";\r\n");
                }
            } else if (pageStyle && PropertyHelper.getCoreProperty("fckeditor.toolbar.styles_standard") != null && PropertyHelper.getCoreProperty("fckeditor.toolbar.styles_standard").length() > 0) {
                out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"+" + PropertyHelper.getCoreProperty("fckeditor.toolbar.styles_standard") + "\";\r\n");
            }
            if (autorisations != null && autorisations.possedePermissionTech("fpg") && (pageLibre || pageStyle) && PropertyHelper.getCoreProperty("fckeditor.toolbar.colors") != null && PropertyHelper.getCoreProperty("fckeditor.toolbar.colors").length() > 0) {
                out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"+" + PropertyHelper.getCoreProperty("fckeditor.toolbar.colors") + "\";\r\n");
            }
            sToolbar = PropertyHelper.getCoreProperty("fckeditor.toolbar.bo");
        } else if (toolbar.equals("Collaboratif")) {
            if (StringUtils.isNotBlank((CharSequence)infoBean.getString("ESPACE"))) {
                sToolbar = PropertyHelper.getCoreProperty("fckeditor.toolbar.collaboratif");
            } else {
                out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"" + PropertyHelper.getCoreProperty("fckeditor.toolbar.standard") + "\";\r\n");
                sToolbar = PropertyHelper.getCoreProperty("fckeditor.toolbar.fo");
            }
        } else {
            sToolbar = PropertyHelper.getCoreProperty("fckeditor.toolbar." + toolbar);
        }
        int nbOptions = 0;
        if (sToolbar.length() > 0) {
            String[] tOptions = sToolbar.split(",", -2);
            boolean active = true;
            for (String option : tOptions) {
                if (option.equals("KPortalList") && (autorisations == null || !autorisations.possedePermissionTech("flf"))) {
                    active = false;
                }
                if (option.equals("KPortalTag") && (autorisations == null || !autorisations.possedePermissionTech("fat"))) {
                    active = false;
                }
                if (option.equals("KPortalRss") && (autorisations == null || !autorisations.possedePermissionTech("fra"))) {
                    active = false;
                }
                if (option.equals("KPortalGalerie") && (autorisations == null || !autorisations.possedePermissionTech("fgm"))) {
                    active = false;
                }
                if (active) {
                    if (nbOptions > 0) {
                        out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \",\";");
                    }
                    out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"" + option + "\";\r\n");
                }
                active = true;
                ++nbOptions;
            }
        }
        List<Pair<String, String>> options = PluginToolboxHelper.getOptions(infoBean);
        for (Pair<String, String> pair : options) {
            if (((String)pair.getKey()).equals("DynamicToolbar_buttons")) {
                if (nbOptions > 0) {
                    out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \",\";");
                }
                out.write(" oFCKeditor" + nomDonnee + ".Config['" + (String)pair.getKey() + "'] += \"" + (String)pair.getValue() + "\";\r\n");
                continue;
            }
            out.write(" oFCKeditor" + nomDonnee + ".Config['" + (String)pair.getKey() + "'] = \"" + (String)pair.getValue() + "\";\r\n");
        }
        if (autorisations != null && autorisations.possedePermissionTech("mdh")) {
            out.write(" oFCKeditor" + nomDonnee + ".Config['DynamicToolbar_buttons'] += \"|" + PropertyHelper.getCoreProperty("fckeditor.toolbar.source") + "\";\r\n");
        }
        out.write(" oFCKeditor" + nomDonnee + ".Config['MediathequeMaxWidth']=" + PropertyHelper.getCoreProperty("fckeditor.mediatheque.max_width") + ";\r\n");
        out.write(" oFCKeditor" + nomDonnee + ".ToolbarSet = 'DynamicToolbar' ;\r\n");
        out.write(" oFCKeditor" + nomDonnee + ".Create() ;\r\n");
        out.write(" if( document.getElementsByName('FCK_EDITORS_NAMES')[0].value.indexOf('" + nomDonnee + "_FCK')==-1 ){ \r\n");
        out.write(" if( document.getElementsByName('FCK_EDITORS_NAMES')[0].value.length>0)document.getElementsByName('FCK_EDITORS_NAMES')[0].value += \";\";\r\n");
        out.write("document.getElementsByName('FCK_EDITORS_NAMES')[0].value +=\"" + nomDonnee + "_FCK\";}\r\n");
        out.write("</script>\r\n");
    }

    private String escapeFckValue(String chaine, boolean controlled) {
        if (chaine == null) {
            return "";
        }
        String sautDeLigne = "";
        if (controlled) {
            sautDeLigne = "<br />";
        }
        chaine = StringUtils.replace((String)chaine, (String)"\r\n", (String)sautDeLigne);
        chaine = StringUtils.replace((String)chaine, (String)"\r", (String)sautDeLigne);
        chaine = StringUtils.replace((String)chaine, (String)"\n", (String)sautDeLigne);
        return chaine;
    }

    private String formaterFckValue(InfoBean infoBean, String chaine) {
        HttpSession session = infoBean.getSessionHttp();
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
        Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
        String sTag = "(\\[id-image\\][0-9A-Z]+\\[/id-image\\])";
        Pattern p = Pattern.compile("(\\[id-image\\][0-9A-Z]+\\[/id-image\\])");
        Matcher m = p.matcher(chaine);
        while (m.find()) {
            infosSession.put(m.group(1), -1);
        }
        String replacePattern = "src=\"(http://)*([a-zA-Z0-9:]+)*(/servlet/com.univ.utils.LectureImageToolbox\\?TAG=)*\\[id-image\\]";
        chaine = StringUtils.replacePattern((String)chaine, (String)"src=\"(http://)*([a-zA-Z0-9:]+)*(/servlet/com.univ.utils.LectureImageToolbox\\?TAG=)*\\[id-image\\]", (String)"src=\"/servlet/com.univ.utils.LectureImageToolbox?TAG=[id-image]");
        return chaine;
    }

    public void insererEditeurHTML(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone, boolean stylePageLibre, boolean styleEncadreAvance, boolean styleStandart) throws IOException {
        this.insererEditeurHTML(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nomZone, stylePageLibre, styleEncadreAvance, styleStandart, TYPE_TOOLBAR_BACKOFFICE);
    }

    public void insererEditeurHTML(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone, boolean stylePageLibre, boolean styleEncadreAvance, boolean styleStandart, String typeToolbar) throws IOException {
        if (optionModification != -1) {
            this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
            if (optionModification == 0) {
                fmt.insererChampSaisie((Writer)out, infoBean, nomDonnee, 0, 0, 0, 0);
                this.insererFinChamp(out);
            } else {
                HttpSession session = infoBean.getSessionHttp();
                SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
                Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
                AutorisationBean autorisations = (AutorisationBean)infosSession.get("AUTORISATIONS");
                boolean isencadre = false;
                if (nomDonnee.indexOf("ENCADRE") != -1 || styleEncadreAvance) {
                    isencadre = true;
                }
                String format = "APPLET_HTML=1,CODE_HTML=1,LIB=" + nomZone;
                fmt.insererChampSaisie((Writer)out, infoBean, nomDonnee, optionModification, 10, nbCarMin, nbCarMax, format);
                this.insererFckToolbox(out, infoBean, nomDonnee, 600, 250, typeToolbar, autorisations, stylePageLibre, isencadre, styleStandart);
            }
            this.insererFinChamp(out);
        }
    }

    public void insererToolbox(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int nbCarMax, String nomZone) throws IOException {
        this.insererEditeurHTML(fmt, out, infoBean, nomDonnee, optionModification, 5, 0, nbCarMax, nomZone, false, false, false);
    }

    private void insererEnteteChamp(JspWriter out, String nomDonnee, String nomZone) throws IOException {
        this.insererEnteteChamp(out, nomDonnee, nomZone, 1);
    }

    private void insererEnteteChamp(JspWriter out, String nomDonnee, String nomZone, int optionModification) throws IOException {
        if (optionModification == 2) {
            nomZone = nomZone + " (*)";
        }
        if (nomZone.indexOf("TRI_") != -1) {
            nomZone = nomZone.substring(0, nomZone.indexOf("TRI_"));
        }
        out.println("<p>");
        if (nomZone.length() > 0) {
            switch (optionModification) {
                case 0: {
                    out.println("<span class=\"label colonne\">" + nomZone + "</span>");
                    break;
                }
                default: {
                    out.println("<label for=\"" + nomDonnee + "\" class=\"colonne\"> " + nomZone + "</label>");
                }
            }
        }
    }

    @Deprecated
    private void insererFinChamp(JspWriter out) throws IOException {
        out.println("</p>");
    }

    public void insererImage(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws IOException {
        out.println("   <div id=\"layerphoto\"><img src=\"" + EscapeString.escapeHtml(infoBean.getString(nomDonnee + "_URL")) + "\" width=\"150\" ></div> ");
        fmt.insererChampSaisie((Writer)out, infoBean, nomDonnee + "_FICHIER", optionModification, 9, 10, 30);
    }

    public void insererSaisieStructure(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws Exception {
        if (optionModification != -1 && ReferentielObjets.getNombreObjetsTypeStructure() != 0) {
            this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        }
        this.insererContenuSaisieStructure(fmt, out, infoBean, nomDonnee, optionModification, nomZone);
        if (optionModification != -1 && ReferentielObjets.getNombreObjetsTypeStructure() != 0) {
            this.insererFinChamp(out);
        }
    }

    public void insererChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone, String _format) throws IOException {
        this.insererChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nomZone, _format, true);
    }

    public void insererChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone, String _format, boolean afficheCal) throws IOException {
        this.insererChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nbCarMax, nomZone, _format, afficheCal, "");
    }

    public void insererChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone, String _format, boolean afficheCal, String nomImage) throws IOException {
        this.insererChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nbCarMax, nomZone, _format, afficheCal, nomImage);
    }

    public void insererChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, int size, String nomZone, String _format, boolean afficheCal, String nomImage) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        this.insererContenuChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, size, nomZone, _format, afficheCal, nomImage);
        this.insererFinChamp(out);
    }

    public void insererContenuChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone, String _format, boolean afficheCal, String nomImage) throws IOException {
        this.insererContenuChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nbCarMax, nomZone, _format, afficheCal, nomImage);
    }

    public void insererContenuChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, int size, String nomZone, String _format, boolean afficheCal, String nomImage) throws IOException {
        if (optionModification == -1) {
            return;
        }
        String format = "LIB=" + nomZone;
        if (_format.length() > 0) {
            format = _format + "," + format;
        }
        fmt.insererChampSaisie((Writer)out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, size, format);
    }

    public void insererContenuChampSaisie(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String nomZone) throws IOException {
        this.insererContenuChampSaisie(fmt, out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nomZone, "", true, "");
    }

    public void insererContenuSaisieListeDebut(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, int typeListe) throws IOException {
        if (optionModification != -1 && optionModification != 0) {
            String res = "";
            String value = "";
            if (infoBean.get(nomDonnee) != null) {
                value = infoBean.getString(nomDonnee);
            }
            String libelle = "";
            if (infoBean.get("LIBELLE_" + nomDonnee) != null) {
                libelle = infoBean.getString("LIBELLE_" + nomDonnee);
            }
            String infoBulle = "";
            if (infoBean.get("INFOBULLE_" + nomDonnee) != null) {
                infoBulle = infoBean.getString("INFOBULLE_" + nomDonnee);
            }
            if (infoBulle.length() == 0) {
                if (nomDonnee.equals("RUBRIQUE_PUBLICATION") || nomDonnee.equals("CODE_RATTACHEMENT_AUTRES") || nomDonnee.equals("PUBLIC_VISE_DSI") || nomDonnee.equals("PUBLIC_VISE_DSI_RESTRICTION") || nomDonnee.equals("SERVICE_PUBLIC_VISE_DSI") || nomDonnee.equals("SERVICE_PUBLIC_VISE_DSI_RESTRICTION") || nomDonnee.equals("GROUPES_DSI") || nomDonnee.equals("GROUPE_DSI") || nomDonnee.equals("GROUPES")) {
                    StringTokenizer st = new StringTokenizer(value, ";");
                    while (st.hasMoreElements()) {
                        if (infoBulle.length() > 0) {
                            infoBulle = infoBulle + ";";
                        }
                        if (nomDonnee.equals("RUBRIQUE_PUBLICATION")) {
                            infoBulle = infoBulle + Rubrique.getFilAriane(st.nextToken(), " > ");
                            continue;
                        }
                        if (nomDonnee.equals("CODE_RATTACHEMENT_AUTRES")) {
                            infoBulle = infoBulle + Structure.getFilAriane(st.nextToken(), " > ");
                            continue;
                        }
                        infoBulle = infoBulle + Groupedsi.getFilAriane(st.nextToken(), " > ");
                    }
                } else {
                    infoBulle = libelle;
                }
            }
            res = res + "<!-- DEBUT GESTION LISTE " + nomDonnee + " -->\n";
            res = res + "<input type=\"hidden\" name=\"" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(value) + "\"/>\n";
            res = res + "<input type=\"hidden\" name=\"LIBELLE_" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(libelle) + "\"/>\n";
            res = res + "<input type=\"hidden\" name=\"INFOBULLE_" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(infoBulle) + "\"/>\n";
            out.println(res);
        }
    }

    public void insererContenuSaisieListeFin(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, int typeListe) throws IOException {
        if (optionModification != -1 && optionModification != 0) {
            String res = "";
            res = res + "</td>\n";
            res = res + "<td>";
            res = res + "<a href=\"#\" title=\"Ajouter l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\" onclick=\"oMultivalueField" + nomDonnee + ".Add(); return false;\"><img src=\"/adminsite/images/add_icon.gif\" alt=\"Ajouter l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\"  /></a>\n";
            res = res + "<br />\n";
            if (infoBean.get(nomDonnee + "_MODIFICATION") != null) {
                res = res + "<a href=\"#\" title=\"Modifier l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\" onclick=\"oMultivalueField" + nomDonnee + ".Modify(); return false;\"><img src=\"/adminsite/images/modify_icon.gif\" alt=\"Modifier l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\"  /></a>\n";
                res = res + "<br />\n";
            }
            res = res + "<a href=\"#\" title=\"Supprimer l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\" onclick=\"oMultivalueField" + nomDonnee + ".Remove(); return false;\"><img src=\"/adminsite/images/remove_icon.gif\" alt=\"Supprimer l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\"  /></a>\n";
            res = res + "</td>\n";
            res = "1".equals(infoBean.get("ZONE_LARGE")) ? res + "<td>\n" : res + "<td>\n";
            if (nomZone.length() > 0) {
                res = res + "<label for=\"SELECT_" + nomDonnee + "\" value=\"" + nomZone + "\">\n";
            }
            res = res + "<select name=\"SELECT_" + nomDonnee + "\" size=\"5\" class=\"multivalue\" style=\"width:100%;min-width:100px;\" onchange=\"oMultivalueField" + nomDonnee + ".SelectItem();\">\n";
            res = res + "</select>\n";
            res = res + "</td>\n";
            res = res + "<td >";
            res = res + "<a href=\"#\" title=\"Remonter l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\" onclick=\"oMultivalueField" + nomDonnee + ".MoveUp(); return false;\"><img src=\"/adminsite/images/fhaut.gif\" alt=\"Remonter\"  /></a>\n";
            res = res + "<br />\n";
            res = res + "<a href=\"#\" title=\"Descendre l'\u00e9l\u00e9ment s\u00e9lectionn\u00e9\" onclick=\"oMultivalueField" + nomDonnee + ".MoveDown(); return false;\"><img src=\"/adminsite/images/fbas.gif\" alt=\"Descendre\"  /></a>\n";
            res = res + "</td>\n";
            res = res + "</tr>\n";
            res = res + "</table>\n";
            res = res + "<script type=\"text/javascript\">\n";
            res = res + "    var oMultivalueField" + nomDonnee + " = new MultivalueField(window.document.forms[0], '" + nomDonnee + "', " + typeListe + ");\n";
            res = res + "    oMultivalueField" + nomDonnee + ".Init();\n";
            res = res + "</script>\n";
            res = res + "<!-- FIN GESTION LISTE " + nomDonnee + " -->\n";
            out.println(res);
        }
    }

    public void insererListeFichiersGw(JspWriter out, InfoBean infoBean, String nomZone, String bouton1, String modeFichier, String nomForm) throws IOException {
        this.insererEnteteChamp(out, "", nomZone);
        this.insererContenuListeFichiersGw(out, infoBean, bouton1, modeFichier, nomForm, "1/1", 1, "Liste de fichier");
        this.insererFinChamp(out);
    }

    public void insererContenuListeFichiersGw(JspWriter out, InfoBean infoBean, String bouton1, String modeFichier, String nomForm) throws IOException {
        this.insererContenuListeFichiersGw(out, infoBean, bouton1, modeFichier, nomForm, "1/1", 1, "Liste de fichier");
    }

    public void insererContenuListeFichiersGw(JspWriter out, InfoBean infoBean, String bouton1, String modeFichier, String nomForm, String indice, int optionModification, String nomZone) throws IOException {
        String nomDonnee = "FICHIER_MULTIPLE";
        String[] itemIndice = indice.split("/", -2);
        if (itemIndice.length == 2) {
            indice = itemIndice[0];
            String nombreFichier = itemIndice[1];
            String valeur = "";
            int nbFichiers = 0;
            if (infoBean.getString("TOTAL_FICHIER_MULTIPLE_" + indice) != null) {
                valeur = infoBean.getString("TOTAL_FICHIER_MULTIPLE_" + indice);
            }
            out.println("<div id=\"liste-fichier-" + indice + "\" class=\"liste-fichier\">");
            out.println("<table id=\"inner-fichier-" + indice + "\">");
            out.println("<script type=\"text/javascript\">");
            if (StringUtils.isNotEmpty((CharSequence)infoBean.getString("MAX_FILE_SIZE"))) {
                out.println("maxFileSize = '" + infoBean.getString("MAX_FILE_SIZE") + "';");
            }
            out.println("indiceForm = '" + nomForm.replaceAll("'", "\\\\'") + "';");
            out.println("libelleFichierMulti=\"FICHIER_MULTIPLE\"");
            out.println("arrayFichierMulti[" + indice + "]= new Array();");
            if (valeur.length() > 0) {
                int j = 0;
                for (String fichierTab : StringUtils.split((String)valeur, (char)'|')) {
                    String[] fichierItem = fichierTab.split(";", -2);
                    out.println("arrayFichierMulti[" + indice + "][" + j + "]= new Fichier('" + fichierItem[0] + "','" + EscapeString.escapeJavaScript(fichierItem[1]) + "','" + EscapeString.escapeJavaScript(fichierItem[2]) + "','" + EscapeString.escapeJavaScript(fichierItem[3]) + "','" + EscapeString.escapeJavaScript(fichierItem[4]) + "');");
                    ++nbFichiers;
                    ++j;
                }
            }
            out.println("</script>");
            out.println("</table>");
            String saisie = "";
            if (infoBean.get("SAISIE_FRONT") != null) {
                saisie = "&amp;SAISIE_FRONT=true";
            }
            out.println(String.format("<input type=\"button\" class=\"submit\" value=\"%s\" onclick=\"ajouterFichier('%s','multi','%s');\" />", bouton1, indice, saisie));
            out.println("</div>");
            out.println("<input type=\"hidden\" name=\"#FORMAT_TOTAL_FICHIER_MULTIPLE_" + indice + "\" value=\"" + optionModification + ";;;;LIB=" + nomZone + ";\" />");
            out.println("<input type=\"hidden\" name=\"TOTAL_FICHIER_MULTIPLE_" + indice + "\" value=\"" + EscapeString.escapeHtml(valeur) + "\" />");
            out.println("<input type=\"hidden\" name=\"NB_FICHIER_MULTIPLE_" + indice + "\" value=\"" + nbFichiers + "\" />");
            out.println("<input type=\"hidden\" name=\"NO_FICHIER_MULTIPLE_" + indice + "\" value=\"\" />");
            out.println("<input type=\"hidden\" name=\"MODE_FICHIER_MULTIPLE_" + indice + "\" value=\"" + modeFichier + "\" />");
            out.println("<input type=\"hidden\" name=\"NB_FICHIER_MULTIPLE\" value=\"" + nombreFichier + "\"/>");
            out.println("<script type=\"text/javascript\">affichageFichier('" + indice + "');</script>");
        }
    }

    public void insererSaisieFichierGw(JspWriter out, InfoBean infoBean, String nomZone, String modeFichier, String nomForm, String indice) throws IOException {
        this.insererEnteteChamp(out, "", nomZone);
        this.insererContenuSaisieFichierGw(out, infoBean, modeFichier, nomForm, indice);
        this.insererFinChamp(out);
    }

    public void insererSaisieFichierGw(JspWriter out, InfoBean infoBean, String nomDonnee, String nomZone, String modeFichier, String nomForm, String indice) throws IOException {
        this.insererEnteteChamp(out, nomDonnee, nomZone);
        this.insererContenuSaisieFichierGw(out, infoBean, nomDonnee, modeFichier, nomForm, indice, 1, "Fichier");
        this.insererFinChamp(out);
    }

    public void insererSaisieFichierGw(JspWriter out, InfoBean infoBean, String nomZone, String modeFichier, String nomForm) throws IOException {
        this.insererEnteteChamp(out, "", nomZone);
        this.insererContenuSaisieFichierGw(out, infoBean, modeFichier, nomForm, "1/1");
        this.insererFinChamp(out);
    }

    public void insererContenuSaisieFichierGw(JspWriter out, InfoBean infoBean, String modeFichier, String nomForm) throws IOException {
        this.insererContenuSaisieFichierGw(out, infoBean, modeFichier, nomForm, "1/1");
    }

    public void insererContenuSaisieFichierGw(JspWriter out, InfoBean infoBean, String modeFichier, String nomForm, String indice) throws IOException {
        this.insererContenuSaisieFichierGw(out, infoBean, "", modeFichier, nomForm, indice, 1, "Fichier");
    }

    public void insererContenuSaisieFichierGw(JspWriter out, InfoBean infoBean, String nomDonnee, String modeFichier, String nomForm, String indice, int optionModification, String nomZone) throws IOException {
        String[] itemIndice = indice.split("/", -2);
        if (nomDonnee.length() == 0) {
            nomDonnee = "FICHIER_UNIQUE";
        }
        if (itemIndice.length == 2) {
            indice = itemIndice[0];
            String nombreFichier = itemIndice[1];
            String fichier = "";
            String libelle = MessageHelper.getCoreMessage("JTF_CLIQUER_PARCOURIR");
            String saisie = "";
            if (infoBean.get("SAISIE_FRONT") != null) {
                saisie = "&amp;SAISIE_FRONT=true";
            }
            String valeur = "";
            if (infoBean.getString(nomDonnee + "_" + indice) != null) {
                valeur = infoBean.getString(nomDonnee + "_" + indice);
            }
            out.println("<script type=\"text/javascript\">");
            if (infoBean.get("ESPACE") != null) {
                out.println("espace = '" + ((String)infoBean.get("ESPACE")).replaceAll("'", "\\\\'") + "';");
            }
            if (StringUtils.isNotEmpty((CharSequence)infoBean.getString("MAX_FILE_SIZE"))) {
                out.println("maxFileSize = '" + infoBean.getString("MAX_FILE_SIZE") + "';");
            }
            out.println("indiceForm = '" + nomForm.replaceAll("'", "\\\\'") + "';");
            out.println("libelleFichierUnique=\"" + nomDonnee + "\"");
            if (valeur.length() > 0) {
                String[] fichierItem = valeur.split(";", -2);
                out.println("arrayFichierUnique[" + indice + "] = new Fichier('" + fichierItem[0] + "','" + Chaine.escapeJavaScript(fichierItem[1]) + "','" + Chaine.escapeJavaScript(fichierItem[2]) + "', '" + Chaine.escapeJavaScript(fichierItem[3]) + "','" + fichierItem[4] + "');");
                fichier = EscapeString.escapeHtml(valeur);
                libelle = EscapeString.escapeHtml(infoBean.getString("LIBELLE_" + nomDonnee + "_" + indice));
            }
            out.println("</script>");
            out.println("<input type=\"hidden\" name=\"#FORMAT_" + nomDonnee + "_" + indice + "\" value=\"" + optionModification + ";;;;LIB=" + nomZone + ";\" />");
            out.println("<input type=\"hidden\" name=\"" + nomDonnee + "_" + indice + "\" value=\"" + fichier + "\" />");
            out.println("<input type=\"hidden\" name=\"MODE_" + nomDonnee + "_" + indice + "\" value=\"" + modeFichier + "\" />");
            out.println("<input type=\"hidden\" name=\"NB_" + nomDonnee + "\" value=\"" + nombreFichier + "\"/>");
            out.println("<input type=\"text\" readonly=\"readonly\" name=\"LIBELLE_" + nomDonnee + "_" + indice + "\" value=\"" + libelle + "\"/>");
            out.println("<input type=\"button\" class=\"submit\" value=\"" + MessageHelper.getCoreMessage("JTF_BOUTON_PARCOURIR") + "\" onclick=\"ajouterFichier('" + indice + "','unique','" + saisie + "');\"/>");
            out.println("<input type=\"button\" class=\"reset\" value=\"" + MessageHelper.getCoreMessage("JTF_BOUTON_EFFACER") + "\" onclick=\"effacerFichier(" + indice + ");\"/>");
        }
    }

    @Deprecated
    public void insererContenuSaisieCouleur(JspWriter out, InfoBean infoBean, String champ1, String champ2, String nomForm) throws IOException {
        String codeCouleur = "";
        if (infoBean.get(champ1) != null) {
            codeCouleur = EscapeString.escapeHtml((String)infoBean.get(champ1));
            out.println("<input type=\"color\" name=\"" + champ1 + "\" value=\"" + codeCouleur + "\" />");
        }
    }

    public void insererToolboxGw(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int nbCarMax, String nomZone, int width) throws IOException {
        this.insererToolboxGw(fmt, out, infoBean, nomDonnee, optionModification, nbCarMax, nomZone, width, "Collaboratif");
    }

    public void insererToolboxGw(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, int nbCarMax, String nomZone, int width, String toolbar) throws IOException {
        HttpSession session = infoBean.getSessionHttp();
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
        Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
        AutorisationBean autorisations = (AutorisationBean)infosSession.get("AUTORISATIONS");
        fmt.insererChampSaisie((Writer)out, infoBean, nomDonnee, optionModification, 10, 0, nbCarMax, "APPLET_HTML=1,CODE_HTML=1,LIB=" + nomZone);
        this.insererFckToolbox(out, infoBean, nomDonnee, width, 250, toolbar, autorisations, false, false, false);
    }

    public void insererSaisieDossierGw(JspWriter out, InfoBean infoBean, String nomForm) throws Exception {
        out.println("<script type=\"text/javascript\">");
        out.println("var indiceForm = '" + nomForm + "'; ");
        for (int i = 0; i < infoBean.getInt("NB_DOSSIERS_GW"); ++i) {
            out.println("var fic = new Dossiergw('" + EscapeString.escapeJavaScript(infoBean.getString("ID_DOSSIER_GW#" + i)) + "','" + EscapeString.escapeJavaScript(infoBean.getString("CODE_DOSSIER_GW#" + i)) + "','" + EscapeString.escapeJavaScript(infoBean.getString("PARENT_DOSSIER_GW#" + i)) + "','" + EscapeString.escapeJavaScript(infoBean.getString("NOM_DOSSIER_GW#" + i).replaceAll("'", "\\\\'")) + "','" + EscapeString.escapeJavaScript(infoBean.getString("PATH_DOSSIER_GW#" + i)) + "');");
            out.println("arrayDossiergw[" + i + "]=fic;");
        }
        out.println("</script>");
        if (!infoBean.getString("DOSSIER").equals("0") && !infoBean.getString("DOSSIER").equals("")) {
            String nomDossier = EscapeString.escapeHtml(infoBean.getString("NOM_DOSSIER"));
            out.println("<input type=\"text\" readonly name=\"LIBELLE_DOSSIER\" value=\"" + nomDossier + "\" size=\"30\" />");
            out.println("<input type=\"hidden\" name=\"NOM_DOSSIER\" value=\"" + nomDossier + "\" />");
            out.println("<input type=\"hidden\" name=\"DOSSIER\" value=\"" + EscapeString.escapeHtml(infoBean.getString("DOSSIER")) + "\" />");
        } else {
            out.println("<input type=\"text\" readonly name=LIBELLE_DOSSIER value=\"Racine (par d\u00e9faut)\" size=\"30\" />");
            out.println("<input type=\"hidden\" name=\"NOM_DOSSIER\" value=\"\" />");
            out.println("<input type=\"hidden\" name=\"DOSSIER\" value=\"\" />");
        }
        String nomObjet = "";
        String idObjet = "";
        String espace = "";
        if (infoBean.get("CODE_OBJET") != null && (nomObjet = ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET")).toUpperCase()) != null && nomObjet.length() > 0 && infoBean.get("ID_" + nomObjet.toUpperCase()) != null) {
            idObjet = EscapeString.escapeJavaScript(infoBean.getString("ID_" + nomObjet.toUpperCase()));
        }
        if (infoBean.get("ESPACE") != null) {
            espace = EscapeString.escapeJavaScript(infoBean.getString("ESPACE"));
        }
        out.println("<input type=\"button\" class=\"button\" value=\"Parcourir\" onclick=\"visualiserDossiergw('" + idObjet + "','" + nomObjet + "','" + espace + "');\" />");
        out.println("<input type=\"hidden\" name=\"TOTAL_DOSSIER\" value='' />");
        out.println("<input type=\"hidden\" name=\"NB_DOSSIERS\" value=\"" + (infoBean.getInt("NB_DOSSIERS_GW") + 1) + "\" />");
    }

    public void insererDtreeDossierGw(JspWriter out, InfoBean infoBean, String bouton, String nomForm) throws IOException {
        this.insererDtreeDossierGw(out, infoBean, bouton, nomForm, "");
    }

    public void insererDtreeDossierGw(JspWriter out, InfoBean infoBean, String bouton, String nomForm, String url) throws IOException {
        int i = 0;
        out.println("<div id=\"dtree\">");
        out.println("<script type=\"text/javascript\">");
        out.println("var espacedoc = '" + EscapeString.escapeJavaScript(infoBean.getString("ESPACE")).replaceAll("'", "\\\\'") + "';");
        String nomEspace = "";
        if (infoBean.get("NOM_ESPACE") != null) {
            nomEspace = EscapeString.escapeJavaScript(infoBean.getString("NOM_ESPACE")).replaceAll("'", "\\\\'");
        }
        out.println("var nomEspace = '" + nomEspace + "';");
        out.println("var documentgw = '" + infoBean.get("ID_DOCUMENTGW") + "';");
        out.println("var indiceForm = '" + nomForm + "'; ");
        if (infoBean.get("NB_DOSSIERS_GW") != null) {
            for (i = 0; i < infoBean.getInt("NB_DOSSIERS_GW"); ++i) {
                out.println("var fic = new Dossiergw('" + EscapeString.escapeJavaScript(infoBean.getString("ID_DOSSIER_GW#" + i)) + "','" + EscapeString.escapeJavaScript(infoBean.getString("CODE_DOSSIER_GW#" + i)) + "','" + EscapeString.escapeJavaScript(infoBean.getString("PARENT_DOSSIER_GW#" + i)) + "','" + EscapeString.escapeJavaScript(infoBean.getString("NOM_DOSSIER_GW#" + i).replaceAll("'", "\\\\'")) + "','" + EscapeString.escapeJavaScript(infoBean.getString("CODE_ESPACE_GW#" + i)) + "');");
                out.println("arrayDossiergw[" + i + "]=fic;");
            }
        }
        out.println("affichageDtreeDossiergw('" + url + "');");
        out.println("</script>");
        out.println("<input type=\"hidden\" name=\"TOTAL_DOSSIER\" value='' />");
        out.println("<input type=\"hidden\" name=\"NB_DOSSIER\" value='" + i + "' />");
        out.println("<input type=\"hidden\" name=\"NO_DOSSIER\" value='' />");
        out.println("</div>");
    }

    public void insererComboHashtable(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomHashtable, String nomZone, String tri) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        this.insererContenuComboHashtable(fmt, out, infoBean, nomDonnee, optionModification, nomHashtable, nomZone, tri);
        this.insererFinChamp(out);
    }

    public void insererContenuComboHashtable(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomHashtable, String nomZone, String tri) {
        fmt.insererComboHashtable((Writer)out, infoBean, nomDonnee, optionModification, nomHashtable, "8pt,LIB=" + nomZone + ",TRI=" + tri);
    }

    public void insererContenuSaisieZone(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomFonctionPopUp) throws IOException {
        String szTmp;
        if (optionModification == -1) {
            return;
        }
        String res = "";
        String libelle = "";
        if (infoBean.get("LIBELLE_" + nomDonnee) != null) {
            libelle = infoBean.getString("LIBELLE_" + nomDonnee);
        }
        String infoBulle = "";
        if (infoBean.get("INFOBULLE_" + nomDonnee) != null) {
            infoBulle = infoBean.getString("INFOBULLE_" + nomDonnee);
        }
        String value = "";
        if (infoBean.get(nomDonnee) != null) {
            value = infoBean.getString(nomDonnee);
        }
        if ((szTmp = nomDonnee).startsWith("TMP_")) {
            szTmp = szTmp.substring(4);
        }
        if (optionModification != 0) {
            boolean arbre;
            int indice = fmt.getIndiceChamp();
            res = res + "<input type=\"hidden\" name=\"#FORMAT_" + szTmp + "\" value=\"" + optionModification + ";" + 0 + ";" + 0 + ";" + 0 + ";LIB=" + nomZone + ";" + indice++ + "\" />";
            fmt.setIndiceChamp(indice);
            String libelleBoutonPopup = MessageHelper.getCoreMessage("JTF_BOUTON_CHERCHER");
            String libelleParDefaut = MessageHelper.getCoreMessage("JTF_CLIQUER_CHERCHER");
            boolean bl = arbre = nomFonctionPopUp.startsWith("rub") || nomFonctionPopUp.startsWith("groupe") || nomFonctionPopUp.startsWith("public");
            if (arbre) {
                libelleBoutonPopup = MessageHelper.getMessage(infoBean.getNomExtension(), "JTF_BOUTON_PARCOURIR");
                libelleParDefaut = MessageHelper.getCoreMessage("JTF_CLIQUER_PARCOURIR");
                if (value.length() > 0) {
                    if (nomFonctionPopUp.startsWith("rub")) {
                        infoBulle = Rubrique.getFilAriane(value, ">");
                    } else if (nomFonctionPopUp.startsWith("groupe") || nomFonctionPopUp.startsWith("public")) {
                        infoBulle = Groupedsi.getFilAriane(value, ">");
                    }
                }
            }
            if (infoBulle.length() == 0) {
                infoBulle = libelle;
            }
            res = res + "<input type=\"hidden\" name=\"" + nomDonnee;
            res = res + "\" value=\"" + value;
            res = res + "\" />";
            if (libelle.equals("-") || libelle.equals("")) {
                libelle = libelleParDefaut;
            }
            String size = "30";
            if ("1".equals(infoBean.get("ZONE_LARGE"))) {
                size = "25";
            }
            res = res + "<input type=\"text\" readonly=\"readonly\" name=\"LIBELLE_" + nomDonnee + "\" size=\"" + size + "\" value=\"" + EscapeString.escapeAttributHtml(libelle) + "\" title=\"" + EscapeString.escapeAttributHtml(infoBulle) + "\" />";
            if (nomFonctionPopUp.toLowerCase().startsWith("saisie_")) {
                res = res + "<input type=\"button\" class=\"button\" value=\"" + libelleBoutonPopup + "\" onclick=\"ouvrirFenetreRechercheParProcessus('" + infoBean.getNomExtension() + "','" + nomFonctionPopUp.toUpperCase() + "','" + nomDonnee + "','LIBELLE_" + nomDonnee + "');\"/> ";
            } else {
                String typeAide = nomFonctionPopUp.toLowerCase();
                if (typeAide.startsWith("rubbo")) {
                    typeAide = nomFonctionPopUp;
                } else if (typeAide.equals("rubrique") && infoBean.get("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE") != null && infoBean.getString("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE").equals(nomDonnee)) {
                    String action;
                    String objet;
                    String type = infoBean.getString("GRS_PERMISSION_TYPE");
                    if (type == null) {
                        type = "";
                    }
                    if ((objet = infoBean.getString("GRS_PERMISSION_OBJET")) == null) {
                        objet = "";
                    }
                    if ((action = infoBean.getString("GRS_PERMISSION_ACTION")) == null) {
                        action = "";
                    }
                    if (!("".equals(type) || "".equals(objet) || "".equals(action) && !"acp".equals(objet))) {
                        typeAide = "rubbo/" + type + "/" + objet + "/" + action + "/";
                    }
                }
                res = res + "<input type=\"button\" class=\"button\" value=\"" + libelleBoutonPopup + "\" onclick=\"showMessageField('" + typeAide + "','" + nomDonnee + "','LIBELLE_" + nomDonnee + "');\" /> ";
            }
            if (optionModification == 1) {
                res = res + "<input type=\"button\" class=\"button\" value=\"Effacer\" onclick=\"effacerTextField('" + nomDonnee + "','LIBELLE_" + nomDonnee + "','','" + libelleParDefaut + "');\"/> ";
            }
        } else {
            fmt.insererChampSaisie((Writer)out, infoBean, "LIBELLE_" + szTmp, 0, 0, 0, 0);
        }
        out.println(res);
    }

    public void insererSaisieListeDebut(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, int typeListe) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        this.insererContenuSaisieListeDebut(fmt, out, infoBean, nomDonnee, optionModification, nomZone, typeListe);
    }

    public void insererSaisieListeFin(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, int typeListe) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererContenuSaisieListeFin(fmt, out, infoBean, nomDonnee, optionModification, nomZone, typeListe);
        this.insererFinChamp(out);
    }

    public void insererSaisieZone(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomFonctionPopUp) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        this.insererContenuSaisieZone(fmt, out, infoBean, nomDonnee, optionModification, nomZone, nomFonctionPopUp);
        this.insererFinChamp(out);
    }

    public void insererContenuSaisieGroupeDsi(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws IOException {
        this.insererContenuSaisieGroupedsi(fmt, out, infoBean, nomDonnee, optionModification, nomZone, 0);
    }

    public void insererContenuSaisiePublicViseDsi(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws IOException {
        this.insererContenuSaisieGroupedsi(fmt, out, infoBean, nomDonnee, optionModification, nomZone, 1);
    }

    private void insererContenuSaisieGroupedsi(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, int typeGroupedsi) throws IOException {
        if (optionModification == -1) {
            return;
        }
        if (optionModification != 0) {
            String libelle = "";
            if (infoBean.get("LIBELLE_" + nomDonnee) != null) {
                libelle = infoBean.getString("LIBELLE_" + nomDonnee);
            }
            String value = "";
            if (infoBean.get(nomDonnee) != null) {
                value = infoBean.getString(nomDonnee);
            }
            String res = "<input type=\"hidden\" name=\"" + nomDonnee;
            res = res + "\" value=\"" + value;
            res = res + "\" />";
            String typeAide = "groupe_dsi";
            if (typeGroupedsi == 1) {
                typeAide = "public_vise_dsi";
            }
            if ("1".equals(infoBean.get("GRS_FILTRE_ARBRE_GROUPE")) || "1".equals(infoBean.get("GRS_FILTRE_ARBRE_GROUPE_" + nomDonnee.toUpperCase()))) {
                String type = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_TYPE");
                String objet = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_OBJET");
                String action = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_ACTION");
                if (type != null && type.length() > 0 && objet != null && objet.length() > 0) {
                    typeAide = "groupebo/";
                    if (typeGroupedsi == 1) {
                        typeAide = "publicbo/";
                    }
                    typeAide = typeAide + type + "/" + objet + "/" + action + "/";
                }
            }
            res = res + "<input type=\"button\" class=\"button\" value=\"Parcourir\" onclick=\"showMessageField('" + typeAide + "','" + nomDonnee + "','LIBELLE_" + nomDonnee + "');\" /> ";
            if (optionModification == 1) {
                res = res + "<input type=\"button\" class=\"button\" value=\"Effacer\" onclick=\"effacerTextField('" + nomDonnee + "','LIBELLE_" + nomDonnee + "','','Cliquer sur parcourir');\"/> ";
            }
            if (libelle.equals("-") || libelle.equals("")) {
                libelle = "Cliquer sur parcourir";
            }
            res = res + "<input type=\"text\" readonly=\"readonly\" name=\"LIBELLE_";
            res = res + nomDonnee;
            res = res + "\" size=\"30\" value=\"";
            res = res + libelle;
            if (value.length() > 0) {
                res = res + "\" title=\"" + Groupedsi.getFilAriane(value, "");
            }
            res = res + "\"/> ";
            out.println(res);
        } else {
            fmt.insererChampSaisie((Writer)out, infoBean, "LIBELLE_" + nomDonnee, 0, 0, 0, 0);
        }
    }

    public void insererSaisieGroupeDsi(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone) throws IOException {
        if (optionModification == -1) {
            return;
        }
        this.insererEnteteChamp(out, nomDonnee, nomZone, optionModification);
        this.insererContenuSaisieGroupeDsi(fmt, out, infoBean, nomDonnee, optionModification, nomZone);
        this.insererFinChamp(out);
    }

    public static boolean estSaisissable(InfoBean infoBean, String nomZone) {
        int mode = UnivFmt.getModeSaisieZone(infoBean, nomZone);
        return mode == 1 || mode == 2;
    }

    public static int getModeRechercheZone(InfoBean infoBean, String nomZone) {
        int mode = 1;
        String s = PropertyHelper.getProperty(infoBean.getNomExtension(), "recherche." + nomZone + ".INVISIBLE");
        if (s != null && s.equals("1")) {
            mode = -1;
        } else {
            s = PropertyHelper.getProperty(infoBean.getNomExtension(), "saisie." + nomZone + ".INVISIBLE");
            if (s != null && s.equals("1")) {
                mode = -1;
            }
        }
        return mode;
    }

    public static int getModeSaisieZone(InfoBean infoBean, String nomZone) {
        int modeSaisieDonneesImportes = -1;
        boolean visible = true;
        boolean modifiable = true;
        boolean obligatoire = false;
        String s = "";
        s = PropertyHelper.getProperty(infoBean.getNomExtension(), "saisie." + nomZone + ".INVISIBLE");
        if (s != null && s.equals("1")) {
            visible = false;
        }
        if ((s = PropertyHelper.getProperty(infoBean.getNomExtension(), "saisie." + nomZone + ".MODIFIABLE")) != null && s.equals("0")) {
            modifiable = false;
        }
        if ((s = PropertyHelper.getProperty(infoBean.getNomExtension(), "saisie." + nomZone + ".FACULTATIF")) != null && s.equals("0")) {
            obligatoire = true;
        }
        if (!visible) {
            return -1;
        }
        if (infoBean.getEtatObjet().equals("CREATION") || infoBean.getActionUtilisateur().equals("DUPLIQUER") || infoBean.getActionUtilisateur().equals("TRADUIRE") || infoBean.get("PREMIERE_ACTION") != null) {
            modeSaisieDonneesImportes = 2;
            if (!obligatoire) {
                modeSaisieDonneesImportes = 1;
            }
        } else if (infoBean.getEtatObjet().equals("MODIFICATION")) {
            modeSaisieDonneesImportes = 0;
            if (modifiable) {
                modeSaisieDonneesImportes = !obligatoire ? 1 : 2;
            }
        }
        return modeSaisieDonneesImportes;
    }

    public static int getModeSaisieCode(InfoBean infoBean) {
        int mode = 2;
        if (infoBean.getEtatObjet().equals("MODIFICATION") && !infoBean.getActionUtilisateur().equals("DUPLIQUER") && !"DUPLIQUER".equals(infoBean.get("PREMIERE_ACTION"))) {
            mode = 0;
        }
        return mode;
    }

    public static boolean isStyleZone(InfoBean infoBean, String nomZone) {
        if ("1".equals(PropertyHelper.getProperty(infoBean.getNomExtension(), "saisie.STYLE"))) {
            return true;
        }
        return "1".equals(PropertyHelper.getProperty(infoBean.getNomExtension(), "saisie." + nomZone + ".STYLE"));
    }

    public static void insererComboSites(ContexteUniv ctx, Writer out, boolean sitesLocaux, boolean sitesDistants, String selectedOption) throws Exception {
        if (sitesDistants || sitesLocaux) {
            String selection = "";
            if (selectedOption.equals("") && ctx.getInfosSite() != null) {
                selectedOption = ctx.getInfosSite().getCodeRubrique();
            }
            out.write("<option value=\"TOUS\">Tous</option>");
            if (sitesLocaux) {
                out.write("<option value=\"\">--------------------</option>");
                Iterator<InfosSite> it = Site.getListeInfosSites().values().iterator();
                InfosSite infosSite = null;
                while (it.hasNext()) {
                    infosSite = it.next();
                    selection = "";
                    if (infosSite.getCodeRubrique().equals(selectedOption)) {
                        selection = "selected=\"selected\"";
                    }
                    out.write("<option value=\"" + infosSite.getAlias() + "\" " + selection + ">" + infosSite.getIntitule() + "</option>");
                }
            }
            if (sitesDistants) {
                RechercheSitesDistants recherche = new RechercheSitesDistants();
                Collection<CibleRecherche> lstCible = recherche.getLstCible();
                Iterator<CibleRecherche> it = lstCible.iterator();
                out.write("<option value=\"\">--------------------</option>");
                while (it.hasNext()) {
                    selection = "";
                    CibleRecherche cible = it.next();
                    if (cible.getCode().equals(selectedOption)) {
                        selection = "selected=\"selected\"";
                    }
                    out.write("<option value=\"" + cible.getCode() + "\" " + selection + ">" + cible.getLibelle() + "</option>\n");
                }
            }
        }
    }

    public static void insererComboObjets(ContexteUniv ctx, Writer out) throws Exception {
        out.write("<option value=\"TOUS\">Dans :</option>");
        out.write("<option value=\"TOUS\">Toutes les fiches</option>");
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            out.write("<option value=\"" + ReferentielObjets.getNomObjet(codeObjet) + "\">" + ReferentielObjets.getLibelleObjet(codeObjet) + "</option>");
        }
    }

    public void insererKmultiSelectLtl(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomHashtable, String format, int context) throws Exception {
        this.insererKmultiSelect(fmt, out, infoBean, nomDonnee, optionModification, nomZone, nomHashtable, format, "ltl", context, "", false);
    }

    public void insererKmultiSelectLtl(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomHashtable, String format, int context, boolean editable) throws Exception {
        this.insererKmultiSelect(fmt, out, infoBean, nomDonnee, optionModification, nomZone, nomHashtable, format, "ltl", context, "", editable);
    }

    public void insererKmultiSelectTtl(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomHashtable, String format, int context, String nomFonctionPopUp) throws Exception {
        this.insererKmultiSelect(fmt, out, infoBean, nomDonnee, optionModification, nomZone, nomHashtable, format, "ttl", context, nomFonctionPopUp, false);
    }

    public void insererKmultiSelectTtl(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomHashtable, String format, int context, String nomFonctionPopUp, boolean editable) throws Exception {
        this.insererKmultiSelect(fmt, out, infoBean, nomDonnee, optionModification, nomZone, nomHashtable, format, "ttl", context, nomFonctionPopUp, editable);
    }

    private void insererKmultiSelect(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomHashtable, String format, String type, int context, String nomFonctionPopUp, boolean editable) throws IOException {
        if (optionModification == -1) {
            return;
        }
        if (optionModification == 0) {
            out.write("<p><span class=\"label colonne\">" + nomZone + "</span>");
            fmt.insererChampSaisie((Writer)out, infoBean, "LIBELLE_" + nomDonnee, 0, 0, 0, 0);
            out.write("</p>");
            return;
        }
        StringBuffer kMultiSelect = new StringBuffer("<div>");
        HashMap<String, String> actionMap = this.genererAction(context, infoBean, nomDonnee, nomFonctionPopUp, false);
        if (StringUtils.isNotBlank((CharSequence)nomZone)) {
            kMultiSelect.append("<strong class=\"label colonne ").append(optionModification == 2 ? "obligatoire" : "").append("\">").append(nomZone).append(optionModification == 2 ? " (*)" : "").append("</strong>");
        }
        kMultiSelect.append("<div id=\"kmultiselect").append(nomDonnee).append("\" class=\"kmultiselect-").append(type).append(optionModification == 0 ? " locked" : "").append(editable ? " editable\" " : "\" ").append("data-addAction=\"").append(actionMap.get("action")).append("\" ").append("data-popintitle=\"LOCALE_BO.popin.title.").append(actionMap.get("title")).append("\" ").append("data-popinwidth=\"").append(actionMap.get("width")).append("\" ").append("data-popinvalidate=\"").append(actionMap.get("validate")).append("\">");
        kMultiSelect.append(fmt.genererHiddenInputs(!type.equals("ltl"), nomDonnee, optionModification, format, infoBean, context));
        if (type.equals("ltl")) {
            TreeMap<Object, Object> table = new TreeMap();
            Locale localeCourante = ContexteUtil.getContexteUniv().getLocale();
            switch (context) {
                case 6: {
                    Collection<InfosStructure> listeStructures = Structure.renvoyerItemStructure("00").getListeSousStructuresTousNiveaux();
                    Iterator<InfosStructure> it = listeStructures.iterator();
                    String indiceLocale = String.valueOf(LangueUtil.getIndiceLocale(localeCourante));
                    String libelleFiche = "";
                    while (it.hasNext()) {
                        InfosStructure infosSt = it.next();
                        libelleFiche = infosSt.getLibelleLong();
                        if (!indiceLocale.equals(infosSt.getLangue())) {
                            libelleFiche = Structure.renvoyerItemStructure(infosSt.getCode(), indiceLocale).getLibelleLong();
                        }
                        if (!infosSt.getAttributSpecifique1().equals("0")) continue;
                        table.put(infosSt.getCode(), libelleFiche);
                    }
                    infoBean.set(nomZone, table);
                    nomHashtable = nomZone;
                    break;
                }
                default: {
                    infoBean.set(nomZone, table);
                }
            }
            Hashtable<String, String> tempTable = (Hashtable<String, String>)infoBean.get(nomHashtable);
            table = tempTable == null ? ((tempTable = CodeLibelle.lireTable(infoBean.getNomExtension(), nomHashtable, localeCourante)) == null ? new TreeMap() : new TreeMap<String, String>(tempTable)) : new TreeMap(tempTable);
            kMultiSelect.append("<div class=\"kscrollable\">");
            kMultiSelect.append("<ul class=\"ui-sortable kmultiselect-list kmultiselect-parent-list\">");
            kMultiSelect.append(fmt.genererListe((Writer)out, infoBean, nomDonnee, optionModification, table, format, context));
            kMultiSelect.append("</ul>");
            kMultiSelect.append("</div>");
        }
        kMultiSelect.append("<div class=\"kscrollable\">");
        kMultiSelect.append("<ul class=\"ui-sortable kmultiselect-list kmultiselect-composition-list\">");
        kMultiSelect.append("</ul>");
        kMultiSelect.append("</div>");
        kMultiSelect.append("</div>");
        kMultiSelect.append("</div>");
        out.println((Object)kMultiSelect);
    }

    public void insererRechercheUtilisateur(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, String nomZone) throws IOException {
        boolean isAutorise;
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        AutorisationBean autorisations = ctx.getAutorisation();
        boolean bl = isAutorise = autorisations != null && (autorisations.possedePermission(ComposantUtilisateur.getPermissionConsultation()) || autorisations.isWebMaster());
        if (isAutorise) {
            this.insererkMonoSelect(fmt, out, infoBean, nomDonnee, 1, nomZone, "utilisateur", 2);
        }
    }

    public void insererkMonoSelect(FormateurJSP fmt, JspWriter out, InfoBean infoBean, String nomDonnee, int optionModification, String nomZone, String nomFonctionPopUp, int context) throws IOException {
        if (optionModification == -1) {
            return;
        }
        if (optionModification == 0) {
            out.write("<p><span class=\"label colonne\">" + nomZone + "</span>");
            fmt.insererChampSaisie((Writer)out, infoBean, "LIBELLE_" + nomDonnee, 0, 0, 0, 0);
            out.write("</p>");
            return;
        }
        String libelle = "";
        if (StringUtils.isNotEmpty((CharSequence)infoBean.getString("LIBELLE_" + nomDonnee))) {
            libelle = infoBean.getString("LIBELLE_" + nomDonnee);
        } else if (StringUtils.isNotEmpty((CharSequence)infoBean.getString(nomDonnee))) {
            libelle = MessageHelper.getCoreMessage("BO_LIBELLE_VIDE");
        }
        String clearable = optionModification == 2 || optionModification == 3 ? " not-clearable" : "";
        StringBuffer kMonoSelect = new StringBuffer("");
        if (!StringUtils.isBlank((CharSequence)nomZone)) {
            kMonoSelect.append("<div>");
            kMonoSelect.append("<span class=\"label colonne" + (optionModification == 2 ? " obligatoire" : " ") + "\">" + nomZone + (optionModification == 2 || optionModification == 3 ? " (*)" : "") + "</span>");
        }
        String placeHolder = context == 4 || context == 3 ? "m" : "f";
        HashMap<String, String> actionMap = this.genererAction(context, infoBean, nomDonnee, nomFonctionPopUp, true);
        kMonoSelect.append("<div id=\"kMonoSelect" + nomDonnee + "\" class=\"kmonoselect" + clearable + "\" data-value=\"" + EscapeString.escapeAttributHtml(libelle) + "\" data-placeholder=\"" + placeHolder + "\" data-editAction=\"" + actionMap.get("action") + "\" data-popintitle=\"LOCALE_BO.popin.title." + actionMap.get("title") + "\" data-popinwidth=\"" + actionMap.get("width") + "\" data-popinvalidate=\"" + actionMap.get("validate") + "\" data-title=\"" + actionMap.get("tip") + "\">");
        kMonoSelect.append(fmt.genererHiddenInputs(false, nomDonnee, optionModification, "LIB=" + nomZone, infoBean, context));
        kMonoSelect.append("</div>");
        if (!StringUtils.isBlank((CharSequence)nomZone)) {
            kMonoSelect.append("</div>");
        }
        out.println((Object)kMonoSelect);
    }

    private HashMap<String, String> genererAction(int context, InfoBean infoBean, String nomDonnee, String params, boolean mono) {
        String finalAction = "";
        String titleAction = "";
        String widthAction = "530";
        String validateAction = "true";
        String tip = "";
        boolean frontOffice = false;
        String recherchePageTeteParURL = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("rubrique.recherchePageTeteParURL"), (String)"0");
        String lg = String.valueOf(LangueUtil.getIndiceLocale(LangueUtil.getDefaultLocale()));
        String langueInfoBean = infoBean.getString("LANGUE");
        String langueFicheInfoBean = infoBean.getString("LANGUE_FICHE");
        if (StringUtils.isNotEmpty((CharSequence)langueFicheInfoBean) && StringUtils.isNumeric((CharSequence)langueFicheInfoBean)) {
            lg = langueFicheInfoBean;
        } else if (StringUtils.isNotEmpty((CharSequence)langueInfoBean) && StringUtils.isNumeric((CharSequence)langueInfoBean)) {
            lg = langueInfoBean;
        }
        if (infoBean.get("SAISIE_FRONT") != null) {
            frontOffice = true;
        }
        switch (context) {
            case 2: {
                String realParams;
                Matcher matcher = selectPattern.matcher(params);
                String string = realParams = matcher.matches() ? matcher.group(2) : params;
                if (realParams.startsWith("saisie_")) {
                    widthAction = "700";
                    titleAction = "objet";
                    validateAction = "false";
                    String param = "";
                    if (realParams.indexOf("&") != -1) {
                        param = StringUtils.substring((String)realParams, (int)realParams.indexOf("&"));
                    }
                    String nomObjet = StringUtils.substring((String)realParams, (int)7, (int)(realParams.length() - param.length()));
                    String codeObjet = ReferentielObjets.getCodeObjet(nomObjet);
                    String extension = ReferentielObjets.getExtension(codeObjet);
                    String proc = ReferentielObjets.getProcessus(codeObjet);
                    finalAction = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + extension + "&PROC=" + EscapeString.escapeJavaScript(proc) + "&ACTION=RECHERCHER&TOOLBOX=LIEN_INTERNE_JOINTURE&LANGUE_FICHE=-1" + param;
                    break;
                }
                if (realParams.startsWith("objet_")) {
                    String toolbox = realParams.substring(6).toUpperCase();
                    validateAction = "false";
                    widthAction = "700";
                    titleAction = "objet";
                    if ("1".equals(recherchePageTeteParURL) && "PAGE_TETE".equals(toolbox)) {
                        finalAction = "/adminsite/template/recherche_back.jsp?TOOLBOX=" + toolbox + "&PAR_URL=1";
                        break;
                    }
                    finalAction = "/adminsite/toolbox/choix_objet.jsp?TOOLBOX=" + toolbox;
                    break;
                }
                titleAction = mono ? "rubrique.mono" : "rubrique.multi";
                String string2 = validateAction = mono ? "false" : "true";
                if (!StringUtils.isBlank((CharSequence)URLS.get(realParams))) {
                    widthAction = "700";
                    titleAction = realParams;
                    finalAction = URLS.get(realParams);
                    break;
                }
                tip = RubriquesJsTree.getPath("", infoBean.getString(nomDonnee), " > ");
                String typeAide = realParams;
                if (typeAide.equals("rubrique")) {
                    finalAction = "/adminsite/tree/tree.jsp?JSTREEBEAN=rubriquesJsTree&DISPLAY=full&SELECTED={0}&CODE={1}&UNBINDED_SELECT=true";
                    if (infoBean.get("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE") == null || !infoBean.getString("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE").equals(nomDonnee)) break;
                    String type = infoBean.getString("GRS_PERMISSION_TYPE");
                    String objet = infoBean.getString("GRS_PERMISSION_OBJET");
                    String action = infoBean.getString("GRS_PERMISSION_ACTION");
                    if (!StringUtils.isNotBlank((CharSequence)type) || !StringUtils.isNotBlank((CharSequence)objet) || !StringUtils.isNotBlank((CharSequence)action) && !objet.equals("acp")) break;
                    typeAide = "/" + type + "/" + objet + "/" + action + "/";
                    finalAction = "/adminsite/tree/tree.jsp?JSTREEBEAN=rubriquesJsTree&DISPLAY=full&SELECTED={0}&CODE={1}&UNBINDED_SELECT=true&PERMISSION=" + typeAide;
                    break;
                }
                typeAide = "/" + realParams;
                finalAction = "/adminsite/tree/tree.jsp?JSTREEBEAN=rubriquesJsTree&DISPLAY=full&SELECTED={0}&CODE={1}&UNBINDED_SELECT=true&PERMISSION=" + typeAide;
                break;
            }
            case 1: {
                finalAction = "/adminsite/tree/tree.jsp?JSTREEBEAN=structuresJsTree&DISPLAY=full&SELECTED={0}&CODE={1}";
                titleAction = mono ? "structure.mono" : "structure.multi";
                validateAction = mono ? "false" : "true";
                tip = StructuresJsTree.getPath("", infoBean.getString(nomDonnee), " > ");
                if (frontOffice) {
                    finalAction = finalAction + "&LANGUE=" + lg;
                    finalAction = finalAction + "&RACINE=" + nomDonnee;
                    finalAction = finalAction + "&FRONT=true";
                    if (infoBean.get("FILTRE_" + nomDonnee) == null) break;
                    finalAction = finalAction + "&FILTRE=" + EscapeString.escapeJavaScript(infoBean.getString("FILTRE_" + nomDonnee));
                    break;
                }
                if (infoBean.getEtatObjet() != null && !infoBean.getEtatObjet().equals("CREATION")) {
                    finalAction = finalAction + "&LANGUE=" + lg;
                }
                String nomDonneeFiltreArbre = nomDonnee;
                if (nomDonnee.startsWith("TMP")) {
                    nomDonneeFiltreArbre = nomDonnee.substring(4);
                }
                if (infoBean.get("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT") != null && infoBean.getString("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT").equals(nomDonneeFiltreArbre) || infoBean.get("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT_AUTRES") != null && infoBean.getString("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT_AUTRES").equals(nomDonneeFiltreArbre)) {
                    String type = infoBean.getString("GRS_PERMISSION_TYPE");
                    String objet = infoBean.getString("GRS_PERMISSION_OBJET");
                    String action = infoBean.getString("GRS_PERMISSION_ACTION");
                    if (!(StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)objet) || StringUtils.isBlank((CharSequence)action))) {
                        finalAction = finalAction + "&PERMISSION=/" + type + "/" + objet + "/" + action + "/";
                    }
                }
                if (infoBean.get("FILTRE_" + nomDonnee) == null) break;
                finalAction = finalAction + "&FILTRE=" + EscapeString.escapeJavaScript(infoBean.getString("FILTRE_" + nomDonnee));
                break;
            }
            case 3: {
                finalAction = "/adminsite/tree/tree.jsp?JSTREEBEAN=groupsJsTree&DISPLAY=full&SELECTED={0}&CODE={1}" + ("lock_dyn".equals(params) ? "&LOCK_DYN=true&UNBINDED_SELECT=true" : "");
                titleAction = mono ? "groupe.mono" : "groupe.multi";
                validateAction = mono ? "false" : "true";
                tip = GroupsJsTree.getPath("", infoBean.getString(nomDonnee), " > ");
                if (!"1".equals(infoBean.get("GRS_FILTRE_ARBRE_GROUPE")) && !"1".equals(infoBean.get("GRS_FILTRE_ARBRE_GROUPE_" + nomDonnee.toUpperCase()))) break;
                String type = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_TYPE");
                String objet = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_OBJET");
                String action = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_ACTION");
                if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)objet)) break;
                finalAction = finalAction + "&PERMISSION=/" + type + "/" + objet + "/" + action + "/";
                break;
            }
            case 4: {
                finalAction = "/adminsite/tree/tree.jsp?JSTREEBEAN=groupsJsTree&DISPLAY=full&SELECTED={0}&CODE={1}&PUBLIC_VISE=1&UNBINDED_SELECT=true";
                titleAction = mono ? "groupe.mono" : "groupe.multi";
                validateAction = mono ? "false" : "true";
                tip = GroupsJsTree.getPath("", infoBean.getString(nomDonnee), " > ");
                if (!"1".equals(infoBean.get("GRS_FILTRE_ARBRE_GROUPE")) && !"1".equals(infoBean.get("GRS_FILTRE_ARBRE_GROUPE_" + nomDonnee.toUpperCase()))) break;
                String type = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_TYPE");
                String objet = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_OBJET");
                String action = infoBean.getString("GRS_FILTRE_ARBRE_GROUPE_ACTION");
                if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)objet)) break;
                finalAction = finalAction + "&PERMISSION=/" + type + "/" + objet + "/" + action + "/";
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("action", EscapeString.escapeAttributHtml(finalAction));
        map.put("title", EscapeString.escapeAttributHtml(titleAction));
        map.put("width", EscapeString.escapeAttributHtml(widthAction));
        map.put("validate", EscapeString.escapeAttributHtml(validateAction));
        map.put("tip", EscapeString.escapeAttributHtml(tip));
        return map;
    }

    static {
        URLS.put("utilisateur", "/servlet/com.jsbsoft.jtf.core.SG?PROC=SAISIE_UTILISATEUR&ACTION=RECHERCHER&MODE=RECHERCHE&TOOLBOX=TRUE");
        URLS.put("pagelibre", "/servlet/com.jsbsoft.jtf.core.SG?PROC=SAISIE_PAGELIBRE&ACTION=RECHERCHER&TOOLBOX=LIEN_INTERNE_JOINTURE&LANGUE_FICHE=0");
        URLS.put("pagelibre_creation", "/servlet/com.jsbsoft.jtf.core.SG?PROC=TRAITEMENT_PAGELIBRE&ACTION=AJOUTER&CODE_RUBRIQUE=LIBELLE_CODE_PAGE_TETE");
    }
}

