/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.identification.SourceAuthClearTrust;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.jsbsoft.jtf.webutils.FormateurHTML;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.FichePageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.kportal.extension.module.plugin.toolbox.PluginTagHelper;
import com.univ.mediatheque.Mediatheque;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.MediaPhoto;
import com.univ.objetspartages.om.PageLibre;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.StructureModele;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.url.FrontOfficeMgr;
import com.univ.url.UrlManager;
import com.univ.utils.CacheUrlWrappedResponse;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.EscapeString;
import com.univ.utils.ExceptionSite;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RechercheFicheHelper;
import com.univ.utils.RequeteUtil;
import com.univ.utils.ServicesUtil;
import com.univ.utils.ToolboxUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.xhtml.HTMLParser;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnivWebFmt
extends FormateurHTML {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnivWebFmt.class);
    public static final String OLD_TAG_URL_LOGIN = "/servlet/[href_logindsi]";
    public static final String TAG_URL_LOGIN = "[href_logindsi]";
    public static final String OLD_TAG_URL_PREF = "/servlet/[href_prefdsi]";
    public static final String TAG_URL_PREF = "[href_prefdsi]";
    public static final String OLD_TAG_URL_LOGOUT = "/servlet/[href_logoutdsi]";
    public static final String TAG_URL_LOGOUT = "[href_logoutdsi]";

    @Deprecated
    public static String getUrlFichierJoint(ContexteUniv ctx, FicheUniv ficheUniv) {
        if (ficheUniv == null) {
            return "";
        }
        return ctx.getInfosSite().getJspFo() + "/saisie/liste_fichiergw.jsp?OBJET=DOCUMENT&amp;CODE=" + ficheUniv.getCode() + "&amp;LANGUE=" + ficheUniv.getLangue();
    }

    public static String getUrlAccueilDsi(ContexteUniv ctx) {
        return UnivWebFmt.getUrlDsi("REVENIR_ACCUEIL", true);
    }

    public static String getUrlDeconnexion(ContexteUniv ctx) {
        return UnivWebFmt.getUrlDeconnexion(ctx, true, true);
    }

    public static String getUrlDeconnexion(ContexteUniv ctx, boolean ampersands) {
        return UnivWebFmt.getUrlDeconnexion(ctx, ampersands, true);
    }

    public static String getUrlDeconnexion(ContexteUniv ctx, boolean ampersands, boolean front) {
        GestionnaireIdentification gI;
        String url = UnivWebFmt.getUrlDsi("DECONNECTER", false);
        if (!front) {
            url = StringUtils.remove((String)url, (String)"_FRONT");
        }
        if ((gI = GestionnaireIdentification.getInstance()).estSourceAuth("cas") && !"".equals(gI.getValidateurCAS().getUrlCasLogoutFront(ctx))) {
            if (front) {
                return gI.getValidateurCAS().getUrlCasLogoutFront(ctx);
            }
            return gI.getValidateurCAS().getUrlCasLogout(ctx);
        }
        if (gI.estSourceAuth("ClearTrust")) {
            SourceAuthClearTrust authCT = (SourceAuthClearTrust)gI.getSourceAuth();
            url = front ? URLResolver.getAbsoluteUrl(url, (OMContext)ctx, 5) : URLResolver.getAbsoluteBoUrl(url, ctx.getInfosSite());
            return authCT.getUrlCtrustLogout(ctx, url);
        }
        if (ctx.getCodeRubriquePageCourante().length() > 0) {
            url = url + "&RH=" + EscapeString.escapeURL(ctx.getCodeRubriquePageCourante());
        }
        if (ampersands) {
            url = StringUtils.replace((String)url, (String)"&", (String)"&amp;");
        }
        return url;
    }

    public static String getUrlPreferences(ContexteUniv ctx) {
        String urlPreferences = UnivWebFmt.getUrlDsi("PERSONNALISER", true);
        if (StringUtils.isNotBlank((CharSequence)ctx.getCodeRubriquePageCourante())) {
            urlPreferences = urlPreferences + "&amp;RH=" + EscapeString.escapeURL(ctx.getCodeRubriquePageCourante());
        }
        return urlPreferences;
    }

    public static String getUrlDemandeMotDePasse(ContexteUniv ctx) {
        String urlDemandeMotDePasse = UnivWebFmt.getUrlDsi("DEMANDER_MDP", true);
        if (StringUtils.isNotBlank((CharSequence)ctx.getCodeRubriquePageCourante())) {
            urlDemandeMotDePasse = urlDemandeMotDePasse + "&amp;RH=" + EscapeString.escapeURL(ctx.getCodeRubriquePageCourante());
        }
        return urlDemandeMotDePasse;
    }

    public static String getUrlLogin(ContexteUniv ctx, boolean ampersands) {
        String url;
        String esperluette = ampersands ? "&amp;" : "&";
        GestionnaireIdentification gI = GestionnaireIdentification.getInstance();
        if (gI.estSourceAuth("cas")) {
            url = gI.getValidateurCAS().getUrlCasLoginFront(ctx);
        } else {
            url = UnivWebFmt.getUrlDsi("CONNECTER", ampersands);
            if (ctx.getCodeRubriquePageCourante().length() > 0) {
                url = url + esperluette + "RH=" + ctx.getCodeRubriquePageCourante();
            }
        }
        return url;
    }

    public static String getUrlConnexion(ContexteUniv ctx) {
        return UnivWebFmt.getUrlLogin(ctx, true);
    }

    public static String getUrlConnexionExterne(HttpServletRequest req, ContexteUniv ctx) {
        GestionnaireIdentification gI = GestionnaireIdentification.getInstance();
        String url = "";
        if (gI.estSourceAuth("cas")) {
            url = gI.getValidateurCAS().getUrlCasLoginFront(ctx);
        } else if (gI.estSourceAuth("ClearTrust")) {
            SourceAuthClearTrust authCT = (SourceAuthClearTrust)gI.getSourceAuth();
            url = URLResolver.getAbsoluteUrl(authCT.getUrlCtrustLogin(ctx), ctx);
        }
        return url;
    }

    private static String getUrlDsi(String action, boolean ampersands) {
        String esperluette = ampersands ? "&amp;" : "&";
        return "/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT" + esperluette + "ACTION=" + action;
    }

    private static void ajouterLienEncadre(ContexteUniv ctx, TreeMap<String, String> onglets, String libelle, String objet, String code) throws Exception {
        onglets.put(libelle.toUpperCase(), "<a href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, objet, code), ctx) + "\">" + libelle + "</a>");
    }

    private static void ajouterOngletEnteteRubrique(ContexteUniv ctx, Object collectionOnglets, InfosRubriques rubrique, int stNav) throws Exception {
        String codeHTML = "";
        String url = UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, rubrique.getCode());
        codeHTML = url.length() == 0 ? rubrique.getOnglet() : "<a href=\"" + URLResolver.getAbsoluteUrl(url, ctx) + "\">" + rubrique.getOnglet() + "</a>";
        if (collectionOnglets instanceof Vector) {
            ((Vector)collectionOnglets).add(0, codeHTML);
        }
        if (collectionOnglets instanceof TreeMap) {
            ((TreeMap)collectionOnglets).put(rubrique.getOnglet(), codeHTML);
        }
    }

    public static String determinerUrlFiche(ContexteUniv ctx, FicheUniv fiche) throws Exception {
        return UnivWebFmt.determinerUrlFiche(ctx, fiche, true);
    }

    public static String determinerUrlFiche(ContexteUniv ctx, FicheUniv fiche, boolean ampersand) throws Exception {
        if (fiche == null) {
            return "";
        }
        String code = ReferentielObjets.getCodeObjetParClasse(fiche.getClass().getName());
        String nomObjet = ReferentielObjets.getNomObjet(code);
        String langue = "";
        if (!fiche.getLangue().equals(LangueUtil.getLangueLocale(ctx.getLocale()))) {
            langue = ",LANGUE=" + fiche.getLangue();
        }
        return UnivWebFmt.determinerUrlFiche(ctx, nomObjet, fiche.getCode() + langue, ampersand);
    }

    public static String determinerUrlFiche(ContexteUniv ctx, String objet, String code) throws Exception {
        return UnivWebFmt.determinerUrlFiche(ctx, objet, code, true);
    }

    public static String determinerUrlFiche(ContexteUniv ctx, String objet, String code, boolean ampersands) throws Exception {
        String esperluette = ampersands ? "&amp;" : "&";
        String urlFiche = "";
        if (StringUtils.isEmpty((CharSequence)code) || StringUtils.contains((CharSequence)code, (CharSequence)"=") && !StringUtils.contains((CharSequence)code, (CharSequence)",LANGUE=")) {
            urlFiche = RechercheFicheHelper.getUrlResults("OBJET=" + objet + "&" + code, "0", ctx.getCodeRubriquePageCourante());
            urlFiche = StringUtils.replace((String)urlFiche, (String)"&", (String)"&amp;");
            if (ctx.getRubriqueExterneConnecteur().length() > 0) {
                urlFiche = urlFiche + esperluette + "RUBNAV=" + EscapeString.escapeURL(ctx.getRubriqueExterneConnecteur());
            }
        } else {
            String codeFiche = "";
            String langueFiche = "";
            if (!StringUtils.contains((CharSequence)code, (CharSequence)",LANGUE=")) {
                codeFiche = code;
                langueFiche = LangueUtil.getLangueLocale(ctx.getLocale());
            } else {
                codeFiche = code.substring(0, code.indexOf(",LANGUE="));
                langueFiche = code.substring(code.indexOf(",LANGUE=") + 8);
            }
            urlFiche = UnivWebFmt.determinerUrlFiche(ctx, objet, codeFiche, langueFiche, ampersands);
        }
        return urlFiche;
    }

    public static String determinerUrlFiche(OMContext ctx, String objet, String codeFiche, String langueFiche, boolean ampersands) throws Exception {
        return UnivWebFmt.determinerUrlFiche(ctx, objet, codeFiche, langueFiche, ampersands, "");
    }

    public static String determinerUrlFiche(OMContext ctx, String objet, String codeFiche, String langueFiche, boolean ampersands, String codeRubriqueForcee) throws Exception {
        String esperluette = ampersands ? "&amp;" : "&";
        String urlFiche = "";
        String rubNav = "";
        String rubHistorique = "";
        if (ctx instanceof ContexteUniv) {
            if (((ContexteUniv)ctx).isGenererLiensInternes() && ((ContexteUniv)ctx).getCodesLiensInternes().contains(objet.toLowerCase() + "/" + codeFiche + "/" + langueFiche)) {
                return "#" + objet.toLowerCase() + "/" + codeFiche + "/" + langueFiche;
            }
            rubNav = ((ContexteUniv)ctx).getRubriqueExterneConnecteur();
            rubHistorique = ((ContexteUniv)ctx).getCodeRubriquePageCourante();
        }
        String codeObjet = ReferentielObjets.getCodeObjet(objet.toLowerCase());
        String params = "";
        if (rubNav.length() > 0) {
            if (params.length() > 0) {
                params = params + esperluette;
            }
            params = params + "RUBNAV=" + EscapeString.escapeURL(rubNav);
        }
        if (rubHistorique.length() > 0) {
            if (params.length() > 0) {
                params = params + esperluette;
            }
            params = params + "RH=" + EscapeString.escapeURL(rubHistorique);
        }
        urlFiche = FrontOfficeMgr.getInstance().getAbsoluteUrlFriendly(ctx, codeObjet, codeFiche, langueFiche, "0003", codeRubriqueForcee, params);
        return urlFiche;
    }

    public static String determinerUrlCanonique(ContexteUniv ctx, FicheUniv fiche) throws Exception {
        if (fiche == null) {
            return "";
        }
        String codeRubriqueFiche = fiche.getCodeRubrique();
        InfosSite siteFiche = null;
        if (StringUtils.isEmpty((CharSequence)codeRubriqueFiche)) {
            siteFiche = Site.getSitePrincipal();
            codeRubriqueFiche = siteFiche.getCodeRubrique();
        } else {
            siteFiche = Site.determinerSiteRubrique(codeRubriqueFiche);
        }
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubriqueFiche);
        String urlFiche = URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(siteFiche, rubrique, ctx.getMetaCourant()), (OMContext)ctx, siteFiche);
        return urlFiche;
    }

    public static String formaterEnHTML(ContexteUniv ctx, String texte) throws Exception {
        return UnivWebFmt.formaterEnHTML(ctx, texte, true);
    }

    public static String formaterEnHTML(ContexteUniv ctx, String texte, boolean formaterEnHtml) throws Exception {
        return UnivWebFmt.formaterEnHTML(ctx, texte, formaterEnHtml, true);
    }

    public static String formaterEnHTML(ContexteUniv ctx, String _texte, boolean formaterEnHtml, boolean handleLinks) throws Exception {
        if (StringUtils.isBlank((CharSequence)_texte)) {
            return _texte;
        }
        int lgBuffer = _texte.length() + 100;
        StringBuffer newTexte = new StringBuffer(lgBuffer);
        String texte = "";
        texte = ToolboxUtil.nettoyerAttributsNonValides(_texte);
        texte = PluginTagHelper.interpreterTags(texte);
        texte = UnivWebFmt.transformerTagsPersonnalisation(ctx, texte);
        int indexTexte = 0;
        int indexDebutMotCle = -1;
        int indexFinMotCle = 0;
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[traitement", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String contenuTag = Chaine.remplacerPointsVirgules(texte.substring(indexDebutMotCle + 1, indexFinMotCle));
            String action = "";
            String paramExit = "";
            String resultatExit = "";
            StringTokenizer st = new StringTokenizer(contenuTag, "*");
            int indiceToken = 0;
            while (st.hasMoreTokens()) {
                String itemTag = st.nextToken();
                if (indiceToken == 1) {
                    action = itemTag;
                }
                if (indiceToken == 2) {
                    paramExit = EscapeString.unescapeHtml(itemTag);
                    paramExit = StringUtils.replace((String)paramExit, (String)"#", (String)"&");
                }
                ++indiceToken;
            }
            if (ctx.getJsp() != null) {
                Class[] params = new Class[]{Class.forName("com.univ.utils.ContexteUniv"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                Class<?> classJSP = ctx.getJsp().getClass();
                Method methodeExit = MethodUtils.getAccessibleMethod((Class)classJSP, (String)"methodeExit", (Class[])params);
                if (methodeExit != null) {
                    Object[] args = new Object[]{ctx, action, paramExit};
                    resultatExit = (String)methodeExit.invoke(ctx.getJsp(), args);
                }
            } else {
                ctx.setCalculListeResultatsFront(true);
                List<ResultatRecherche> listeFiches = RequeteUtil.traiterRequete(ctx, paramExit);
                ctx.setCalculListeResultatsFront(false);
                for (ResultatRecherche res : listeFiches) {
                    FicheUniv fiche = RequeteUtil.lireFiche(res);
                    String urlFiche = UnivWebFmt.determinerUrlFiche(ctx, fiche);
                    resultatExit = resultatExit + "<a href=\"" + URLResolver.getAbsoluteUrl(urlFiche, ctx) + "\" class=\"txtcourant\">" + fiche.getLibelleAffichable() + "</a><br />";
                }
            }
            newTexte.append(resultatExit);
            indexTexte = indexFinMotCle + 1;
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        ArrayList<Media> lstMedia = new ArrayList<Media>();
        while ((indexDebutMotCle = texte.indexOf("[id-image]", indexTexte)) != -1) {
            int indexDebutMotCleSuivant;
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("[/id-image]", indexDebutMotCle);
            if (indexFinMotCle == -1 || (indexDebutMotCleSuivant = texte.indexOf("[id-image]", indexDebutMotCle + 1)) != -1 && indexDebutMotCleSuivant < indexFinMotCle) break;
            String image = texte.substring(indexDebutMotCle + 10, indexFinMotCle);
            String url = "";
            if (image.startsWith("F")) {
                image = image.substring(1);
            }
            Media media = Media.getMedia(new Long(image));
            url = media.getUrlAbsolue();
            if (ctx.getFicheCourante() != null) {
                url = url + (url.contains("?") ? "&amp;" : "?") + "ID_FICHE=" + ctx.getFicheCourante().getIdFiche();
            }
            if (media.isLocal()) {
                newTexte.append(URLResolver.getAbsoluteUrl(url, ctx));
            } else {
                newTexte.append(url);
            }
            indexTexte = indexFinMotCle + 11;
            lstMedia.add(media);
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        for (Media media : lstMedia) {
            texte = texte.replaceAll("\\[legende-image\\]" + media.getIdMedia() + "\\[/legende-image\\]", StringUtils.replace((String)media.getLegende(), (String)"\"", (String)"&#34;"));
            texte = texte.replaceAll("\\[title-image\\]" + media.getIdMedia() + "\\[/title-image\\]", StringUtils.replace((String)media.getTitre(), (String)"\"", (String)"&#34;"));
            String urlVignette = "";
            if (media.getUrlVignetteAbsolue().length() > 0) {
                urlVignette = media.getUrlVignetteAbsolue();
            } else if (Mediatheque.getInstance().getRessource(media.getTypeRessource()) != null) {
                urlVignette = Mediatheque.getInstance().getRessource(media.getTypeRessource()).getUrlVignette();
            }
            texte = texte.replaceAll("\\[vignette-image\\]" + media.getIdMedia() + "\\[/vignette-image\\]", urlVignette);
        }
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[id-fiche]", indexTexte)) != -1) {
            int indexDebutMotCleSuivant;
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("[/id-fiche]", indexDebutMotCle);
            if (indexFinMotCle == -1 || (indexDebutMotCleSuivant = texte.indexOf("[id-fiche]", indexDebutMotCle + 1)) != -1 && indexDebutMotCleSuivant < indexFinMotCle) break;
            int linkTypeStart = texte.indexOf("_linktype=\"", indexFinMotCle) != -1 ? texte.indexOf("_linktype=\"", indexFinMotCle) + "_linktype=\"".length() : -1;
            int linkTypeEnd = linkTypeStart != -1 ? texte.indexOf("\"", linkTypeStart) : -1;
            String linkType = linkTypeStart != -1 && linkTypeEnd != -1 ? texte.substring(linkTypeStart, linkTypeEnd) : "";
            String chaine = texte.substring(indexDebutMotCle + 10, indexFinMotCle);
            String codeFiche = "";
            String objet = "";
            String langueFiche = "";
            StringTokenizer st = new StringTokenizer(chaine, ";");
            for (int indiceToken = 0; st.hasMoreTokens() && indiceToken < 3; ++indiceToken) {
                if (indiceToken == 0) {
                    objet = st.nextToken();
                }
                if (indiceToken == 1) {
                    codeFiche = st.nextToken();
                }
                if (indiceToken != 2) continue;
                langueFiche = st.nextToken();
            }
            String url = "requete".equals(linkType) ? UnivWebFmt.handleRequestLink(ctx, objet, codeFiche) : (StringUtils.isNotBlank((CharSequence)langueFiche) ? UnivWebFmt.determinerUrlFiche(ctx, objet, codeFiche, langueFiche, false) : UnivWebFmt.determinerUrlFiche(ctx, objet, codeFiche));
            if (!ctx.isGenererLiensInternes() || !url.startsWith("#")) {
                url = URLResolver.getAbsoluteUrl(url, ctx);
            }
            newTexte.append(url);
            indexTexte = indexFinMotCle + 11;
            if (texte.charAt(indexTexte) != '?' && texte.charAt(indexTexte) != '&') continue;
            if (url.contains("?")) {
                newTexte.append("&");
            } else {
                newTexte.append("?");
            }
            ++indexTexte;
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[id-rubrique]", indexTexte)) != -1) {
            int indexDebutMotCleSuivant;
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("[/id-rubrique]", indexDebutMotCle);
            if (indexFinMotCle == -1 || (indexDebutMotCleSuivant = texte.indexOf("[id-rubrique]", indexDebutMotCle + 1)) != -1 && indexDebutMotCleSuivant < indexFinMotCle) break;
            String codeRubrique = texte.substring(indexDebutMotCle + 13, indexFinMotCle);
            if (codeRubrique.endsWith("TARGET=BLANK")) {
                codeRubrique = codeRubrique.substring(0, codeRubrique.indexOf("TARGET=BLANK"));
            }
            InfosRubriques rubriqueCourant = Rubrique.renvoyerItemRubrique(codeRubrique);
            String urlRubrique = URLResolver.getAbsoluteUrl(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, codeRubrique), ctx);
            newTexte.append(urlRubrique).append("\" class=\"type_rubrique_").append(rubriqueCourant.getTypeRubrique());
            indexTexte = indexFinMotCle + 14;
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[form-recherche]", indexTexte)) != -1) {
            int indexDebutMotCleSuivant;
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("[/form-recherche]", indexDebutMotCle);
            if (indexFinMotCle == -1 || (indexDebutMotCleSuivant = texte.indexOf("[form-recherche]", indexDebutMotCle + 1)) != -1 && indexDebutMotCleSuivant < indexFinMotCle) break;
            String codeObjet = texte.substring(indexDebutMotCle + 16, indexFinMotCle);
            newTexte.append(URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFormulaire(ctx, codeObjet, ctx.getLangue(), true, ctx.getCodeRubriquePageCourante()), ctx));
            indexTexte = indexFinMotCle + 17;
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[url", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String contenuTag = Chaine.remplacerPointsVirgules(texte.substring(indexDebutMotCle + 1, indexFinMotCle));
            String sUrl = "";
            StringTokenizer st = new StringTokenizer(contenuTag, "*");
            int indiceToken = 0;
            while (st.hasMoreTokens()) {
                String itemTag = st.nextToken();
                if (indiceToken == 1) {
                    sUrl = itemTag;
                }
                ++indiceToken;
            }
            if (sUrl.length() > 0) {
                if (sUrl.charAt(0) == '/') {
                    sUrl = URLResolver.getAbsoluteUrl(sUrl, ctx);
                }
                sUrl = sUrl.replaceAll("&amp;", "&");
                try {
                    int iFin;
                    URL urlSiteAInclure = new URL(sUrl);
                    URLConnection urlConnection = urlSiteAInclure.openConnection();
                    String connectionReadTimeout = PropertyHelper.getCoreProperty("fckeditor.tag.insertionpageexterne.readtimeout");
                    String connectionConnectTimeout = PropertyHelper.getCoreProperty("fckeditor.tag.insertionpageexterne.connecttimeout");
                    if (connectionReadTimeout != null) {
                        urlConnection.setReadTimeout(Integer.valueOf(connectionReadTimeout));
                    }
                    if (connectionConnectTimeout != null) {
                        urlConnection.setConnectTimeout(Integer.valueOf(connectionConnectTimeout));
                    }
                    HTMLParser htmlParser = new HTMLParser(urlConnection);
                    htmlParser.parse();
                    int iDeb = 0;
                    if (sUrl.startsWith("http://")) {
                        iDeb = 7;
                    }
                    if ((iFin = iDeb + sUrl.substring(iDeb).lastIndexOf(47) + 1) < iDeb) {
                        iFin = sUrl.length();
                    }
                    String urlBase = "";
                    if (iFin > 0) {
                        try {
                            urlBase = new URL(sUrl.substring(0, iFin)).toString();
                        }
                        catch (MalformedURLException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    htmlParser.processAbsoluteUrl(urlBase);
                    newTexte.append(htmlParser.getInputHtml());
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            indexTexte = indexFinMotCle + 1;
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[ouvrir_photo", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String idPhoto = texte.substring(indexDebutMotCle + 14, indexFinMotCle);
            Media media = Media.getMedia(new Long(idPhoto));
            int largeur = MediaPhoto.getCritereLimite().getLargeur();
            int hauteur = MediaPhoto.getCritereLimite().getHauteur();
            try {
                largeur = Integer.parseInt(media.getSpecificData("LARGEUR"));
                hauteur = Integer.parseInt(media.getSpecificData("HAUTEUR"));
            }
            catch (Exception e) {
                // empty catch block
            }
            String data = "javascript:ouvrirPhoto('" + PropertyHelper.getCoreProperty("phototheque.ecran_physique") + "?ID_MEDIA=" + idPhoto + "'," + largeur + "," + hauteur + ");";
            newTexte.append(data);
            indexTexte = indexFinMotCle + 1;
        }
        newTexte.append(texte.substring(indexTexte));
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf("[page", indexTexte)) != -1) {
            int indexBR;
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String contenuTag = Chaine.remplacerPointsVirgules(texte.substring(indexDebutMotCle + 1, indexFinMotCle));
            String nomPage = "";
            StringTokenizer st = new StringTokenizer(contenuTag, "*");
            int indiceToken = 0;
            while (st.hasMoreTokens()) {
                String itemTag = st.nextToken();
                if (indiceToken == 1) {
                    nomPage = itemTag;
                }
                ++indiceToken;
            }
            String nomFichier = WebAppUtil.getAbsolutePath() + File.separator + StringUtils.replace((String)nomPage, (String)"/", (String)File.separator);
            File pageFile = new File(nomFichier);
            if (pageFile.exists() && pageFile.isFile()) {
                newTexte.append(FileUtils.readFileToString((File)pageFile, (Charset)StandardCharsets.UTF_8));
            }
            if ((indexBR = texte.indexOf("<BR>", indexTexte = indexFinMotCle + 1)) == -1) continue;
            indexTexte = indexBR + 4;
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        newTexte = UnivWebFmt.genererLienIntranet(ctx, lgBuffer, newTexte);
        String res = new String(newTexte);
        if (ctx.getFicheCourante() != null) {
            res = ServicesUtil.transformerTagsServices(ctx, res, ctx.getFicheCourante().getCode());
        }
        if (handleLinks) {
            res = UnivWebFmt.gererLiens(res);
        }
        return res;
    }

    private static String handleRequestLink(ContexteUniv ctx, String objet, String code) {
        String urlRequest = RechercheFicheHelper.getUrlResults("OBJET=" + objet + "&" + code.replaceAll(",LANGUE=\"(.)*\"", ""), "0", ctx.getCodeRubriquePageCourante());
        urlRequest = StringUtils.replace((String)urlRequest, (String)"&", (String)"&amp;");
        if (ctx.getRubriqueExterneConnecteur().length() > 0) {
            urlRequest = urlRequest + "&amp;RUBNAV=" + EscapeString.escapeURL(ctx.getRubriqueExterneConnecteur());
        }
        return urlRequest;
    }

    private static StringBuffer genererLienIntranet(ContexteUniv ctx, int lgBuffer, StringBuffer newTexte) {
        String texte = new String(newTexte);
        int indexTexte = 0;
        int indexDebutMotCle = -1;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf(OLD_TAG_URL_LOGIN, indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            newTexte.append(UnivWebFmt.getUrlLogin(ctx, true));
            indexTexte = indexDebutMotCle + OLD_TAG_URL_LOGIN.length();
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf(TAG_URL_LOGIN, indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            newTexte.append(URLResolver.getAbsoluteUrl(UnivWebFmt.getUrlLogin(ctx, true), ctx));
            indexTexte = indexDebutMotCle + TAG_URL_LOGIN.length();
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf(OLD_TAG_URL_PREF, indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            newTexte.append(UnivWebFmt.getUrlPreferences(ctx));
            indexTexte = indexDebutMotCle + OLD_TAG_URL_PREF.length();
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf(TAG_URL_PREF, indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            newTexte.append(URLResolver.getAbsoluteUrl(UnivWebFmt.getUrlPreferences(ctx), ctx));
            indexTexte = indexDebutMotCle + TAG_URL_PREF.length();
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf(OLD_TAG_URL_LOGOUT, indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            newTexte.append(UnivWebFmt.getUrlDeconnexion(ctx));
            indexTexte = indexDebutMotCle + OLD_TAG_URL_LOGOUT.length();
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        newTexte = new StringBuffer(lgBuffer);
        while ((indexDebutMotCle = texte.indexOf(TAG_URL_LOGOUT, indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            newTexte.append(URLResolver.getAbsoluteUrl(UnivWebFmt.getUrlDeconnexion(ctx), ctx));
            indexTexte = indexDebutMotCle + TAG_URL_LOGOUT.length();
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        return newTexte;
    }

    private static String gererLiens(String texte) {
        Document doc = Jsoup.parseBodyFragment((String)texte);
        Document.OutputSettings settings = doc.outputSettings();
        settings.prettyPrint(Boolean.FALSE.booleanValue());
        doc.outputSettings(settings);
        Elements links = doc.getElementsByTag("a");
        if (CollectionUtils.isNotEmpty((Collection)links)) {
            ArrayList<String> hosts = Site.getListeCompleteHostsEtAlias();
            CharSequence[] hostsArray = hosts.toArray(new String[hosts.size()]);
            CharSequence[] prefixes = new String[]{"#", "/"};
            for (Element currentLink : links) {
                if (StringUtils.startsWithAny((CharSequence)currentLink.attr("href"), (CharSequence[])hostsArray) || StringUtils.startsWithAny((CharSequence)currentLink.attr("href"), (CharSequence[])prefixes)) {
                    if (StringUtils.isNotBlank((CharSequence)currentLink.attr("class"))) {
                        currentLink.attr("class", String.format("%s lien_interne", currentLink.attr("class")));
                    } else {
                        currentLink.attr("class", "lien_interne");
                    }
                } else if (currentLink.attr("href").startsWith("javascript:melA")) {
                    if (StringUtils.isNotBlank((CharSequence)currentLink.attr("class"))) {
                        currentLink.attr("class", String.format("%s mailto", currentLink.attr("class")));
                    } else {
                        currentLink.attr("class", "mailto");
                    }
                } else if (StringUtils.isNotBlank((CharSequence)currentLink.attr("class"))) {
                    currentLink.attr("class", String.format("%s lien_externe", currentLink.attr("class")));
                } else {
                    currentLink.attr("class", "lien_externe");
                }
                currentLink.removeAttr("_linkType");
            }
        }
        return doc.body().html();
    }

    public static Vector<String> getOngletsNavigationRubrique(ContexteUniv ctx, FicheUniv ficheUniv) throws Exception {
        return UnivWebFmt.getOngletsNavigationRubrique(ctx, ficheUniv, true, 1);
    }

    public static Vector<String> getOngletsNavigationRubrique(ContexteUniv ctx, FicheUniv ficheUniv, boolean affiche) throws Exception {
        return UnivWebFmt.getOngletsNavigationRubrique(ctx, ficheUniv, affiche, 1);
    }

    public static Vector<String> getOngletsNavigationRubrique(ContexteUniv ctx, FicheUniv ficheUniv, boolean affiche, int stNav) throws Exception {
        Vector<String> v = new Vector<String>();
        String codeRubrique = ctx.getCodeRubriquePageCourante();
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
        while (rubrique.getNiveau() > 0) {
            BeanPageAccueil beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(rubrique);
            FichePageAccueilRubrique.BeanFichePageAccueil ficheAcceuil = null;
            if (beanAccueil != null && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil) {
                ficheAcceuil = (FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil;
            }
            if (affiche || ficheUniv == null || ficheAcceuil != null && !ficheUniv.getCode().equals(ficheAcceuil.getCode())) {
                UnivWebFmt.ajouterOngletEnteteRubrique(ctx, v, rubrique, stNav);
            }
            rubrique = rubrique.getRubriqueMere();
        }
        return v;
    }

    public static Vector<String> getOngletsNavigationRubrique(ContexteUniv ctx, String _code) throws Exception {
        Vector<String> v = new Vector<String>();
        if (_code == null || _code.length() == 0) {
            return v;
        }
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(_code);
        while (rubrique.getNiveau() > 0) {
            UnivWebFmt.ajouterOngletEnteteRubrique(ctx, v, rubrique, 1);
            rubrique = rubrique.getRubriqueMere();
        }
        return v;
    }

    public static String getEncadreContenuRubriqueCourante(ContexteUniv ctx, FicheUniv ficheUniv, String titre, String codeHTMLEntete, String codeHTMLItem) throws Exception {
        return UnivWebFmt.getEncadreContenuRubriqueCourante(ctx, ficheUniv, titre, codeHTMLEntete, codeHTMLItem, "", "", false, true, true);
    }

    public static String getEncadreContenuRubriqueCourante(ContexteUniv ctx, FicheUniv ficheUniv, String titre, String codeHTMLEntete, String codeHTMLItem, String codeHTMLFinItem, String codeHTMLFinEntete, boolean enlever2Points, boolean affichePageTeteDansEncadre, boolean affichePageCouranteDansEncadre) throws Exception {
        String codeFicheCourante = "";
        ctx.setCalculListeResultatsFront(true);
        TreeMap<String, String> m = new TreeMap<String, String>();
        String codeRubriqueEncadre = ctx.getCodeRubriquePageCourante();
        InfosRubriques infos = Rubrique.renvoyerItemRubrique(codeRubriqueEncadre);
        BeanPageAccueil beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(infos);
        FichePageAccueilRubrique.BeanFichePageAccueil ficheAcceuil = null;
        if (beanAccueil != null && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil) {
            ficheAcceuil = (FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil;
        }
        if (!"1".equals(infos.getGestionEncadre())) {
            return "";
        }
        Collection<InfosRubriques> sousRubriques = infos.getListeSousRubriques();
        Iterator<InfosRubriques> itSousRubriques = sousRubriques.iterator();
        InfosRubriques sousRubrique = null;
        while (itSousRubriques.hasNext()) {
            sousRubrique = itSousRubriques.next();
            UnivWebFmt.ajouterOngletEnteteRubrique(ctx, m, sousRubrique, 1);
        }
        FicheUniv maFicheUniv = null;
        String nomObjet = null;
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            nomObjet = ReferentielObjets.getNomObjet(codeObjet);
            maFicheUniv = ReferentielObjets.instancierFiche(nomObjet);
            if (maFicheUniv == null) continue;
            maFicheUniv.init();
            maFicheUniv.setCtx(ctx);
            String nomPage = ReferentielObjets.getNomPage(codeObjet);
            if (maFicheUniv.selectParCodeRubrique(codeRubriqueEncadre, "") > 0) {
                while (maFicheUniv.nextItem()) {
                    if (!affichePageTeteDansEncadre && (ficheAcceuil == null || maFicheUniv.getCode().equals(ficheAcceuil.getCode()) || maFicheUniv.getLangue().equals(ficheAcceuil.getLangue()) || ReferentielObjets.getNomObjet(maFicheUniv).equals(ficheAcceuil.getObjet())) || !affichePageCouranteDansEncadre && maFicheUniv.getCode().equals("")) continue;
                    String titreFiche = maFicheUniv.getLibelleAffichable();
                    if (titreFiche.startsWith(":") && enlever2Points) {
                        titreFiche = titreFiche.substring(1, titreFiche.length());
                    }
                    UnivWebFmt.ajouterLienEncadre(ctx, m, titreFiche, nomPage, maFicheUniv.getCode() + ",LANGUE=" + maFicheUniv.getLangue());
                }
            }
            if (!nomObjet.equalsIgnoreCase(codeRubriqueEncadre)) continue;
            ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("LANGUE", infos.getLangue()));
            where.and(ConditionHelper.egalVarchar("ETAT_OBJET", "0003"));
            ConditionList conditionCodeRubrique = new ConditionList(ConditionHelper.egalVarchar("CODE_RUBRIQUE", ""));
            conditionCodeRubrique.or(ConditionHelper.egalVarchar("CODE_RUBRIQUE", codeRubriqueEncadre));
            where.and(conditionCodeRubrique);
            maFicheUniv.select(where.formaterSQL());
            while (maFicheUniv.nextItem()) {
                if (!affichePageTeteDansEncadre && maFicheUniv.getCode().equals(ficheAcceuil.getCode()) || !affichePageCouranteDansEncadre && maFicheUniv.getCode().equals("")) continue;
                String titreFiche = maFicheUniv.getLibelleAffichable();
                if (titreFiche.startsWith(":") && enlever2Points) {
                    titreFiche = titreFiche.substring(1, titreFiche.length());
                }
                UnivWebFmt.ajouterLienEncadre(ctx, m, titreFiche, nomPage, maFicheUniv.getCode() + ",LANGUE=" + maFicheUniv.getLangue());
            }
        }
        String chaineEncadre = "";
        Iterator iter = m.values().iterator();
        codeHTMLFinItem = (String)StringUtils.defaultIfEmpty((CharSequence)codeHTMLFinItem, (CharSequence)"<br />");
        while (iter.hasNext()) {
            String nextIter = (String)iter.next();
            chaineEncadre = chaineEncadre + codeHTMLItem + nextIter + codeHTMLFinItem;
        }
        if (chaineEncadre.length() > 0) {
            chaineEncadre = titre.length() > 0 ? "[titre;" + titre + "]" + codeHTMLEntete + chaineEncadre + codeHTMLFinEntete : "[titre;" + Rubrique.renvoyerItemRubrique(codeRubriqueEncadre).getIntitule() + "]" + codeHTMLEntete + chaineEncadre + codeHTMLFinEntete;
        }
        ctx.setCalculListeResultatsFront(false);
        return chaineEncadre;
    }

    public static String transformerTagsPersonnalisation(ContexteUniv ctx, String _texte) throws Exception {
        int lgBuffer = _texte.length() + 100;
        StringBuffer newTexte = new StringBuffer(lgBuffer);
        String texte = _texte;
        int indexTexte = 0;
        int indexDebutMotCle = -1;
        int indexFinMotCle = 0;
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        while ((indexDebutMotCle = texte.indexOf("[traitement;debutgroupe", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String contenuTag = Chaine.remplacerPointsVirgules(texte.substring(indexDebutMotCle + 1, indexFinMotCle));
            String action = "";
            String paramExit = "";
            StringTokenizer st = new StringTokenizer(contenuTag, "*");
            int indiceToken = 0;
            while (st.hasMoreTokens()) {
                String itemTag = st.nextToken();
                if (indiceToken == 1) {
                    action = itemTag;
                }
                if (indiceToken == 2) {
                    paramExit = itemTag;
                    paramExit = StringUtils.replace((String)paramExit, (String)"#", (String)"&");
                }
                ++indiceToken;
            }
            if (action.compareToIgnoreCase("debutgroupe") == 0) {
                String tagFinGroupe = "[traitement;fingroupe]";
                int indexFinGroupe = texte.indexOf("[traitement;fingroupe]", indexDebutMotCle);
                if (indexFinGroupe != -1) {
                    Enumeration e = null;
                    Vector<String> listeGroupes = new Vector<String>();
                    if (paramExit.length() == 0) {
                        for (String codeGroupe : ctx.getGroupesDsi()) {
                            InfosGroupeDsi infosGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
                            if (infosGroupe.getCode().length() <= 0) continue;
                            listeGroupes.add(codeGroupe);
                        }
                    } else {
                        StringTokenizer typesGroupes = new StringTokenizer(paramExit, ",");
                        while (typesGroupes.hasMoreTokens()) {
                            String type = typesGroupes.nextToken();
                            Enumeration<InfosGroupeDsi> e2 = Groupedsi.renvoyerCodesGroupeDsiParType(type).elements();
                            while (e2.hasMoreElements()) {
                                InfosGroupeDsi infosGroupe = e2.nextElement();
                                if (!ctx.getGroupesDsi().contains(infosGroupe.getCode())) continue;
                                listeGroupes.add(infosGroupe.getCode());
                            }
                        }
                    }
                    e = listeGroupes.elements();
                    while (e.hasMoreElements()) {
                        ctx.setGroupePersonnalisationCourant((String)e.nextElement());
                        newTexte.append(UnivWebFmt.transformerTagsPersonnalisation(ctx, texte.substring(indexFinMotCle + 1, indexFinGroupe)));
                        ctx.setGroupePersonnalisationCourant("");
                    }
                    indexFinMotCle = texte.indexOf("]", indexFinGroupe);
                }
            }
            indexTexte = indexFinMotCle + 1;
        }
        if (indexTexte < texte.length()) {
            newTexte.append(texte.substring(indexTexte));
        }
        texte = new String(newTexte);
        indexTexte = 0;
        indexDebutMotCle = -1;
        indexFinMotCle = 0;
        newTexte = new StringBuffer(lgBuffer);
        InfosGroupeDsi infoGroupe = Groupedsi.renvoyerItemGroupeDsi(ctx.getGroupePersonnalisationCourant());
        while ((indexDebutMotCle = texte.indexOf("[", indexTexte)) != -1) {
            newTexte.append(texte.substring(indexTexte, indexDebutMotCle));
            indexFinMotCle = texte.indexOf("]", indexDebutMotCle);
            String valeurRemplacement = "";
            boolean estUnMotcle = false;
            String motCle = "";
            if (indexFinMotCle != -1) {
                String codeGroupe;
                String libelleLien;
                String[] listeMots;
                motCle = texte.substring(indexDebutMotCle + 1, indexFinMotCle);
                if (motCle.equals("groupe")) {
                    valeurRemplacement = infoGroupe.getCode();
                    estUnMotcle = true;
                } else if (motCle.equals("intitulegroupe")) {
                    valeurRemplacement = infoGroupe.getIntitule();
                    estUnMotcle = true;
                } else if (motCle.equals("pagegroupe")) {
                    if (infoGroupe.getCodePageTete().length() > 0) {
                        String langueFiche = "0";
                        String codeFiche = infoGroupe.getCodePageTete();
                        int indiceLangue = codeFiche.indexOf(",LANGUE=");
                        if (indiceLangue != -1) {
                            langueFiche = codeFiche.substring(indiceLangue + 8);
                            codeFiche = codeFiche.substring(0, indiceLangue);
                        }
                        valeurRemplacement = "<a href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, "pagelibre", infoGroupe.getCodePageTete()), ctx) + "\">" + PageLibre.getLibelleAffichable(ctx, codeFiche, langueFiche) + "</a>";
                    }
                    estUnMotcle = true;
                } else if (motCle.equals("code")) {
                    valeurRemplacement = ctx.getCode();
                    estUnMotcle = true;
                } else if (motCle.equals("nom")) {
                    valeurRemplacement = ctx.getNom();
                    estUnMotcle = true;
                } else if (motCle.equals("prenom")) {
                    valeurRemplacement = ctx.getPrenom();
                    estUnMotcle = true;
                } else if (motCle.equals("profil")) {
                    valeurRemplacement = ctx.getProfilDsi().equals("") ? "DYNAMIK" : ctx.getProfilDsi();
                    estUnMotcle = true;
                } else if (motCle.equals("intituleprofil")) {
                    valeurRemplacement = Profildsi.getIntitule(ctx.getProfilDsi());
                    estUnMotcle = true;
                } else if (motCle.equals("liendesabonews")) {
                    valeurRemplacement = URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=TRAITEMENT_DEMANDE_ABONNEMENT&amp;ACTION=DEMANDER_DESABONNEMENT&amp;EMAIL=" + ctx.getAdresseMail() + "&amp;CODE=" + ctx.getCode(), ctx);
                    estUnMotcle = true;
                } else if (motCle.equals("centresinteret")) {
                    if (ctx.getCentresInteret().isEmpty()) {
                        valeurRemplacement = "???";
                    } else {
                        Enumeration<String> e = ctx.getCentresInteret().elements();
                        while (e.hasMoreElements()) {
                            if (valeurRemplacement.length() > 0) {
                                valeurRemplacement = valeurRemplacement + "+";
                            }
                            valeurRemplacement = valeurRemplacement + e.nextElement();
                        }
                    }
                    estUnMotcle = true;
                } else if ("intitulestructure".equals(motCle)) {
                    valeurRemplacement = Structure.getLibelleAffichable(ctx.getCodeStructure(), ctx.getLangue());
                    estUnMotcle = true;
                } else if (motCle.equals("date")) {
                    valeurRemplacement = DateFormat.getDateInstance(1, ctx.getLocale()).format(new Date(System.currentTimeMillis()));
                    estUnMotcle = true;
                } else if (motCle.equals("ksession")) {
                    valeurRemplacement = ctx.getKsession();
                    estUnMotcle = true;
                } else if (motCle.equals("modifierfiches")) {
                    valeurRemplacement = "[traitement;liste_fiches;CODE_REDACTEUR=DYNAMIK#MODE=MODIF#TRI=5#INCREMENT=3#TAB=0]";
                    estUnMotcle = true;
                } else if (motCle.equals("creerfiches")) {
                    valeurRemplacement = "[traitement;lien_fiches;CODE_REDACTEUR=DYNAMIK#ACTION=AJOUTER#SEPARATEUR=br#LIBELLE=OBJET]";
                    estUnMotcle = true;
                } else if (motCle.equals("validerfiches")) {
                    valeurRemplacement = "[traitement;lien_fiches;CODE_REDACTEUR=DYNAMIK#ACTION=VALIDER#SEPARATEUR=br#LIBELLE=Fiches \u00e0 valider]";
                    estUnMotcle = true;
                }
                if (motCle.startsWith("soumettreactu")) {
                    listeMots = motCle.split(";", -2);
                    libelleLien = "Saisir une actualit\u00e9";
                    if (listeMots.length > 1) {
                        libelleLien = listeMots[1];
                    }
                    String codeRubrique = "";
                    if (listeMots.length > 2) {
                        codeRubrique = listeMots[2];
                    }
                    estUnMotcle = true;
                    if (codeRubrique.equalsIgnoreCase("RB")) {
                        codeRubrique = "DYNAMIK";
                    }
                    valeurRemplacement = "[traitement;lien_fiches;OBJET=ACTUALITE#ACTION=AJOUTER#LIBELLE=" + libelleLien + "#CODE_RUBRIQUE=" + codeRubrique + "]";
                } else if (motCle.startsWith("soumettredoc")) {
                    listeMots = motCle.split(";", -2);
                    libelleLien = "Saisir un document";
                    if (listeMots.length > 1) {
                        libelleLien = listeMots[1];
                    }
                    String codeRubrique = "";
                    if (listeMots.length > 2) {
                        codeRubrique = listeMots[2];
                    }
                    estUnMotcle = true;
                    valeurRemplacement = "[traitement;lien_fiches;OBJET=DOCUMENT#ACTION=AJOUTER#LIBELLE=" + libelleLien + "#CODE_RUBRIQUE=" + codeRubrique + "]";
                } else if (motCle.startsWith("soumettrearticle")) {
                    listeMots = motCle.split(";", -2);
                    libelleLien = "Saisir un article";
                    if (listeMots.length > 1) {
                        libelleLien = listeMots[1];
                    }
                    String codeRubrique = "";
                    if (listeMots.length > 2) {
                        codeRubrique = listeMots[2];
                    }
                    estUnMotcle = true;
                    valeurRemplacement = "[traitement;lien_fiches;OBJET=ARTICLE#ACTION=AJOUTER#LIBELLE=" + libelleLien + "#CODE_RUBRIQUE=" + codeRubrique + "]";
                } else if (motCle.startsWith("envoi_mail_dsi")) {
                    listeMots = motCle.split(";", -2);
                    codeGroupe = "";
                    String libelleLien2 = "Envoyer un mail \u00e0 tout le groupe";
                    if (listeMots.length > 1 && listeMots[1].length() > 0) {
                        libelleLien2 = listeMots[1];
                    }
                    if (listeMots.length > 2) {
                        codeGroupe = listeMots[2];
                    }
                    Utilisateur utilisateur = new Utilisateur();
                    utilisateur.init();
                    utilisateur.setCtx(ctx);
                    if (StringUtils.isEmpty((CharSequence)codeGroupe)) {
                        if (ctx.getAutorisation() != null) {
                            Vector<String> vCodeGroupe = ctx.getAutorisation().getListeGroupes();
                            valeurRemplacement = valeurRemplacement + "<a href=\"mailto:";
                            for (String string : vCodeGroupe) {
                                if (utilisateur.select("", "", "", "", "", string, "", "") <= 0) continue;
                                while (utilisateur.nextItem()) {
                                    valeurRemplacement = valeurRemplacement + utilisateur.getAdresseMail() + ",";
                                }
                            }
                            valeurRemplacement = valeurRemplacement + "\">" + libelleLien2 + "</a>";
                        }
                    } else if (utilisateur.select("", "", "", "", "", codeGroupe, "", "") > 0) {
                        valeurRemplacement = valeurRemplacement + "<a href=\"mailto:";
                        while (utilisateur.nextItem()) {
                            valeurRemplacement = valeurRemplacement + utilisateur.getAdresseMail() + ",";
                        }
                        valeurRemplacement = valeurRemplacement + "\">" + libelleLien2 + "</a>";
                    }
                    estUnMotcle = true;
                } else if (motCle.startsWith("liste_membres_dsi")) {
                    listeMots = motCle.split(";", -2);
                    codeGroupe = "";
                    if (listeMots.length > 1) {
                        codeGroupe = listeMots[1];
                    }
                    Utilisateur utilisateur = new Utilisateur();
                    utilisateur.init();
                    utilisateur.setCtx(ctx);
                    if (StringUtils.isEmpty((CharSequence)codeGroupe)) {
                        if (ctx.getAutorisation() != null) {
                            Vector<String> vCodeGroupe = Groupeutilisateur.getVecteurGroupes(ctx.getCode());
                            for (String string : vCodeGroupe) {
                                if (utilisateur.select("", "", "", "", "", string, "", "") <= 0) continue;
                                while (utilisateur.nextItem()) {
                                    if (StringUtils.isNotEmpty((CharSequence)valeurRemplacement)) {
                                        valeurRemplacement = valeurRemplacement + "<br />";
                                    }
                                    valeurRemplacement = valeurRemplacement + "<a href=\"mailto:" + utilisateur.getAdresseMail() + "\">" + utilisateur.getLibelle() + "</a>";
                                }
                            }
                        }
                    } else if (utilisateur.select("", "", "", "", "", codeGroupe, "", "") > 0) {
                        while (utilisateur.nextItem()) {
                            if (StringUtils.isNotEmpty((CharSequence)valeurRemplacement)) {
                                valeurRemplacement = valeurRemplacement + "<br />";
                            }
                            valeurRemplacement = valeurRemplacement + "<a href=\"mailto:" + utilisateur.getAdresseMail() + "\">" + utilisateur.getLibelle() + "</a>";
                        }
                    }
                    estUnMotcle = true;
                }
            }
            if (estUnMotcle) {
                newTexte.append(valeurRemplacement);
                indexTexte = indexFinMotCle + 1;
                continue;
            }
            newTexte.append("[");
            indexTexte = indexDebutMotCle + 1;
        }
        newTexte.append(texte.substring(indexTexte));
        return newTexte.toString();
    }

    public static String insererComboRubriques(ContexteUniv ctx, String separateur) throws Exception {
        return UnivWebFmt.insererComboRubriques(ctx, separateur, -1, 0, 1);
    }

    public static String insererComboRubriques(ContexteUniv ctx, String separateur, int longueurMax, int typeValue, int uppercase) throws Exception {
        String res = "";
        Collection<InfosRubriques> listeMeres = Rubrique.getListeRubriquesPrincipale(ctx, true);
        Iterator<InfosRubriques> it = listeMeres.iterator();
        InfosRubriques ir = null;
        String intitule = null;
        String attValue = null;
        while (it.hasNext()) {
            ir = it.next();
            intitule = ir.getIntitule();
            if (uppercase == 1) {
                intitule = intitule.toUpperCase();
            }
            if (intitule.length() > longueurMax && longueurMax != -1) {
                intitule = intitule.substring(0, longueurMax - 1);
            }
            attValue = typeValue == 0 ? ir.getCode() : URLResolver.getAbsoluteUrl(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, ir.getCode()), ctx);
            res = res + "<option value=\"" + attValue + "\">" + intitule + "</option>\n";
            res = res + UnivWebFmt.insererComboRubriquesFilles(ctx, ir, 1, separateur, longueurMax, typeValue);
        }
        return res;
    }

    private static String insererComboRubriquesFilles(ContexteUniv ctx, InfosRubriques irMere, int niveau, String separateur, int longueurMax, int typeValue) throws Exception {
        Collection<InfosRubriques> listeFilles = irMere.getListeSousRubriques();
        Iterator<InfosRubriques> itListeFilles = listeFilles.iterator();
        String res = "";
        while (itListeFilles.hasNext()) {
            InfosRubriques ir = itListeFilles.next();
            if (ir != null && ir.getCodeRubriqueMere().equals(irMere.getCode())) {
                String espaces = "";
                for (int niv = 0; niv < niveau; ++niv) {
                    espaces = espaces + separateur;
                }
                String intitule = espaces + ir.getIntitule();
                if (intitule.length() > longueurMax && longueurMax != -1) {
                    intitule = intitule.substring(0, longueurMax - 1);
                }
                String attValue = "";
                attValue = typeValue == 0 ? ir.getCode() : URLResolver.getAbsoluteUrl(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, ir.getCode()), ctx);
                res = res + "<option value=\"" + attValue + "\">" + intitule + "</option>\n";
            }
            res = res + UnivWebFmt.insererComboRubriquesFilles(ctx, ir, ++niveau, separateur, longueurMax, typeValue);
            --niveau;
        }
        return res;
    }

    public static String renvoyerUrlAccueilRubrique(ContexteUniv ctx, String _codeRubrique) throws Exception {
        return UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, _codeRubrique, true);
    }

    public static String renvoyerUrlAccueilRubrique(ContexteUniv ctx, String _codeRubrique, boolean ampersands) throws Exception {
        return UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, _codeRubrique, ampersands, "");
    }

    public static String renvoyerUrlAccueilRubrique(ContexteUniv ctx, String _codeRubrique, boolean ampersands, String langue) throws Exception {
        return UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, _codeRubrique, ampersands, langue, true);
    }

    public static String renvoyerUrlAccueilRubrique(ContexteUniv ctx, String _codeRubrique, boolean ampersands, String langue, boolean forcageRubrique) throws Exception {
        return UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, _codeRubrique, ampersands, langue, forcageRubrique, true);
    }

    public static String renvoyerUrlAccueilRubrique(ContexteUniv ctx, String _codeRubrique, boolean ampersands, String langue, boolean forcageRubrique, boolean urlFriendly) throws Exception {
        String res = "";
        if (urlFriendly) {
            FrontOfficeMgr frontOfficeMgr = FrontOfficeMgr.getInstance();
            res = frontOfficeMgr.getUrlAccueilRubrique(ctx.getInfosSite(), _codeRubrique);
            InfosSite siteDeLaRubrique = Site.determinerSiteRubrique(_codeRubrique);
            if (res == null && siteDeLaRubrique != null) {
                res = frontOfficeMgr.getUrlAccueilRubrique(siteDeLaRubrique, _codeRubrique);
            }
            if (res != null) {
                return res;
            }
            res = "";
        }
        String esperluette = ampersands ? "&amp;" : "&";
        InfosRubriques info = Rubrique.renvoyerItemRubrique(_codeRubrique);
        PageAccueilRubriqueManager accueilRubriqueManager = PageAccueilRubriqueManager.getInstance();
        BeanPageAccueil beanAccueil = accueilRubriqueManager.getBeanPageAccueil(info);
        if (beanAccueil != null) {
            res = beanAccueil.getUrlRubrique(_codeRubrique, langue, ampersands);
        }
        if (forcageRubrique && StringUtils.isNotEmpty((CharSequence)res) && accueilRubriqueManager.isInterne(info)) {
            res = res + (res.indexOf(63) == -1 ? "?" : esperluette);
            res = res + "RF=" + URLEncoder.encode(_codeRubrique, "UTF-8");
        }
        if (!ampersands) {
            res = StringUtils.replace((String)res, (String)"&amp;", (String)"&");
        }
        return res;
    }

    public static String determinerUrlFormulaire(ContexteUniv ctx, String objet, String langue, boolean ampersands, String codeRubrique) {
        String esperluette = ampersands ? "&amp;" : "&";
        String urlFiche = "/servlet/com.jsbsoft.jtf.core.SG?PROC=RECHERCHE" + esperluette + "ACTION=RECHERCHER" + esperluette + "OBJET=" + EscapeString.escapeURL(objet.toUpperCase());
        if (codeRubrique.length() > 0) {
            urlFiche = urlFiche + esperluette + "RH=" + EscapeString.escapeURL(codeRubrique);
        }
        if (langue != null && langue.length() > 0) {
            urlFiche = urlFiche + esperluette + "LANGUE=" + EscapeString.escapeURL(langue);
        }
        return urlFiche;
    }

    private static String ajouterParametreUrl(String _url, String _name, String _value) {
        String url = _url;
        url = !url.contains("?") ? url + "?" : url + "&amp;";
        url = url + _name + "=" + EscapeString.escapeURL(_value);
        return url;
    }

    public static String determinerUrlRelative(ContexteUniv ctx, String _urlRelative) {
        return UnivWebFmt.determinerUrlRelative(ctx, _urlRelative, false);
    }

    public static String determinerUrlRelative(ContexteUniv ctx, String _urlRelative, boolean _critereEspace) {
        String urlFiche = _urlRelative;
        if (_critereEspace && ctx.getEspaceCourant().length() > 0) {
            urlFiche = UnivWebFmt.ajouterParametreUrl(urlFiche, "ESPACE", ctx.getEspaceCourant());
        }
        if (ctx.getCodeRubriquePageCourante().length() > 0) {
            urlFiche = UnivWebFmt.ajouterParametreUrl(urlFiche, "RH", ctx.getCodeRubriquePageCourante());
        }
        if (ctx.getRubriqueExterneConnecteur().length() > 0) {
            urlFiche = UnivWebFmt.ajouterParametreUrl(urlFiche, "RUBNAV", ctx.getRubriqueExterneConnecteur());
        }
        if (ctx.getLangue().length() > 0) {
            urlFiche = UnivWebFmt.ajouterParametreUrl(urlFiche, "LANGUE", ctx.getLangue());
        }
        return urlFiche;
    }

    @Deprecated
    public static String determinerTargetService(ContexteUniv ctx, ServiceBean _service) throws Exception {
        return ServicesUtil.determinerTargetService(ctx, _service);
    }

    public static void redirigerVersLogin(ContexteUniv ctx, HttpServletResponse response, String callbackUrl) throws IOException {
        HttpServletRequest request = ctx.getRequeteHTTP();
        if (callbackUrl == null || callbackUrl.length() == 0) {
            callbackUrl = request.getRequestURI();
            if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                callbackUrl = callbackUrl + "?" + request.getQueryString();
            }
        }
        if (!callbackUrl.contains("RH=")) {
            callbackUrl = !callbackUrl.contains("?") ? callbackUrl + "?RH=" + ctx.getCodeRubriquePageCourante() : callbackUrl + "&RH=" + ctx.getCodeRubriquePageCourante();
        }
        UnivWebFmt.initialiserUrlRedirection(request.getSession(Boolean.FALSE.booleanValue()), callbackUrl);
        if (response instanceof CacheUrlWrappedResponse) {
            response = ((CacheUrlWrappedResponse)response).getHttpServletResponse();
        }
        response.sendRedirect(URLResolver.getAbsoluteUrl(UnivWebFmt.getUrlLogin(ctx, false), (OMContext)ctx, 1));
    }

    public static String renvoyerUrlRedirection(HttpSession session) {
        String res = null;
        String urlDemandee = (String)session.getAttribute("URL_DEMANDEE");
        Long timeUrlDemandee = (Long)session.getAttribute("TIME_URL_DEMANDEE");
        if (urlDemandee != null) {
            if (timeUrlDemandee != null) {
                if (System.currentTimeMillis() - timeUrlDemandee < 60000L) {
                    res = urlDemandee;
                }
                session.removeAttribute("TIME_URL_DEMANDEE");
            }
            session.removeAttribute("URL_DEMANDEE");
        }
        return res;
    }

    public static void initialiserUrlRedirection(HttpSession session, String callbackUrl) {
        if (session != null && callbackUrl != null && UnivWebFmt.isInternalLink(callbackUrl)) {
            if (callbackUrl.contains("?") || !callbackUrl.contains("%")) {
                try {
                    callbackUrl = URLEncoder.encode(callbackUrl, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("erreur lors de l'encodage de l'url de callback", (Throwable)e);
                }
            }
            session.setAttribute("URL_DEMANDEE", (Object)callbackUrl);
            session.setAttribute("TIME_URL_DEMANDEE", (Object)System.currentTimeMillis());
        }
    }

    private static boolean isInternalLink(String link) {
        String currentUrl = StringUtils.startsWith((CharSequence)link, (CharSequence)"://") ? "http" + link : link;
        ArrayList<String> hosts = Site.getListeCompleteHostsEtAlias();
        CharSequence[] prefixes = new String[]{"#", "/"};
        boolean internal = StringUtils.startsWithAny((CharSequence)currentUrl, (CharSequence[])prefixes);
        if (!internal) {
            Iterator hostIterator = hosts.iterator();
            while (!internal && hostIterator.hasNext()) {
                String host = (String)hostIterator.next();
                internal = StringUtils.equals((CharSequence)currentUrl, (CharSequence)host) || StringUtils.startsWith((CharSequence)currentUrl, (CharSequence)(host + "/"));
            }
        }
        return internal;
    }

    public static void redirigerVersLogin(InfoBean infoBean, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContexteUniv ctx = new ContexteUniv(request);
        if (infoBean.get("RH") != null) {
            ctx.setCodeRubriquePageCourante(infoBean.getString("RH"));
        }
        UnivWebFmt.redirigerVersLogin(ctx, response, "");
    }

    public static void redirigerVersUrl(ContexteUniv ctx, HttpServletResponse response, ExceptionSite e) throws Exception {
        String url = URLDecoder.decode(e.getUrlRedirect(), "UTF-8");
        url = url.replaceAll("&amp;", "&");
        if (response instanceof CacheUrlWrappedResponse) {
            response = ((CacheUrlWrappedResponse)response).getHttpServletResponse();
        }
        response.sendRedirect(url);
    }

    @Deprecated
    public static ArrayList<String> getListeEncadresRubriqueCourante(InfosRubriques rubrique) {
        ArrayList<String> listEncadreRubrique = new ArrayList<String>();
        InfosRubriques tmpRubrique = rubrique;
        while (tmpRubrique.getNiveau() > 0) {
            if (tmpRubrique.getEncadre().length() > 0 && (tmpRubrique.equals(rubrique) || tmpRubrique.isEncadreSousRubrique())) {
                listEncadreRubrique.add(0, tmpRubrique.getEncadre());
            }
            tmpRubrique = tmpRubrique.getRubriqueMere();
        }
        return listEncadreRubrique;
    }

    public static String insererComboLibelle(ContexteUniv ctx, String nomDonnee, String nomCss, String typeLibelle, String libelleDefaut) {
        String res = "";
        res = res + "<select id=\"" + nomCss + "\" name=\"" + nomDonnee + "\" size=\"1\" onchange=\"window.location.href=this.options[this.selectedIndex].value;\">";
        res = res + "<option value=\"#\" selected >" + libelleDefaut + "</option>";
        try {
            Hashtable<String, String> hLibelle = Libelle.getListe(typeLibelle, ctx.getLocale());
            if (!hLibelle.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(hLibelle.keySet());
                for (String key : tree) {
                    String[] chaine = hLibelle.get(key).split("#", -2);
                    String code = "";
                    String libelle = "";
                    if (chaine.length <= 0) continue;
                    FicheUniv ficheUniv = ReferentielObjets.instancierFiche(chaine[0]);
                    if (chaine.length > 1) {
                        code = chaine[1];
                    }
                    if (chaine.length > 2) {
                        libelle = chaine[2];
                    }
                    if (ficheUniv != null) {
                        ficheUniv.setCtx(ctx);
                        ficheUniv.init();
                        if (ficheUniv.selectCodeLangueEtat(code, LangueUtil.getLangueLocale(ctx.getLocale()), "0003") <= 0) continue;
                        ficheUniv.nextItem();
                        if (libelle.equals("")) {
                            libelle = ficheUniv.getLibelleAffichable();
                        }
                        res = res + "<option value=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, ficheUniv), ctx) + "\">" + libelle + "</option>";
                        continue;
                    }
                    if (code.equals("")) {
                        code = "#";
                    }
                    if (libelle.equals("")) {
                        libelle = "Option";
                    }
                    res = res + "<option value=\"" + UnivWebFmt.formaterEnHTML(ctx, code) + "\">" + libelle + "</option>";
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        res = res + "</select>";
        return res;
    }

    public static String insererComboStructures(ContexteUniv ctx, String _codeStructureRoot, String _codeStructureSelect, String separateur) throws Exception {
        return UnivWebFmt.insererComboStructures(ctx, _codeStructureRoot, _codeStructureSelect, separateur, -1, 0, 0);
    }

    public static String insererComboStructures(ContexteUniv ctx, String codeRoot, String codeSelect, String separateur, int longueurMax, int typeValue, int uppercase) throws Exception {
        StringBuilder res = new StringBuilder();
        String _langue = ctx.getLangue();
        if (StringUtils.isEmpty((CharSequence)codeSelect)) {
            codeSelect = "00";
        }
        if (StringUtils.isEmpty((CharSequence)codeRoot)) {
            codeRoot = "00";
        }
        InfosStructure infosStructureRoot = Structure.getTopLevelStructure(codeRoot, _langue);
        InfosStructure infosStructureSelect = Structure.renvoyerItemStructure(codeSelect, _langue);
        for (InfosStructure sousStructure : infosStructureRoot.getListeSousStructuresSortedByLibelleLong()) {
            StructureModele structureCourante = Structure.getFicheStructure(sousStructure.getCode(), sousStructure.getLangue());
            if (!sousStructure.isVisibleInFront() || !FicheUnivMgr.controlerRestriction(structureCourante, ctx, Boolean.TRUE)) continue;
            String attValue = "";
            String selected = "";
            String intitule = sousStructure.getLibelleAffichable();
            if (uppercase == 1) {
                intitule = intitule.toUpperCase();
            }
            if (intitule.length() > longueurMax && longueurMax != -1) {
                intitule = intitule.substring(0, longueurMax - 1);
            }
            attValue = typeValue == 0 ? sousStructure.getCode() : URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, Structure.getFicheStructure(sousStructure.getCode(), sousStructure.getLangue())), ctx);
            if (sousStructure.getCode().equals(infosStructureSelect.getCode())) {
                selected = "selected=\"selected\"";
            }
            res.append("<option value=\"").append(attValue).append("\" ").append(selected).append(">").append(intitule).append("</option>\n");
            res.append(UnivWebFmt.insererComboStructuresFilles(ctx, sousStructure, 1, separateur, longueurMax, typeValue, infosStructureSelect.getCode()));
        }
        return res.toString();
    }

    private static String insererComboStructuresFilles(ContexteUniv ctx, InfosStructure isMere, int niveau, String separateur, int longueurMax, int typeValue, String codeStructureSelect) throws Exception {
        StringBuilder res = new StringBuilder();
        for (InfosStructure is : isMere.getListeSousStructuresSortedByLibelleLong()) {
            StructureModele structureCourante = Structure.getFicheStructure(is.getCode(), is.getLangue());
            if (!is.isVisibleInFront() || !FicheUnivMgr.controlerRestriction(structureCourante, ctx, Boolean.TRUE)) continue;
            String espaces = "";
            String selected = "";
            for (int niv = 0; niv < niveau; ++niv) {
                espaces = espaces + separateur;
            }
            String intitule = espaces + " " + is.getLibelleAffichable();
            if (intitule.length() > longueurMax && longueurMax != -1) {
                intitule = intitule.substring(0, longueurMax - 1);
            }
            String attValue = "";
            attValue = typeValue == 0 ? is.getCode() : URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, Structure.getFicheStructure(is.getCode(), is.getLangue())), ctx);
            if (is.getCode().equals(codeStructureSelect)) {
                selected = "selected=\"selected\"";
            }
            res.append("<option value=\"").append(attValue).append("\" ").append(selected).append(">").append(intitule).append("</option>\n");
            res.append(UnivWebFmt.insererComboStructuresFilles(ctx, is, ++niveau, separateur, longueurMax, typeValue, codeStructureSelect));
            --niveau;
        }
        return res.toString();
    }
}

