/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.filter;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardContexteFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardContexteFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        HttpServletRequest requeteHttp = (HttpServletRequest)request;
        if (ctx != null && !requeteHttp.equals(ctx.getRequeteHTTP())) {
            ctx.setRequeteHTTP(requeteHttp);
            this.gestionParametreRH(ctx);
            this.rechargeInfosSessionsUtilisateurs(ctx);
        }
        chain.doFilter(request, response);
    }

    private void rechargeInfosSessionsUtilisateurs(ContexteUniv ctx) {
        HttpServletRequest requeteHttp = ctx.getRequeteHTTP();
        try {
            SessionUtilisateur sessionUtilisateur;
            HttpSession sessionHTTP = requeteHttp.getSession(Boolean.FALSE.booleanValue());
            if (sessionHTTP != null && (sessionUtilisateur = (SessionUtilisateur)sessionHTTP.getAttribute("session")) != null) {
                if (ctx.getAutorisation() == null) {
                    ctx.initialiserInfosUtilisateur();
                } else {
                    ctx.initialiserEspace();
                }
            }
        }
        catch (Exception e) {
            LOG.error("erreur sur l'initialisation des infos utilisateur", (Throwable)e);
        }
    }

    private void gestionParametreRH(ContexteUniv ctx) {
        InfoBean infoBean;
        HttpServletRequest requeteHttp = ctx.getRequeteHTTP();
        String codeRH = requeteHttp.getParameter("RH");
        if (StringUtils.isBlank((CharSequence)codeRH) && (infoBean = (InfoBean)requeteHttp.getAttribute("infoBean")) != null) {
            codeRH = infoBean.getString("RH");
        }
        if (StringUtils.isNotBlank((CharSequence)codeRH)) {
            ctx.setCodeRubriqueHistorique(codeRH);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

