/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.json;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;

public class CodecJSon {
    public static File encodeObjectToJsonInFile(String path, Object obj, DateFormat dateFormat, boolean autoDetectGetters) throws JsonGenerationException, JsonMappingException, IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        ObjectMapper mapper = new ObjectMapper();
        if (dateFormat != null) {
            mapper.setDateFormat(dateFormat);
        }
        if (!autoDetectGetters) {
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, autoDetectGetters);
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, autoDetectGetters);
            mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        }
        mapper.writeValue(file, obj);
        return file;
    }

    public static File encodeObjectToJsonInFile(String path, Object obj, DateFormat dateFormat) throws Exception {
        return CodecJSon.encodeObjectToJsonInFile(path, obj, dateFormat, true);
    }

    public static File encodeObjectToJsonInFile(String path, Object obj, boolean autoDetectGetters) throws Exception {
        return CodecJSon.encodeObjectToJsonInFile(path, obj, null, autoDetectGetters);
    }

    public static File encodeObjectToJsonInFile(String path, Object obj) throws Exception {
        return CodecJSon.encodeObjectToJsonInFile(path, obj, null, true);
    }

    public static String encodeObjectToJSonInString(Object obj, DateFormat dateFormat, boolean autoDetectGetters) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        if (dateFormat != null) {
            mapper.setDateFormat(dateFormat);
        }
        if (!autoDetectGetters) {
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, autoDetectGetters);
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, autoDetectGetters);
            mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        }
        return mapper.writeValueAsString(obj);
    }

    public static String encodeObjectToJSonInString(Object obj, DateFormat dateFormat) throws Exception {
        return CodecJSon.encodeObjectToJSonInString(obj, dateFormat, true);
    }

    public static String encodeObjectToJSonInString(Object obj, boolean autoDetectGetters) throws Exception {
        return CodecJSon.encodeObjectToJSonInString(obj, null, autoDetectGetters);
    }

    public static String encodeObjectToJSonInString(Object obj) throws Exception {
        return CodecJSon.encodeObjectToJSonInString(obj, null, true);
    }

    public static <T> T decodeStringJSonToClass(String valeur, TypeReference<T> typeReference) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(valeur, typeReference);
    }

    public static <T> T decodeStringJSonToClass(String valeur, Class<T> typeClass) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(valeur, typeClass);
    }

    public static <T> T decodeFileJSonToClass(File valeur, TypeReference<T> typeReference) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(valeur, typeReference);
    }

    public static <T> T decodeFileJSonToClass(File valeur, Class<T> typeClass) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(valeur, typeClass);
    }
}

