/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.recherche;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.rubrique.FichePageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.url.FrontOfficeMgr;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.recherche.RequeteMultifiche;
import com.univ.utils.recherche.ResultatRechercheMultifiche;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class RechercheMultificheHelper {
    public static ResultatRechercheMultifiche rerchercherParmisToutesLesFiches(OMContext ctx, AutorisationBean autorisations, RequeteMultifiche requete) throws Exception {
        return RechercheMultificheHelper.rerchercherParmisToutesLesFiches(ctx, autorisations, requete.getsLibelle(), requete.getsCodeObjet(), requete.getsCodeFiche(), requete.getsCodeRubrique(), requete.getsCodeRattachement(), requete.getsCodeRedacteur(), requete.getsIdMeta(), requete.getUrlFiche(), requete.getDateDebutCreation(), requete.getDateFinCreation(), requete.getDateDebutModification(), requete.getDateFinModification(), requete.getDateDebutMiseEnLigne(), requete.getDateFinMiseEnLigne());
    }

    public static ResultatRechercheMultifiche rerchercherParmisToutesLesFiches(OMContext ctx, AutorisationBean autorisations, String sLibelle, String sCodeObjet, String sCodeFiche, String sCodeRubrique, String sCodeRattachement, String sCodeRedacteur, String urlFiche, Date dateDebutCreation, Date dateFinCreation, Date dateDebutModification, Date dateFinModification, Date dateDebutMiseEnLigne, Date dateFinMiseEnLigne) throws Exception {
        return RechercheMultificheHelper.rerchercherParmisToutesLesFiches(ctx, autorisations, sLibelle, sCodeObjet, sCodeFiche, sCodeRubrique, sCodeRattachement, sCodeRedacteur, "", urlFiche, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne);
    }

    public static ResultatRechercheMultifiche rerchercherParmisToutesLesFiches(OMContext ctx, AutorisationBean autorisations, String sLibelle, String sCodeObjet, String sCodeFiche, String sCodeRubrique, String sCodeRattachement, String sCodeRedacteur, String sIdMeta, String urlFiche, Date dateDebutCreation, Date dateFinCreation, Date dateDebutModification, Date dateFinModification, Date dateDebutMiseEnLigne, Date dateFinMiseEnLigne) throws Exception {
        return RechercheMultificheHelper.rerchercherParmisToutesLesFiches(ctx, autorisations, sLibelle, sCodeObjet, sCodeFiche, sCodeRubrique, sCodeRattachement, sCodeRedacteur, sIdMeta, urlFiche, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne, "", "", "");
    }

    /*
     * Unable to fully structure code
     */
    public static ResultatRechercheMultifiche rerchercherParmisToutesLesFiches(OMContext ctx, AutorisationBean autorisations, String sLibelle, String sCodeObjet, String sCodeFiche, String sCodeRubrique, String sCodeRattachement, String sCodeRedacteur, String sIdMeta, String urlFiche, Date dateDebutCreation, Date dateFinCreation, Date dateDebutModification, Date dateFinModification, Date dateDebutMiseEnLigne, Date dateFinMiseEnLigne, String langue, String etatObjet, String nombre) throws ErreurApplicative, Exception {
        lesMetas = new ArrayList<Metatag>();
        urlFicheSansParametres = StringUtils.substringBefore((String)urlFiche, (String)"?");
        if (StringUtils.isNotBlank((CharSequence)urlFicheSansParametres) && !urlFicheSansParametres.endsWith("/")) {
            try {
                metatagRecherche = RechercheMultificheHelper.rechercheMetaParUrlFiche(ctx, autorisations, urlFicheSansParametres);
                if (metatagRecherche == null) ** GOTO lbl20
                lesMetas.add(metatagRecherche);
            }
            catch (Exception e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("ST_RECHERCHE_DIRECTE_URL_INVALIDE"));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)urlFicheSansParametres) && urlFicheSansParametres.endsWith("/")) {
                infosRubriques = FrontOfficeMgr.getInstance().getInfosRubriqueByUrl(urlFicheSansParametres);
                beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(infosRubriques);
                if (beanAccueil != null && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil) {
                    sCodeFiche = ((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getCode();
                    sCodeObjet = ReferentielObjets.getCodeObjet(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getObjet());
                }
            }
            lesMetas.addAll(RechercheMultificheHelper.rechercherParCriteresMultiples(ctx, autorisations, sLibelle, sCodeObjet, sCodeFiche, sCodeRubrique, sCodeRattachement, sCodeRedacteur, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne, langue, etatObjet, nombre));
        }
lbl20:
        // 3 sources

        result = new ResultatRechercheMultifiche();
        result.getResultats().addAll(lesMetas);
        result.setCodeObjet(sCodeObjet);
        return result;
    }

    private static Metatag rechercheMetaParUrlFiche(OMContext ctx, AutorisationBean autorisations, String urlFiche) throws Exception {
        if (!urlFiche.contains("-")) {
            return null;
        }
        Long idMeta = new Long(urlFiche.substring(urlFiche.lastIndexOf("-") + 1, urlFiche.lastIndexOf(".")));
        return RechercheMultificheHelper.rechercheMetaParIdMeta(ctx, autorisations, idMeta);
    }

    private static Metatag rechercheMetaParIdMeta(OMContext ctx, AutorisationBean autorisations, Long idMeta) throws Exception {
        Metatag meta = new Metatag();
        meta.setCtx(ctx);
        meta.init();
        meta.setIdMetatag(idMeta);
        try {
            meta.retrieve();
        }
        catch (Exception e) {
            return null;
        }
        FicheUniv ficheUniv = FicheUnivMgr.init(meta);
        if (!autorisations.estAutoriseAModifierLaFiche(ficheUniv)) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("ST_RECHERCHE_DIRECTE_OPERATION_INTERDITE"));
        }
        return meta;
    }

    private static Condition traiterDate(String nomColonne, Date dateDebut, Date dateFin) {
        ConditionList conditionSurDate = new ConditionList();
        if (dateDebut != null) {
            conditionSurDate.setPremiereCondtion(ConditionHelper.greaterThan(nomColonne, dateDebut, TypeOperande.DATE));
        }
        if (dateFin != null) {
            conditionSurDate.and(ConditionHelper.lessThan(nomColonne, dateFin, TypeOperande.DATE));
        }
        return conditionSurDate;
    }

    private static Collection<Metatag> rechercherParCriteresMultiples(OMContext ctx, AutorisationBean autorisations, String libelle, String codeObjet, String codeFiche, String codeRubrique, String codeRattachement, String codeRedacteur, Date debutCreation, Date finCreation, Date debutModification, Date finModification, Date debutMiseEnLigne, Date finMiseEnLigne, String langue, String etatObjet, String nombre) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.setPremiereCondition(ConditionHelper.rechercheMots("T1.META_LIBELLE_FICHE", libelle));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar("T1.META_CODE_REDACTEUR", codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeFiche)) {
            where.and(ConditionHelper.egalVarchar("T1.META_CODE", codeFiche));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.getConditionStructure("T1.META_CODE_RATTACHEMENT", codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar("T1.META_LANGUE", langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.and(ConditionHelper.egalVarchar("T1.META_ETAT_OBJET", etatObjet));
        }
        where.and(RechercheMultificheHelper.traiterDate("T1.META_DATE_CREATION", debutCreation, finCreation));
        where.and(RechercheMultificheHelper.traiterDate("T1.META_DATE_MODIFICATION", debutModification, finModification));
        where.and(RechercheMultificheHelper.traiterDate("T1.META_DATE_MISE_EN_LIGNE", debutMiseEnLigne, finMiseEnLigne));
        if (StringUtils.isNotEmpty((CharSequence)codeObjet) && !"0000".equals(codeObjet)) {
            FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(codeObjet));
            where.and(RequeteSQLHelper.traiterConditionDsiMeta(autorisations, fiche, "", codeRubrique, null));
        } else {
            ConditionList conditionSurObjets = new ConditionList();
            for (String nomObjet : ReferentielObjets.getListeNomsObjet()) {
                FicheUniv fiche = ReferentielObjets.instancierFiche(nomObjet);
                if (fiche == null || !FicheAnnotationHelper.isAccessibleBo(fiche)) continue;
                fiche.setCodeRubrique(codeRubrique);
                conditionSurObjets.or(RequeteSQLHelper.traiterConditionDsiMeta(autorisations, fiche, "", codeRubrique, null));
            }
            where.and(conditionSurObjets);
        }
        where.and(ConditionHelper.getConditionRubPubSuivantAction(ctx, "", "T1.META_CODE_RUBRIQUE", codeRubrique));
        requeteSelect.where(where);
        requeteSelect.join(RechercheMultificheHelper.jointurePourClauseWhere(where));
        requeteSelect.limit(LimitHelper.ajouterCriteresLimitesEtOptimisation(ctx, nombre));
        Metatag meta = new Metatag();
        meta.init();
        meta.setCtx(ctx);
        meta.select(requeteSelect.formaterRequete());
        ArrayList<Metatag> result = new ArrayList<Metatag>();
        while (meta.nextItem()) {
            result.add(meta.clone());
        }
        return result;
    }

    private static ClauseJoin jointurePourClauseWhere(ClauseWhere where) {
        ClauseJoin joinRubPub = new ClauseJoin();
        if (where.formaterSQL().contains("RUB_PUB.")) {
            joinRubPub.setTypeJointure(ClauseJoin.TypeJointure.LEFT_JOIN);
            joinRubPub.setNomTable("RUBRIQUEPUBLICATION RUB_PUB");
            joinRubPub.on(ConditionHelper.critereJointureSimple("T1.META_CODE", "RUB_PUB.CODE_FICHE_ORIG"));
            joinRubPub.and(ConditionHelper.critereJointureSimple("T1.META_LANGUE", "RUB_PUB.LANGUE_FICHE_ORIG"));
            joinRubPub.and(ConditionHelper.critereJointureSimple("T1.META_CODE_OBJET", "RUB_PUB.TYPE_FICHE_ORIG"));
        }
        return joinRubPub;
    }
}

