/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql;

import com.univ.utils.sql.clause.ClauseGroupBy;
import com.univ.utils.sql.clause.ClauseHaving;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class RequeteSQL
implements Cloneable {
    private ClauseWhere where;
    private Collection<ClauseJoin> jointures = new ArrayList<ClauseJoin>();
    private Collection<ClauseOrderBy> ordersBy = new ArrayList<ClauseOrderBy>();
    private ClauseGroupBy groupBy;
    private ClauseHaving having;
    private ClauseLimit limit;

    public ClauseWhere getWhere() {
        return this.where;
    }

    public Collection<ClauseJoin> getJointures() {
        return this.jointures;
    }

    public Collection<ClauseOrderBy> getOrdersBy() {
        return this.ordersBy;
    }

    public void setJointures(Collection<ClauseJoin> jointures) {
        this.jointures = jointures;
    }

    public void setOrdersBy(Collection<ClauseOrderBy> ordersBy) {
        this.ordersBy = ordersBy;
    }

    public ClauseGroupBy getGroupBy() {
        return this.groupBy;
    }

    public ClauseLimit getLimit() {
        return this.limit;
    }

    public RequeteSQL where(ClauseWhere where) {
        this.where = where;
        return this;
    }

    public RequeteSQL having(ClauseHaving having) {
        this.having = having;
        return this;
    }

    public RequeteSQL orderBy(ClauseOrderBy orderBy) {
        this.ordersBy.add(orderBy);
        return this;
    }

    public RequeteSQL groupBy(ClauseGroupBy groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public RequeteSQL join(ClauseJoin join) {
        if (join == null || StringUtils.isEmpty((CharSequence)join.getNomTable())) {
            return this;
        }
        String tableAAJouter = join.getNomTable();
        for (ClauseJoin joinDejaPresent : this.jointures) {
            if (!tableAAJouter.equals(joinDejaPresent.getNomTable())) continue;
            return this;
        }
        this.jointures.add(join);
        return this;
    }

    public RequeteSQL limit(ClauseLimit limit) {
        this.limit = limit;
        return this;
    }

    public String formaterRequete() {
        StringBuilder requete = new StringBuilder();
        if (!this.jointures.isEmpty()) {
            for (ClauseSQL clauseSQL : this.jointures) {
                if (clauseSQL == null) continue;
                requete.append(clauseSQL.formaterSQL());
            }
        }
        if (this.where != null) {
            requete.append(this.where.formaterSQL());
        }
        if (this.groupBy != null) {
            requete.append(this.groupBy.formaterSQL());
        }
        if (this.having != null) {
            requete.append(this.having.formaterSQL());
        }
        if (!this.ordersBy.isEmpty()) {
            for (ClauseSQL clauseSQL : this.ordersBy) {
                if (clauseSQL == null) continue;
                requete.append(clauseSQL.formaterSQL());
            }
        }
        if (this.limit != null) {
            requete.append(this.limit.formaterSQL());
        }
        return requete.toString();
    }

    public RequeteSQL clone() throws CloneNotSupportedException {
        return (RequeteSQL)super.clone();
    }
}

