/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.clause;

import com.univ.utils.sql.OperateurConditionnel;
import com.univ.utils.sql.clause.ClauseSQL;
import com.univ.utils.sql.condition.Condition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ClauseHaving
implements ClauseSQL {
    private Condition premierCritere;
    private List<Condition> critereRequete = new ArrayList<Condition>();
    private List<OperateurConditionnel> operateurDeCondition = new ArrayList<OperateurConditionnel>();

    public ClauseHaving() {
    }

    public ClauseHaving(Condition premiereCondition) {
        this.premierCritere = premiereCondition;
    }

    public void setPremiereCondition(Condition condition) {
        this.premierCritere = condition;
    }

    public ClauseHaving or(Condition condition) {
        if (this.premierCritere == null || this.premierCritere.isEmpty()) {
            this.premierCritere = condition;
        } else {
            this.operateurDeCondition.add(OperateurConditionnel.OR);
            this.critereRequete.add(condition);
        }
        return this;
    }

    public ClauseHaving and(Condition condition) {
        if (this.premierCritere == null || this.premierCritere.isEmpty()) {
            this.premierCritere = condition;
        } else {
            this.operateurDeCondition.add(OperateurConditionnel.AND);
            this.critereRequete.add(condition);
        }
        return this;
    }

    @Override
    public String formaterSQL() {
        StringBuilder requeteHaving = new StringBuilder();
        if (this.premierCritere == null) {
            return requeteHaving.toString();
        }
        requeteHaving.append(this.premierCritere.formaterCondition());
        for (int i = 0; i < this.operateurDeCondition.size(); ++i) {
            String sousCondition = this.critereRequete.get(i).formaterCondition();
            if (!StringUtils.isNotEmpty((CharSequence)sousCondition)) continue;
            requeteHaving.append(this.operateurDeCondition.get(i).getOperateur()).append(sousCondition);
        }
        requeteHaving = this.ajouterClauseHavingSiNonVide(requeteHaving);
        return requeteHaving.toString();
    }

    private StringBuilder ajouterClauseHavingSiNonVide(StringBuilder requeteSQLFormater) {
        if (StringUtils.isNotEmpty((CharSequence)requeteSQLFormater.toString())) {
            requeteSQLFormater.insert(0, " HAVING ");
        }
        return requeteSQLFormater;
    }
}

