/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.clause;

import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.OperateurConditionnel;
import com.univ.utils.sql.clause.ClauseSQL;
import com.univ.utils.sql.condition.Condition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ClauseJoin
implements ClauseSQL {
    private TypeJointure typeJointure;
    private String nomTable;
    private Condition premierCritere;
    private List<Condition> critereJointure;
    private List<OperateurConditionnel> operateurDeCondition;

    public ClauseJoin() {
        this.critereJointure = new ArrayList<Condition>();
        this.operateurDeCondition = new ArrayList<OperateurConditionnel>();
    }

    public ClauseJoin(TypeJointure typeJointure, String nomTable) {
        this.typeJointure = typeJointure;
        this.nomTable = nomTable;
        this.critereJointure = new ArrayList<Condition>();
        this.operateurDeCondition = new ArrayList<OperateurConditionnel>();
    }

    public void setNomTable(String nomTable) {
        this.nomTable = nomTable;
    }

    public String getNomTable() {
        return this.nomTable;
    }

    public void setTypeJointure(TypeJointure typeJointure) {
        this.typeJointure = typeJointure;
    }

    public void on(Condition condition) {
        this.premierCritere = condition;
    }

    public ClauseJoin or(Condition condition) {
        this.operateurDeCondition.add(OperateurConditionnel.OR);
        this.critereJointure.add(condition);
        return this;
    }

    public ClauseJoin and(Condition condition) {
        this.operateurDeCondition.add(OperateurConditionnel.AND);
        this.critereJointure.add(condition);
        return this;
    }

    @Override
    public String formaterSQL() {
        StringBuilder requeteJoin = new StringBuilder();
        if (this.isAttributValide()) {
            return requeteJoin.toString();
        }
        requeteJoin.append(this.premierCritere.formaterCondition());
        for (int i = 0; i < this.operateurDeCondition.size(); ++i) {
            String sousCondition = this.critereJointure.get(i).formaterCondition();
            if (!StringUtils.isNotEmpty((CharSequence)sousCondition)) continue;
            requeteJoin.append(this.operateurDeCondition.get(i).getOperateur()).append(sousCondition);
        }
        requeteJoin = this.ajouterClauseJoinSiNonVide(requeteJoin);
        return requeteJoin.toString();
    }

    private boolean isAttributValide() {
        return this.premierCritere == null || this.typeJointure == null || StringUtils.isEmpty((CharSequence)this.nomTable);
    }

    private StringBuilder ajouterClauseJoinSiNonVide(StringBuilder requeteSQLFormater) {
        StringBuilder enteteClauseJoin = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)requeteSQLFormater.toString())) {
            enteteClauseJoin.append(this.typeJointure.getType());
            enteteClauseJoin.append(this.nomTable);
            enteteClauseJoin.append(Operateur.ON.getOperateur());
        }
        enteteClauseJoin.append((CharSequence)requeteSQLFormater);
        return enteteClauseJoin;
    }

    public static enum TypeJointure {
        JOINT(" JOIN "),
        INNER_JOIN(" INNER JOIN "),
        LEFT_JOIN(" LEFT JOIN "),
        NATURAL_JOIN(" NATURAL JOIN "),
        RIGHT_JOIN(" RIGHT JOIN "),
        CROSS_JOIN(" CROSS JOIN "),
        RIGHT_OUTER_JOIN(" RIGHT OUTER JOIN "),
        LEFT_OUTER_JOIN(" LEFT OUTER JOIN "),
        FULL_OUTER_JOIN(" FULL OUTER JOIN ");

        private String typeJointure;

        private TypeJointure(String valeur) {
            this.typeJointure = valeur;
        }

        public String getType() {
            return this.typeJointure;
        }
    }
}

