/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.clause;

import com.univ.utils.EscapeString;
import com.univ.utils.sql.clause.ClauseSQL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ClauseOrderBy
implements ClauseSQL {
    private List<String> colonnesOrdersBy = new ArrayList<String>();
    private List<SensDeTri> ordres = new ArrayList<SensDeTri>();

    public ClauseOrderBy() {
    }

    public ClauseOrderBy(String nomChamp, SensDeTri sens) {
        this.colonnesOrdersBy.add(nomChamp);
        this.ordres.add(sens);
    }

    public ClauseOrderBy orderBy(String nomChamp, SensDeTri sens) {
        this.colonnesOrdersBy.add(nomChamp);
        this.ordres.add(sens);
        return this;
    }

    @Override
    public String formaterSQL() {
        StringBuilder requeteSQLOrder = new StringBuilder();
        boolean isFirst = Boolean.TRUE;
        for (int i = 0; i < this.colonnesOrdersBy.size(); ++i) {
            String nomColonne = this.colonnesOrdersBy.get(i);
            if (!StringUtils.isNotEmpty((CharSequence)nomColonne)) continue;
            if (!isFirst) {
                requeteSQLOrder.append(", ");
            }
            requeteSQLOrder.append(EscapeString.escapeSql(nomColonne));
            if (this.ordres.get(i) != null && StringUtils.isNotEmpty((CharSequence)this.ordres.get(i).getSens())) {
                requeteSQLOrder.append(this.ordres.get(i).getSens());
            }
            isFirst = Boolean.FALSE;
        }
        requeteSQLOrder = this.ajouterClauseOrderSiNonVide(requeteSQLOrder);
        return requeteSQLOrder.toString();
    }

    private StringBuilder ajouterClauseOrderSiNonVide(StringBuilder requeteSQLFormater) {
        if (StringUtils.isNotEmpty((CharSequence)requeteSQLFormater.toString())) {
            requeteSQLFormater.insert(0, " ORDER BY ");
        }
        return requeteSQLFormater;
    }

    public static enum SensDeTri {
        ASC(" ASC "),
        DESC(" DESC ");

        private String sens;

        private SensDeTri(String valeur) {
            this.sens = valeur;
        }

        public String getSens() {
            return this.sens;
        }
    }
}

