/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.criterespecifique;

import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;

public class ClauseJoinHelper {
    public static ClauseJoin creerJointureMetaTag(FicheUniv fiche) {
        ClauseJoin joinMetaDonnee = new ClauseJoin(ClauseJoin.TypeJointure.LEFT_JOIN, "METATAG META");
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        String nomClasse = ReferentielObjets.getNomTableSql(codeObjet);
        joinMetaDonnee = ClauseJoinHelper.creerJointure(ClauseJoin.TypeJointure.LEFT_JOIN, "METATAG META", ConditionHelper.critereJointureSimple("T1.ID_" + nomClasse, "META.META_ID_FICHE"));
        joinMetaDonnee.and(ConditionHelper.egalVarchar("META.META_CODE_OBJET", codeObjet));
        return joinMetaDonnee;
    }

    public static ClauseJoin creerJointureRubPub(FicheUniv fiche) {
        ClauseJoin joinRubPub = new ClauseJoin(ClauseJoin.TypeJointure.LEFT_JOIN, "RUBRIQUEPUBLICATION RUB_PUB");
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        joinRubPub.on(ConditionHelper.critereJointureSimple("T1.CODE", "RUB_PUB.CODE_FICHE_ORIG"));
        joinRubPub.and(ConditionHelper.egal("T1.LANGUE", "RUB_PUB.LANGUE_FICHE_ORIG", TypeOperande.NOM_CHAMP));
        joinRubPub.and(ConditionHelper.egalVarchar("RUB_PUB.TYPE_FICHE_ORIG", codeObjet));
        return joinRubPub;
    }

    public static ClauseJoin creerJointure(ClauseJoin.TypeJointure type, String nomTableEtAlias, Condition conditionDeJointure) {
        ClauseJoin jointure = new ClauseJoin(type, nomTableEtAlias);
        jointure.on(conditionDeJointure);
        return jointure;
    }
}

