/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.criterespecifique;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.EscapeString;
import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.condition.ConditionSimple;
import com.univ.utils.sql.criterespecifique.CritereBO;
import com.univ.utils.sql.criterespecifique.CritereDSI;
import com.univ.utils.sql.criterespecifique.CritereRubriquePublicationHelper;
import com.univ.utils.sql.operande.Operande;
import com.univ.utils.sql.operande.OperandeFactory;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public final class ConditionHelper {
    private static final String CODE_DEFAUT = "0000";

    public static Condition egalVarchar(String nomColonne, String valeur) {
        return ConditionHelper.egal(nomColonne, valeur, TypeOperande.VARCHAR);
    }

    public static Condition egal(String nomColonne, Object valeur, TypeOperande typeValeur) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, valeur, typeValeur, Operateur.EQUALS);
    }

    public static Condition notEgal(String nomColonne, Object valeur, TypeOperande typeValeur) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, valeur, typeValeur, Operateur.NOT_EQUALS);
    }

    public static Condition greaterEquals(String nomColonne, Object valeur, TypeOperande typeValeur) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, valeur, typeValeur, Operateur.GREATER_EQUALS);
    }

    public static Condition lessEquals(String nomColonne, Object valeur, TypeOperande typeValeur) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, valeur, typeValeur, Operateur.LESS_EQUALS);
    }

    public static Condition greaterThan(String nomColonne, Object valeur, TypeOperande typeValeur) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, valeur, typeValeur, Operateur.GREATER_THAN);
    }

    public static Condition lessThan(String nomColonne, Object valeur, TypeOperande typeValeur) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, valeur, typeValeur, Operateur.LESS_THAN);
    }

    public static Condition like(String nomColonne, String valeur, String tokenBefore, String tokenAfter) {
        valeur = EscapeString.escapeSql(valeur);
        return ConditionHelper.genericConditionSurColonne(nomColonne, "'" + tokenBefore + valeur + tokenAfter + "'", TypeOperande.NON_ECHAPABLE, Operateur.LIKE);
    }

    public static Condition notlike(String nomColonne, String valeur, String tokenBefore, String tokenAfter) {
        valeur = EscapeString.escapeSql(valeur);
        return ConditionHelper.genericConditionSurColonne(nomColonne, "'" + tokenBefore + valeur + tokenAfter + "'", TypeOperande.NON_ECHAPABLE, Operateur.NOT_LIKE);
    }

    public static Condition isNull(String nomColonne) {
        return ConditionHelper.genericConditionSurColonne(nomColonne, " NULL ", TypeOperande.NON_ECHAPABLE, Operateur.IS);
    }

    public static Condition critereJointureSimple(String nomPremiereColonne, String nomDeuxiemeColonne) {
        return ConditionHelper.genericConditionSurColonne(nomPremiereColonne, nomDeuxiemeColonne, TypeOperande.NOM_CHAMP, Operateur.EQUALS);
    }

    public static Condition genericConditionSurColonne(String nomColonne, Object valeur, TypeOperande typeValeur, Operateur operateur) {
        return ConditionHelper.genericCondition(nomColonne, TypeOperande.NOM_CHAMP, valeur, typeValeur, operateur);
    }

    public static Condition genericCondition(Object valeurA, TypeOperande typeValeurA, Object valeurB, TypeOperande typeValeurB, Operateur operateur) {
        Operande colonne = OperandeFactory.creerOperande(valeurA, typeValeurA);
        Operande valeurColonne = OperandeFactory.creerOperande(valeurB, typeValeurB);
        ConditionSimple generique = new ConditionSimple(colonne, operateur, valeurColonne);
        return generique;
    }

    public static Condition in(String nomColonne, Collection<String> valeurs) {
        if (valeurs != null && !valeurs.isEmpty()) {
            return ConditionHelper.genericConditionSurColonne(nomColonne, valeurs, TypeOperande.LISTE_VARCHAR, Operateur.IN);
        }
        return new ConditionSimple();
    }

    public static Condition notIn(String nomColonne, Collection<String> valeurs) {
        if (valeurs != null && !valeurs.isEmpty()) {
            return ConditionHelper.genericConditionSurColonne(nomColonne, valeurs, TypeOperande.LISTE_VARCHAR, Operateur.NOT_IN);
        }
        return new ConditionSimple();
    }

    public static Condition rechercheMots(String colonne, String motsCles) {
        ConditionList conditionsPourRechMots = new ConditionList();
        if (StringUtils.isNotEmpty((CharSequence)motsCles) && StringUtils.isNotBlank((CharSequence)motsCles)) {
            String[] motsClesSpliter;
            for (String motCle : motsClesSpliter = StringUtils.split((String)motsCles.toUpperCase(), (String)" +'\"")) {
                if (!StringUtils.isNotEmpty((CharSequence)motCle) || !StringUtils.isNotBlank((CharSequence)motCle)) continue;
                conditionsPourRechMots.and(ConditionHelper.like(colonne, motCle, "%", "%"));
            }
        }
        return conditionsPourRechMots;
    }

    public static Condition critereDateDebut(String colonne, Date valeur) {
        return ConditionHelper.greaterEquals(colonne, valeur, TypeOperande.DATE);
    }

    public static Condition critereDateFin(String colonne, Date valeur) {
        return ConditionHelper.lessEquals(colonne, valeur, TypeOperande.DATE);
    }

    public static Condition likePourValeursMultiple(String colonne, String valeur) {
        ConditionList criterevaleurMultiple = new ConditionList();
        if (ConditionHelper.isValeurValidePourChampMultiple(valeur)) {
            String[] valeursMultiples;
            for (String valeurPossible : valeursMultiples = StringUtils.split((String)valeur, (String)"+")) {
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "", ""));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "", ";%"));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%;", ""));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%;", ";%"));
            }
        }
        return criterevaleurMultiple;
    }

    public static Condition likePourValeursMultipleAvecSeparateurInterne(String colonne, String valeur, String separateurInterne) {
        ConditionList criterevaleurMultiple = new ConditionList();
        if (ConditionHelper.isValeurValidePourChampMultiple(valeur)) {
            String[] valeursMultiples = StringUtils.split((String)valeur, (String)"+");
            String separateur = EscapeString.escapeSql(StringUtils.defaultString((String)separateurInterne));
            for (String valeurPossible : valeursMultiples) {
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "", ""));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "", separateur + "%"));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%" + separateur, ""));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%" + separateur, separateur + "%"));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%;", separateur + "%"));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%;", ""));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%" + separateur, ";%"));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "", ";%"));
                criterevaleurMultiple.or(ConditionHelper.like(colonne, valeurPossible, "%;", ";%"));
            }
        }
        return criterevaleurMultiple;
    }

    public static Condition notlikePourValeursMultiple(String colonne, String valeur, String separateur) {
        ConditionList criterevaleurMultiple = new ConditionList();
        if (ConditionHelper.isValeurValidePourChampMultiple(valeur)) {
            String[] valeursMultiples;
            for (String valeurPossible : valeursMultiples = StringUtils.split((String)valeur, (String)separateur)) {
                criterevaleurMultiple.and(ConditionHelper.notlike(colonne, valeurPossible, "", ""));
                criterevaleurMultiple.and(ConditionHelper.notlike(colonne, valeurPossible, "", ";%"));
                criterevaleurMultiple.and(ConditionHelper.notlike(colonne, valeurPossible, "%;", ""));
                criterevaleurMultiple.and(ConditionHelper.notlike(colonne, valeurPossible, "%;", ";%"));
            }
        }
        return criterevaleurMultiple;
    }

    private static boolean isValeurValidePourChampMultiple(String valeur) {
        return StringUtils.isNotEmpty((CharSequence)valeur) && !CODE_DEFAUT.equals(valeur);
    }

    public static Condition getConditionDSI(OMContext ctx, FicheUniv fiche) {
        return CritereDSI.traiterCritereDSI(ctx, fiche);
    }

    public static Condition getConditionBO(OMContext ctx, FicheUniv fiche) {
        return CritereBO.traiterCritereBO(ctx, fiche);
    }

    public static Condition getConditionRubPubDSIFiche(OMContext ctx, FicheUniv ficheUniv, String codeRubrique) {
        return CritereRubriquePublicationHelper.traiterCritereRubPubDSIFiche(ctx, ficheUniv, codeRubrique);
    }

    public static Condition getConditionRubPubFiche(FicheUniv ficheUniv) {
        return CritereRubriquePublicationHelper.traiterConditionRubPubIdRubriqueAndFicheOrig(ficheUniv);
    }

    public static Condition getConditionRubPubSuivantAction(OMContext ctx, String action, String nomColonne, String codeRubrique) {
        return CritereRubriquePublicationHelper.traiterCritereRubriquePublicationSuivantAction(ctx, action, nomColonne, codeRubrique);
    }

    public static Condition getConditionRubrique(String nomColonne, String codeRubrique) {
        if (ConditionHelper.isRubriqueNoArbo(codeRubrique)) {
            codeRubrique = StringUtils.substringBefore((String)codeRubrique, (String)"_NOARBO");
            return ConditionHelper.egalVarchar(nomColonne, codeRubrique);
        }
        InfosRubriques infosRub = Rubrique.renvoyerItemRubrique(codeRubrique);
        Collection<InfosRubriques> infosRubriquesToutNiveau = infosRub.getListeSousRubriquesTousNiveaux();
        infosRubriquesToutNiveau.add(infosRub);
        ArrayList<String> codeRubriquesTousNiveaux = new ArrayList<String>();
        for (InfosRubriques rub : infosRubriquesToutNiveau) {
            codeRubriquesTousNiveaux.add(rub.getCode());
        }
        return ConditionHelper.in(nomColonne, codeRubriquesTousNiveaux);
    }

    private static boolean isRubriqueNoArbo(String codeRubrique) {
        return StringUtils.isNotEmpty((CharSequence)codeRubrique) && !codeRubrique.contains(";") && codeRubrique.endsWith("_NOARBO");
    }

    public static Condition getConditionStructure(String nomColonne, String codeStructure) {
        if (ConditionHelper.isStructureNoArbo(codeStructure = codeStructure.replaceAll("\\+", ";"))) {
            codeStructure = StringUtils.substringBefore((String)codeStructure, (String)"_NOARBO");
            return ConditionHelper.egalVarchar(nomColonne, codeStructure);
        }
        Collection<String> listeDesCodesStructures = ConditionHelper.getListeDesCodesStructures(codeStructure);
        return ConditionHelper.in(nomColonne, listeDesCodesStructures);
    }

    public static boolean isStructureNoArbo(String codeStructure) {
        return StringUtils.isNotEmpty((CharSequence)codeStructure) && !codeStructure.contains(";") && codeStructure.endsWith("_NOARBO");
    }

    public static Collection<String> getListeDesCodesStructures(String codesStructures) {
        String[] codesStructuresSplite = codesStructures.split(";");
        ArrayList<String> listeDesCodesStructures = new ArrayList<String>();
        for (String codeCourant : codesStructuresSplite) {
            if (!StringUtils.isNotEmpty((CharSequence)codeCourant)) continue;
            listeDesCodesStructures.add(codeCourant);
            InfosStructure infoStructure = Structure.renvoyerItemStructure(codeCourant);
            Collection<InfosStructure> allInfosStructures = infoStructure.getListeSousStructuresTousNiveaux();
            for (InfosStructure structureCourante : allInfosStructures) {
                listeDesCodesStructures.add(structureCourante.getCode());
            }
        }
        return listeDesCodesStructures;
    }

    public static Condition getConditionStructureMultiple(String nomColonne, String codeStructure) {
        codeStructure = codeStructure.replaceAll("\\+", ";");
        String[] codeStructureSplite = codeStructure.split(";");
        StringBuilder regexpAExecuter = new StringBuilder();
        for (String code : codeStructureSplite) {
            if (!StringUtils.isNotEmpty((CharSequence)code)) continue;
            if (regexpAExecuter.length() != 0) {
                regexpAExecuter.append("|");
            }
            regexpAExecuter.append(EscapeString.escapeSql(code));
            Collection<InfosStructure> allStructure = Structure.renvoyerItemStructure(code).getListeSousStructuresTousNiveaux();
            for (InfosStructure structure : allStructure) {
                regexpAExecuter.append("|");
                regexpAExecuter.append(structure.getCode());
            }
        }
        if (regexpAExecuter.length() == 0) {
            return null;
        }
        regexpAExecuter.insert(0, "'(^|.*;|.*\\\\[)(");
        regexpAExecuter.append(")($|;.*|\\\\].*)'");
        return ConditionHelper.genericConditionSurColonne(nomColonne, regexpAExecuter.toString(), TypeOperande.NON_ECHAPABLE, Operateur.REGEXP);
    }

    public static ClauseWhere whereCodeLangueEtat(String code, String langue, String etat) {
        ClauseWhere codeLangueEtat = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            codeLangueEtat.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE", code));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            codeLangueEtat.and(ConditionHelper.egalVarchar("T1.LANGUE", langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etat) && !CODE_DEFAUT.equals(etat)) {
            codeLangueEtat.and(ConditionHelper.egalVarchar("T1.ETAT_OBJET", etat));
        }
        return codeLangueEtat;
    }
}

