/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.criterespecifique;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.ClassMetaUtil;
import com.univ.utils.sql.ConstanteSQL;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public final class CritereBO {
    protected static Condition traiterCritereBO(OMContext ctx, FicheUniv fiche) {
        ConditionList critereBO = new ConditionList();
        Boolean aucuneRestriction = Boolean.FALSE;
        boolean isATraiterBO = CritereBO.isATraiterBO(ctx);
        if (!isATraiterBO) {
            return critereBO;
        }
        AutorisationBean autorisations = (AutorisationBean)ctx.getDatas().get("AUTORISATIONS");
        if (autorisations != null) {
            Hashtable<String, Vector<Perimetre>> listePermissions = autorisations.getListePermissions();
            String codeObjet = ReferentielObjets.getCodeObjet(fiche);
            for (String clePermission : listePermissions.keySet()) {
                PermissionBean permission = new PermissionBean(clePermission);
                if (!CritereBO.isPermissionATraiter(permission, codeObjet)) continue;
                Vector<Perimetre> perimetres = listePermissions.get(clePermission);
                for (Perimetre perimetreCourant : perimetres) {
                    ConditionList conditionsSelectionPerimetre = new ConditionList();
                    if (CritereBO.isPerimetreSansRestriction(perimetreCourant)) {
                        aucuneRestriction = true;
                        continue;
                    }
                    conditionsSelectionPerimetre = CritereBO.traiterCriterePerimetre(fiche, perimetreCourant);
                    if (conditionsSelectionPerimetre.isEmpty()) continue;
                    critereBO.or(conditionsSelectionPerimetre);
                }
            }
            if (!aucuneRestriction.booleanValue()) {
                critereBO.or(ConditionHelper.egalVarchar("CODE_REDACTEUR", autorisations.getCode()));
            }
        }
        if (critereBO.isEmpty() && !aucuneRestriction.booleanValue()) {
            critereBO.and(ConstanteSQL.CONDITION_IMPOSSIBLE);
        }
        return critereBO;
    }

    private static ConditionList traiterCriterePerimetre(FicheUniv fiche, Perimetre perimetre) {
        String codeEspaceCollaboratif;
        String codeStructure;
        ConditionList conditionsSelectionPerimetre = new ConditionList();
        boolean criteresPertinents = Boolean.FALSE;
        String codeRubrique = perimetre.getCodeRubrique();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            criteresPertinents = Boolean.TRUE;
            Condition conditionRubrique = CritereBO.traiterConditionRubrique(codeRubrique, fiche);
            conditionsSelectionPerimetre.setPremiereCondtion(conditionRubrique);
        }
        if (StringUtils.isNotEmpty((CharSequence)(codeStructure = perimetre.getCodeStructure()))) {
            criteresPertinents = Boolean.TRUE;
            ConditionList conditionStructure = CritereBO.traiterConditionStructure(codeStructure, fiche);
            if (!conditionStructure.isEmpty()) {
                conditionsSelectionPerimetre.and(conditionStructure);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(codeEspaceCollaboratif = perimetre.getCodeEspaceCollaboratif()))) {
            ConditionList conditionsEspaceCollab = new ConditionList(ConditionHelper.egalVarchar("T1.DIFFUSION_MODE_RESTRICTION", "4"));
            conditionsEspaceCollab.and(ConditionHelper.egalVarchar("T1.DIFFUSION_PUBLIC_VISE_RESTRICTION", codeEspaceCollaboratif));
            conditionsSelectionPerimetre.and(conditionsEspaceCollab);
            criteresPertinents = Boolean.TRUE;
        }
        if (!criteresPertinents) {
            return new ConditionList();
        }
        return conditionsSelectionPerimetre;
    }

    private static Condition traiterConditionRubrique(String codeRubrique, FicheUniv fiche) {
        Condition conditionRubrique = null;
        String nomCodeRubrique = ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RUBRIQUE");
        conditionRubrique = "-".equals(codeRubrique) ? ConditionHelper.egalVarchar(nomCodeRubrique, "") : ConditionHelper.getConditionRubrique(nomCodeRubrique.toUpperCase(), codeRubrique);
        return conditionRubrique;
    }

    private static boolean isATraiterBO(OMContext ctx) {
        Boolean isATraiterBO = Boolean.TRUE;
        if (ctx.getDatas() != null) {
            String controle = (String)ctx.getDatas().get("CONTROLE_PERIMETRE_BO");
            isATraiterBO = "1".equals(controle);
        }
        return isATraiterBO;
    }

    private static boolean isPermissionATraiter(PermissionBean permission, String codeObjet) {
        return permission.getType().equals("FICHE") && permission.getObjet().equals(codeObjet) && permission.getAction().equals("M");
    }

    private static boolean isPerimetreSansRestriction(Perimetre perimetre) {
        return StringUtils.isEmpty((CharSequence)perimetre.getCodeRubrique()) && StringUtils.isEmpty((CharSequence)perimetre.getCodeStructure()) && StringUtils.isEmpty((CharSequence)perimetre.getCodeProfil()) && StringUtils.isEmpty((CharSequence)perimetre.getCodeGroupe());
    }

    private static ConditionList traiterConditionStructure(String codeStructure, FicheUniv fiche) {
        ConditionList conditionStructure = new ConditionList();
        String nomCodeStructure = ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RATTACHEMENT");
        if ("-".equals(codeStructure)) {
            conditionStructure.setPremiereCondtion(ConditionHelper.egalVarchar(nomCodeStructure, ""));
            if (fiche instanceof FicheRattachementsSecondaires) {
                nomCodeStructure = ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RATTACHEMENT_AUTRES");
                conditionStructure.and(ConditionHelper.egalVarchar(nomCodeStructure, ""));
            }
        } else {
            conditionStructure.setPremiereCondtion(ConditionHelper.getConditionStructure(nomCodeStructure.toUpperCase(), codeStructure));
            if (fiche instanceof StructureModele) {
                conditionStructure.or(ConditionHelper.egalVarchar("CODE", codeStructure));
            }
            if (fiche instanceof FicheRattachementsSecondaires) {
                nomCodeStructure = ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RATTACHEMENT_AUTRES");
                conditionStructure.or(ConditionHelper.getConditionStructureMultiple(nomCodeStructure.toUpperCase(), codeStructure));
            }
        }
        return conditionStructure;
    }
}

