/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.criterespecifique;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.utils.ContexteUniv;
import com.univ.utils.sql.ConstanteSQL;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class CritereDSI {
    protected static Condition traiterCritereDSI(OMContext ctx, FicheUniv fiche) {
        ConditionList critereDSI = null;
        if (CritereDSI.isDiffusionSelective(fiche, ctx)) {
            Condition persoGroupe;
            ContexteUniv ctxUniv = (ContexteUniv)ctx;
            critereDSI = new ConditionList(CritereDSI.traiterRestrictionDSI(ctxUniv));
            if (CritereDSI.isGroupePersonnalisation(ctxUniv) && (persoGroupe = CritereDSI.traiterPersonnalisationGroupe(ctxUniv)) != null) {
                critereDSI.and(persoGroupe);
            }
            if (CritereDSI.isEspacePersonnalisation(ctxUniv)) {
                critereDSI.and(CritereDSI.traiterPersonnalisationEspace(ctxUniv));
            }
        }
        return critereDSI;
    }

    private static boolean isDiffusionSelective(FicheUniv fiche, OMContext ctx) {
        return fiche instanceof DiffusionSelective && "1".equals(ConstanteSQL.ACTIVATION_DSI) && ctx instanceof ContexteUniv && ((ContexteUniv)ctx).isCalculListeResultatsFront();
    }

    private static ConditionList traiterRestrictionDSI(ContexteUniv ctx) {
        ConditionList conditionEspaceCollab;
        ConditionList conditionPublicViseRestriction;
        ConditionList conditionRestrictionDSI = new ConditionList(ConditionHelper.egalVarchar("T1.DIFFUSION_MODE_RESTRICTION", "0"));
        Collection<String> groupesAVerifier = CritereDSI.getAllGroupesDSIDuCtx(ctx.getGroupesDsi());
        ConditionList conditionPublicVise = CritereDSI.traiterGroupeDSI(groupesAVerifier, "T1.DIFFUSION_PUBLIC_VISE", "2");
        if (conditionPublicVise != null) {
            conditionRestrictionDSI.or(conditionPublicVise);
        }
        if ((conditionPublicViseRestriction = CritereDSI.traiterGroupeDSI(groupesAVerifier, "T1.DIFFUSION_PUBLIC_VISE_RESTRICTION", "3")) != null) {
            conditionRestrictionDSI.or(conditionPublicViseRestriction);
        }
        if (Espacecollaboratif.isExtensionActivated() && (conditionEspaceCollab = CritereDSI.traiterEspaceCollab(ctx)) != null) {
            conditionRestrictionDSI.or(conditionEspaceCollab);
        }
        return conditionRestrictionDSI;
    }

    private static Collection<String> getAllGroupesDSIDuCtx(TreeSet<String> codesGroupesCourant) {
        ArrayList<String> groupesAVerifier = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(codesGroupesCourant)) {
            groupesAVerifier.addAll(codesGroupesCourant);
            for (String codeGroupeCourant : codesGroupesCourant) {
                InfosGroupeDsi infoGroupeCourant = Groupedsi.renvoyerItemGroupeDsi(codeGroupeCourant);
                for (int niveau = infoGroupeCourant.getNiveau() - 1; niveau > 0; --niveau) {
                    infoGroupeCourant = infoGroupeCourant.getGroupePere();
                    groupesAVerifier.add(infoGroupeCourant.getCode());
                }
            }
        }
        return groupesAVerifier;
    }

    private static ConditionList traiterGroupeDSI(Collection<String> groupesAVerifier, String nomColonnePublicVise, String valeurDiffusionModeRestriction) {
        ConditionList restrictionGroupe = new ConditionList();
        ConditionList conditionGroupeDSI = CritereDSI.creerConditionProfilEtGroupe(nomColonnePublicVise, groupesAVerifier);
        if (conditionGroupeDSI != null) {
            restrictionGroupe.setPremiereCondtion(ConditionHelper.egalVarchar("T1.DIFFUSION_MODE_RESTRICTION", valeurDiffusionModeRestriction));
            restrictionGroupe.and(conditionGroupeDSI);
        }
        return restrictionGroupe;
    }

    private static ConditionList creerConditionProfilEtGroupe(String nomColonne, Collection<String> listeDesGroupes) {
        ConditionList conditionProfilGroupe = null;
        boolean isFirst = Boolean.TRUE;
        for (String codeGroupe : listeDesGroupes) {
            if (isFirst) {
                conditionProfilGroupe = new ConditionList(ConditionHelper.like(nomColonne, codeGroupe, "%[/", "]%"));
            }
            conditionProfilGroupe.or(ConditionHelper.like(nomColonne, codeGroupe, "%[/", "]%"));
            isFirst = Boolean.FALSE;
        }
        return conditionProfilGroupe;
    }

    private static ConditionList traiterEspaceCollab(ContexteUniv ctx) {
        ConditionList conditionEspaceCollab = null;
        TreeSet<String> espacesAccessibles = new TreeSet<String>();
        Collection<InfosEspaceCollaboratif> listeEspaces = Espacecollaboratif.getListeEspaces();
        for (InfosEspaceCollaboratif espace : listeEspaces) {
            if (!Espacecollaboratif.estMembreEspace(ctx, espace) && !Espacecollaboratif.estVisiteurEspace(ctx, espace)) continue;
            espacesAccessibles.add(espace.getCode());
        }
        if (!espacesAccessibles.isEmpty()) {
            conditionEspaceCollab = new ConditionList(ConditionHelper.egalVarchar("T1.DIFFUSION_MODE_RESTRICTION", "4"));
            conditionEspaceCollab.and(ConditionHelper.in("T1.DIFFUSION_PUBLIC_VISE_RESTRICTION", espacesAccessibles));
        }
        return conditionEspaceCollab;
    }

    private static boolean isGroupePersonnalisation(ContexteUniv ctx) {
        return StringUtils.isNotEmpty((CharSequence)ctx.getGroupePersonnalisationCourant());
    }

    private static boolean isEspacePersonnalisation(ContexteUniv ctx) {
        return StringUtils.isNotEmpty((CharSequence)ctx.getEspacePersonnalisationCourant());
    }

    private static Condition traiterPersonnalisationGroupe(ContexteUniv ctx) {
        if (ctx.getAutorisation() == null) {
            return ConstanteSQL.CONDITION_DEFAUT_POUR_GROUPE;
        }
        Collection<String> codesDesGroupes = null;
        String groupePersoCourant = ctx.getGroupePersonnalisationCourant();
        if ("DYNAMIK".equals(groupePersoCourant)) {
            codesDesGroupes = CritereDSI.getAllGroupesDSIDuCtx(ctx.getGroupesDsi());
        } else if (groupePersoCourant.endsWith("_TYPEGROUPE")) {
            String type = StringUtils.substringBefore((String)groupePersoCourant, (String)"_TYPEGROUPE");
            codesDesGroupes = CritereDSI.getGroupesDSIDuCtxParType(ctx.getGroupesDsi(), type);
            if (codesDesGroupes.isEmpty()) {
                return ConstanteSQL.CONDITION_DEFAUT_POUR_GROUPE;
            }
        } else {
            codesDesGroupes = Arrays.asList(ctx.getGroupePersonnalisationCourant().split(";"));
        }
        return CritereDSI.creerConditionProfilEtGroupe("T1.DIFFUSION_PUBLIC_VISE", codesDesGroupes);
    }

    private static Collection<String> getGroupesDSIDuCtxParType(TreeSet<String> codesGroupesCourant, String type) {
        ArrayList<String> groupesAVerifier = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(codesGroupesCourant)) {
            for (String codeGroupeCourant : codesGroupesCourant) {
                InfosGroupeDsi infoGroupeCourant = Groupedsi.renvoyerItemGroupeDsi(codeGroupeCourant);
                if (type.equals(infoGroupeCourant.getType())) {
                    groupesAVerifier.add(infoGroupeCourant.getCode());
                }
                for (int niveau = infoGroupeCourant.getNiveau() - 1; niveau > 0; --niveau) {
                    if (!type.equals((infoGroupeCourant = infoGroupeCourant.getGroupePere()).getType())) continue;
                    groupesAVerifier.add(infoGroupeCourant.getCode());
                }
            }
        }
        return groupesAVerifier;
    }

    private static Condition traiterPersonnalisationEspace(ContexteUniv ctx) {
        String espace = ctx.getEspacePersonnalisationCourant();
        return ConditionHelper.egalVarchar("T1.DIFFUSION_PUBLIC_VISE_RESTRICTION", espace);
    }
}

