/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.criterespecifique;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.multisites.InfosSite;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.sql.ConstanteSQL;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public final class CritereRubriquePublicationHelper {
    protected static Condition traiterConditionRubPubIdRubriqueAndFicheOrig(FicheUniv fiche) {
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        ConditionList critereRubPub = new ConditionList(ConditionHelper.isNull("RUB_PUB.ID_RUBRIQUEPUBLICATION"));
        critereRubPub.or(ConditionHelper.egalVarchar("RUB_PUB.TYPE_FICHE_ORIG", codeObjet));
        return critereRubPub;
    }

    protected static Condition traiterCritereRubPubDSIFiche(OMContext ctx, FicheUniv ficheUniv, String codeRubrique) {
        Collection<String> listeCodeRubriques = CritereRubriquePublicationHelper.getCodesRubriquesSuivantCritereDSIDeLaFiche(ctx, ficheUniv, codeRubrique);
        ConditionList conditionRubPub = new ConditionList(ConditionHelper.in("T1.CODE_RUBRIQUE", listeCodeRubriques));
        conditionRubPub.or(ConditionHelper.in("RUB_PUB.RUBRIQUE_DEST", listeCodeRubriques));
        return conditionRubPub;
    }

    private static Collection<String> getCodesRubriquesSuivantCritereDSIDeLaFiche(OMContext ctx, FicheUniv ficheUniv, String codeRubrique) {
        ArrayList<String> listeCodesRubriques = new ArrayList<String>();
        String codeRubriqueSite = null;
        boolean rechercheArborescente = Boolean.TRUE;
        InfosSite infosSite = null;
        ContexteUniv ctxUniv = null;
        if (ctx instanceof ContexteUniv && ((ContexteUniv)ctx).isCalculListeResultatsFront()) {
            infosSite = ctx.getInfosSite();
            ctxUniv = (ContexteUniv)ctx;
            if (CritereRubriquePublicationHelper.isSiteCloisonne(infosSite)) {
                codeRubriqueSite = infosSite.getCodeRubrique();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique) && codeRubrique.endsWith("_NOARBO")) {
            codeRubrique = StringUtils.substringBefore((String)codeRubrique, (String)"_NOARBO");
            rechercheArborescente = Boolean.FALSE;
        }
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
        if (CritereRubriquePublicationHelper.isCodeExisteMaisPasRubrique(codeRubrique = CritereRubriquePublicationHelper.getCodeRubriqueCloisonnee(infosSite, rubrique, codeRubrique, codeRubriqueSite), rubrique = Rubrique.renvoyerItemRubrique(codeRubrique))) {
            codeRubrique = "ZYZYZYZYZYZYZYZYZYZYZY";
        }
        Collection<InfosRubriques> listeRubriques = CritereRubriquePublicationHelper.getListeRubriques(ctxUniv, rubrique, codeRubrique, "CONSUL", rechercheArborescente);
        for (InfosRubriques rubCourante : listeRubriques) {
            listeCodesRubriques.add(rubCourante.getCode());
        }
        return listeCodesRubriques;
    }

    protected static Condition traiterCritereRubriquePublicationSuivantAction(OMContext ctx, String action, String nomColonne, String codeRubrique) {
        Collection<String> listeCodeRubriques = CritereRubriquePublicationHelper.getCodesRubriquesSuivantAction(ctx, action, codeRubrique);
        ConditionList conditionRubPub = new ConditionList(ConditionHelper.in(nomColonne, listeCodeRubriques));
        conditionRubPub.or(ConditionHelper.in("RUB_PUB.RUBRIQUE_DEST", listeCodeRubriques));
        return conditionRubPub;
    }

    public static Collection<String> getCodesRubriquesSuivantAction(OMContext ctx, String action, String codeRubrique) {
        ArrayList<String> listeCodesRubriques = new ArrayList<String>();
        String codeRubriqueSite = null;
        InfosSite infosSite = null;
        boolean rechercheArborescente = !StringUtils.endsWith((CharSequence)codeRubrique, (CharSequence)"_NOARBO");
        codeRubrique = StringUtils.removeEnd((String)codeRubrique, (String)"_NOARBO");
        if ("CONSUL".equals(action) && CritereRubriquePublicationHelper.isSiteCloisonne(infosSite = ctx.getInfosSite())) {
            codeRubriqueSite = infosSite.getCodeRubrique();
        }
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
        if (CritereRubriquePublicationHelper.isCodeExisteMaisPasRubrique(codeRubrique = CritereRubriquePublicationHelper.getCodeRubriqueCloisonnee(infosSite, rubrique, codeRubrique, codeRubriqueSite), rubrique = Rubrique.renvoyerItemRubrique(codeRubrique))) {
            codeRubrique = "ZYZYZYZYZYZYZYZYZYZYZY";
        }
        Collection<InfosRubriques> listeRubriques = CritereRubriquePublicationHelper.getListeRubriques(ctx, rubrique, codeRubrique, action, rechercheArborescente);
        for (InfosRubriques rubCourante : listeRubriques) {
            listeCodesRubriques.add(rubCourante.getCode());
        }
        return listeCodesRubriques;
    }

    private static Collection<InfosRubriques> getListeRubriques(OMContext ctxUniv, InfosRubriques rubrique, String codeRubrique, String action, boolean rechercheArborescente) {
        Collection<InfosRubriques> listeRubriques = new HashSet<InfosRubriques>();
        if (CritereRubriquePublicationHelper.isCodeRubriqueExistante(codeRubrique)) {
            if ("CONSUL".equals(action) && ctxUniv != null && ctxUniv instanceof ContexteUniv && "1".equals(ConstanteSQL.ACTIVATION_DSI)) {
                if (Rubrique.controlerRestrictionRubrique((ContexteUniv)ctxUniv, codeRubrique)) {
                    if (rechercheArborescente) {
                        listeRubriques = Rubrique.determinerListeSousRubriquesAutorisees((ContexteUniv)ctxUniv, rubrique);
                    }
                } else {
                    rubrique = new InfosRubriques("ZYZYZYZYZYZYZYZYZYZYZY");
                }
                listeRubriques.add(rubrique);
            } else if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
                if (rechercheArborescente) {
                    listeRubriques = rubrique.getListeSousRubriquesTousNiveaux();
                }
                listeRubriques.add(rubrique);
            }
        } else {
            listeRubriques.add(new InfosRubriques("ZYZYZYZYZYZYZYZYZYZYZY"));
        }
        return listeRubriques;
    }

    private static boolean isSiteCloisonne(InfosSite infosSite) {
        return infosSite != null && infosSite.getRestriction() == 1;
    }

    private static String getCodeRubriqueCloisonnee(InfosSite infosSite, InfosRubriques rubrique, String codeRubrique, String codeRubriqueSite) {
        String codeRubriqueRetour = codeRubrique;
        if (StringUtils.isNotEmpty((CharSequence)codeRubriqueSite)) {
            if (CritereRubriquePublicationHelper.isCodeExisteMaisPasRubrique(codeRubrique, rubrique)) {
                codeRubriqueRetour = "ZYZYZYZYZYZYZYZYZYZYZY";
            } else if (StringUtils.isEmpty((CharSequence)codeRubrique)) {
                codeRubriqueRetour = codeRubriqueSite;
            } else if (!infosSite.isRubriqueVisibleInSite(rubrique)) {
                codeRubriqueRetour = "ZYZYZYZYZYZYZYZYZYZYZY";
            }
        }
        return codeRubriqueRetour;
    }

    private static boolean isCodeExisteMaisPasRubrique(String codeRubrique, InfosRubriques infoRub) {
        return StringUtils.isNotEmpty((CharSequence)codeRubrique) && StringUtils.isEmpty((CharSequence)infoRub.getCode());
    }

    private static boolean isCodeRubriqueExistante(String codeRubrique) {
        return !"ZYZYZYZYZYZYZYZYZYZYZY".equals(codeRubrique);
    }
}

