/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.criterespecifique;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.ContexteUniv;
import com.univ.utils.sql.ConstanteSQL;
import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.condition.ConditionSimple;
import com.univ.utils.sql.criterespecifique.ClauseJoinHelper;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class RequeteSQLHelper {
    public static RequeteSQL getRequeteGenerique(ClauseWhere where, OMContext ctx, FicheUniv fiche, String codeRubrique) {
        RequeteSQL requeteCritererGenerique = new RequeteSQL();
        Condition conditionMeta = RequeteSQLHelper.traiterConditionMeta(ctx, fiche);
        Condition conditionDSI = ConditionHelper.getConditionDSI(ctx, fiche);
        Condition conditionBO = ConditionHelper.getConditionBO(ctx, fiche);
        Condition conditionRubPub = ConditionHelper.getConditionRubPubDSIFiche(ctx, fiche, codeRubrique);
        Condition conditionIdRubriqueAndFicheOrig = ConditionHelper.getConditionRubPubFiche(fiche);
        boolean isJoinRubPub = Boolean.FALSE;
        if (conditionIdRubriqueAndFicheOrig != null && !conditionIdRubriqueAndFicheOrig.isEmpty()) {
            where.and(conditionIdRubriqueAndFicheOrig);
            requeteCritererGenerique.join(ClauseJoinHelper.creerJointureRubPub(fiche));
            isJoinRubPub = Boolean.TRUE;
        }
        if (conditionRubPub != null && !conditionRubPub.isEmpty()) {
            where.and(conditionRubPub);
            isJoinRubPub = Boolean.TRUE;
        }
        if (!isJoinRubPub) {
            requeteCritererGenerique.join(ClauseJoinHelper.creerJointureRubPub(fiche));
        }
        if (conditionMeta != null && !conditionMeta.isEmpty()) {
            where.and(conditionMeta);
            requeteCritererGenerique.join(ClauseJoinHelper.creerJointureMetaTag(fiche));
        }
        if (conditionBO != null && !conditionBO.isEmpty()) {
            where.and(conditionBO);
        }
        if (conditionDSI != null && !conditionDSI.isEmpty()) {
            where.and(conditionDSI);
        }
        requeteCritererGenerique.where(where);
        return requeteCritererGenerique;
    }

    private static Condition traiterConditionMeta(OMContext ctx, FicheUniv fiche) {
        ConditionList metaDateMiseEnLigne = null;
        if (ctx instanceof ContexteUniv && ((ContexteUniv)ctx).isCalculListeResultatsFront()) {
            Date aujourdhui = new Date(System.currentTimeMillis());
            metaDateMiseEnLigne = new ConditionList(ConditionHelper.genericCondition("DATE_FORMAT(META.META_DATE_MISE_EN_LIGNE, '%Y-%m-%d')", TypeOperande.NON_ECHAPABLE, aujourdhui, TypeOperande.DATE, Operateur.LESS_EQUALS));
            if (RequeteSQLHelper.isFicheStructureInTree(fiche)) {
                metaDateMiseEnLigne.and(ConditionHelper.egalVarchar("META.META_IN_TREE", "1"));
            }
            String codeObjet = ReferentielObjets.getCodeObjet(fiche);
            metaDateMiseEnLigne.and(ConditionHelper.egalVarchar("META.META_CODE_OBJET", codeObjet));
        }
        return metaDateMiseEnLigne;
    }

    private static boolean isFicheStructureInTree(FicheUniv fiche) {
        return fiche instanceof StructureModele && !"1".equals(PropertyHelper.getCoreProperty("structure.inTree"));
    }

    public static Condition traiterConditionDsiMeta(AutorisationBean autorisations, FicheUniv ficheUniv, String action, String rubriqueRecherche, String prefixeTableMeta) throws Exception {
        if (StringUtils.isEmpty((CharSequence)prefixeTableMeta)) {
            prefixeTableMeta = "T1";
        }
        ConditionList conditionComplete = null;
        ConditionList conditionSurFiche = new ConditionList();
        boolean restriction = Boolean.FALSE;
        boolean aucuneRestriction = Boolean.FALSE;
        boolean aucunePermission = Boolean.TRUE;
        String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
        Hashtable<String, String> actionsPossibles = RequeteSQLHelper.recupererActionsPossibles(action);
        HashSet<String> codesEspacesCollab = new HashSet<String>();
        if (autorisations != null) {
            for (Map.Entry<String, String> actionPossible : actionsPossibles.entrySet()) {
                String lettreAction = actionPossible.getKey();
                for (Map.Entry<String, Vector<Perimetre>> permission : autorisations.getListePermissions().entrySet()) {
                    if (!RequeteSQLHelper.isPermissionValide(permission.getKey(), codeObjet, lettreAction)) continue;
                    aucunePermission = Boolean.FALSE;
                    for (Perimetre perimetre : permission.getValue()) {
                        ConditionList conditionPerimetre = new ConditionList();
                        if (RequeteSQLHelper.isAcuneRestriction(perimetre)) {
                            aucuneRestriction = Boolean.TRUE;
                        } else {
                            Condition conditionRubrique = RequeteSQLHelper.traiterCodeRubriquePerimetre(perimetre.getCodeRubrique(), rubriqueRecherche, prefixeTableMeta);
                            Condition conditionStructure = RequeteSQLHelper.traiterStructurePerimetre(perimetre.getCodeStructure(), ficheUniv, prefixeTableMeta);
                            if (StringUtils.isNotEmpty((CharSequence)perimetre.getCodeEspaceCollaboratif())) {
                                codesEspacesCollab.add(perimetre.getCodeEspaceCollaboratif());
                            }
                            if (conditionRubrique != null) {
                                restriction = Boolean.TRUE;
                                conditionPerimetre.setPremiereCondtion(conditionRubrique);
                            }
                            if (conditionStructure != null) {
                                restriction = Boolean.TRUE;
                                conditionPerimetre.and(conditionStructure);
                            }
                        }
                        conditionSurFiche.or(conditionPerimetre);
                    }
                }
            }
        }
        if (!codesEspacesCollab.isEmpty()) {
            ConditionList conditionEspaceCollab = new ConditionList(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_DIFFUSION_MODE_RESTRICTION", "4"));
            conditionEspaceCollab.and(ConditionHelper.in(prefixeTableMeta + ".META_DIFFUSION_PUBLIC_VISE_RESTRICTION", codesEspacesCollab));
            conditionSurFiche.or(conditionEspaceCollab);
        }
        if (aucunePermission) {
            if (autorisations == null) {
                return ConstanteSQL.CONDITION_IMPOSSIBLE;
            }
            ConditionList ficheDeLUtilisateur = new ConditionList(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE_REDACTEUR", autorisations.getCode()));
            if (StringUtils.isNotBlank((CharSequence)codeObjet)) {
                ficheDeLUtilisateur.and(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE_OBJET", codeObjet));
            }
            return ficheDeLUtilisateur;
        }
        if (conditionSurFiche.isEmpty() && !aucuneRestriction) {
            return new ConditionSimple();
        }
        if (aucuneRestriction && !restriction && !codesEspacesCollab.isEmpty()) {
            conditionSurFiche.or(ConditionHelper.notEgal(prefixeTableMeta + ".META_DIFFUSION_MODE_RESTRICTION", "4", TypeOperande.VARCHAR));
        }
        conditionComplete = new ConditionList(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE_OBJET", codeObjet));
        conditionComplete.and(conditionSurFiche);
        return conditionComplete;
    }

    public static RequeteSQL getRequeteGeneriqueMeta(RequeteSQL requeteCritere, OMContext ctx, List<FicheUniv> lstFiche, String codeRubrique) throws Exception {
        ClauseWhere where = requeteCritere.getWhere();
        if (lstFiche.size() > 0) {
            Date aujourdhui = new Date(System.currentTimeMillis());
            ConditionList metaDateMiseEnLigne = new ConditionList(ConditionHelper.genericCondition("DATE_FORMAT(META.META_DATE_MISE_EN_LIGNE, '%Y-%m-%d')", TypeOperande.NON_ECHAPABLE, aujourdhui, TypeOperande.DATE, Operateur.LESS_EQUALS));
            where.and(metaDateMiseEnLigne);
            ConditionList conditionSurObjets = new ConditionList();
            for (FicheUniv ficheUniv : lstFiche) {
                if (!RequeteSQLHelper.isDiffusionSelective(ficheUniv, ctx)) continue;
                String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
                ConditionList conditionFiche = new ConditionList(ConditionHelper.egalVarchar("META.META_CODE_OBJET", codeObjet));
                if (RequeteSQLHelper.isFicheStructureInTree(ficheUniv)) {
                    conditionFiche.and(ConditionHelper.egalVarchar("META.META_IN_TREE", "1"));
                }
                conditionSurObjets.or(conditionFiche);
            }
            where.and(conditionSurObjets);
            where.and(RequeteSQLHelper.construireConditionDSI((ContexteUniv)ctx, "", "", "", "META"));
            where.and(ConditionHelper.getConditionRubPubSuivantAction(ctx, "CONSUL", "META.META_CODE_RUBRIQUE", codeRubrique));
            if (where.formaterSQL().contains("RUB_PUB.")) {
                ClauseJoin joinRubPub = new ClauseJoin();
                joinRubPub.setTypeJointure(ClauseJoin.TypeJointure.LEFT_JOIN);
                joinRubPub.setNomTable("RUBRIQUEPUBLICATION RUB_PUB");
                joinRubPub.on(ConditionHelper.critereJointureSimple("META.META_CODE", "RUB_PUB.CODE_FICHE_ORIG"));
                joinRubPub.and(ConditionHelper.critereJointureSimple("META.META_LANGUE", "RUB_PUB.LANGUE_FICHE_ORIG"));
                joinRubPub.and(ConditionHelper.critereJointureSimple("META.META_CODE_OBJET", "RUB_PUB.TYPE_FICHE_ORIG"));
                requeteCritere.join(joinRubPub);
            }
            requeteCritere.where(where);
        }
        return requeteCritere;
    }

    private static boolean isDiffusionSelective(FicheUniv fiche, OMContext ctx) {
        return fiche instanceof DiffusionSelective && "1".equals(ConstanteSQL.ACTIVATION_DSI) && ctx instanceof ContexteUniv && ((ContexteUniv)ctx).isCalculListeResultatsFront();
    }

    public static boolean isPermissionValide(String key, String codeObjet, String lettreAction) {
        PermissionBean permissionBean = new PermissionBean(key);
        return permissionBean.getType().equals("FICHE") && permissionBean.getObjet().equals(codeObjet) && permissionBean.getAction().equals(lettreAction);
    }

    public static boolean isAcuneRestriction(Perimetre perimetre) {
        return perimetre.getCodeRubrique().length() == 0 && perimetre.getCodeStructure().length() == 0 && perimetre.getCodeProfil().length() == 0 && perimetre.getCodeGroupe().length() == 0 && perimetre.getCodeEspaceCollaboratif().length() == 0;
    }

    public static Hashtable<String, String> recupererActionsPossibles(String action) {
        Hashtable<String, String> actionsPossibles = new Hashtable<String, String>();
        String lettreAction = "M";
        if (action.equals("MODIF")) {
            lettreAction = "M";
        } else if (action.equals("VALID")) {
            lettreAction = "V";
            actionsPossibles.putAll(AutorisationBean.getListeNiveauxApprobation());
        }
        actionsPossibles.put(lettreAction, action);
        return actionsPossibles;
    }

    public static Condition traiterCodeRubriquePerimetre(String codeRubrique, String rubriqueRecherche, String prefixeTableMeta) throws Exception {
        Condition conditionRubrique = null;
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            if ("-".equals(codeRubrique)) {
                conditionRubrique = ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE_RUBRIQUE", "");
            } else {
                Collection<String> codesRubriquesValides = RequeteSQLHelper.recupererListeCodeRubriqueParRubriqueRecherche(codeRubrique, rubriqueRecherche);
                conditionRubrique = ConditionHelper.in(prefixeTableMeta + ".META_CODE_RUBRIQUE", codesRubriquesValides);
            }
        }
        return conditionRubrique;
    }

    public static Condition traiterStructurePerimetre(String codeStructure, FicheUniv ficheUniv, String prefixeTableMeta) throws Exception {
        ConditionList conditionStructure = null;
        if (StringUtils.isNotEmpty((CharSequence)codeStructure)) {
            if ("-".equals(codeStructure)) {
                conditionStructure = new ConditionList(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE_RATTACHEMENT", ""));
                if (ficheUniv instanceof StructureModele) {
                    conditionStructure.and(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE_RATTACHEMENT_AUTRES", ""));
                }
            } else {
                conditionStructure = new ConditionList(ConditionHelper.getConditionStructure(prefixeTableMeta + ".META_CODE_RATTACHEMENT", codeStructure));
                if (ficheUniv instanceof StructureModele) {
                    conditionStructure.or(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_CODE", codeStructure));
                }
                if (ficheUniv instanceof FicheRattachementsSecondaires) {
                    conditionStructure.or(RequeteSQLHelper.traiterStructureMultiplePerimetre(codeStructure));
                }
            }
        }
        return conditionStructure;
    }

    public static Collection<String> recupererListeCodeRubriqueParRubriqueRecherche(String codeRubrique, String codeRubriqueRecherche) {
        ArrayList<String> codeDesRurbiquesValides = new ArrayList<String>();
        InfosRubriques rubriqueRecherche = Rubrique.renvoyerItemRubrique(codeRubriqueRecherche);
        InfosRubriques infosRub = Rubrique.renvoyerItemRubrique(codeRubrique);
        Collection<InfosRubriques> sousRubriques = infosRub.getListeSousRubriquesTousNiveaux();
        for (InfosRubriques rubriqueCourante : sousRubriques) {
            if (!StringUtils.isEmpty((CharSequence)codeRubriqueRecherche) && !rubriqueRecherche.contains(rubriqueCourante)) continue;
            codeDesRurbiquesValides.add(rubriqueCourante.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)codeRubriqueRecherche) || rubriqueRecherche.contains(infosRub)) {
            codeDesRurbiquesValides.add(codeRubrique);
        }
        return codeDesRurbiquesValides;
    }

    public static Condition traiterStructureMultiplePerimetre(String codesStructures) {
        String[] toutLesCodes;
        ConditionList conditionStructureMultiple = new ConditionList();
        for (String code : toutLesCodes = codesStructures.split("\\+")) {
            if (!StringUtils.isNotEmpty((CharSequence)code)) continue;
            Collection<InfosStructure> sousInfosStructures = Structure.renvoyerItemStructure(code).getListeSousStructuresTousNiveaux();
            conditionStructureMultiple.or(ConditionHelper.like("T1.META_CODE_RATTACHEMENT_AUTRES", code, "%[", "]%"));
            for (InfosStructure infoStructure : sousInfosStructures) {
                conditionStructureMultiple.or(ConditionHelper.like("T1.META_CODE_RATTACHEMENT_AUTRES", infoStructure.getCode(), "%[", "]%"));
            }
        }
        return conditionStructureMultiple;
    }

    public static final Condition construireConditionDSI(ContexteUniv ctx, String diffusionPublicVise, String diffusionModeRestriction, String diffusionPublicViseRestriction, String prefixeTableMeta) {
        if (StringUtils.isEmpty((CharSequence)prefixeTableMeta)) {
            prefixeTableMeta = "T1";
        }
        ConditionList conditionDSI = new ConditionList();
        if (RequeteSQLHelper.isSousDSI(ctx)) {
            if (StringUtils.isEmpty((CharSequence)diffusionModeRestriction)) {
                conditionDSI.setPremiereCondtion(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_DIFFUSION_MODE_RESTRICTION", "0"));
            }
            conditionDSI.or(RequeteSQLHelper.traiterProfilEtGroupe(ctx, diffusionModeRestriction, diffusionPublicVise, prefixeTableMeta));
            conditionDSI.or(RequeteSQLHelper.traiterProfilDynamique(ctx, diffusionModeRestriction, diffusionPublicViseRestriction, prefixeTableMeta));
            if (Espacecollaboratif.isExtensionActivated()) {
                conditionDSI.or(RequeteSQLHelper.traiterEspaceCollab(ctx, diffusionModeRestriction, diffusionPublicViseRestriction, prefixeTableMeta));
            }
        }
        return conditionDSI;
    }

    private static final Condition traiterRestrictionGroupeDSI(ContexteUniv ctx, String nomColonne, String valeur) {
        Collection<String> codeDesGroupesDSI = RequeteSQLHelper.getListeCodesRestrictionGroupeDSI(ctx, valeur);
        ConditionList conditionRestrictionDSI = new ConditionList();
        for (String codeGroupeDSI : codeDesGroupesDSI) {
            conditionRestrictionDSI.or(ConditionHelper.like(nomColonne, codeGroupeDSI, "%[/", "]%"));
        }
        return conditionRestrictionDSI;
    }

    private static Condition traiterProfilEtGroupe(ContexteUniv ctx, String diffusionModeRestriction, String diffusionPublicVise, String prefixeTableMeta) {
        ConditionList restrictionProfilGroupe = new ConditionList();
        if (diffusionModeRestriction.equals("") || diffusionModeRestriction.equals("2")) {
            restrictionProfilGroupe.setPremiereCondtion(RequeteSQLHelper.traiterRestrictionGroupeDSI(ctx, prefixeTableMeta + ".META_DIFFUSION_PUBLIC_VISE", diffusionPublicVise));
            restrictionProfilGroupe.and(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_DIFFUSION_MODE_RESTRICTION", "2"));
        }
        return restrictionProfilGroupe;
    }

    private static Condition traiterProfilDynamique(ContexteUniv ctx, String diffusionModeRestriction, String diffusionPublicViseRestriction, String prefixeTableMeta) {
        ConditionList restrictionProfilDynamique = new ConditionList();
        if (diffusionModeRestriction.equals("") || diffusionModeRestriction.equals("3")) {
            restrictionProfilDynamique = new ConditionList(RequeteSQLHelper.traiterRestrictionGroupeDSI(ctx, prefixeTableMeta + ".META_DIFFUSION_PUBLIC_VISE_RESTRICTION", diffusionPublicViseRestriction));
            restrictionProfilDynamique.and(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_DIFFUSION_MODE_RESTRICTION", "3"));
        }
        return restrictionProfilDynamique;
    }

    private static boolean isSousDSI(ContexteUniv ctx) {
        return "1".equals(ConstanteSQL.ACTIVATION_DSI) && ctx.isCalculListeResultatsFront();
    }

    private static Condition traiterEspaceCollab(ContexteUniv ctx, String diffusionModeRestriction, String diffusionPublicViseRestriction, String prefixeTableMeta) {
        ConditionList conditionEspace = new ConditionList();
        if ((diffusionModeRestriction.equals("") || diffusionModeRestriction.equals("4")) && StringUtils.isEmpty((CharSequence)diffusionPublicViseRestriction)) {
            Collection<InfosEspaceCollaboratif> espaces = Espacecollaboratif.getListeEspaces();
            ArrayList<String> espacesUtilisateur = new ArrayList<String>();
            for (InfosEspaceCollaboratif espace : espaces) {
                if (!Espacecollaboratif.estMembreEspace(ctx, espace) && !Espacecollaboratif.estVisiteurEspace(ctx, espace)) continue;
                espacesUtilisateur.add(espace.getCode());
            }
            if (espacesUtilisateur.isEmpty()) {
                espacesUtilisateur.add("ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ");
            }
            conditionEspace = new ConditionList(ConditionHelper.in(prefixeTableMeta + ".META_DIFFUSION_PUBLIC_VISE_RESTRICTION", espacesUtilisateur));
            conditionEspace.and(ConditionHelper.egalVarchar(prefixeTableMeta + ".META_DIFFUSION_MODE_RESTRICTION", "4"));
        }
        return conditionEspace;
    }

    private static Collection<String> getListeCodesRestrictionGroupeDSI(ContexteUniv ctx, String valeur) {
        HashSet<String> listeGroupes = new HashSet<String>();
        TreeSet<String> groupesDSIDuContexte = ctx.getGroupesDsi();
        boolean requete = true;
        if (StringUtils.isNotEmpty((CharSequence)valeur) && !groupesDSIDuContexte.contains(valeur) || groupesDSIDuContexte.isEmpty()) {
            requete = false;
        }
        if (requete) {
            for (String codeGroupeDSIDuContexte : groupesDSIDuContexte) {
                listeGroupes.add(codeGroupeDSIDuContexte);
                InfosGroupeDsi infoGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupeDSIDuContexte);
                for (int niveau = infoGroupe.getNiveau() - 1; niveau > 0; --niveau) {
                    String codeGroupeCourant = infoGroupe.getCodeGroupePere();
                    listeGroupes.add(codeGroupeCourant);
                    infoGroupe = Groupedsi.renvoyerItemGroupeDsi(codeGroupeCourant);
                }
            }
        } else {
            listeGroupes.add("ZZZZZZZZZZZZZZZZZZZZ");
        }
        return listeGroupes;
    }
}

